<?php

function parseStatus($xmlString)
{
  $xml = new XMLDocument($xmlString);
  if (!$xml)
    return -1; // xml error

  $root = $xml->document_element();
  $xpath = xpath_new_context($root);

  $statusData = array();
  $statusData['caption'] = $root->get_attribute('caption');
  $statusData['state'] = $root->get_attribute('state');
  $statusData['percent'] = $root->get_attribute('percentComplete');

  $statusData['runMode'] = ($root->has_attribute('desiredTestTime')) ? 'time' : 'loop';
  
  $statusData['currentTime'] = $root->get_attribute('testTime');
  $statusData['desiredTime'] = $root->get_attribute('desiredTestTime');
  $statusData['currentLoop'] = $root->get_attribute('currentLoop');
  $statusData['desiredLoops'] = $root->get_attribute('testLoops');
  $statusData['currentTests'] = $root->get_attribute('testsFinished');
  $statusData['desiredTests'] = $root->get_attribute('totalTests');

  $prompts = $xml->get_elements_by_tagname('diagPrompt');
  //$statusData['isPrompting'] = (count($prompts) > 0) ? true : false;
  if (count($prompts) == 0)
  {
    $statusData['isPrompting'] = false;
  }
  else
  {
    $statusData['isPrompting'] = true;
    $statusData['queuedPrompt'] = parseQueuedPrompt($prompts[0]);
  }

  $children = $root->child_nodes();
  $statusData['children'] = array();
  foreach ($children as $child)
  {
    if (isChildValid($child))
      $statusData['children'][] = parseStatusChild($child);
  }

  return $statusData;
}

function parseStatusChild($child)
{
  $childData = array();
  $childData['caption'] = $child->get_attribute('caption');
  $childData['state'] = $child->get_attribute('state');
  $childData['result'] = $child->get_attribute('result');
  $percent = $child->get_attribute('percentComplete');
  $childData['percent'] = ($percent != '') ? $percent : '0';
  $childData['time'] = $child->get_attribute('testTime');
  return $childData;
}

function parseQueuedPrompt($prompt)
{
  $promptData = array();
  $parent = $prompt->parent_node();
  $promptData['id'] = $prompt->get_attribute('promptID');
  $promptData['caption'] = $parent->get_attribute('caption');
  $promptData['content'] = $prompt->get_content();
  $promptData['type'] = $prompt->get_attribute('type');
  $promptData['options'] = array();
  $options = $prompt->child_nodes();
  foreach ($options as $option)
  {
    if (isOptionValid($option))
    {
      $optionData = array();
      $optionData['caption'] = $option->get_attribute('caption');
      $optionData['hotkey'] = $option->get_attribute('hotkey');
      $optionData['image'] = $option->get_attribute('image');
      $promptData['options'][] = $optionData;
    }
  }
  return $promptData;
}

function isChildValid($child)
{
  $returnVal = false;
  if ($child->node_type() == XML_ELEMENT_NODE && 
      $child->tagname() == 'processStatus')
    $returnVal = true;
  return $returnVal;
}

function isOptionValid($option)
{
  $returnVal = false;
  if ($option->node_type() == XML_ELEMENT_NODE &&
      $option->tagname() == 'option')
    $returnVal = true;
  return $returnVal;
}
/*


    $queuedPrompt = false;
    @ $prompts = @ xpath_eval($xpath, '/processStatus/diagPrompt'); // causes error in SmartStart when none are present, so we use '@'

    if (count($prompts->nodeset) > 0)
    {
      $queuedPrompt = true;
      $prompt = $prompts->nodeset[0];

      $promptXpath = xpath_new_context($prompt);
      $parentNodes = @ xpath_eval($promptXpath, '/..');
      $parent = $parentNodes->nodeset[0];

      $promptID = $prompt->get_attribute('promptID');
      $promptCaption = $parent->get_attribute('caption');
      $promptContent = str_replace("\n", '<br />', $prompt->get_content());
      $promptType = $prompt->get_attribute('type');
      $promptOptions = array();

      $options = @ xpath_eval($promptXpath, '/option');
      if (count($options->nodeset) > 0)
      {
        foreach($options->nodeset as $option)
        {
          $promptOption = array();
          $promptOption['caption'] = $option->get_attribute('caption');
          $promptOption['hotkey'] = $option->get_attribute('hotkey');
          $promptOption['image'] = $option->get_attribute('image');
          $promptOptions[] = $promptOption;
        }
      }
    }

    
    
    if ($numberOfProcesses <= 0)
    {
      $tableContent[] = '<tr class="message">';
      $tableContent[] = ('<th>' . translate('MSG_INITIALIZING_TESTS') . '</th>');
      $tableContent[] = '</tr>';
    }
    else
    {
      $testsCaption = $root->get_attribute('caption');
      $testsState = $root->get_attribute('state');
      $testsPercentComplete = $root->get_attribute('percentComplete');

      $failedTests = @ xpath_eval($xpath, '/processStatus[@result="failed"]');
      $numberOfFailedTests = count($failedTests->nodeset);

      $timeString = array();

    
      
      $tableContent[] = '<thead>';
      $tableContent[] = '<tr>';
      $tableContent[] = '<th class="icon"></th>';
      $tableContent[] = ('<th class="caption">' . translate('MSG_DEVICE') . ', ' . translate('MSG_TEST') . '</th>');
      $tableContent[] = ('<th class="status">' . translate('MSG_STATUS') . '</th>');
      $tableContent[] = ('<th class="progress">' . translate('MSG_TEST_PROGRESS') . '</th>');
      $tableContent[] = ('<th class="time">' . translate('MSG_TIME') . '</th>');
      $tableContent[] = '</tr>';
      $tableContent[] = '</thead>';
      $tableContent[] = '<tbody>';
      
      
      
      $tableContent[] = '</tbody>';

      if (!in_array($testsState, $runningStates) && // is not running anymore
          IS_FACTORY && 
          isset($_GET['scriptTesting']) && 
          $_GET['scriptTesting'] == 'yes' &&
          checkDiagConfig('/src', 'name', 'factory.xml'))
      {
        $factoryXML = new XMLDocument(file_get_contents(DIAGS_DIRECTORY . 'factory.xml'));
        $factoryRoot = $factoryXML->document_element();
        $factoryXpath = xpath_new_context($factoryRoot);
        $stationID = $factoryRoot->get_attribute('station');
        $srcNodes = @ xpath_eval($factoryXpath, ('/src[@station="' . $stationID . '"]'));
        if (count($srcNodes->nodeset) > 0)
        {
          $srcNode = $srcNodes->nodeset[0];
          $timeString = ($root->has_attribute('desiredTestTime')) ? ($root->get_attribute('testTime') . ' of ' . $root->get_attribute('desiredTestTime')) : $root->get_attribute('testTime');
          $srcNode->set_attribute('totalTestTime', $timeString);
          if ($testsState == 'canceled')
          {
            $srcNode->set_attribute('status', 'canceled');
          }
          else if ($testsState == 'completed')
          {
            if ($numberOfFailedTests > 0)
            {
              $srcNode->set_attribute('status', 'failed');
            }
            else
            {
              $srcNode->set_attribute('status', 'passed');
              // $stationID++;
              // $factoryRoot->set_attribute('station', $stationID);
            }
          }
        }
        $factoryFilepath = (DIAGS_DIRECTORY . 'factory.xml');
        $factoryXML->dump_file($factoryFilepath, false, false);
      }
    }
  }

  $verTableContent = array();
  if (IS_FACTORY)
  {
    chdir('/');
    $verFiles = array_merge(glob('*.ver'), glob('*.VER'));
    foreach ($verFiles as $verFilename)
    {
      if (file_exists($verFilename))
      {
        $verFile = file_get_contents($verFilename);
        $verContent = str_replace(array("\r","\n"), '', $verFile); // remove line breaks
        $verTableContent[] = '<td>';
        $verTableContent[] = '<fieldset>';
        $verTableContent[] = ('<legend>' . $verFilename . '</legend>');
        $verTableContent[] = $verContent;
        $verTableContent[] = '</fieldset>';
        $verTableContent[] = '</td>';
      }
    }
  }

  $output = array();
  appendViewHeader($output);
  $output[] = '<script type="text/javascript">';
  $output[] = 'function init() {';
  if (isset($_GET['processID']))
  {
    $caption = (isset($testsCaption)) ? $testsCaption : '';
    $percentComplete = (isset($testsPercentComplete)) ? $testsPercentComplete : '0';
    $timeString = (isset($timeString)) ? $timeString : array();
    $state = (isset($testsState)) ? $testsState : '';
    $output[] = (' parent.Frontend.statusController.setCaption("' . $caption . '");');
    $output[] = (' parent.Frontend.statusController.setPercent(' . $percentComplete . ');');
    $output[] = (' parent.Frontend.statusController.setMessage("' . createMessage() . '");');
    $output[] = (' parent.Frontend.statusController.setInfo("' . implode('', $timeString) . '");');
    if ($queuedPrompt == true)
//      $output[] = (' parent.Frontend.statusController.updateWithPrompt("' . $promptID . '", "' . $promptComponent . '", "' . $promptDevice . '", "' . $promptTest . '", "' . $promptType . '", "' . $promptCaption . '", "' . $promptContent . '", ' . Rosetta::arrayToJSON($promptOptions) . ');');
      $output[] = (' parent.Frontend.statusController.updateWithPrompt("' . $promptID . '", "' . $promptType . '", "' . $promptCaption . '", "' . $promptContent . '", ' . Rosetta::arrayToJSON($promptOptions) . ');');
    else
      $output[] = (' parent.Frontend.statusController.updateWithState("' . $state . '");');
  }
  
//  $output[] = ' parent.Body.adjustToViewport(parent.Frontend.statusController.buffer);';
//  $output[] = ' parent.Frontend.statusController.refreshBuffer();';
  $output[] = ' parent.Frontend.statusController.viewController.switchFrames();';
  $output[] = ' parent.Frontend.statusController.resize();';
  $output[] = '}';
  $output[] = '</script>';
  $output[] = '</head>';
  $output[] = '<body onload="init();">';
  if (count($verTableContent) > 0)
  {
    $output[] = '<table id="verfiles">';
    $output[] = implode('', $verTableContent);
    $output[] = '</table>';
  }
  $output[] = '<table class="status" id="testStatus">';
  $output[] = implode('', $tableContent);
  $output[] = '</table>';
  appendViewFooter($output);
  
  echo implode('', $output);

  // UTILITY FUNCTIONS

/*
  function detectUTF8($string)
  {
     return preg_match('%(?:
     [\xC2-\xDF][\x80-\xBF]        # non-overlong 2-byte
     |\xE0[\xA0-\xBF][\x80-\xBF]              # excluding overlongs
     |[\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}      # straight 3-byte
     |\xED[\x80-\x9F][\x80-\xBF]              # excluding surrogates
     |\xF0[\x90-\xBF][\x80-\xBF]{2}    # planes 1-3
     |[\xF1-\xF3][\x80-\xBF]{3}                  # planes 4-15
     |\xF4[\x80-\x8F][\x80-\xBF]{2}    # plane 16
     )+%xs', $string);
  }

  
  function drawProgressBar($percent=0)
  {
    if ($percent < 0 || !is_numeric($percent))
      $percent = 0;
    if ($percent > 100)
      $percent = 100;

    $progressBar = array('<div class="progressbar');
    if ($percent == 100)
       $progressBar[] = ' finished';
    $progressBar[] = '">';
    $progressBar[] = ('<div class="stretcher" style="width: ' . $percent . '%">' . $percent . '%</div>');
    $progressBar[] = '</div>';
    return implode('', $progressBar);
  }

  function createMessage()
  {
    global $testsState;
    global $numberOfFailedTests;

    $message = '';
    if ($testsState == 'running' || $testsState == '')
    {
      $message = translate('MSG_TESTING_IN_PROGRESS');
    }
    else if ($testsState == 'canceling')
    {
      $message = translate('MSG_CANCELING');
    }
    else if ($testsState == 'canceled')
    {
      $message .= translate('MSG_TEST_CANCELED');
    }
    else
    {
      $message .= translate('MSG_TESTING_COMPLETED');
      if ($numberOfFailedTests <= 0 || $numberOfFailedTests == '')
        $message .= (' ' . translate('MSG_TESTS_PASSED'));
      else
        $message .= (' ' . translate('MSG_TESTS_FAILED'));
    }
    return $message;
  }
  
?>


/*
function parseSurvey($category='overview')
{
  if (!file_exists(IDRESULT_PATH))
    return -1; // file missing error

  $surveyData = array();

  $idResult = file_get_contents(IDRESULT_PATH);
  $xml = new XMLDocument($idResult);
  $xpath = xpath_new_context($xml->document_element());

  if ($category == 'all')
    $categoryNodes = @ xpath_eval($xpath, '/diagOutput/category');
  else
    $categoryNodes = @ xpath_eval($xpath, ('/diagOutput/category[@name="' . $category . '"]'));

  foreach ($categoryNodes->nodeset as $category)
  {
    $categoryData = array();
    $categoryData['name'] = $category->get_attribute('name');
    $categoryData['caption'] = $category->get_attribute('caption');

    $children = $category->child_nodes();
    $categoryData['children'] = array();
    foreach ($children as $child)
    {
      if (isChildValid($child))
        $categoryData['children'][] = parseSurveyChild($child);
    }

    $surveyData[] = $categoryData;
  }
  return $surveyData;
}

function parseSurveyChild(&$data)
{
  $childData = array();
  $childData['caption'] = $data->get_attribute('caption');
  $childData['isHexData'] = ($data->get_attribute('hexData') == '1') ? true : false;
  $childData['isAdvanced'] = ($data->get_attribute('techDetail') == '1') ? true : false;
  $childData['value'] = extractValue($data, $childData['caption']);

  $children = $data->child_nodes();
  $childData['children'] = array();
  foreach ($children as $child)
  {
    if (isChildValid($child))
      $childData['children'][] = parseSurveyChild($child);
  }

  return $childData;
}

function extractValue($data, $nullMatch='')
{
  $returnVal = '';
  $value = $data->get_attribute('value');
  $description = $data->get_attribute('description');
  if ($value != '' && $value != $nullMatch)
    $returnVal = $value;
  else if ($description != '' && $description != $nullMatch)
    $returnVal = $description;
  return $returnVal;
}

function extractFirstNode(&$target, $xpath)
{
  $nodes = @ xpath_eval($target, $xpath);
  if (count($nodes->nodeset) > 0)
    return $nodes->nodeset[0];
  else
    return false;
}

function isChildValid($child)
{
  $returnVal = false;
  if ($child->node_type() == XML_ELEMENT_NODE)
  {
    $validTagnames = array('device', 'structure', 'property');
    $tagname = $child->tagname();
    $testOnly = $child->get_attribute('testOnly');
    if ($testOnly != '1' &&
        in_array($tagname, $validTagnames))
      $returnVal = true;
  }
  return $returnVal;
}
//*/
?>
