<?php
function domxml_new_doc()
{
  return new XMLDocument();
}

function xpath_new_context($element)
{
  if (is_a($element, 'XMLElement'))
    return $element;
  return new XMLElement($element);
}

function xpath_eval($element, $query)
{
  if (!is_a($element, 'XMLElement'))
    $element = new XMLElement($element);
  $document = $element->owner_document();
  $xpath = new DOMXPath($document);
  // PHP5 DOM parses xpath queries differently than PHP4
  // if dealing with a root element, we need to strip
  // any leading single slashes from the query
  if ($element == $document->document_element())
  {
    // split the query across any 'or' operators
    $subqueries = explode(' | ', $query);
    foreach ($subqueries as &$subquery)
    {


      if (substr($subquery, 0, 1) == '/' && substr($subquery, 0, 2) != '//')
        $subquery = substr($subquery, 1);
    }
    $query = implode(' | ', $subqueries);
  }
  $result = $xpath->query($query, $element->original());
  return new XPathResult($result);
}

class XMLDocument extends DOMDocument
{
  public function __construct($string='')
  {
    parent::__construct('1.0', 'UTF-8');
    if ($string != '')
      $this->loadXML($string);
  }

  public function document_element()
  {
    $element = $this->documentElement;
    return new XMLElement($element);
  }

  public function add_root($tagname)
  {
    $element = $this->createElement($tagname);
    $this->appendChild($element);
    return new XMLElement($element);
  }

  public function create_element($tagname)
  {
    $element = $this->createElement($tagname);
    return new XMLElement($element);
  }

  public function dump_mem()
  {
    return $this->saveXML();
  }

  public function dump_file($filepath, $compression=false, $format=false)
  {
    return $this->save($filepath);
  }
}

class XMLElement
{
  private $element;

  //public $tagname;

  public function __construct($element)
  {
    //echo "XMLElement construct<br>";
    $this->element = $element;
    //$tagName = $element->tagName;
    //echo "TagName: '$tagName'<br>";
    //$this->tagname = $tagName;
    //$this->tagname = $element->tagName;
  }

  public function owner_document()
  {
    return $this->element->ownerDocument;
  }

  public function tagname()
  {
    return $this->element->tagName;
  }

  public function __get($name)
  {
    if ($name == 'tagname')
      return $this->tagname();
    return null;
  }

  public function node_type()
  {
    return $this->element->nodeType;
  }

  public function node_name()
  {
    return $this->element->nodeName;
  }

  public function has_attribute($name)
  {
    return $this->element->hasAttribute($name);
  }

  public function get_attribute($name)
  {
    return $this->element->getAttribute($name);
  }

  public function set_attribute($name, $value)
  {
    return $this->element->setAttribute($name, $value);
  }

  public function get_content()
  {
    return $this->element->textContent;
  }

  public function set_content($string)
  {
    $document = $this->element->ownerDocument;
    $this->element->appendChild($document->createTextNode($string));
  }
  
  public function parent_node()
  {
    $parent = $this->element->parentNode;
    if ($parent)
      return new XMLElement($parent);
    return null;
  }

  public function child_nodes()
  {
    $childNodes = array();
    $children = $this->element->childNodes;
    foreach ($children as $child)
      $childNodes[] = new XMLElement($child);
    return $childNodes;
  }

  public function has_child_nodes()
  {
    return $this->element->hasChildNodes();
  }

  public function get_elements_by_tagname($tagname)
  {
    $elements = $this->element->getElementsByTagName($tagname);
    $returnVal = array();
    foreach ($elements as $element)
      $returnVal[] = new XMLElement($element);
    return $returnVal;
  }

  public function append_child($element)
  {
    if (is_a($element, 'XMLElement'))
      $child = $element->original();
    else
      $child = $element;
    $this->element->appendChild($child);
    return $element;
  }
  
  public function original()
  {
    return $this->element;
  }
}

class XPathResult
{
  public $nodeset = array();

  public function __construct($result)
  {
    foreach ($result as $element)
      $this->nodeset[] = new XMLElement($element);
  }
}

?>
