//makeClass(Debugger);
function Debugger()
{
  this.commands = [];
  this.currentCommand = -1;
  this.panel = newElement('div', {'id':'debugPanel'})//,'style':{'display':'none'}});
  //this.panel = document.createElement('div');
  //this.panel.id = 'debugPanel';
  //this.panel.style.display = 'none'; // initially hidden
  this.curtain = this.panel.appendChild(newElement('div', {'id':'debugCurtain'}));
  //this.curtain = this.panel.appendChild(document.createElement('div'));
  //this.curtain.id = 'debugCurtain';
  this.filter = this.panel.appendChild(newElement('iframe', {'id':'debugFilter'}));
  this.filter.src = 'utils/dummy.html';
//  this.filter = this.panel.appendChild(document.createElement('iframe'));
//  this.filter.id = 'debugFilter';
//  this.filter.src = 'dummy.html';
  this.controls = this.panel.appendChild(newElement('div', {'id':'debugControls'}));
  //this.controls = this.panel.appendChild(document.createElement('div'));
  //this.controls.id = 'debugControls';
  this.commandLine = this.controls.appendChild(newElement('input', {'type':'text','id':'debugCommandLine','controller':this}));
  //this.commandLine = this.controls.appendChild(document.createElement('input'));
  //this.commandLine.type = 'text';
  //this.commandLine.id = 'debugCommandLine';
  //this.commandLine.control = this;
  this.commandLine.onfocus = function(event)
  {
    this.controller.toggleKeyCapture(true);
  }
  this.commandLine.onblur = function(event)
  {
    this.controller.toggleKeyCapture(false);
  }
  this.output = this.controls.appendChild(newElement('ul', {'id':'debugOutput'}));
  //this.output = this.controls.appendChild(document.createElement('ul'));
  //this.output.id = 'debugOutput';
  this.closeButton = this.panel.appendChild(newElement('div', {'id':'debugClose'}));
  //this.closeButton = this.panel.appendChild(document.createElement('div'));
  //this.closeButton.id = 'debugClose';
  this.closeSpan = this.closeButton.appendChild(newElement('span', {'controller':this,'text':'Close'}));
  //this.closeSpan = this.closeButton.appendChild(document.createElement('span'));
  //this.closeSpan.control = this;
  //this.closeSpan.appendChild(document.createTextNode('Close'));
  this.closeSpan.onmouseover = function()
  {
    addClass(this, 'hover');
  }
  this.closeSpan.onmouseout = function()
  {
    removeClass(this, 'hover');
  }
  this.closeSpan.onclick = function()
  {
    this.controller.hide();
  }
  this.openButton = newElement('div', {'id':'debugOpen'});
  //this.openButton = document.createElement('div');
  //this.openButton.id = 'debugOpen';
  this.openSpan = this.openButton.appendChild(newElement('span', {'controller':this,'text':'Open Debugger'}));
  //this.openSpan = this.openButton.appendChild(document.createElement('span'));
  //this.openSpan.appendChild(document.createTextNode('Open Debugger'));
  //this.openSpan.control = this;
  this.openSpan.onmouseover = function()
  {
    addClass(this, 'hover');
  }
  this.openSpan.onmouseout = function()
  {
    removeClass(this, 'hover');
  }
  this.openSpan.onclick = function()
  {
    this.controller.show();
  }
  this.panel.hide();
  Body.appendChild(this.openButton);
  Body.appendChild(this.panel);
  //document.body.appendChild(this.openButton);
  //document.body.appendChild(this.panel);
  
  Array.prototype.classid = 'array';

  document.onerror = function(error)
  {
    window.Debugger.error(error);
  }

  window.onerror = function (error)
  {
    window.Debugger.error(error);
  }

  window.serialize = function (object)
  {
    if (typeof object == 'object')
    {
      for (var name in object)
      {
        var value = object[name];
        window.Debugger.log(name + ' (' + (typeof value) + '): ' + value);
      }
    }
  }
  
  this.hide = function()
  {
    //this.panel.style.display = 'none';
    this.panel.style.top = "";
    this.panel.style.left = "";
    this.panel.hide();
    //this.openButton.style.display = '';
    this.openButton.show();
  }
  
  this.show = function()
  {
    //this.panel.style.display = '';
    this.panel.conformTo(Body);
    this.panel.show();
    Body.adjustToViewport(this.output);
    //this.openButton.style.display = 'none';
    this.openButton.hide();
  }
  
  this.outputLine = function(message, mode)
  {
    //var li = document.createElement('li');
    //li.className = mode;
    var li = newElement('li', {'class':mode});
    var lines = new String(message).split('\n');
    for(var i=0; i<lines.length; i++)
    {
      if (i > 0)
        li.appendChild(newElement('br'));
        //li.appendChild(document.createElement('br'));
      //li.appendChild(document.createTextNode(lines[i]));
      li.appendChild(newText(lines[i]));
    }
    window.Debugger.output.appendChild(li);
  }

  this.log = function(message)
  {
    this.outputLine(message, 'message');
  }

  this.inform = function(message)
  {
    this.outputLine(message, 'info');
  }

  this.warn = function(message)
  {
    this.outputLine(message, 'warn');
  }

  this.error = function(error)
  {
    if (error.message != undefined)
      var message = error.message;
    else if (error.toString != undefined)
      var message = error.toString();
    else
      var message = error;
    this.outputLine(message, 'error');
  }

  function echo(message)
  {
    var li = newElement('li', {'class':'echo','text':('>>> ' + message)});
    //var li = document.createElement('li');
    //li.className = 'echo';
    //li.appendChild(document.createTextNode('>>> '+message));
    window.Debugger.output.appendChild(li);
  }

  this.evaluateCommand = function()
  {
    //var command = getElement('debugCommandLine').value;
    var command = this.commandLine.value;
    if (command != undefined && command != '' && command != null)
    {
      echo(command);
      switch(command)
      {
      case 'clear()':
        clearChildren(this.output);
        break;
      default:
        try
        {
          var returnVal = eval(command);
          if (returnVal != undefined)
          {
            if (returnVal.classid && returnVal.classid == 'array')
              this.log('[' + returnVal.join(', ') + ']');
            else
              this.log(returnVal);
          }
        }
        catch(error)
        {
          this.error(error);
        }
      }
      this.commands.push(command);
      this.currentCommand = this.commands.length;
      this.commandLine.value = '';
    }
  }

  this.toggleKeyCapture = function(bool)
  {
    if (bool)
    {
      this.previousKeyDown = document.onkeydown;
      var keycontroller = this;
      document.onkeydown = function(event)
      {
        keycontroller.captureKeyPress(event);
      }
    }
    else
    {
      if (this.previousKeyDown != undefined)
        document.onkeydown = this.previousKeyDown;
    }
  }

  this.captureKeyPress = function(evnt)
  {
    var key;
    if (evnt != undefined && evnt.which != undefined)
      key = evnt.which;
    else if (event != undefined && event.keyCode != undefined)
      key = event.keyCode;
    if (key == undefined)
    {
      this.error('Could Not Detect Keypress');
    }
    else
    {
      switch(key)
      {
      case 13: // ENTER
        this.evaluateCommand();
        break;
      case 38: // UP
        this.loadCommand(this.currentCommand-1);
        break;
      case 40: // DOWN
        this.loadCommand(this.currentCommand+1);
        break;
      }
    }
  }

  this.loadCommand = function(commandIndex)
  {
    if (commandIndex < 0)
    {
      this.currentCommand = 0;
      this.commandLine.value = this.commands[0];
    }
    else if (commandIndex > this.commands.lastIndex())
    {
      this.currentCommand = this.commands.length;
      this.commandLine.value = '';
    }
    else
    {
      this.currentCommand = commandIndex;
      this.commandLine.value = this.commands[commandIndex];
    }
  }
  
 /* this.toString = function()
  {
    return '[object Debugger]';
  }
  this.classid = 'Debugger'; */
}
