var Frontend =
{
/********************************************************************
//        NAME- Frontend.init
// DESCRIPTION- Initializer of Frontend, instantiates all required
//              objects and calls startup upon completion
//      PASSED- 
//     RETURNS- 
//       NOTES- 
********************************************************************/
  init: function init()
  {
    addEvent(document, 'keydown', function (event)
    {
      Frontend.checkKeyCommand(event);
    });

    var debugOpener = new HotCorner('tl');
    debugOpener.action = function ()
    {
      window.Debugger = new Debugger();
      CONFIG.DEBUG_MODE = true;
      CONFIG.DEBUG_ACTIVE = true;
      this.active = false;
    }
    
    document.oncontextmenu = function ()
    {
      return CONFIG.DEBUG_ACTIVE;
    }

    // variable used to prevent beginTesting from being executed multiple times
    // when browser response may be slow for whatever reason.
    this.allowBeginTesting = true;

    this.initializeButtons();

    this.tabs             = new MainTabController();

    this.currentConfig    = new CurrentConfigController();
    this.statusController = new StatusMonitor();
    this.errorLog         = new ErrorLogController();    

    this.dialog           = new ModalDialog('informBox');
    this.aboutDialog      = new ModalElement(getElement('aboutDialog'));

    if (CONFIG.DIAGNOSIS_SUPPORT == true)
    {
      this.diagnoseController    = new DiagnoseController();
      this.diagnosisLog          = new DiagnosisLogController();
      this.aboutDiagnosisDialog  = new ModalElement(getElement('aboutDiagnosisDialog'));
    }

    if (CONFIG.IS_ONLINE == true)
    {
      this.compareConfig       = new CompareConfigController();
      this.scheduleDialog      = new ScheduleDialog();
      this.manageSurveysDialog = new ManageSurveysDialog();
      if (CONFIG.IS_SMH == true)
        this.sessionRefresher  = new SMHSessionRefresher();
    }
    else
    {
      this.saveDialog = new SaveDialog();
    }
    if (CONFIG.SURVEY_ONLY == false)
    {
      this.quickTests       = new QuickTestController();
      this.completeTests    = new CompleteTestController();
      this.customTests      = new CustomTestController();
      this.testLog          = new TestLogController();
      this.errorCodes       = new ErrorCodeController();
      this.testComponents   = new TestComponentController();
    }
    if (CONFIG.IML_SUPPORT == true)
    {
      this.imlLog = new ImlLogController();
    }

    this.saveRequest = new ServerRequest();
    this.saveRequest.callback = function (data)
    {
      Frontend.clientSaveReady(data);
    }

    this.startup();
  },


  startup: function startup()
  {
    if (CONFIG.SCRIPT_TESTING_PID != undefined)
    {
      this.tabs.selectTab('status');
      this.statusController.startMonitoring(CONFIG.SCRIPT_TESTING_PID);
    }
    else if (CONFIG.FACTORY_ERRORS == true)
    {
      this.tabs.logTabs.selectTab('errorLog');
      this.tabs.selectTab('log');
    }
    this.initializeUserInterface();
  },


/********************************************************************
//        NAME- Frontend.initializeUserInterface
// DESCRIPTION- Performs some final graphical adjustments before
//              removing the splash screen and revealing the UI
//      PASSED- 
//     RETURNS- 
//       NOTES- 
********************************************************************/
  initializeUserInterface: function initializeUserInterface()
  {
    getElement('aboutDialogButton').onclick = function ()
    {
      Frontend.aboutDialog.hide();
    }
    if (CONFIG.IS_OFFLINE === true || CONFIG.IS_FACTORY === true)
    {
      getElement('exitDiags').action = function ()
      {
        Frontend.shutdown();
      }
    }
    if (CONFIG.DIAGNOSIS_SUPPORT)
    {
      getElement('diagnosisMoreInfoButton').onclick = function ()
      {
        Frontend.aboutDiagnosisDialog.show();
      }
      getElement('aboutDiagnosisDialogButton').onclick = function ()
      {
        Frontend.aboutDiagnosisDialog.hide();
      }
    }
    addClass(getElement('initialWait'), 'hidden');
    removeClass(getElement('masthead'), 'hidden');
    removeClass(getElement('content'), 'hidden');
    // we reselect our starting tab in order to get the UI adjusted to the resolution
    // it must be done after 'content' is no longer hidden, but before the splash screen is hidden
    this.tabs.reselectTab();
    //this.currentConfig.refresh();
    //this.splashScreen.hide();
  },

  initializeButtons: function initializeButtons()
  {
    var buttons = getTagsByClassName('div', 'button').concat(getTagsByClassName('div', 'subButton'));
    var count = buttons.length;
    for (var i=0; i<count; i++)
    {
      var button = buttons[i];
      button.is_disabled = false;
      button.onclick = function ()
      {
        if (this.is_disabled == false && this.action != undefined)
          this.action();
      }
      button.onselectstart = function()
      {
        return false;
      }
      button.onmouseover = function ()
      {
        if (this.is_disabled != true)
        {
          if (hasClass(this, 'button'))
            replaceClass(this, 'button', 'buttonHover');
          else
            replaceClass(this, 'subButton', 'subButtonHover');
        }
      }
      button.onmouseout = function ()
      {
        if (this.is_disabled != true)
        {
          if (hasClass(this, 'buttonHover'))
          {
            replaceClass(this, 'buttonHover', 'button');
          }
          else
            replaceClass(this, 'subButtonHover', 'subButton');
        }
      }
      button.disable = function ()
      {
        this.is_disabled = true;
        if (hasClass(this, 'button'))
          replaceClass(this, 'button', 'buttonDisabled');
        else if (hasClass(this, 'buttonHover'))
          replaceClass(this, 'buttonHover', 'buttonDisabled');
        else if (hasClass(this, 'subButton'))
          replaceClass(this, 'subButton', 'subButtonDisabled');
        else if (hasClass(this, 'subButtonHover'))
          replaceClass(this, 'subButtonHover', 'subButtonDisabled');
      }
      button.enable = function ()
      {
        this.is_disabled = false;
        if (hasClass(this, 'buttonDisabled'))
          replaceClass(this, 'buttonDisabled', 'button');
        else
          replaceClass(this, 'subButtonDisabled', 'subButton');
      }
    }
  },

  checkKeyCommand : function checkKeyCommand(event)
  {
    if (event.ctrlKey == true &&
        event.altKey == true &&
        eventKey(event) == 65)
    {
      Frontend.promptAdvancedMode();
    }
  },

  promptAdvancedMode : function promptAdvancedMode()
  {
    if (CONFIG.ADVANCED_MODE != true && CONFIG.IS_FACTORY != true)
    {
      var dialog = this.dialog;
      dialog.setHeader(translate('MSG_ADVANCED_MODE'));
      dialog.toggleBadge(false);
      dialog.toggleHeader(true);
      dialog.toggleContent(true);
      dialog.toggleButtons(true);
      var secondPrompt = function ()
      {
        dialog.setContent(translate('MSG_ADVANCED_MODE_PROMPT2'));
        dialog.clearButtons();
        dialog.addButton(translate('MSG_OK'), 0, function ()
        {
          dialog.hide();
          Frontend.triggerAdvancedMode();
        });
        dialog.addButton(translate('MSG_CANCEL'), 1, function ()
        {
          dialog.hide();
        });
        dialog.show();
      }
      dialog.setContent(translate('MSG_ADVANCED_MODE_PROMPT1'));
      dialog.clearButtons();
      dialog.addButton(translate('MSG_OK'), 0, function ()
      {
        dialog.hide();
        secondPrompt();
      });
      dialog.addButton(translate('MSG_CANCEL'), 1, function ()
      {
        dialog.hide();
      });
      dialog.show();
    }
  },

  triggerAdvancedMode: function triggerAdvancedMode()
  {
    CONFIG.ADVANCED_MODE = true;
    var loadingString = (translate('MSG_LOADING') + ' ...');
    Frontend.quickTests.element.innerHTML = loadingString;
    Frontend.completeTests.element.innerHTML = loadingString;
    Frontend.customTests.element.innerHTML = loadingString;
    Frontend.customTests.deselectLeaf();
    var testTab = Frontend.tabs.tabs.test;
    var testTabs = [Frontend.tabs.testTabs.tabs.quick, Frontend.tabs.testTabs.tabs.complete, Frontend.tabs.testTabs.tabs.custom];
    var count = testTabs.length;
    for (var i=0; i<count; i++)
    {
      var tab = testTabs[i];
      if (testTab.isActive == true &&
          tab.isActive == true)
        tab.reinitialize();
      else
        tab.isInitialized = false;
    }
    removeClass(getElement('advancedModeLabel'), 'hidden');
  },

  reportError: function reportError(value, display)
  {
    var request = new ServerRequest('commands/logUIError.php');
    request.addVariable('value', value);
    request.send();
    if (display)
    {
      this.inform(value, translate('MSG_ERROR'));
    }
  },

  inform: function inform(value, header)
  {
    if (this.dialog != undefined)
    {
      if (header)
      {
        this.dialog.toggleHeader(true);
        this.dialog.setHeader(header);
      }
      else
      {
        this.dialog.toggleHeader(false);
      }
      this.dialog.toggleBadge(false);
      this.dialog.toggleContent(true);
      this.dialog.toggleButtons(true);
      this.dialog.setContent(value);
      this.dialog.clearButtons();
      this.dialog.addButton();
      this.dialog.show();
    }
    else
    {
      window.alert(value);
    }
  },

  heartbeat: function heartbeat(callback)
  {
    if (this.sessionRefresher != undefined)
      this.sessionRefresher.heartbeat(callback);
    else
      callback();
  },

  clientSaving: false,
  clientSave: function clientSave(commandURL, queryObject, dialogHeader)
  {
    if (this.clientSaving == false)
    {
      this.clientSaving = true;
      dialogHeader = dialogHeader || translate('MSG_SAVE');
      this.dialog.toggleButtons(false);
      this.dialog.toggleBadge(false);
      this.dialog.toggleHeader(true);
      this.dialog.toggleContent(true);
      this.dialog.setHeader(dialogHeader);
      this.dialog.setContent(translate('MSG_PREPARING_FILE') + ' ...');
      this.dialog.show();
  
      var saveWatcher = new ServerRequest();
      saveWatcher.callback = function ()
      {
        Frontend.clientSaveComplete();
      }
      saveWatcher.url = 'utils/saveWatcher.php';
  
      var url = new URLBuilder(commandURL);
      for (var field in queryObject)
        url.addToQuery(field, queryObject[field]);
      window.location = url.toString();
  
      saveWatcher.send();
    }
  },

  clientSaveComplete: function clientSaveReady()
  {
    this.clientSaving = false;
    this.dialog.hide();
  },

  restart: function restart()
  {
    if (!Frontend.statusController.isIdle())
    {
      Frontend.inform(translate('MSG_PLEASE_WAIT_FOR_TESTS'), translate('MSG_RELOAD') + ' ' + translate('MSG_DIAGNOSTICS'));
    }
    else
    {
      var dialog = this.dialog;
      dialog.setHeader(translate('MSG_RELOAD') + ' ' + translate('MSG_DIAGNOSTICS'));
      dialog.setContent(translate('MSG_CLICK_OK_TO_RESTART'));
      dialog.clearButtons();
      dialog.addButton(translate('MSG_OK'), 0, function ()
      {
        dialog.hide();
        Frontend.showRestart();
        var request = new ServerRequest('commands/shutdownDiags.php');
        request.addVariable('doReboot', 'no');
        request.callback = function ()
        {
          setTimeout(function ()
          {
            var url = (CONFIG.BASE_URI + 'startup.php');
            var parameters = [];
            if (CONFIG.ADVANCED_MODE)
              parameters.push('advancedMode=on');
            if (CONFIG.DEBUG_MODE)
              parameters.push('debugMode=on');
            if (parameters.length > 0)
              url += ('?' + parameters.join('&'));
            window.location = url;
          }, 10000);
        }
        request.send();
      });
      dialog.addButton(translate('MSG_CANCEL'), 1, function ()
      {
        dialog.hide();
      });
      dialog.toggleBadge(false);
      dialog.toggleHeader(true);
      dialog.toggleContent(true);
      dialog.toggleButtons(true);
      dialog.show();
    }
  },

  shutdown: function shutdown()
  {
    if (!Frontend.statusController.isIdle())
    {
      Frontend.inform(translate('MSG_PLEASE_WAIT_FOR_TESTS'), translate('MSG_EXIT') + ' ' + translate('MSG_DIAGNOSTICS'));
    }
    else
    {
      var dialog = this.dialog;
      dialog.setHeader(translate('MSG_EXIT') + ' ' + translate('MSG_DIAGNOSTICS'));
      dialog.setContent(translate('MSG_CLICK_OK_TO_EXIT'));
      dialog.clearButtons();
      dialog.addButton(translate('MSG_OK'), 0, function ()
      {
        dialog.hide();
        Frontend.showGoodbye();
        var request = new ServerRequest('commands/shutdownDiags.php');
        request.callback = function ()
        {
          Frontend.closeWindow();
        }
        request.send();
      });
      dialog.addButton(translate('MSG_CANCEL'), 1, function ()
      {
        dialog.hide();
      });
      dialog.toggleBadge(false);
      dialog.toggleHeader(true);
      dialog.toggleContent(true);
      dialog.toggleButtons(true);
      dialog.show();
    }
  },

  showGoodbye: function showGoodbye()
  {
    var dialog = this.dialog;
    dialog.setBadge('images/hourglass.gif');
    dialog.setHeader(translate('MSG_EXIT') + ' ' + translate('MSG_DIAGNOSTICS'));
    dialog.setContent(translate('MSG_SHUTTING_DOWN_INSIGHT_DIAGNOSTICS'));
    dialog.toggleBadge(true);
    dialog.toggleHeader(true);
    dialog.toggleContent(true);
    dialog.clearButtons();
    dialog.toggleButtons(false);
    dialog.show();
  },

  showRestart: function showRestart()
  {
    var dialog = this.dialog;
    dialog.setBadge('images/hourglass.gif');
    dialog.setHeader(translate('MSG_PLEASE_WAIT'));
    dialog.setContent(translate('MSG_REFRESH_TITLE'));
    dialog.toggleBadge(true);
    dialog.toggleHeader(true);
    dialog.toggleContent(true);
    dialog.clearButtons();
    dialog.toggleButtons(false);
    dialog.show();
  },

  closeWindow: function closeWindow()
  {
    window.opener = self;
    //window.close();
    setTimeout(function ()
    {
      window.close();
      window.blur();
    }, 1);
  }
}
