/********************************************************************
//        NAME- CompleteTestController
// DESCRIPTION- controls all the functions of the completeTest
//              panel
//       NOTES- The majority of this object's functionality comes
//              from inheriting TestList
********************************************************************/

/********************************************************************
// CompleteTestController() : constructor
// Instantiates the CompleteTestController object
********************************************************************/
function CompleteTestController()
{
  // create a new TestDurationController with the appropriate values
  var durationController = new TestDurationController('completeTestLoopMode', 'completeTestNumberOfLoops', 'completeTestTimeMode', 'completeTestNumberOfMinutes');

  // inherit from TestList
  inherit(this, new TestList('completeTestDeviceList',
                             'completeTestInteractiveMode',
                             'completeTestUnattendedMode',
                             durationController,
                             'completeTestStopOnError',
                             'beginCompleteTesting',
                             'scheduleCompleteTests',
                             translate('MSG_SCHEDULED_COMPLETE_TESTS')));

  // assign additional variables
  this.dataSource = 'commands/getStandardTests.php';
  this.testType   = 'complete';

  // initialize the object
  this.init();
}
