function DiagnosisLogController()
{
  this.saveCommand   = 'commands/saveDiagnosisLog.php';
  this.viewURL = 'views/diagnosisLog.php';

  this.viewController = new ViewController('diagnosisLogFrame');
  this.clearRequest = new ServerRequest('commands/clearDiagnosisLog.php');
  
  this.saveButton = getElement('saveDiagnosisLog');
  this.clearButton = getElement('clearDiagnosisLog');

  this.shadowBox = this.viewController.shadowBox;
  
  this.init();
}

DiagnosisLogController.prototype.init = function init()
{
  this.clearButton.controller = this;
  this.clearButton.action = function ()
  {
    this.controller.promptToClearLog(translate('MSG_DIAGNOSIS_LOG'), this.controller);
  }
  this.clearButton.disable();

  this.saveButton.controller = this;
  this.saveButton.action = function ()
  {
    //Frontend.saveDialog.openDialog((translate('MSG_SAVE') + ' ' + translate('MSG_DIAGNOSIS_LOG')), 'diagnosislog', this.controller);
    this.controller.save();
  }
  this.saveButton.disable();
  
  this.clearRequest.controller = this;
  this.clearRequest.callback = function ()
  {
    this.controller.refreshFrame();
  }
}

DiagnosisLogController.prototype.refreshFrame = function refreshFrame()
{
  this.clearButton.disable();
  this.saveButton.disable();
  this.viewController.setURL(this.viewURL);
}

DiagnosisLogController.prototype.promptToClearLog = function promptToClearLog(title)
{
  var controller = this;
  var dialog = Frontend.dialog;
  dialog.toggleBadge(false);
  dialog.setHeader(title);
  dialog.toggleHeader(true);
  dialog.setContent(translate('MSG_CLEAR_LOG_CONFIRMATION'));
  dialog.toggleContent(true);
  dialog.clearButtons();
  dialog.addButton(translate('MSG_OK'), null, function ()
  {
    dialog.hide();
    controller.clearLog();
  });
  dialog.addButton(translate('MSG_CANCEL'), null, function ()
  {
    dialog.hide();
  });
  dialog.toggleButtons(true);
  dialog.show();
}

DiagnosisLogController.prototype.clearLog = function clearLog()
{
  this.clearRequest.send();
}

DiagnosisLogController.prototype.appendSaveInfo = function appendSaveInfo(request)
{
  return false;
}

DiagnosisLogController.prototype.save = function save()
{
  var header = (translate('MSG_SAVE') + ' ' + translate('MSG_DIAGNOSIS_LOG'));
  if (CONFIG.IS_OFFLINE)
  {
    Frontend.saveDialog.openDialog(header, 'diagnosislog', this);
  }
  else
  {
    var query = 
    {
      attachment : 1,
      filename   : 'diagnosislog'
    }
    Frontend.clientSave(this.saveCommand, query, header);
  }
}