function HTMLTag(tag)
{
	this.tag = tag;
	this.empty = false;
	this.xhtml = true;
	this.children = [];
	this.attributes = {};
	
	if (arguments.length > 1)
	{
		var defaultAttributes = arguments[1];
		for (var name in defaultAttributes)
		{
			var value = defaultAttributes[name];
			if (typeof value != 'function')
			{
				if (name == 'text')
					this.appendChild(value);
				else
					this.setAttribute(name, value);
			}
		}
	}
}

HTMLTag.prototype.setAttribute = function setAttribute(name, value)
{
	this.attributes[name] = value;
	return this;
}

HTMLTag.prototype.appendChild = function appendChild(child)
{
	if (!this.children.contains(child))
		this.children.push(child);
	return child;
}

HTMLTag.prototype.removeChild = function removeChild(child)
{
	this.children.remove(child);
	return child;
}

HTMLTag.prototype.insertBefore = function insertBefore(beforeMe, child)
{
	if (this.children.contains(beforeMe))
	{
		var index = this.children.indexOf(beforeMe);
		this.children.splice(index, 0, child);
	}
	return child;
}

HTMLTag.prototype.replaceChild = function replaceChild(replaceMe, child)
{
	if (this.children.contains(replaceMe))
	{
		var index = this.children.indexOf(replaceMe);
		this.children.splice(index, 1, child);
	}
	return child;
}

HTMLTag.prototype.draw = function draw(canvas)
{
	var array = (canvas.push != undefined) ? canvas : [];
	array.push('<' + this.tag);
	for (var name in this.attributes)
	{
		var value = this.attributes[name];
		if (typeof value == 'string')
			array.push(' ' + name + '="' + value + '"');
	}
	if (this.empty)
	{
		if (this.xhtml)
			array.push(' />');
		else
			array.push('>');
	}
	else
	{
		array.push('>');
    this.children.compact() // remove null and undefined's
		var childCount = this.children.length;
		if (childCount > 0)
		{
			for (var i=0; i<childCount; i++)
			{
				var child = this.children[i];	
        if (typeof child == 'string')
					array.push(child);
				else if (child.draw != undefined)
					child.draw(array);
			}
		}
		array.push('</' + this.tag + '>');
	}
	if (canvas.innerHTML != undefined)
		canvas.innerHTML = array.join('');
	return this;	
}

HTMLTag.prototype.toString = function toString()
{
	return ('[HTMLTag ' + this.tag + ']');
}