function LogTabController()
{
  inherit(this, TabController);
  
  this.init();
}

LogTabController.prototype.init = function init()
{
  // setup tabs
  this.addTab('error', 'errorLogTab', ['errorLogView', 'errorLogViewFooter'], ['errorLogFrame'], 'errorLogFrame');
  if (CONFIG.DIAGNOSIS_SUPPORT == true)
    this.addTab('diagnosis', 'diagnosisLogTab', ['diagnosisLogView', 'diagnosisLogViewFooter'], ['diagnosisLogFrame'], 'diagnosisLogFrame');
  if (CONFIG.SURVEY_ONLY == false)
    this.addTab('test', 'testLogTab', ['testLogView', 'testLogViewFooter'], ['testLogFrame'], 'testLogFrame');
  if (CONFIG.IML_SUPPORT == true)
    this.addTab('iml', 'imlLogTab', ['imlLogView', 'imlLogViewFooter'], ['imlLogFrame'], 'imlLogFrame');

  // setup error tab actions
  this.tabs.error.addActivationAction(function(that)
  {
    Frontend.errorLog.refreshFrame();
  });

  if (CONFIG.DIAGNOSIS_SUPPORT == true)
  {
    // setup diagnosis tab actions
    this.tabs.diagnosis.addActivationAction(function(that)
    {
      Frontend.diagnosisLog.refreshFrame();
    });
  }

  if (CONFIG.SURVEY_ONLY == false)
  {
    // setup test tab actions
    this.tabs.test.addActivationAction(function(that)
    {
      Frontend.testLog.refreshFrame();
    });
  }

  if (CONFIG.IML_SUPPORT == true)
  {
    // setup iml tab actions
    this.tabs.iml.addActivationAction(function(that)
    {
      Frontend.imlLog.refreshFrame();
    });
  }
}
