function ModalCurtain()
{
  if (CONFIG.IS_WINDOWS === true)
  {
    this.element = newElement('div', {'class':'modalCurtain'});
    this.filter  = newElement('iframe', {'class':'modalCurtainFilter'});
  }
  else
  {
    this.element = newElement('div', {'class':'blockingCurtain'});
  }

  this.init();
}

ModalCurtain.prototype.init = function init()
{
  if (CONFIG.IS_WINDOWS === true)
  {
    //this.filter.hide();
    addClass(this.filter, 'modalCurtain-hidden');
    this.filter.fade(100);
    this.filter.src = 'utils/dummy.html';
    Body.appendChild(this.filter);
    this.element.fade(50);
  }
  //this.element.hide();
  addClass(this.element, 'modalCurtain-hidden');
  Body.appendChild(this.element);  
}

ModalCurtain.prototype.show = function show()
{
  this.element.conformTo(Body);
  //this.element.show();
  removeClass(this.element, 'modalCurtain-hidden');
  if (CONFIG.IS_WINDOWS === true)
  {
    this.filter.conformTo(Body);
    //this.filter.show();
    removeClass(this.filter, 'modalCurtain-hidden');
  }
}

ModalCurtain.prototype.hide = function hide()
{
  //this.element.hide();
  addClass(this.element, 'modalCurtain-hidden');
  if (CONFIG.IS_WINDOWS === true)
    addClass(this.filter, 'modalCurtain-hidden');
    //this.filter.hide();
}
