function ScheduleDialog()
{
  inherit(this, new ModalElement(getElement('scheduleDialog')));

  this.scheduleCommand = 'commands/scheduleProcess.php';

  this.tabs = new TabController();
  this.header = getElement('scheduleDialogHeader');
  this.weeklyFieldset = extendElement(getElement('weeklyFieldset'));
  this.monthlyFieldset = extendElement(getElement('monthlyFieldset'));
  this.weeklyAllWidget = getElement('weeklyAll');
  this.monthlyAllWidget = getElement('monthlyAll');
  this.hourField = getElement('scheduleDialogHourField');
  this.minuteField = getElement('scheduleDialogMinuteField');
  this.okButton = getElement('scheduleDialogOkButton');
  this.cancelButton = getElement('scheduleDialogCancelButton');

  this.init();
}

ScheduleDialog.prototype.init = function init()
{
  this.tabs.addTab('week', 'weeklyTab', ['weeklyContent'], [], '');
  this.tabs.addTab('month', 'monthlyTab', ['monthlyContent'], [], '');

  this.okButton.controller = this;
  this.okButton.onclick = function ()
  {
    this.controller.sendSchedule();
  }

  this.cancelButton.controller = this;
  this.cancelButton.onclick = function ()
  {
    this.controller.hide();
  }

  var weeklyInputs = this.weeklyFieldset.getElementsByTagName('input');
  var numberOfInputs = weeklyInputs.length;
  for (var i=0; i<numberOfInputs; i++)
  {
    var input = weeklyInputs[i];
    input.controller = this;
    input.onclick = function ()
    {
      this.controller.weeklyInputSelected();
    }
  }

  var monthlyInputs = this.monthlyFieldset.getElementsByTagName('input');
  var numberOfInputs = monthlyInputs.length;
  for (var i=0; i<numberOfInputs; i++)
  {
    var input = monthlyInputs[i];
    input.controller = this;
    input.onclick = function ()
    {
      this.controller.monthlyInputSelected();
    }
  }

  this.weeklyAllWidget.controller = this;
  this.weeklyAllWidget.onclick = function ()
  {
    this.controller.toggleAll('weekly', this.checked);
  }

  this.monthlyAllWidget.controller = this;
  this.monthlyAllWidget.onclick = function ()
  {
    this.controller.toggleAll('monthly', this.checked);
  }
}

ScheduleDialog.prototype.openDialog = function openDialog(title, controller)
{
  this.controller = controller;
  this.title = title;
  this.header.innerHTML = title;
  this.show();
}

ScheduleDialog.prototype.willShow = function willShow()
{
  if (this.tabs.currentTab == undefined)
  {
    var weeklyHeight = this.weeklyFieldset.getHeight();
    var monthlyHeight = this.monthlyFieldset.getHeight();
    if (monthlyHeight > weeklyHeight)
      this.weeklyFieldset.setHeight(monthlyHeight);
    else if (weeklyHeight > monthlyHeight)
      this.monthlyFieldset.setHeight(weeklyHeight);
    this.tabs.selectTab('week');
  }
}

ScheduleDialog.prototype.toggleAll = function toggleAll(mode, bool)
{
  if (mode == 'weekly')
    var fieldset = this.weeklyFieldset;
  else
    var fieldset = this.monthlyFieldset;
  var inputs = fieldset.getElementsByTagName('input');
  var numberOfInputs = inputs.length;
  for (var i=0; i<numberOfInputs; i++)
    inputs[i].checked = bool;
}

ScheduleDialog.prototype.weeklyInputSelected = function weeklyInputSelected()
{
  this.weeklyAllWidget.checked = false;
}

ScheduleDialog.prototype.monthlyInputSelected = function monthlyInputSelected()
{
  this.monthlyAllWidget.checked = false;
}

ScheduleDialog.prototype.sendSchedule = function sendSchedule()
{
  var hour = this.hourField.value;
  var minute = this.minuteField.value;
  if (this.tabs.currentTab.name == 'week')
  {
    var mode = 'weekly';
    var months = [];
    var monthdays = [];
    var weekdays = this.getSelectedWeekdays();
  }
  else
  {
    var mode = 'monthly';
    var months = ['1','2','3','4','5','6','7','8','9','10','11','12'];
    var monthdays = this.getSelectedMonthdays();
    var weekdays = [];
  }
  if (isNaN(hour) || hour > 23 || hour < 0 || isNaN(minute) || minute > 59 || minute < 0)
  {
    this.inform(translate('MSG_INVALID_TIME'));
  }
  else if (mode == 'weekly' && weekdays.length <= 0)
  {
    this.inform(translate('MSG_SELECT_WEEKDAYS'))
  }
  else if (mode == 'monthly' && monthdays.length <= 0)
  {
    this.inform(translate('MSG_SELECT_MONTHDAYS'))
  }
  else // all parameters are valid
  {
    var request = new ServerRequest(this.scheduleCommand, 'POST');
    request.controller = this;
    request.addVariable('scheduleMode', mode);
    request.addVariable('hour', hour);
    request.addVariable('minute', minute);
    request.addVariable('months', months.join(','));
    request.addVariable('monthdays', monthdays.join(','));
    request.addVariable('weekdays', weekdays.join(','));
    this.controller.appendScheduleInfo(request);
    request.callback = function (data)
    {
      this.controller.response(data);
    }
    request.send();
    //this.hide();
    this.inform(translate('MSG_SCHEDULING_TASK'), false);
  }
}

ScheduleDialog.prototype.getSelectedWeekdays = function getSelectedWeekdays()
{
  var selectedWeekdays = [];
  var weekdays = this.weeklyFieldset.getElementsByTagName('input');
  var numberOfWeekdays = (weekdays.length - 1) // we want to ignore the last input, which is the ALL input
  for (var i=0; i<numberOfWeekdays; i++)
  {
    var weekday = weekdays[i];
    if (weekday.checked == true)
      selectedWeekdays.push(weekday.value);
  }
  return selectedWeekdays;
}

ScheduleDialog.prototype.getSelectedMonthdays = function getSelectedMonthdays()
{
  var selectedMonthdays = [];
  var monthdays = this.monthlyFieldset.getElementsByTagName('input');
  var numberOfMonthdays = (monthdays.length - 1) // we want to ignore the last input, which is the ALL input
  for (var i=0; i<numberOfMonthdays; i++)
  {
    var monthday = monthdays[i];
    if (monthday.checked == true)
      selectedMonthdays.push(monthday.value);
  }
  return selectedMonthdays;
}

ScheduleDialog.prototype.inform = function inform(message, doIncludeButton, doShowSelfAfterDismiss)
{
  doShowSelfAfterDismiss = (doShowSelfAfterDismiss == undefined) ? true : doShowSelfAfterDismiss;
  doIncludeButton = (doIncludeButton == undefined) ? true : doIncludeButton;
  var dialog = Frontend.dialog;
  if (this.title != undefined)
  {
    dialog.setHeader(this.title);
    dialog.toggleHeader(true);
  }
  else
  {
    dialog.toggleHeader(false);
  }
  dialog.toggleBadge(false);
  dialog.setContent(message);
  dialog.toggleContent(true);
  dialog.clearButtons();
  if (doIncludeButton)
  {
    dialog.addButton(translate('MSG_OK'), null, function ()
    {
      if (doShowSelfAfterDismiss)
        Frontend.scheduleDialog.show();
      Frontend.dialog.hide();
    });
    dialog.toggleButtons(true);
  }
  else
  {
    dialog.toggleButtons(false);
  }
  dialog.show();
  this.hide();
}

ScheduleDialog.prototype.endInform = function endInform(doShowSelf)
{
  if (doShowSelf)
    this.show();
  Frontend.dialog.hide();
}

ScheduleDialog.prototype.response = function response(data)
{
  this.endInform();
  if (data.name && data.name.indexOf('Error') >= 0)
  {
    this.inform(data.name + ': ' + data.value);
  }
  else
  {
    this.inform(translate('MSG_TASK_SCHEDULED'), true, false);
  }
}
