function TestDurationController(loopsButton, loopsValue, minutesButton, minutesValue)
{
  this.loopsButton   = getElement(loopsButton);
  this.loopsValue    = getElement(loopsValue);
  this.minutesButton = getElement(minutesButton);
  this.minutesValue  = getElement(minutesValue);

  this.init();
}

TestDurationController.prototype.init = function init()
{
  this.loopsButton.controller = this;
  this.loopsButton.onclick = function onclick()
  {
    this.controller.updateEnabled();
  }

  this.loopsValue.controller = this;

  this.minutesButton.controller = this;
  this.minutesButton.onclick = function onclick()
  {
    this.controller.updateEnabled();
  }

  this.minutesValue.controller = this;
  
  this.updateEnabled();
}

TestDurationController.prototype.updateEnabled = function updateEnabled()
{
  if (this.loopsButton.checked == true)
  {
    this.loopsValue.disabled = false;
    this.minutesValue.disabled = true;
    this.type = 'loop';
  }
  else
  {
    this.loopsValue.disabled = true;
    this.minutesValue.disabled = false;
    this.type = 'time';
  }
}

TestDurationController.prototype.getValue = function getValue()
{
  var value = '';
  if (this.type == 'loop')
    value = this.loopsValue.value;
  else
    value = this.minutesValue.value;
  return value;
}
