function URLBuilder(path)
{
  this.path = path || '';
  this.hash = null;
  this.query = [];
}

URLBuilder.prototype.addToQuery = function addToQuery(field, value)
{
  this.query.push([field, value]);
}

URLBuilder.prototype.toString = function toString()
{
  var string = this.path;
  if (this.query.length > 0)
  {
    var encodedQuery = [];
    var count = this.query.length;
    for (var i=0; i<count; i++)
    {
      var field = encodeURIComponent(this.query[i][0]);
      var value = encodeURIComponent(this.query[i][1]);
      encodedQuery.push(field + '=' + value);
    }
    string += ('?' + encodedQuery.join('&'));
  }
  if (this.hash != null)
    string += ('#' + this.hash);
  return string;
}
