function ViewController(frameRef)
{
  this.dummyURL = 'utils/dummy.html';
  this.hiddenClass = 'hiddenFrame';
  this.parameters = {};

  if (typeof frameRef == 'string')
    this.frame = getElement(frameRef);
  else
    this.frame = frameRef;

  this.shadowBox = new ShadowBox2(this, this.frame);
  this.useShadowBox = true;

  //this.init();
}

ViewController.prototype.init = function init()
{
  addClass(this.frame, this.hiddenClass);
  this.setURL(this.dummyURL);
}

ViewController.prototype.getContentWindow = function getContentWindow()
{
  if (this.frame.contentWindow)
    return this.frame.contentWindow;
  else
    return null;
}

ViewController.prototype.getContentDocument = function getContentDocument()
{
  if (this.frame.contentDocument)
    return this.frame.contentDocument;
  else if (this.getContentWindow().document)
    return this.getContentWindow().document;
  else
    return null;
}

ViewController.prototype.hide = function hide()
{
  addClass(this.frame, this.hiddenClass);
}

ViewController.prototype.show = function show()
{
  removeClass(this.frame, this.hiddenClass);
}

ViewController.prototype.setURL = function setURL(newURL)
{
  if (this.shouldSetURL())
  {
    var that = this;
    this.willSetURL();
    var url = '';
    if (CONFIG != undefined && CONFIG.BASE_URI != undefined)
      url += CONFIG.BASE_URI;
    url += newURL;
    url = this.appendQueryString(url);
    Frontend.heartbeat(function ()
    {
      that.frame.src = url;
    });
    this.url = newURL;
    this.didSetURL();
  }
}

ViewController.prototype.refresh = function refresh()
{
  this.setURL(this.url);
}

ViewController.prototype.shouldSetURL = function shouldSetURL()
{
  return true;
}

ViewController.prototype.willSetURL = function willSetURL()
{
  if (CONFIG != undefined)
  {
    if (CONFIG.DEBUG_MODE == true)
      this.setParameter('debugMode', 'on');
    if (CONFIG.OVERRIDE_IDRESULT != undefined)
      this.setParameter('overrideIdResult', CONFIG.OVERRIDE_IDRESULT);
  }
  //this.setParameter('r', Math.random());
  if (this.useShadowBox == true)
    this.shadowBox.show();
  return true;
}

ViewController.prototype.didSetURL = function didSetURL()
{
  return true;
}

ViewController.prototype.appendQueryString = function appendQueryString(url)
{
  var queryBits = [];
  var parameters = this.parameters;
  for (var key in parameters)
  {
    var value = parameters[key];
    if (value != null)
    {
      if (value.classid && value.classid == 'array')
      {
        var count = value.length;
        for (var i=0; i<count; i++)
        {
          queryBits.push(key + '=' + value[i]);
        }
      }
      else
      {
        queryBits.push(key + '=' + value);
      }
    }
  }
  if (queryBits.length > 0)
    url += ('?' + queryBits.join('&'));
  return url;
}

ViewController.prototype.setParameter = function addParameter(key, value)
{
  var parameters = this.parameters;
  if (key.substr(-2,2) == '[]')
  {
    if (parameters[key] == undefined)
      parameters[key] = [value];
    else
      parameters[key].push(value);
  }
  else
  {
    parameters[key] = value;
  }
}

ViewController.prototype.unsetParameter = function removeParameter(key)
{
  var parameters = this.parameters;
  if (parameters[key] != undefined)
    parameters[key] = undefined;
}

ViewController.prototype.clearParameters = function clearParameters()
{
  this.parameters = {};
}
