<?php
// SETUP page
ini_set('error_reporting', E_ALL);
ini_set('display_errors', true);

header('Content-type: text/html; charset=utf-8', true);
header('Cache-control: no-cache', true);
header('Pragma: no-cache');

require_once 'includes/constants.php';  
require_once 'includes/aibridge.class.php';
require_once 'includes/translations.php';

// GATHER required data
$numberOfSlots = checkDiagConfig("/factory/ErrorScreenSlots", "slots");

$testLogXML = AIBridge::getTestLog();
$testLogDocument = new XMLDocument($testLogXML);
$testLogXPath = xpath_new_context($testLogDocument->document_element());

$errorLogXML = AIBridge::getErrorLog();
$errorLogDocument = new XMLDocument($errorLogXML);
$errorLogXPath = xpath_new_context($errorLogDocument->document_element());

// PREPARE data for display
// we start with 1 so that the keys match the slot #
$slots = array_fill(1, $numberOfSlots, array('status'    => 'empty',
                                             'caption'   => '',
                                             'error'     => '',
                                             'errorCode' => ''));
$columnWidth = floor(100 / $numberOfSlots); // percentage width of columns

// PARSE data from xml documents
$testLogRecords = xpath_eval($testLogXPath, '/testLogRecord');
foreach ($testLogRecords->nodeset as $testLogRecord)
{
  $caption = $testLogRecord->get_attribute("testCaption");
  // Caption should be formatted as: "Array Controller, HP P700m, Slot 1 - Controller MFG NVRAM test"
  $slotMatches = array();
  $matchesFound = preg_match("/Slot ([0-9]+)/", $caption, $slotMatches);
  if ($matchesFound)
  {
    $slotNumber = ($slotMatches[1]);
    if ($slotNumber > 0 && $slotNumber <= $numberOfSlots)
    {
      $slot = &$slots[$slotNumber];
      $device = $testLogRecord->get_attribute("device");
      $test = $testLogRecord->get_attribute("test");
      
      $errorLogRecords = xpath_eval($errorLogXPath, "/errorLogRecord[@device='{$device}' and @test='{$test}']");
      if (count($errorLogRecords->nodeset) == 0)
      {
        if ($slot['status'] == 'empty')
        {
          // only mark a slot as passed if it hasn't been marked as failed already
          $slot['status'] = 'passed';
        }
      }
      else
      {
        foreach ($errorLogRecords->nodeset as $errorLogRecord)
        {
          $slot['status'] = 'failed';
          $slot['caption'] = $caption;
          $errorLogRecordXPath = xpath_new_context($errorLogRecord);
          $errors = xpath_eval($errorLogRecordXPath, '/error');
          if (count($errors->nodeset) > 0)
          {
            $error = $errors->nodeset[0]; // we only want the first item, this should be the most recent
            $slot['error'] = $error->get_attribute('caption');
            $slot['errorCode'] = $error->get_attribute('errorCode');
          }
        }
      }
    }
  }
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
  <title><?=translate('MSG_HP_INSIGHT_DIAGNOSTICS');?></title>
  <link type="text/css" rel="stylesheet" media="all" href="css/slotdisplay.css"></link>
  <script type="text/javascript" src="js/lib.js"></script>
  <script type="text/javascript">
  function init()
  {
    var closeButton = getElement("closeWindowButton");
    addEvent(closeButton, "click", closeWindow);
  }
  
  function closeWindow()
  {
    window.opener = self;
    window.close();
  }
  </script>
  <style type="text/css">
  #slotTable tbody td { width: <?php echo $columnWidth; ?>%; }
  </style>
</head>

<body onload="init();">

<table id="slotTable">
  <thead>
    <tr>
      <th colspan="<?php echo $numberOfSlots; ?>">
        <?php echo translate("MSG_FINAL_TEST_STATUS"); ?>
      </th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <?php
      unset($slot); // required, otherwise PHP starts skipping items (weird bug)
      foreach ($slots as $slotNumber => $slot)
      {
        ?>
        <td class="<?php echo $slot['status']; ?>">
          <?php if ($slot['status'] == 'failed'): ?>
          <p class="caption"><?php echo $slot['caption']; ?></p>
          <p class="error"><?php echo $slot['error']; ?></p>
          <p class="errorCode"><?php echo $slot['errorCode']; ?></p>
          <?php elseif ($slot['status'] == 'passed'): ?>
          <p class="slotNumber">Slot <?php echo $slotNumber; ?></p>
          <p class="status"><?php echo strtoupper(translate("MSG_PASSED")); ?></p>
          <?php else: ?>
          <p class="slotNumber">Slot <?php echo $slotNumber; ?></p>
          <p class="status"><?php echo strtoupper(translate("MSG_EMPTY")); ?></p>
          <?php endif; ?>
        </td>
        <?php
      }
      ?>
    </tr>
  </tbody>
  <tfoot>
    <tr>
      <td colspan="<?php echo $numberOfSlots; ?>">
        <input type="button" id="closeWindowButton" value="<?php printf("%s - %s", translate("MSG_OK"), translate("MSG_CLOSE_WINDOW")); ?>" />
      </td>
    </tr>
  </tfoot>
</table>

</body>

</html>