<?php
  header('Content-type: text/html; charset=utf-8', true);
  header('Cache-control: no-cache', true);
  header('Pragma: no-cache');

  require_once 'includes/constants.php';  
  require_once 'includes/aibridge.class.php';
  require_once 'includes/translations.php';

  $stdout = AIBridge::startSystemSurvey();

  $xml = new XMLDocument($stdout);
  if ($xml)
  {
    $root = $xml->document_element();
    if ($root->tagname() == 'error')
    {
      $message = $root->get_content();
      $isRunning = false;
    }
    else
    {
      $state = $root->get_attribute('state');
      if ($state == 'busy')
      {
        $message = translate('MSG_AI_BUSY_STARUP_ERROR');
        $isRunning = false;
      }
      else if ($state == 'running')
      {
        $message = translate('MSG_SCANNING_HARDWARE');
        $processID = $root->get_attribute('processID');
        $isRunning = true;
      }
    }
  }
  else
  {
    $isRunning = false;
    if (!file_exists(AI_PATH))
      $message = 'AI NOT FOUND';
    else
      $message = 'CANNOT COMMUNICATE WITH AI';
  }
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
  <title><?=translate('MSG_HP_INSIGHT_DIAGNOSTICS');?></title>
  <link type="text/css" rel="stylesheet" media="all" href="css/startup.css"></link>
  <link type="text/css" rel="stylesheet" media="all" href="css/debugger.css"></link>
  <script type="text/javascript">
  var CONFIG = {};
  <?=(defined('CONFIG_VERIFY') && CONFIG_VERIFY === true) ? ('CONFIG.CONFIG_VERIFY = true;' . "\n") : ('CONFIG.CONFIG_VERIFY = false;' . "\n");?>
  <?=(defined('CONFIG_VERIFY_CLOSE_ON_FAIL') && CONFIG_VERIFY_CLOSE_ON_FAIL === true) ? ('CONFIG.CLOSE_ON_FAIL = true;' . "\n") : ('CONFIG.CLOSE_ON_FAIL = false;' . "\n");?>
  <?=(defined('DEBUG_MODE') && DEBUG_MODE === true) ? ('CONFIG.DEBUG_MODE = true;' . "\n") : ('CONFIG.DEBUG_MODE = false;' . "\n");?>
  <?= 'CONFIG.DEBUG_ACTIVE = false;' ?>
  </script>

  <script type="text/javascript" src="js/lib.js"></script> <!-- Custom Javascript Library -->
  <script type="text/javascript" src="js/ui/Body.js"></script>
  <script type="text/javascript" src="js/ui/Viewport.js"></script>
  <script type="text/javascript" src="js/ui/ProgressBar.js"></script>
  <script type="text/javascript" src="js/ui/HotCorner.js"></script>
  <script type="text/javascript" src="js/translator.js.php"></script> <!-- Global Translator -->
  <script type="text/javascript" src="js/debugger.js"></script> <!-- DEBUGGER -->
  <script type="text/javascript">
  function init()
  {
    Body.adjustToViewport(getElement('leftSide'));
    window.onresize = function ()
    {
      Body.adjustToViewport(getElement('leftSide'));
    }
    var debugOpener = new HotCorner('tl');
    debugOpener.action = function ()
    {
      window.Debugger = new Debugger();
      CONFIG.DEBUG_MODE = true;
      CONFIG.DEBUG_ACTIVE = true;
      this.active = false;
    }
    window.frame = extendElement(getElement('statusFrame'));
    window.progressBar = new ProgressBar(getElement('progressBar'));
    window.message = extendElement(getElement('message'));
    window.message.innerHTML = <?=('\'' . $message . '\'');?>;
    extendElement(getElement('initialWait')).hide();
    extendElement(getElement('startupScreen')).uncloak();
    <?php
    if ($isRunning)
    {
      echo ('window.processID = \'' . $processID . '\';');
      echo ('window.frame.src = \'views/idStatus.php?processID=' . $processID);
      if (defined('OVERRIDE_LANG'))
        echo ('&overrideLang=' . OVERRIDE_LANG);
      if (defined('DEBUG_MODE') && DEBUG_MODE === true)
        echo ('&debugMode=on');
      echo '\';';
    }
    ?>
    document.oncontextmenu = function ()
    {
      return CONFIG.DEBUG_ACTIVE;
    };
  }

  function showFrame()
  {
    addClass(getElement('productName'), 'hidden');
    removeClass(window.frame, 'hiddenFrame');
    var leftMiddle = extendElement(getElement('leftMiddle'));
    window.frame.setHeight(leftMiddle.getHeight());
  }

  function update(percent, status)
  {
    if (percent != null)
      progressBar.setPercent(percent);
    message.innerHTML = status;
    setTimeout(function ()
    {
      var url = window.frame.src;
      window.frame.src = url;
    }, 500);
  }

  function finishedRunning(message, doPause)
  {
    window.message.innerHTML = message;
    window.progressBar.setPercent(100);
    window.doPause = doPause;
    var src = ('utils/saveSystemSurvey.php?processID=' + window.processID);
    if (CONFIG.DEBUG_MODE === true)
      src += '&debugMode=on';
    getElement('saveFrame').src = src;
  }

  function finishedSaving()
  {
    <?php
    echo ('var url = \'' . FRONTEND_DIRECTORY . 'frontend.php?');
    $parameters = array();
    if (defined('DEBUG_MODE') && DEBUG_MODE === true)
      $parameters[] = 'debugMode=on';
    if (ADVANCED_MODE)
      $parameters[] = 'advancedMode=on';
    if (defined('OVERRIDE_LANG'))
      $parameters[] = ('overrideLang=' . OVERRIDE_LANG);
    echo implode('&', $parameters);
    echo '\';';
    ?>
    if (CONFIG.CONFIG_VERIFY == false)
    {
      window.message.innerHTML = <? printf("'%s %s ...'\n", translate('MSG_STARTING'), translate('MSG_HP_INSIGHT_DIAGNOSTICS')); ?>
      window.location = url;
    }
    else
    {
      runConfigVerify();
    }
  }

  function runConfigVerify()
  {
    window.message.innerHTML = 'Running Configuration Verification ...';
    <?php
    echo ('var url = \'' . FRONTEND_DIRECTORY . 'views/configVerify.php?');
    if (DEBUG_MODE)
      $parameters[] = 'debugMode=on';
    echo implode('&', $parameters);
    echo '\';';
    ?>
    getElement('configVerifyFrame').src = url;
  }

  function configVerifyPassed()
  {
    CONFIG.CONFIG_VERIFY = false;
    finishedSaving();
  }

  function configVerifyFailed()
  {
    if (CONFIG.CLOSE_ON_FAIL == true)
    {
      exitDiags();
    }
    else
    {
      var frame = extendElement(getElement('configVerifyFrame'));
      removeClass(frame, 'hiddenFrame');
      frame.style.position = 'absolute';
      frame.conformTo(Body);
    }
  }

  function configVerifyError(errorString)
  {
    alert(errorString);
    window.opener = self;
    window.close();
  }

  function continueToDiags()
  {
    CONFIG.CONFIG_VERIFY = false;
    finishedSaving();
  }

  function exitDiags()
  {
    window.opener = self;
    window.close();
  }
  
  </script>
</head>

<body onload="init();">

<!-- START initialWait -->
<div id="initialWait">
  <img src="images/hourglass.gif" /><br />
  <span id="initialWaitMessage"><?=translate('MSG_PLEASE_WAIT');?></span>
</div>
<!-- END initialWait -->

<table id="startupScreen" class="invisible">
  <tbody>
    <tr>
      <td rowspan="2" id="leftSide">
        <table id="leftSideTable">
          <tbody>
            <tr>
              <td id="leftTop">
                <img src="images/startup_logo.gif" />
              </td>
            </tr>
            <tr>
              <td id="leftMiddle">
                <img id="productName" src="images/startup_productname.gif" onclick="showFrame();" />
                <iframe class="hiddenFrame" id="statusFrame" src="utils/dummy.html" frameborder="0"></iframe>
              </td>
            </tr>
            <tr>
              <td id="leftBottom">
                <?=translate('MSG_COPYRIGHT');?> &copy; 2002-2010 Hewlett-Packard Development Company L.P.
              </td>
            </tr>
          </tbody>
        </table>
      </td>
      <td id="rightTop">
        <img src="images/startup_customer_splash.jpg" />
      </td>
    </tr>
    <tr>
      <td id="rightBottom">
        <span><?=(translate('MSG_LOADING') . ' ' . translate('MSG_HP_INSIGHT_DIAGNOSTICS') . ' ...');?></span>
        <br />
        <span id="message">Message</span>
        <div id="progressBar"></div>
      </td>
    </tr>
  </tbody>
</table>

<iframe id="saveFrame" class="hiddenFrame" src="utils/dummy.html" frameborder="0"></iframe>
<iframe id="configVerifyFrame" class="hiddenFrame" src="utils/dummy.html" frameborder="0"></iframe>

</body>

</html>
