<?php
  header('Content-type: text/html; charset=utf-8', true);
  header('Cache-control: no-cache', true);
  header('Pragma: no-cache');
    
  include_once '../includes/globals.php';
  include_once '../includes/aibridge.class.php';
  include_once '../includes/parseComparison.php';

  define('LEFT_FILENAME', ($_GET['leftFilename'] == 'original') ? translate('MSG_ORIGINAL_CONFIGURATION') : $_GET['leftFilename']);
  define('RIGHT_FILENAME', ($_GET['rightFilename'] == 'current') ? translate('MSG_CURRENT_CONFIGURATION') : $_GET['rightFilename']);
  define('VIEW_ADVANCED', (isset($_GET['advanced']) && $_GET['advanced'] == 'yes') ? true : false);
  define('CHANGES_ONLY', (isset($_GET['changesOnly']) && $_GET['changesOnly'] == 'yes') ? true : false);

  $mode = ($_GET['mode'] === 'run') ? true : false;

  $comparisonData = parseComparison($_GET['leftFilepath'], $_GET['rightFilepath'], $_GET['category'], $mode);
  
  outputViewHeader();
  echo '<script type="text/javascript" src="../js/lib.js"></script>';
  echo '<script type="text/javascript" src="js/compareConfigs.js"></script>';
  echo '</head>';
  $arg1 = ($comparisonData == -1) ? 'true' : 'false';
  $arg2 = ($comparisonData == 0) ? 'false' : 'true';
  $arg3 = (DEBUG_MODE === true) ? 'true' : 'false';
  echo ('<body onload="init(' . $arg1 . ', ' . $arg2 . ', ' . $arg3 . ');">');
  echo ('<table class="config" id="compareConfigs">');
  echo '<tbody>';

  if ($comparisonData == -1)
  {
    echo '<tr class="message">';
    echo ('<td>' . translate('MSG_SOME_COMPARE_FILES_MISSING') . '</td>');
    echo '</tr>'; 
  }
  else if ($comparisonData == 0)
  {
    echo '<tr class="message">';
    echo ('<td>' . translate('MSG_NO_CHANGES_FOUND') . '</td>');
    echo '</tr>'; 
  }
  else if (is_array($comparisonData))
  {
    $categoryCount = count($comparisonData);
    foreach ($comparisonData as $category)
    {
      if (CHANGES_ONLY === false || $category['containsNestedChanges'] === true)
      {
        if ($categoryCount > 1)
          displayHeader($category['caption']);
        foreach ($category['children'] as $child)
        {
          if (shouldDisplayChild($child))
          {
            $sublevel = ($categoryCount > 1) ? 1 : 0;
            displayData($child, $sublevel);
          }
        }
      }
    }
  }

  function displayHeader($caption)
  {
    echo '<tr class="header">';
    echo '<td> </td>';
    echo '<th>' . $caption . '</th>';
    echo '<th>' . LEFT_FILENAME . '</th>';
    echo '<th>' . RIGHT_FILENAME . '</th>';
    echo '</tr>';
  }

  function displayData(&$child, $sublevel)
  {
    if ($sublevel == 0)
    {
      displayHeader($child['caption']);
    }
    else
    {
      if (CHANGES_ONLY === false || $child['compareResult'] != 'unchanged')
      {
        switch ($child['compareResult'])
        {
        case 'added':
          displayAddedData($child['caption'], $child['right'], $child['isHexData'], $sublevel);
          break;
        case 'removed':
          displayRemovedData($child['caption'], $child['left'], $child['isHexData'], $sublevel);
          break;
        default:
          displayStandardData($child, $sublevel);
        }
      }
    }
    foreach ($child['children'] as $nextChild)
    {
      if (shouldDisplayChild($nextChild))
      {
        $sublevel++;
        displayData($nextChild, $sublevel);
        $sublevel--;
      }
    }
  }

  function displayAddedData($caption, $value, $isHexData, $sublevel)
  {
    $padding = ($sublevel > 1) ? (15 * ($sublevel - 1)) : 2;
    $class = array('changed');
    if ($isHexData === true)
      $class[] = 'hexdata';
    if ($sublevel == 1)
      $class[] = 'data';
    else
      $class[] = 'subdata';
    echo ('<tr class="' . implode(' ', $class) . '">');
    echo ('<td class="compareResult">' . translate('MSG_ADDED') . '</td>');
    echo ('<th style="padding-left:' . $padding . 'px">' . $caption . '</td>');
    echo ('<td class="value compareResult"> </td>');
    echo ('<td class="value">' . $value . '</td>');
    echo '</tr>';
  }

  function displayRemovedData($caption, $value, $isHexData, $sublevel)
  {
    $padding = ($sublevel > 1) ? (15 * ($sublevel - 1)) : 2;
    $class = array('changed');
    if ($isHexData === true)
      $class[] = 'hexdata';
    if ($sublevel == 1)
      $class[] = 'data';
    else
      $class[] = 'subdata';
    echo ('<tr class="' . implode(' ', $class) . '">');
    echo ('<td class="compareResult">' . translate('MSG_REMOVED') . '</td>');
    echo ('<th style="padding-left:' . $padding . 'px"> </td>');
    echo ('<td class="value">' . $value . '</td>');
    echo ('<td class="value compareResult"> </td>');
    echo '</tr>';
  }

  function displayStandardData(&$child, $sublevel)
  {
    $padding = ($sublevel > 1) ? (15 * ($sublevel - 1)) : 2;
    $class = array();
    if ($child['compareResult'] != 'unchanged')
    {
      $class[] = 'changed';
      $resultClass = 'compareResult';
      $result = translate('MSG_CHANGED');
    }
    else
    {
      $resultClass = 'compareUnchanged';
      $result = translate('MSG_UNCHANGED');
    }
    if ($child['isHexData'] === true)
      $class[] = 'hexdata';
    if ($sublevel == 1)
      $class[] = 'data';
    else
      $class[] = 'subdata';
    echo ('<tr class="' . implode(' ', $class) . '">');
    echo ('<td class="' . $resultClass . '">' . $result . '</td>');
    echo ('<th style="padding-left:' . $padding . 'px">' . $child['caption'] . '</td>');
    echo ('<td class="value">' . $child['left'] . '</td>');
    echo ('<td class="value">' . $child['right'] . '</td>');
    echo '</tr>';
  }
    
  function shouldDisplayChild($child)
  {
    $returnVal = false;
    if (CHANGES_ONLY === false || $child['compareResult'] != 'unchanged' || $child['containsNestedChanges'] === true)
    {
      if (VIEW_ADVANCED === true || $child['isAdvanced'] === false || $child['compareResult'] != 'unchanged' || $child['containsNestedChanges'] === true)
        $returnVal = true;
    }
    return $returnVal;
  }

  echo '</tbody>';
  echo '</table>';
  outputViewFooter();
//*/
?>
