<?php
  header('Content-type: text/html; charset=utf-8', true);
  header('Cache-control: no-cache', true);
  header('Pragma: no-cache');

  include_once '../includes/globals.php';
  include_once '../includes/aibridge.class.php';

  define('CFGVER_OUTPUT_FILE', (WRITE_DIRECTORY . 'cfgveroutput.xml'));
  define('CFGVER_PASSED', 0);
  define('CFGVER_FAILED', 1);
  define('CFGVER_FILE_MISSING', 2);
  if (checkDiagConfig('/factory/configVerifyDisallowContinue'))
    define('CFGVER_DISALLOW_CONTINUE', true);
  else
    define('CFGVER_DISALLOW_CONTINUE', false);

  AIBridge::startConfigVerify();
 
  if (!file_exists(CFGVER_OUTPUT_FILE))
  {
    $cfgverResult = CFGVER_FILE_MISSING;
  }
  else
  {
    $xml = new XMLDocument(file_get_contents(CFGVER_OUTPUT_FILE));
    $configVerify = $xml->document_element();
    $result = $configVerify->get_attribute('verifyResult');
    if ($result != 'failed')
    {
      $cfgverResult = CFGVER_PASSED;
    }
    else
    {
      $cfgverResult = CFGVER_FAILED;
      $tableOutput = array('<table class="configVerify">');

      $xpath = xpath_new_context($configVerify);
      $properties = @ xpath_eval($xpath, '/property');

      $tableOutput[] = '<tr>';
      $tableOutput[] = '<th colspan="4">System Properties</th>';
      $tableOutput[] = '</tr>';
      if (count($properties->nodeset) <= 0)
      {
        $tableOutput[] = '<tr>';
        $tableOutput[] = '<td colspan="4" class="message">No System Properties Found</td>';
        $tableOutput[] = '</tr>';
      }
      else
      {
        $tableOutput[] = '<tr class="header">';
        $tableOutput[] = '<td class="quarter">Name</td>';
        $tableOutput[] = '<td class="quarter">Expected Value</td>';
        $tableOutput[] = '<td class="quarter">Actual Value</td>';
        $tableOutput[] = '<td class="quarter">Failure Result</td>';
        $tableOutput[] = '</tr>';
      }
      foreach ($properties->nodeset as $property)
      {
        $propertyName = $property->get_attribute('name');
        $propertyCaption = $property->get_attribute('caption');
        $propertyValue = $property->get_attribute('value');
        $propertyVerifyResult = $property->get_attribute('verifyResult');
        $propertyActual = $property->get_attribute('actual');
        $propertyDisplayName = ($propertyName != '') ? $propertyName : $propertyCaption;

        $tableOutput[] = '<tr>';
        $tableOutput[] = ('<td class="quarter">' . $propertyDisplayName . '</td>');
        $tableOutput[] = ('<td class="quarter">' . $propertyValue . '</td>');
        $tableOutput[] = ('<td class="quarter">' . $propertyActual . '</td>');
        $tableOutput[] = ('<td class="quarter">' . $propertyVerifyResult . '</td>');
        $tableOutput[] = '</tr>';
      }
      $tableOutput[] = '</table>';

      $tableOutput[] = '<table class="configVerify">';
      $devices = @ xpath_eval($xpath, '/device');
      $tableOutput[] = '<tr>';
      $tableOutput[] = '<th colspan="2">System Device Failures</th>';
      $tableOutput[] = '</tr>';
      if (count($devices->nodeset) <= 0)
      {
        $tableOutput[] = '<tr>';
        $tableOutput[] = '<td colspan="2" class="message">No System Device Failures Found</td>';
        $tableOutput[] = '</tr>';
      }
      foreach ($devices->nodeset as $device)
      {
        $deviceDescription = $device->get_attribute('description');
        $deviceCaption = $device->get_attribute('caption');
        $deviceName = $device->get_attribute('name');
        $deviceClass = $device->get_attribute('class');
        $deviceVerifyResult = $device->get_attribute('verifyResult');

        if ($deviceDescription != '')
          $deviceDisplayName = $deviceDescription;
        else if ($deviceCaption != '')
          $deviceDisplayName = $deviceCaption;
        else if ($deviceName != '')
          $deviceDisplayName = $deviceName;
        else
          $deviceDisplayName = $deviceClass;
        $tableOutput[] = '<tr class="header">';
        $tableOutput[] = '<td class="half">Name</td>';
        $tableOutput[] = '<td class="half">Failure Result</td>';
        $tableOutput[] = '</tr>';
        $tableOutput[] = '<tr>';
        $tableOutput[] = ('<td class="half bold highlight">' . $deviceDisplayName . '</td>');
        $tableOutput[] = ('<td class="half bold highlight">' . $deviceVerifyResult . '</td>');
        $tableOutput[] = '</tr>';
        $tableOutput[] = '<tr class="header">';
        $tableOutput[] = '<td colspan="2">Device Properties:</th>';
        $tableOutput[] = '</tr>';

        $deviceXpath = xpath_new_context($device);
        $deviceProperties = @ xpath_eval($deviceXpath, '/property');
        if (count($deviceProperties->nodeset) <= 0)
        {
          $tableOutput[] = '<tr class="deviceProperties">';
          $tableOutput[] = '<td colspan="2">';
          $tableOutput[] = '<table class="deviceProperties">';
          $tableOutput[] = '<tr>';
          $tableOutput[] = '<td colspan="4" class="message">No Device Properties Found</td>';
          $tableOutput[] = '</tr>';
          $tableOutput[] = '</table>';
          $tableOutput[] = '</td>';
          $tableOutput[] = '</tr>';
        }
        else
        {
          $tableOutput[] = '<tr class="deviceProperties">';
          $tableOutput[] = '<td colspan="2">';
          $tableOutput[] = '<table class="deviceProperties">';
          $tableOutput[] = '<tr class="header">';
          $tableOutput[] = '<td class="quarter">Name</td>';
          $tableOutput[] = '<td class="quarter">Expected Value</td>';
          $tableOutput[] = '<td class="quarter">Actual Value</td>';
          $tableOutput[] = '<td class="quarter">Failure Result</td>';
          $tableOutput[] = '</tr>';
          foreach ($deviceProperties->nodeset as $deviceProperty)
          {
            $devicePropertyName = $deviceProperty->get_attribute('name');
            $devicePropertyCaption = $deviceProperty->get_attribute('caption');
            $devicePropertyValue = $deviceProperty->get_attribute('value');
            $devicePropertyVerifyResult = $deviceProperty->get_attribute('verifyResult');
            $devicePropertyActual = $deviceProperty->get_attribute('actual');
            $devicePropertyDisplayName = ($devicePropertyName != '') ? $devicePropertyName : $devicePropertyCaption;

            $tableOutput[] = '<tr>';
            $tableOutput[] = ('<td class="quarter">' . $devicePropertyDisplayName . '</td>');
            $tableOutput[] = ('<td class="quarter">' . $devicePropertyValue . '</td>');
            $tableOutput[] = ('<td class="quarter">' . $devicePropertyActual . '</td>');
            $tableOutput[] = ('<td class="quarter">' . $devicePropertyVerifyResult . '</td>');
            $tableOutput[] = '</tr>';
          }
          $tableOutput[] = '</table>';
          $tableOutput[] = '</td>';
          $tableOutput[] = '</tr>';
        }
      }
      $tableOutput[] = '</table>';
    }
  }

  outputViewHeader();
  echo '<script type="text/javascript" src="js/configVerify.js"></script>';
  echo '</head>';
  echo ('<body id="configVerifyView" onload="init(' . $cfgverResult . ');">');
  if ($cfgverResult == CFGVER_FAILED)
  {
    echo '<h1>Configuration Verification <em>FAILED</em></h1>';

    echo '<div class="buttonDiv">';
    echo '<input type="button" id="exitButton1" value="Exit" onclick="parent.exitDiags();" />';
    if (CFGVER_DISALLOW_CONTINUE == false)
      echo '<input type="button" id="continueButton1" value="Continue to Diags" onclick="parent.continueToDiags();" />';
    echo '</div>';

    echo implode('', $tableOutput);

    echo '<div class="buttonDiv">';
    echo '<input type="button" id="exitButton2" value="Exit" onclick="parent.exitDiags();" />';
    if (CFGVER_DISALLOW_CONTINUE == false)
      echo '<input type="button" id="continueButton2" value="Continue to Diags" onclick="parent.continueToDiags();" />';
    echo '</div>';
  }
  outputViewFooter();
  //*/
?>
