<?php
  header('Content-type: text/html; charset=utf-8', true);
  header('Cache-control: no-cache', true);
  header('Pragma: no-cache');

  include_once '../includes/globals.php';
  include_once '../includes/parseSurvey.php';

  $selectedCategory = (isset($_GET['category'])) ? $_GET['category'] : 'all';
  define('VIEW_ADVANCED', (isset($_GET['advanced']) && $_GET['advanced'] == 'yes') ? true : false);
  
  outputViewHeader();
  echo '<script type="text/javascript" src="../js/lib.js"></script>';
  echo '<script type="text/javascript" src="js/currentConfig.js"></script>';
  echo '</head>';
  echo ('<body onload="init(' . ((DEBUG_MODE === true) ? 'true' : 'false') . ');">');
  echo '<table class="config" id="currentConfig">';
  echo '<tbody>';

  $surveyData = parseSurvey($selectedCategory);

  if ($surveyData == -1)
  {
    echo '<tr class="message">';
    echo '<td>IDRESULT MISSING</td>';
    echo '</tr>'; 
  }
  else if (is_array($surveyData))
  {
    $categoryCount = count($surveyData);
    foreach ($surveyData as $category)
    {
      if ($categoryCount > 1)
        displayHeader($category['caption']);
      foreach ($category['children'] as $child)
      {
        if (shouldDisplayChild($child))
        {
          $sublevel = ($categoryCount > 1) ? 1 : 0;
          displayData($child, $sublevel);
        }
      }
    }
  }

  function displayHeader($caption, $value='')
  {
    $displayCaption = ($value != '' && $value != $caption) ? ($caption . ' - ' . $value) : $caption;
    echo '<tr class="header">';
    echo ('<th colspan="2">' . $displayCaption . '</th>');
    echo '</tr>';
  }

  function displayData(&$child, $sublevel)
  {
    if ($sublevel == 0)
    {
      displayHeader($child['caption'], $child['value']);
    }
    else
    {
      $class = array();
      if ($sublevel == 1)
      {
        $padding = 2;
        $class[] = 'data';
      }
      else
      {
        $padding = (15 * ($sublevel - 1));
        $class[] = 'subdata';
      }
      if ($child['isHexData'] === true)
        $class[] = 'hexdata';
      if ($child['isAdvanced'] === true)
        $class[] = 'advanced';

      echo ('<tr class="' . implode(' ', $class) . '">');
      if ($child['value'] == '')
      {
        echo ('<th colspan="2" style="padding-left: ' . $padding . 'px;">' . $child['caption'] . '</th>');
      }
      else
      {
        echo ('<th style="padding-left: ' . $padding . 'px;">' . $child['caption'] . '</th>');
        echo ('<td>' . $child['value'] . '</td>');
      }
      echo '</tr>';
    }
    foreach ($child['children'] as $nextChild)
    {
      if (shouldDisplayChild($nextChild))
      {
        $sublevel++;
        displayData($nextChild, $sublevel);
        $sublevel--;
      }
    }
  }

  echo '</tbody>';
  echo '</table>';
  outputViewFooter();

  function shouldDisplayChild($child)
  {
    $returnVal = false;
    if (VIEW_ADVANCED === true || $child['isAdvanced'] === false)
      $returnVal = true;
    return $returnVal;
  }

  //*/
?>
