<?php
  header('Content-type: text/html; charset=UTF-8', true);
  header('Cache-control: no-cache', true);
  header('Pragma: no-cache');

  include_once '../includes/constants.php';
  include_once '../includes/aibridge.class.php';
  include_once '../includes/translations.php';
  
  $processID = $_GET['processID'];

  $hasCrashedChildren = false;

  $stdout = AIBridge::getProcessStatus($processID);

  $xml = new XMLDocument($stdout);
  $root = $xml->document_element();
  $xpath = xpath_new_context($root);
  
  $overallPercent = $root->get_attribute('percentComplete');
  $overallState = $root->get_attribute('state');

  $tableContent = array();

  $processStatusNodes = @ xpath_eval($xpath, '/processStatus');
  if (count($processStatusNodes->nodeset) > 0)
  {
    $tableContent[] = '<tbody>';
    foreach ($processStatusNodes->nodeset as $processStatus)
    {
      $state = $processStatus->get_attribute('state');
      $component = $processStatus->get_attribute('component');
      $percent = $processStatus->get_attribute('percentComplete');
      
      $tableContent[] = ('<tr class="' . $state . '">');
      $tableContent[] = ('<td class="component">' . $component . '</td>');
      $tableContent[] = ('<td class="state">' . $state . '</td>');
      $tableContent[] = ('<td class="progress">' . drawProgressBar($percent) . '</td>');
      $tableContent[] = '</tr>';

      if ($state == 'crashed')
        $hasCrashedChildren = true;
    }
    $tableContent[] = '</tbody>';
  }
  
  $output = array();
  $output[] = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"';
  $output[] = '"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">';
  $output[] = '<html xmlns="http://www.w3.org/1999/xhtml">';
  $output[] = '<head>';
  $output[] = '<title>view</title>';
  $output[] = '<link type="text/css" rel="stylesheet" media="all" href="../css/views.css"></link>';
  $output[] = '<script type="text/javascript">';
  $output[] = 'function init() {';
  if ($overallState != 'completed')
  {
    $output[] = (' parent.update(' . $overallPercent . ', "' . createMessage($overallState) . '");');
  }
  else
  {
    if ($hasCrashedChildren == true)
      $bool = 'true';
    else
      $bool = 'false';
    $output[] = (' parent.finishedRunning("' . createMessage($overallState) . '", ' . $bool . ');');
  }
  $output[] = '}';
  $output[] = '</script>';
  $output[] = '</head>';
  $output[] = '<body onload="init();">';
  $output[] = '<table class="status" id="idStatus">';
  $output[] = implode('', $tableContent);
  $output[] = '</table>';
  $output[] = '</body>';
  $output[] = '</html>';
  
  echo implode('', $output);
  
  function drawProgressBar($percent=0)
  {
    if ($percent < 0 || !is_numeric($percent))
      $percent = 0;
    if ($percent > 100)
      $percent = 100;
    $progressBar = array('<div class="progressbar finished">');
    $progressBar[] = ('<div class="stretcher" style="width: ' . $percent . '%">' . $percent . '%</div>');
    $progressBar[] = '</div>';
    return implode('', $progressBar);
  }

  function createMessage($state)
  {
    $message = '';
    if ($state == 'running' || $state == '')
    {
      $message = (translate('MSG_PLEASE_WAIT') . ' ... ' . translate('MSG_SCANNING_HARDWARE'));
    }
    else if ($state == 'completed')
    {
      $message = (translate('MSG_PLEASE_WAIT') . ' ... ' . translate('MSG_PROCESSING_RESULTS'));
    }
    else
    {
      $message = $state;
    }
    return $message;
  }
  //*/
?>
