<?php
  header('Content-type: text/html; charset=utf-8', true);
  header('Cache-control: no-cache', true);
  header('Pragma: no-cache');

  include_once '../includes/globals.php';
  include_once '../includes/aibridge.class.php';
  include_once '../includes/rosetta.class.php';

  $runningStates = array('running', 'canceling');
  $diagnosisTesting = (isset($_GET['diagnosisTests']) && $_GET['diagnosisTests'] == 'yes') ? true : false;
  
  $tableContent = '';
  
  if (!isset($_GET['processID']))
  {
    $tableContent[] = '<tr class="message">';
    $tableContent[] = ('<td>' . translate('MSG_NO_TESTS_RUNNING') . '</td>');
    $tableContent[] = '</tr>';
  }
  else
  {
    $processID = $_GET['processID'];

    if (isset($_GET['promptID']) && isset($_GET['promptResponse']))
      $stdout = AIBridge::replyToPrompt($processID, $_GET['promptID'], $_GET['promptResponse']);
    else
      $stdout = AIBridge::getProcessStatus($processID);
  
    $xml = new XMLDocument($stdout);
    $root = $xml->document_element();
    $xpath = xpath_new_context($root);

    $queuedPrompt = false;
    $prompts = @ xpath_eval($xpath, '/processStatus/diagPrompt'); // causes error in SmartStart when none are present, so we use '@'

    if (count($prompts->nodeset) > 0)
    {
      $queuedPrompt = true;
      $prompt = $prompts->nodeset[0];

      $promptXpath = xpath_new_context($prompt);
      $parentNodes = @ xpath_eval($promptXpath, '/..');
      $parent = $parentNodes->nodeset[0];

      $promptID = $prompt->get_attribute('promptID');
      $promptCaption = $parent->get_attribute('caption');
      $promptContent = str_replace("\n", '<br />', $prompt->get_content());
      $promptType = $prompt->get_attribute('type');
      $promptOptions = array();

      $options = @ xpath_eval($promptXpath, '/option');
      if (count($options->nodeset) > 0)
      {
        foreach($options->nodeset as $option)
        {
          $promptOption = array();
          $promptOption['caption'] = $option->get_attribute('caption');
          $promptOption['hotkey'] = $option->get_attribute('hotkey');
          $promptOption['image'] = $option->get_attribute('image');
          $promptOptions[] = $promptOption;
        }
      }
    }

    $processStatuses = @ xpath_eval($xpath, '/processStatus'); // causes error in SmartStart when none are present, so we use '@'
    $numberOfProcesses = count($processStatuses->nodeset);

    $testsState = $root->get_attribute('state');
    
    if ($numberOfProcesses <= 0)
    {
      if (!in_array($testsState, $runningStates)) // is not running
      {
        $tableContent[] = '<tr class="message">';
        $tableContent[] = ('<td>' . translate('MSG_NO_TESTS_RUNNING') . '</td>');
        $tableContent[] = '</tr>';
      }
      else // is running
      {
        $tableContent[] = '<tr class="message">';
        $tableContent[] = ('<th>' . translate('MSG_INITIALIZING_TESTS') . '</th>');
        $tableContent[] = '</tr>';
      }
    }
    else
    {
      $testsCaption = $root->get_attribute('caption');
      $testsPercentComplete = $root->get_attribute('percentComplete');

      $numberOfFailedTests = $root->get_attribute('testsFailed');
      if ($numberOfFailedTests == '')
        $numberOfFailedTests = 0;

      $timeString = array();

      if (!$diagnosisTesting)
      {
        if ($root->has_attribute('desiredTestTime'))
        {
          $timeString[] = '<span>';
          $timeString[] = (translate('MSG_TEST_TIME') . ': ');
          $timeString[] = $root->get_attribute('testTime');
          $timeString[] = (' ' . translate('MSG_OF') . ' ');
          $timeString[] = $root->get_attribute('desiredTestTime');
          $timeString[] = '</span><span>';
          $timeString[] = (translate('MSG_TEST') . ' ' . translate('MSG_COMPLETE') . ': ');
          $timeString[] = $root->get_attribute('testsFinished');
          $timeString[] = (' ' . translate('MSG_OF') . ' ');
          $timeString[] = $root->get_attribute('totalTests');
          $timeString[] = '</span>';
        }
        else
        {
          $timeString[] = '<span>';
          $timeString[] = (translate('MSG_CURRENT_LOOP') . ': ');
          $timeString[] = $root->get_attribute('currentLoop');
          $timeString[] = (' ' . translate('MSG_OF') . ' ');
          $timeString[] = $root->get_attribute('testLoops');
          $timeString[] = '</span><span>';
          $timeString[] = (translate('MSG_TEST_TIME') . ': ');
          $timeString[] = $root->get_attribute('testTime');
          $timeString[] = '</span><span>';
          $timeString[] = (translate('MSG_TEST') . ' ' . translate('MSG_COMPLETE') . ': ');
          $timeString[] = $root->get_attribute('testsFinished');
          $timeString[] = (' ' . translate('MSG_OF') . ' ');
          $timeString[] = $root->get_attribute('totalTests');
          $timeString[] = '</span>';
        }
      }
      
      $tableContent[] = '<thead>';
      $tableContent[] = '<tr>';
      $tableContent[] = ('<th class="caption">' . translate('MSG_DEVICE') . ' - ' . translate('MSG_TEST') . '</th>');
      $tableContent[] = ('<th class="status">' . translate('MSG_STATUS') . '</th>');
      $tableContent[] = ('<th class="progress">' . translate('MSG_TEST_PROGRESS') . '</th>');
      $tableContent[] = ('<th class="time">' . translate('MSG_TIME') . '</th>');
      $tableContent[] = '</tr>';
      $tableContent[] = '</thead>';
      $tableContent[] = '<tbody>';
      
      $testCount = 0;
      
      foreach ($processStatuses->nodeset as $processStatus)
      {
        $testCount++;
        
        $tableContent[] = '<tr>';
        
        $state = $processStatus->get_attribute('state');
        $percentComplete = $processStatus->get_attribute('percentComplete');
        $result = $processStatus->get_attribute('result');
        $operationCaption = $processStatus->get_attribute('OperationCaption');
        switch ($state)
        {
        case 'completed':
          $status = ($result == 'passed') ? translate('MSG_PASSED') : (($result == 'passedWithWarnings') ? translate('MSG_PASSED_WITH_WARNINGS') : translate('MSG_FAILED'));
          break;
        case 'crashed':
          $status = translate('MSG_ABNORMAL_TERMINATION');
          break;
        case 'canceling':
          $status = translate('MSG_CANCELING');
          break;
        case 'canceled':
          $status = translate('MSG_CANCELED');
          break;
        case 'running':
          $status = translate('MSG_RUNNING');
          break;
        case 'waiting':
          $status = translate('MSG_WAITING');
          break;
        case 'idle':
          $status = translate('MSG_IDLE');
          break;
        default:
          $status = $state;
        }

        if (($state != 'completed' || $result != 'passed') && $operationCaption != '')
          $status .= (': ' . $operationCaption);

        if ($state == 'completed')
        {
          if ($result == 'passed')
          {
            $src = '../images/status_passed.gif';
            $progressBarClass = 'finished';
          }
          else if ($result == 'passedWithWarnings')
          {
            $src = '../images/status_warning.gif';
            $progressBarClass = 'warning';
          }
          else
          {
            $src = '../images/status_failed.gif';
            $progressBarClass = 'failed';
          }
        }
        else if ($state == 'crashed')
        {
          $src = '../images/status_failed.gif';
          $progressBarClass = 'finished';
        }
        else
        {
          $src = '../images/status_unknown.gif';
          $progressBarClass = '';
        }
        $tableContent[] = ('<td class="caption">' . $processStatus->get_attribute('caption') . '</td>');
        $tableContent[] = ('<td class="status">' . $status . '</td>');
        $tableContent[] = ('<td class="progress">' . drawProgressBar($percentComplete, $progressBarClass) . '</td>');
        $tableContent[] = ('<td class="time">' . $processStatus->get_attribute('testTime') . '</td>');
        $tableContent[] = '</tr>';
      }
      
      $tableContent[] = '</tbody>';

      if (!in_array($testsState, $runningStates) && // is not running anymore
          IS_FACTORY && 
          isset($_GET['scriptTesting']) && 
          $_GET['scriptTesting'] == 'yes' &&
          checkDiagConfig('/src', 'name', 'factory.xml'))
      {
        $factoryXML = new XMLDocument(file_get_contents(DIAGS_DIRECTORY . 'factory.xml'));
        $factoryRoot = $factoryXML->document_element();
        $factoryXpath = xpath_new_context($factoryRoot);
        $stationID = $factoryRoot->get_attribute('station');
        $srcNodes = @ xpath_eval($factoryXpath, ('/src[@station="' . $stationID . '"]'));
        if (count($srcNodes->nodeset) > 0)
        {
          $srcNode = $srcNodes->nodeset[0];
          $timeString = ($root->has_attribute('desiredTestTime')) ? ($root->get_attribute('testTime') . ' of ' . $root->get_attribute('desiredTestTime')) : $root->get_attribute('testTime');
          $srcNode->set_attribute('totalTestTime', $timeString);
          if ($testsState == 'canceled')
          {
            $srcNode->set_attribute('status', 'canceled');
          }
          else if ($testsState == 'completed')
          {
            if ($numberOfFailedTests > 0)
            {
              $srcNode->set_attribute('status', 'failed');
            }
            else
            {
              $srcNode->set_attribute('status', 'passed');
            }
          }
        }
        $factoryFilepath = (DIAGS_DIRECTORY . 'factory.xml');
        $factoryXML->dump_file($factoryFilepath, false, false);
      }
    }
  }

  $verTableContent = array();
  if (IS_FACTORY)
  {
    $verFiles = array_merge(glob('/*.ver'), glob('/*.VER'));
    foreach ($verFiles as $verFilename)
    {
      if (file_exists($verFilename))
      {
        $verFile = file_get_contents($verFilename);
        $verContent = str_replace(array("\r","\n"), '', $verFile); // remove line breaks
        $verTableContent[] = '<td>';
        $verTableContent[] = '<fieldset>';
        $verTableContent[] = ('<legend>' . str_replace("/", "", $verFilename) . '</legend>');
        $verTableContent[] = $verContent;
        $verTableContent[] = '</fieldset>';
        $verTableContent[] = '</td>';
      }
    }
  }

  $output = array();
  appendViewHeader($output);
  $output[] = '<script type="text/javascript" src="../js/lib.js"></script>';
  $output[] = '<script type="text/javascript">';
  $TEST_STATUS = array();
  if (isset($_GET["processID"]))
  {
    $TEST_STATUS["caption"] = (isset($testsCaption)) ? $testsCaption : "";
    $TEST_STATUS["percentComplete"] = (isset($testsPercentComplete)) ? $testsPercentComplete : "0";
    $TEST_STATUS["details"] = (isset($timeString) && is_array($timeString)) ? implode("", $timeString) : "";
    $TEST_STATUS["state"] = (isset($testsState)) ? $testsState : "";
    $TEST_STATUS["message"] = createMessage();
    $TEST_STATUS["testCount"] = (isset($testCount)) ? $testCount : 0;
    $TEST_STATUS["failedCount"] = (!empty($numberOfFailedTests)) ? $numberOfFailedTests : 0;
    if ($queuedPrompt == true)
    {
      $TEST_STATUS["prompt"] = array("ID" => $promptID,
                                     "type" => $promptType,
                                     "caption" => $promptCaption,
                                     "content" => $promptContent,
                                     "options" => $promptOptions);
    }
    else
    {
      $TEST_STATUS["prompt"] = null;
    }
  }
  $output[] = 'window.TEST_STATUS = ' . Rosetta::arrayToJSON($TEST_STATUS) . ';';
  $output[] = 'function init() {';
//  if (DEBUG_ACTIVE === false)
//    $output[] = ' document.oncontextmenu = function () { return false; };';
  $output[] = '  document.oncontextmenu = function () { return parent.CONFIG.DEBUG_ACTIVE; };';
  $output[] = '  addEvent(document, \'keydown\', function (event)';
  $output[] = '  {';
  $output[] = '    parent.Frontend.checkKeyCommand(event);';
  $output[] = '  });';
  $output[] = '}';
  $output[] = '</script>';
  $output[] = '</head>';
  $output[] = '<body onload="init();">';
  if (count($verTableContent) > 0)
  {
    $output[] = '<table id="verfiles">';
    $output[] = implode('', $verTableContent);
    $output[] = '</table>';
  }
  $output[] = '<table class="status" id="testStatus">';
  $output[] = implode('', $tableContent);
  $output[] = '</table>';
  appendViewFooter($output);
  
  echo implode('', $output);

  // UTILITY FUNCTIONS

  function drawProgressBar($percent=0, $class='')
  {
    if ($percent < 0 || !is_numeric($percent))
      $percent = 0;
    if ($percent > 100)
      $percent = 100;

    $progressBar = array('<div class="progressbar');
    if ($percent == 100)
       $progressBar[] = " $class";
    $progressBar[] = '">';
    $progressBar[] = ('<div class="stretcher" style="width: ' . $percent . '%">' . $percent . '%</div>');
    $progressBar[] = '</div>';
    return implode('', $progressBar);
  }

  function createMessage()
  {
    global $testsState;
    global $numberOfFailedTests;
    global $diagnosisTesting;

    $message = '';
    if ($testsState == 'running' || $testsState == '')
    {
      $message = translate('MSG_TESTING_IN_PROGRESS');
    }
    else if ($testsState == 'canceling')
    {
      $message = translate('MSG_CANCELING');
    }
    else if ($testsState == 'canceled')
    {
      $message = translate('MSG_TEST_CANCELED');
    }
    else if ($testsState == 'crashed')
    {
      $message = translate('MSG_ABNORMAL_TERMINATION');
    }
    else
    {
      $message .= translate('MSG_TESTING_COMPLETED');
      if (!$diagnosisTesting)
      {
        if ($numberOfFailedTests <= 0 || $numberOfFailedTests == '')
          $message .= (' ' . translate('MSG_TESTS_PASSED'));
        else
          $message .= (' ' . translate('MSG_TESTS_FAILED'));
      }
    }
    return $message;
  }
  //*/
?>
