$tplin = "$ARGV[0]";
$phpout = "$ARGV[1]";

$mibmapfile = "cpqmibmap.txt";

$webapp = "webagent"; # webapp name to use when making links, etc.


my %tags;   # array to contain tags needing instantiation
            #  $tags[<name>] = <std|raw>;

my %accesstags;   # array to contain tags needing access tag access
                  # $accesstags[<name>] = <name>Access;

my %nametooid;    # array containing name-to-oid mappings  $nametooid[ <name> ] = <oid>;
my %nametotype;   # array containing name-to-type mappings $nametotype[ <name> ] = <leaf|table|tableleaf>
my %oidtoname;    # array containing oid-to-name mappings $oidtoname[ <oid> ] = <name>


# forward function declarations

sub ReplaceInclude;
sub ReplaceTag;
sub ReplacePagetags;



if( $#ARGV != 1)
{
   print "usage:  tpltophp <tpl file>  <php file>\n\n";
   exit;
}

-f $tplin || die "template file $tplin is not a file\n";

print "converting template file $tplin to PHP file $phpout . . . \n";

#-------------- init mibmap info --------------------------------------
open (FIL, "<$mibmapfile" ) || die "unable to open mib map file $mibmapfile\n";

foreach $line (<FIL>)
{
   @chunks = split( /\s+/, $line );

   if(2 == $#chunks)
   {
      #print "mibmap name<" . $chunks[0] . ">  oid<" . $chunks[1] . ">  type<" . $chunks[2] . ">\n";
      $nametooid{ $chunks[0] } = $chunks[1];
      $nametotype{ $chunks[0] }= $chunks[2];
      $oidtoname{ $chunks[1] } = $chunks[0];
   }
}

close( FIL );
#-------------- end init mibmap info ----------------------------------

open( FHTPL, "<$tplin") || die "unable to open template file $tplin\n";
open( FHPHP, ">$phpout") || die "unable to open php file $tplin\n";

print "----------------------------- pass 1 begin -------------------------------\n";
print "pass 1 through TPL file $tplin:\n";

foreach $line (<FHTPL>)
{
   $tl = $line;
   $tl =~ s/^\s+//;   # remove leading whitespace
   $tl =~ s/\s+$//;   # remove trailing whitespace

   #print "original line: <$line>\ntrimmed line:<$tl>\n";

   if ($tl =~ /\<\!\#\S+\>/)
   {
      # line contains an include
      print "include: $tl\n";
   }

   elsif($tl =~ /\<\!\S+\>/)
   {
      # line contains a tag
      #print "tag line: $tl\n";

      @tags = $tl =~ /\<\!\S+\>/g;

      #print "tags found:  " . join('|', @tags) . "\n";

      if ($#tags != 0)
      {
         print "WARNING too many or not enough tags found in line $tl\n";
      }

      $thistag = $tags[0];
      $thistag =~ s/[\<\!\>]+//g;   #clean up tag
      $qualifier = 'std';

      if ($thistag =~ /\./)
      {
         # tag has a qualifier
         @pair = split(/\./, $thistag);
         #print "split $thistag into " . join('|', @pair) . "\n";

         $thistag = $pair[0];
         $qualifier = $pair[1];
      }

      print "tag found:  $thistag ($qualifier) - ";

      if('access' eq $qualifier)
      {
         # add this tag to the accesstags array
         $accesstags{ $thistag } = $thistag . "Access";
      }
      else
      {
         # add this tag to the tags list
         $tags{ $thistag } = $qualifier;
      }

      if($tl =~ /^\<\!\S+\>$/)
      {
         # line is ONLY a tag
         print "tag-only line: $tl\n";
      }
      else
      {
         # tag is embedded in HTML or SCRIPT
         print "embedded tag: $tl\n";
      }
   }
   elsif ($tl =~ /IMAGES\//)
   {
      print "image line:  $tl\n";
   }
}

print "----------------------------- pass 1 complete -------------------------------\n";


# print out contents of tag and accesstag arrays
foreach $key ( sort( keys %tags ) )
{
   print "tag:  $key <" . $tags{ $key } . ">  ";
   print "oid=" . $nametooid{ $key } . "   type=" . $nametotype{ $key } . "\n";

   if ($nametotype{ $key } eq "table")
   {
      print "leaves:\n";
      $oid = $nametooid{ $key };

      for($i=1; $i<100; $i++)
      {
         if( exists( $oidtoname{ "$oid.$i" } ))
         {
            print "    " . $oidtoname{ "$oid.$i" } . "    oid=$oid.$i\n";
         }
         else  {break;}
      }
   }
   print "\n";
}

foreach $key ( sort( keys %accesstags ) )
{
   print "access: $key as " . $accesstags{ $key } . "  ";
   print "oid=" . $nametooid{ $key } . "   type=" . $nametotype{ $key } . "\n";
}

print "----------------------------- pass 2 begin --------------------------------\n";

seek( FHTPL, 0, 0 ); # reset to beginning of file

foreach $line (<FHTPL>)
{
   $tl = $line;
   $tl =~ s/^\s+//;   # remove leading whitespace
   $tl =~ s/\s+$//;   # remove trailing whitespace

   #print "original line: <$line>\ntrimmed line:<$tl>\n";

   if ($tl =~ /\<\!\#\S+\>/)
   {
      # line contains an include

      ReplaceInclude( $tl );


   }

   elsif($tl =~ /\<\!\S+\>/)
   {
      # line contains a tag
      #print "tag line: $tl\n";

      @tags = $tl =~ /\<\!\S+\>/g;

      #print "tags found:  " . join('|', @tags) . "\n";

      if ($#tags != 0)
      {
         print "WARNING too many or not enough tags found in line $tl\n";
      }

      $thistag = $tags[0];
      $thistag =~ s/[\<\!\>]+//g;   #clean up tag
      $qualifier = 'std';

      if ($thistag =~ /\./)
      {
         # tag has a qualifier
         @pair = split(/\./, $thistag);
         #print "split $thistag into " . join('|', @pair) . "\n";

         $thistag = $pair[0];
         $qualifier = $pair[1];
      }

      print "tag found:  $thistag ($qualifier) - ";

      if('access' eq $qualifier)
      {
         # add this tag to the accesstags array
         $accesstags{ $thistag } = $thistag . "Access";
      }
      else
      {
         # add this tag to the tags list
         $tags{ $thistag } = $qualifier;
      }

      if($tl =~ /^\<\!\S+\>$/)
      {
         # line is ONLY a tag
         print "tag-only line: $tl\n";
         print "no replacement line\n";
      }
      else
      {
         # tag is embedded in HTML or SCRIPT
         print "embedded tag: $tl\n";

         ReplaceTag( $line, $thistag, $qualifier );
      }
   }
   else
   {
      # it's a normal line in the file, just echo it
      print FHPHP $line;
   }
}
print "----------------------------- pass 2 complete -------------------------------\n";

close( FHTPL );
close( FHPHP );


sub ReplaceInclude
{
   my ($tl) = @_;    # split out arguments into named variables
   my $replacementline = "";

   if( $tl =~ /pagetags/i )
   {
      print "PAGETAGS include in line $tl\n";

      $replacementline = ReplacePagetags();
   }
   else
   {
      print "non-PAGETAGS include in line $tl\n";

      @incfiles = $tl =~ /\<\!\#\S+\>/g;

      $thisinclude = $incfiles[0];

      $thisinclude =~ s/\<\!\#//;   # remove starting <!#
      $thisinclude =~ s/\>//;       # remove ending >

      $thisinclude = lc( $thisinclude );

      if ($thisinclude =~ /^\/common/)
      {
         # starts with \common
         $thisinclude =~ s/^\/common/\/$webapp\/common/;

         $replacementline = ReplacePagetags();
      }
      else
      {
         $thisinclude = "/$webapp/$thisinclude";
      }

      $replacementline = "<?php  virtual(\'$thisinclude\'); ?>\n";

   }

   print "replacement line is:  $replacementline";

   print FHPHP $replacementline;

   return;
}


sub ReplaceTag
{
   my( $line, $thistag, $qualifier ) = @_;

   my $oid;
   my $replacementline = $line;

   if( "access" eq $qualifier )
   {
      # it's an access tag
      $lookfor = "$thistag.$qualifier";
      $jsvar = $accesstags { $thistag };
   }
   elsif( "raw" eq $qualifier )
   {
      # it's a raw tag
      $lookfor = "$thistag.$qualifier";
      $jsvar = $thistag;
   }
   else # "std"
   {
      # it's a std tag
      $lookfor = $thistag;
      $jsvar = $thistag;
   }

   $replacementline =~ s/\"\<\!$lookfor\>\"/$jsvar/i;   # replace quoted variable
   $replacementline =~ s/\'\<\!$lookfor\>\'/$jsvar/i;   # replace quoted variable
   $replacementline =~ s/\<\!$lookfor\>/$jsvar/i;       # replace variable

   print "replacement line is:  $replacementline";

   print FHPHP $replacementline;
}


sub ReplacePagetags
{
   $lineout = "<?php\n   virtual('/$webapp/common/pagetags.php')\n\n?>\n\n<script>\n\n";

   $lineout .= "<?php\n   require('../../smhutil/ginkgosnmp.inc');\n";

   $keycount = keys %accesstags;
   if( 0 < $keycount )
   {
      # there are accesstags defined, so we need ginkgoprop.inc

      $lineout .= "   require('../../smhutil/ginkgoprop.inc');\n";
   }

   # print out contents of tag and accesstag arrays
   foreach $key ( sort( keys %tags ) )
   {
      #print "tag:  $key <" . $tags{ $key } . ">  ";
      #print "oid=" . $nametooid{ $key } . "   type=" . $nametotype{ $key } . "\n";
      $oid = $nametooid{ $key };
      $type = $nametotype{ $key };
      $qual = $tags{ $key };

      $lineout .= "\n   QueueSNMP(\"$key\", \"$oid\", \"$type\", \"$qual\" ";

      if ($nametotype{ $key } eq "table")
      {
         $lineout .=  ",\n      array(\n";

         for($i=1; $i<100; $i++)
         {
            if( exists( $oidtoname{ "$oid.$i" } ))
            {
               if(1<$i)  { $lineout .= ",\n"; }
               $lineout = $lineout .  "         \"" . $oidtoname{ "$oid.$i" } . "\"";
            }
            else  {break;}
         }

         $lineout .= "\n      )\n   ";
      }
      $lineout .= ");\n";
   }

   $lineout .=  "\n\nGenerateJSfromSNMPQueue();\n\n";

   foreach $key ( sort( keys %accesstags ) )
   {
      $lineout = $lineout . "   GetAccess( \"" . $accesstags{ $key } . "\",  \"." . $nametooid{$key} . ( "leaf" eq $nametotype{$key} ? ".0" : "") . "\" );\n";
   }

   $lineout .= "\n\n";

   $lineout .= "\n?>\n</script>\n\n";

   return $lineout;
}



