/*
 * (c) Copyright Hewlett-Packard Company 2007.  All rights Reserved.
 * Reproduction, adaptation, or translation without prior written
 * permission is prohibited except as allowed under the copyright
 * permission.
 */

/**
 * Index is an abstract base class. This class have some methods used by 
 * application index.
 * 
 * @constructor
 * @author		Gilson Hoffmeister
 * @required	LayoutManager
 * @required	PanelManger
 */
function Index() {

}

/**
 * Initialize and set all panels used by application.
 */
Index.prototype.initialize = function() {
	// Show RefreshDate
	//this.setRefreshDate();
	if (typeof(PanelManager) != "undefined") {
		panelManager = new PanelManager();
	}

	// Set panels
	panelManager.setContent();
	
	// Configure to resize panels after resize window
	window.onresize = function() {
		panelManager.windowWidth = layoutManager.getWindowWidth();
		panelManager.windowHeight = layoutManager.getWindowHeight();
		panelManager.setContent();
        resize_iframe();
	};
};

/**
 * Refresh the content iframe.
 */
Index.prototype.refresh = function() {
	var content = document.getElementById("iframeContent");
	iframeContent.contentWindow.location.reload(true); 
	this.setRefreshDate();
};

/**
 * Show the date that page will opened or refreshed.
 */
Index.prototype.setRefreshDate = function() {
	var date = new Date();	
	var refreshDate = document.getElementById("refreshDate");
	
	refreshDate.innerHTML = date.format(refreshDate.className);
};