#!/usr/bin/perl

package hpSMHSetup;

BEGIN {
    push @INC, "/usr/local/hp";
}

use hpSMHSetup::L10N;

use lib '/opt/hp/hpsmh/data/cgi-bin/';
use IP;

$lh = hpSMHSetup::L10N->get_handle();

&runConfig ;

sub runConfig {
   my $rc ;

   &InitXMLFile ;
   &Intro ;

GROUPINPUT:
   &GroupInput ;

USERACCESS:
   $rc = &UserAccess ;
   if (($rc eq 'p') || ($rc eq 'P')) {
      goto GROUPINPUT ;
   }

TRUSTMODE:
   $rc = &TrustMode ;
   if (($rc eq 'p') || ($rc eq 'P')) {
      goto USERACCESS ;
   }

IPBINDING:
   $rc = &IPBinding ;
   if (($rc eq 'p') || ($rc eq 'P')) {
      goto  TRUSTMODE ;
   }

   $rc = &IPRestrictedLogins ;
   if (($rc eq 'p') || ($rc eq 'P')) {
      goto IPBINDING ;
   }
}

sub InitXMLFile {
   my $XMLSmhpd = "/opt/hp/hpsmh/conf/smhpd.xml" ;
   my $INIFile  = "/var/spool/compaq/wbem/homepage/cpqhmmd.ini" ;
   my $INIXFile = "/var/spool/compaq/wbem/homepage/cpqhmmdx.ini" ;
   my $status ;
   my $tempEntry ;

   my $admgroup="" ;
   my $oprgroup="" ;
   my $usrgroup="" ;
   my $admlogin="true" ;
   my $anonacc="false" ;
   my $localacc="false" ;
   my $localtype="Anonymous" ;
   my $trustmode="TrustByCert" ;
   my $certlst="" ;
   my $xenamelst="" ;
   my $ipbind="False" ;
   my $ipbindlst="" ;
   my $iprestrct="False" ;
   my $iprestrctinc="" ;
   my $iprestrctexc="" ;


   $status = open FILE, $XMLSmhpd ;
   close FILE ;

   if (!$status) {

      $status = open FILE, $INIFile ;
      close FILE ;
      if ($status) {
         
         # Copy existing CHP cert files...
         #
         system("cp -f /var/spool/compaq/wbem/file.pem /opt/hp/sslshare");
         system("cp -f /var/spool/compaq/wbem/cert.pem /opt/hp/sslshare");
         system("cp -f /var/spool/compaq/wbem/certs/* /opt/hp/hpsmh/certs");

         $tempEntry = &GetINIData ($INIFile, "AnonymousAccess") ;
         if ($tempEntry ne "") {
             $anonacc = $tempEntry ;
         }
      }

      $status = open FILE, $INIXFile ;
      close FILE ;
      if ($status) {
         $tempEntry = &GetINIData ($INIXFile, "LocalAccessEnabled") ;
         if ($tempEntry ne "") {
            $localacc = $tempEntry ;
         }

         $tempEntry = &GetINIData ($INIXFile, "LocalAccessType") ;
         if ($tempEntry ne "") {
            $localtype = ucfirst $tempEntry ;
         }

         $tempEntry = &GetINIData ($INIXFile, "TrustMode") ;
         if ($tempEntry ne "") {
            $trustmode = $tempEntry ;
         }

         $tempEntry = &GetINIData ($INIXFile, "XENameList") ;
         if ($tempEntry ne "") {
            $xenamelst = $tempEntry ;
         }

         $tempEntry = &GetINIData ($INIXFile, "IPRestriction") ;
         if ($tempEntry ne "") {
            $iprestrct = $tempEntry ;
         }

         $tempEntry = &GetINIData ($INIXFile, "AdministratorIPInclude") ;
         if ($tempEntry ne "") {
            $tempEntry = &GetINIData ($INIXFile, "AdministratorIPInclude") ;
         }

         $tempEntry = &GetINIData ($INIXFile, "AdministratorIPExclude") ;
         if ($tempEntry ne "") {
            $iprestrctexc = &GetINIData ($INIXFile, "AdministratorIPExclude") ;
         }
      }

      print $lh->maketext("   Writing a new [_1] file\n", $XMLSmhpd) ;
      open FILE, ">$XMLSmhpd" ;

      print FILE "<\?xml version=\"1.0\" encoding=\"UTF-8\"\?>\n" ;
      print FILE "<system-management-homepage>\n" ;
      print FILE "  <admin-group>$admgroup</admin-group>\n" ;
      print FILE "  <operator-group>$oprgroup</operator-group>\n" ;
      print FILE "  <user-group>$usrgroup</user-group>\n" ;
      print FILE "  <allow-default-os-admin>$admlogin</allow-default-os-admin>\n" ;
      print FILE "  <anonymous-access>$anonacc</anonymous-access>\n" ;
      print FILE "  <localaccess-enabled>$localacc</localaccess-enabled>\n" ;
      print FILE "  <localaccess-type>$localtype</localaccess-type>\n" ;
      print FILE "  <trustmode>$trustmode</trustmode>\n" ;
      print FILE "  <xenamelist>$xenamelst</xenamelist>\n" ;
      print FILE "  <ip-binding>$ipbind</ip-binding>\n" ;
      print FILE "  <ip-binding-list>$ipbindlst</ip-binding-list>\n" ;
      print FILE "  <ip-restricted-logins>$iprestrct</ip-restricted-logins>\n" ;
      print FILE "  <ip-restricted-include>$iprestrctinc</ip-restricted-include>\n" ;
      print FILE "  <ip-restricted-exclude>$iprestrctexc</ip-restricted-exclude>\n" ;
      print FILE "</system-management-homepage>\n" ;

      close FILE ;
   }

}

sub Intro {
   my $input ;

   print $lh->maketext('_WELCOME') ;

   print $lh->maketext("Press ENTER to continue.") ;

   $input = <STDIN> ;
}

sub GroupInput {
   my $XMLSmhpd = "/opt/hp/hpsmh/conf/smhpd.xml" ;
   my @AdminGroup ;
   my @OperatorGroup ;
   my @UserGroup ;

   @AdminGroup    = &GetXMLArrayData ($XMLSmhpd, "admin-group") ;
   @OperatorGroup = &GetXMLArrayData ($XMLSmhpd, "operator-group") ;
   @UserGroup     = &GetXMLArrayData ($XMLSmhpd, "user-group") ;

   do {
   my $Group ;

   print $lh->maketext('_OS_SYSTEM_GROUPS') ;

   &PrintGroup ($lh->maketext("Administrator"), @AdminGroup) ;
   &PrintGroup ($lh->maketext("Operator"), @OperatorGroup) ;
   &PrintGroup ($lh->maketext("User"), @UserGroup) ;

   print $lh->maketext('_MODIFY_GROUP_LISTS') ;

   print $lh->maketext("Please enter your selection: ") ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2') && ($key ne 'n') && ($key ne 'N')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   print "\n" ;

   if ($key == '1') {
      (*AdminGroup, *OperatorGroup, *UserGroup) = &AddGroup (\@AdminGroup, \@OperatorGroup, \@UserGroup) ;
   }

   if ($key == '2') {
      (*AdminGroup, *OperatorGroup, *UserGroup) = &DeleteGroup (\@AdminGroup, \@OperatorGroup, \@UserGroup) ;
   }

   } until (($key eq 'n') || ($key eq 'N')) ;

   $key = '0' ;

   &PutXMLArrayData ($XMLSmhpd, "admin-group"   , @AdminGroup) ;
   &PutXMLArrayData ($XMLSmhpd, "operator-group", @OperatorGroup) ;
   &PutXMLArrayData ($XMLSmhpd, "user-group"    , @UserGroup) ;

}

sub AddGroup {
   local (*Admin, *Oper, *User) = @_ ;
   my $key ;
   my $input ;
   my $error ;

   print "\n-------------------------------------------------------------------------------\n" ;
   print $lh->maketext("Add Operating System Groups\n\n") ;

   $error = "" ;

   do {

   &PrintGroup ($lh->maketext("Administrator"), @Admin) ;
   &PrintGroup ($lh->maketext("Operator"),      @Oper) ;
   &PrintGroup ($lh->maketext("User"),          @User) ;

   print $lh->maketext('_GROUP_TYPES') ;

   if ($error ne "") {
      print "$error" ;
   }

   print $lh->maketext("Please enter your selection: ") ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2') && ($key != '3') && ($key ne 'n') && ($key ne 'N')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   print "\n" ;
   
   if ($key == '1') {
      if (scalar (@Admin) < 5) {
         $error = "" ;

         print $lh->maketext("\n   Enter the name of an Operating System (OS) Group that you wish to assign to\n") ;
         print $lh->maketext("   the Administrator Group List: ") ;
         $input = <STDIN> ;
         chomp ($input) ;

         ($grnam, $passwd, $gid, $grmembers) = getgrnam($input);

         if(!$grnam) {
            $error = $lh->maketext("\n   The group does not exist\n\n");
         }

         if (length ($input) > 32) {
            $error = $lh->maketext("\n   The Group Name exceeds 32 characters\n\n") ;
         } 

         if (($input eq "") || (!($input=~/[A-Za-z0-9]+/))) {
            $error = $lh->maketext("\n   A blank value is not a valid Group Name!\n\n");
         }
         
         if ($input =~ m/([ \[\]{}\(\)\\\/\|~`\@#\$\%\^\*\+"'\<\>;\?,\.])/){
            $error = $lh->maketext("\n   The Group Name [_1] contains the illegal character << [_2] >>\n\n", $input, $1) ;
         }
         
         if (&testArrayElement($input, \@Admin) eq "true" || &testArrayElement($input, \@Oper) eq "true" || &testArrayElement($input, \@User) eq "true") {
            $error = $lh->maketext("\n   This group name is already in the list!\n\n");
         }

         if ($error eq "") {
            (*Admin) = &addArrayElement ($input, \@Admin) ;
            $error = "" ;
         }

      } else {
         $error = $lh->maketext("   The limit of 5 Administrator Groups has been reached\n\n") ;
      }
   }

   if ($key == '2') {
      if (scalar (@Oper) < 5) {
         $error = "" ;

         print $lh->maketext("\n   Enter the name of an Operating System (OS) Group that you wish to assign to\n") ;
         print $lh->maketext("   the Operator Group List: ") ;
         $input = <STDIN> ;
         chomp ($input) ;
        
         ($grnam, $passwd, $gid, $grmembers) = getgrnam($input);

         if(!$grnam) {
            $error = $lh->maketext("\n   The group does not exist\n\n");
         }

         if (length ($input) > 32) {
            $error = $lh->maketext("\n   The Group Name exceeds 32 characters\n\n") ;
         } 

         if (($input eq "") || (!($input=~/[A-Za-z0-9]+/))) {
            $error = $lh->maketext("\n   A blank value is not a valid Group Name!\n\n");
         }
            
         if ($input =~ m/([ \[\]{}\(\)\\\/\|~`\@#\$\%\^\*\+"'\<\>;\?,\.])/){
            $error = $lh->maketext("\n   The Group Name [_1] contains the illegal character << [_2] >>\n\n", $input, $1) ;
         }

         if (&testArrayElement($input, \@Admin) eq "true" || &testArrayElement($input, \@Oper) eq "true" || &testArrayElement($input, \@User) eq "true") {
            $error = $lh->maketext("\n   This group name is already in the list!\n\n");
         }

         
         if ($error eq "") {
            (*Oper) = &addArrayElement ($input, \@Oper) ;
            $error = "" ;
         }

      } else {
         $error = $lh->maketext("   The limit of 5 Operator Groups has been reached\n\n") ;
      }
   }

   if ($key == '3') {
      if (scalar (@User) < 5) {
         $error = "" ;

         print $lh->maketext("\n   Enter the name of an Operating System (OS) Group that you wish to assign to\n") ;
         print $lh->maketext("   the User Group List: ") ; 
         $input = <STDIN> ;
         chomp ($input) ;

         ($grnam, $passwd, $gid, $grmembers) = getgrnam($input);

         if(!$grnam) {
            $error = $lh->maketext("\n   The group does not exist\n\n");
         }

         if (length ($input) > 32) {
            $error = $lh->maketext("\n   The Group Name exceeds 32 characters\n\n") ;
         } 

         if (($input eq "") || (!($input=~/[A-Za-z0-9]+/))) {
            $error = $lh->maketext("\n   A blank value is not a valid Group Name!\n\n");
         }
            
         if ($input =~ m/([ \[\]{}\(\)\\\/\|~`\@#\$\%\^\*\+"'\<\>;\?,\.])/){
            $error = $lh->maketext("\n   The Group Name [_1] contains the illegal character << [_2] >>\n\n", $input, $1) ;
         }
         
         if (&testArrayElement($input, \@Admin) eq "true" || &testArrayElement($input, \@Oper) eq "true" || &testArrayElement($input, \@User) eq "true") {
            $error = $lh->maketext("\n   This group name is already in the list!\n\n");
         }

         if ($error eq "") {
            (*User) = &addArrayElement ($input, \@User) ;
            $error = "" ;
         }

      } else {
         $error = $lh->maketext("   The limit of 5 User Groups has been reached\n\n") ;
      }
   }

   } until (($key eq 'n') || ($key eq 'N')) ;

   return (\@Admin, \@Oper, \@User) ;

   $key = '0' ;

}

sub DeleteGroup {
   local (*Admin, *Oper, *User) = @_ ;
   my $key ;
   my $input ;

   print "\n-------------------------------------------------------------------------------\n" ;
   print $lh->maketext("Delete Operating System Groups\n\n") ;

   do {

   &PrintGroup ($lh->maketext("Administrator"), @Admin) ;
   &PrintGroup ($lh->maketext("Operator"),      @Oper) ;
   &PrintGroup ($lh->maketext("User"),          @User) ;

   print $lh->maketext('_GROUP_TYPES') ;

   print $lh->maketext("Please enter your selection: ") ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2') && ($key != '3') && ($key ne 'n') && ($key ne 'N')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   print "\n" ;

   if ($key == '1') {
      (*Admin) = &DeleteGroupEntries ($lh->maketext("Administrator"), \@Admin) ;
   }

   if ($key == '2') {
      (*Oper) = &DeleteGroupEntries ($lh->maketext("Operator"), \@Oper) ;
   }

   if ($key == '3') {
      (*User) = &DeleteGroupEntries ($lh->maketext("User"), \@User) ;
   }

   } until (($key eq 'n') || ($key eq 'N')) ;

   $key = '0' ;

   return (\@Admin, \@Oper, \@User) ;

}

sub DeleteGroupEntries {
   local ($name, *group) = @_ ;
   my $input ;
   my $count ;

   do {
		&PrintGroup ($name, @group) ;

		$count = scalar (@group) ;

		print $lh->maketext('_ENTER_GROUP_NAME_TO_DELETE') ;

		$input = <STDIN> ;

		if (($input > '0') && ($input <= $count)) {
			splice (@group, ($input - 1), 1) ;
		} else {
			print $lh->maketext('_INVALID_GROUP_NUMBER') ;
		}

   } until $input == '0' ;

   return (\@group) ;

}

sub PrintGroup {
   my ($title, @GroupMembers) = @_ ;
   my $groupCount ;


   print $lh->maketext("\n   [_1] Group List\n   ---------------\n", $title) ;
   $groupCount = 1 ;
   if (scalar (@GroupMembers) > '0') {
      my $Group ;

      foreach $Group (@GroupMembers) {
         print "   $groupCount) $Group\n" ;
         $groupCount++ ;
      }
   } else {
      print $lh->maketext("   ***empty list***\n") ;
   }
}

sub UserAccess {
   my $XMLSmhpd = "/opt/hp/hpsmh/conf/smhpd.xml" ;

   my $anonAccess      ;
   my $localAccess     ;
   my $localAccessType ;

   $anonAccess      = &GetXMLData ($XMLSmhpd, "anonymous-access") ;
   $localAccess     = &GetXMLData ($XMLSmhpd, "localaccess-enabled") ;
   $localAccessType = &GetXMLData ($XMLSmhpd, "localaccess-type") ;

   print "-------------------------------------------------------------------------------\n" ;
   print $lh->maketext("User Access\n\n") ;

   print $lh->maketext('_ANONYMOUS_ACCESS') ;
   print $lh->maketext('_LOCAL_ACCESS') ;

   do {
   &printUserAccessSettings ($anonAccess, $localAccess, $localAccessType) ;

   print $lh->maketext('_SET_ANONYMOUS_LOCAL_ACCESS') ;

   print $lh->maketext("Select an optional access methods to modify the Current Settings. ") ;

   $key = '0' ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') &&
           ($key != '2') &&
           ($key != '3') &&
           ($key != '4') &&
           ($key != '5') &&
           ($key ne 'n') &&
           ($key ne 'N') &&
           ($key ne 'p') &&
           ($key ne 'P')
           ) { } ;

   system "stty", 'echo', 'icanon', 'eol', '^@';

   print "\n" ;

   if ($key == '1') {
      $anonAccess = "True" ;
   }

   if ($key == '2') {
      $anonAccess = "False" ;
   }

   if ($key == '3') {
      $localAccess = "False" ;
   }

   if ($key == '4') {
      $localAccess     = "True" ;
      $localAccessType = "Anonymous" ;
   }

   if ($key == '5') {
      $localAccess     = "True" ;
      $localAccessType = "Administrator" ;
   }

   } until (($key eq 'n') || ($key eq 'N') || ($key eq 'p') || ($key eq 'P')) ;

   &PutXMLData ($XMLSmhpd, "anonymous-access"   , $anonAccess) ;
   &PutXMLData ($XMLSmhpd, "localaccess-enabled", $localAccess) ;
   &PutXMLData ($XMLSmhpd, "localaccess-type"   , $localAccessType) ;

   return ($key) ;

}

sub printUserAccessSettings {
   my ($anonAccess, $localAccess, $localAccessType) = @_ ;
   my $tmp ;

   $tmp = ucfirst $localAccess ;

   print "\n";
   print "  User Access Settings\n";
   print "  --------------------" ;
   print $lh->maketext('_ACCESS_SETTINGS', $anonAccess, $localAccess) ;
   if ($tmp eq "True") {
   print "\n";
   print $lh->maketext("   Local Access Type     [_1]", $localAccessType); ;
   }
   print "\n   --------------------\n\n" ;

}

sub TrustMode {
   my $XMLSmhpd = "/opt/hp/hpsmh/conf/smhpd.xml" ;

   my $trustMode ;
   my @XENameList ;

   $trustMode  = &GetXMLData      ($XMLSmhpd, "trustmode") ;
   @XENameList = &GetXMLArrayData ($XMLSmhpd, "xenamelist") ;

   print "-------------------------------------------------------------------------------\n" ;
   print $lh->maketext("Trust Mode\n\n") ;

   print $lh->maketext('_SELECT_TRUST_MODE') ;

   do {
   &printTrustMode ($trustMode, @XENameList) ;

   print $lh->maketext('_TRUST_MODES') ;

   if (lc ($trustMode) eq "trustbycert") {
      print $lh->maketext("   4 - Modify Certificate List\n") ;
   }

   if (lc ($trustMode) eq "trustbyname") {
      print $lh->maketext("   4 - Modify Server Name List\n") ;
   }

   print $lh->maketext('_ENTER_SELECTION') ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') &&
           ($key != '2') &&
           ($key != '3') &&
           ($key != '4') &&
           ($key ne 'n') &&
           ($key ne 'N') &&
           ($key ne 'p') &&
           ($key ne 'P')
           ) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   print "\n" ;

   if ($key == '1') {
      $trustMode = "TrustByCert" ;
   }

   if ($key == '2') {
      $trustMode = "TrustByName" ;
   }

   if ($key == '3') {
      $trustMode = "TrustByAll" ;
   }

   if ($key == '4') {
      if ((lc $trustMode) eq "trustbycert") {
         &TrustCertificates ;
      }

      if ((lc $trustMode) eq "trustbyname") {
         (*XENameList) = &getXENames (\@XENameList) ;
      }
   }

   } until (($key eq 'n') || ($key eq 'N') || ($key eq 'p') || ($key eq 'P')) ;

   &PutXMLData      ($XMLSmhpd, "trustmode" , $trustMode) ;
   &PutXMLArrayData ($XMLSmhpd, "xenamelist", @XENameList) ;

   return ($key) ;

}

sub getXENames {
   local (*XENames) = @_ ;

   my $input ;
   my $key ;
   my $error ;
   my $count ;
   my $name ;

   print $lh->maketext('_SETUP_STE_SSO_REQUESTS') ; 

   do {

   &printXENames (@XENames) ;

   print $lh->maketext('_MODIFY_SIM_SERVER_LIST') ;

   if ($error ne "") {
      print $error ;
   }

   print $lh->maketext("Please enter your selection: ") ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2') && ($key ne 'n') && ($key ne 'N') && ($key ne 'p') && ($key ne 'P')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   print "\n" ;

   if ($key == '1') {
      if (scalar (@XENames) < 5) {
         $error = "" ;

         print $lh->maketext("   Please enter the Systems Insight Manager Server to add: ") ;
         $input = <STDIN> ;
         chomp ($input) ;

         if (length ($input) > 63) {
            $error = $lh->maketext("\n   The XE Name exceeds 63 characters\n\n") ;
         } 

         if (($input eq "") || (!($input=~/[A-Za-z0-9]+/))) {
            $error = $lh->maketext("\n   A blank value is not a valid XE Name!\n\n");
         }

         if ($input =~ m/([\[\]{}\(\)\\\/\|~`\@#\$\%\^\*\+"'<>\?,\.])/){
            $error = $lh->maketext("\n   The XE Name [_1] contains the illegal character << [_2] >>\n\n", $input, $1) ;
         }

         if ($error eq "") {
            (*XENames) = &addArrayElement ($input, \@XENames) ;
         }
      } else {
         $error = $lh->maketext("   The limit of 5 XE Names Groups has been reached\n\n");
      }
   }

   if ($key == '2') {

      $count = scalar (@XENames) ;

      print $lh->maketext("\n   Enter the number of the Systems Insight Manager Server to delete,\n   or ENTER when you are finished: ") ;

      $input = <STDIN> ;
      chomp ($input) ;

      if (($input > '0') && ($input <= $count)) {
         $name = @XENames [$input - '1'] ;
         (*XENames) = &removeArrayElement ($name, \@XENames) ;
      }

   }

   } until (($key eq 'n') || ($key eq 'N') || ($key eq 'p') || ($key eq 'P')) ;

   $key = '0' ;

   return (\@XENames) ;

}

sub printTrustMode {
   my ($mode, @XEList) = @_ ;
   my @certs ;

   print "\n";
   print $lh->maketext("   Trust Mode Settings\n");
   print "   -------------------------" ;

   if ((lc $mode) eq "trustbycert") {
   print "\n";
   print $lh->maketext("   Trust Mode: Trust By Certificate\n") ;
   }

   if ((lc $mode) eq "trustbyname") {
   print "\n";
   print $lh->maketext("   Trust Mode: Trust By Name\n") ;
   }

   if ((lc $mode) eq "trustbyall") {
   print "\n";
   print $lh->maketext("   Trust Mode: Trust All\n") ;
   }
   print "   -------------------------\n" ;

   if ((lc $mode) eq "trustbyname") {
      &printXENames (@XEList) ;
   }

   if ((lc $mode) eq "trustbycert") {
      (*certs) = &printCertList (\@certs) ;
   }

}

sub printXENames {
   my (@xeNames) = @_ ;
   my $count ;

   $count = 0 ;

   print $lh->maketext("\n   Trusted Server Names\n") ;
   print "   -------------------------\n" ;
   foreach $member (@xeNames) {
      $count++ ;
      print "   $count) $member\n" ;
   }
   print "   -------------------------\n" ;
}

sub printCertList {
   local (*certs) = @_ ;
   my $certsDir = "/opt/hp/hpsmh/certs" ;
   my $files ;
   my $count = 0 ;

   opendir (CERTDIR, "$certsDir") ;

   print "\n";
   print $lh->maketext("   Trusted Certificates List\n");
   print "   -------------------------\n" ;
   @files = readdir (CERTDIR) ;
   if (scalar (@files) > '0') {
      for (@files) {
         if ($_ ne "." && $_ ne "..") {
            $count++ ;
            print "   $count) $_\n" ;
            @certs [$count - '1'] = $_ ;
         }
      }
   } else {
   print $lh->maketext("   ***empty list***\n") ;
   }
   print "   -------------------------\n" ;

   closedir CERTDIR ;

   return (\@certs) ;

}

sub TrustCertificates {
   my @certs ;

   print "-------------------------------------------------------------------------------\n" ;
   print $lh->maketext("Trusted Certificates\n\n") ;

   do {
   $Complete  = '0' ;

   do {
   print $lh->maketext('_TRUSTED_CERTIFICATES_INSTRUCTIONS') ;

   (*certs) = &printCertList (\@certs) ;

   if (( ! -x '/usr/bin/curl'  ) && ( ! -x '/usr/bin/wget' )) {
   print $lh->maketext('_TRUSTED_CERTIFICATES_OPTIONS_IMPORT_DISABLED') ;
   }
   else {
   print $lh->maketext('_TRUSTED_CERTIFICATES_OPTIONS') ;
   }

   print $lh->maketext("Please enter your selection: ") ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2') && ($key != '3') && ($key ne 'n') && ($key ne 'N')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   print "\n" ;

   if ($key == '1') {
      &AddCertFile ;
   }

   if ($key == '2') {
      &ImportCertFile ;
   }

   if ($key == '3') {
      &DeleteCertFile ;
   }

   } until (($key eq 'n') || ($key eq 'N')) ;

   $key = '0' ;

   if (scalar (@certs) <= '0') {
   print $lh->maketext('_NO_TRUSTED_CERTIFICATES_WARNING') ;

   print $lh->maketext('_YES_NO_OPTION') ;

   print $lh->maketext("Please enter your selection: ") ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   if ($key == '2') {
      $Complete = '1' ;
   }

   }

   } until $Complete eq '0' ;

   $key = '0' ;

   print "\n\n" ;

}

sub AddCertFile {
   my $certsDir = "/opt/hp/hpsmh/certs" ;
   my @certs ;
   my $input ;
   my $target ;
   my $newpath ;
   my $certFile ;
   my $login ;
   my $pass ;
   my $uid ;
   my $gid ;

   do {
   (*certs) = &printCertList (\@certs) ;

   print $lh->maketext('_TRUSTED_CERTIFICATE_FILE_PATH') ;

   $input = <STDIN> ;
   chomp ($input) ;
  
   $newpath=$input;
   $newpath=~m/([^\\\/]*)$/;
   $target=$1;

   $certFile = "$certsDir/$target" ;

   $status = system ("cp $input $certsDir/$target 2> /dev/null") ;

   if ($status ne '0' && $input ne "") {
   print $lh->maketext('_TRUSTED_CERTIFICATE_FILE_NOT_FOUND', $input) ;
   } else {
      ($login, $pass, $uid, $gid) = getpwnam ("hpsmh") ;
      chown $uid, $gid, $certFile ;
   }

   } until $input eq "" ;

}

sub ImportCertFile {
   my $certsDir = "/opt/hp/hpsmh/certs" ;
   my $certificate ;
   my $certName ;
   my $certFile ;
   my $input ;
   my $login ;
   my $pass ;
   my $uid ;
   my $gid ;


    if (( ! -x '/usr/bin/curl'  ) && ( ! -x '/usr/bin/wget' )) {
       print "\n";
       print $lh->maketext('_IMPORT_TRUSTED_CERTIFICATED_DISABLED');
       return;
    }

   do {
   print $lh->maketext('_ENTER_IMPORT_SERVER_NAME') ;

   $certName = <STDIN> ;
   chomp ($certName) ;

   if ($certName ne "") {
   print $lh->maketext('_RETRIEVING_CERTIFICATE') ;

 # $certificate = get("http://$certName:280/GetCertificate") ;
 # Use cURL or wget utility
    if ( -x '/usr/bin/curl' ) {
       $certificate = `/usr/bin/curl http://$certName:280/GetCertificate`;
    }
    else {
       if (-x '/usr/bin/wget' ) {
         $certificate =`/usr/bin/wget http://$certName:280/GetCertificate -O -`;
       }
       else {
         print $lh->maketext("Certificate Import not supported. Missing cURL or wget utility programs.");
       }
    }

   print "\n";
   print $lh->maketext("   Import Server Certificate request has completed.\n\n") ;

   print $lh->maketext('_REVIEW_CERTIFICATE_INFO') ;

   print "-------------------------------------------------------------------------------\n\n" ;
   $status = system ("echo '$certificate' | /opt/hp/hpsmh/bin/openssl x509 -text -noout") ;
   print "-------------------------------------------------------------------------------\n\n" ;

   print $lh->maketext('_ACCEPT_REJECT_OPTION') ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   if ($key == '1') {
      $certFile = "$certsDir/$certName.pem" ;
      print $lh->maketext("\n   Saving to certificate file: [_1]\n", $certFile) ;
      open CERTFILE, ">$certFile" ;
         print CERTFILE $certificate ;
         ($login, $pass, $uid, $gid) = getpwnam ("hpsmh") ;
         chown $uid, $gid, $certFile ;
      close CERTFILE ;
   }

   if ($key == '2') {
      $certificate = "" ;
   }

   }
   } until $certName eq "" ;

   $key = '0' ;

}

sub DeleteCertFile {
   my $certsDir = "/opt/hp/hpsmh/certs" ;
   my $certFile ;
   my $certCount ;
   my @certs ;
   my $cert ;
   my $input ;

   do {
   (*certs) = &printCertList (\@certs) ;

   $certCount = scalar (@certs) ;

   print $lh->maketext('_ENTER_CERTIFICATE_TO_DELETE') ;

   $input = <STDIN> ;

   if (($input > '0') && ($input <= $certCount)) {
      $cert = @certs [$input - '1'] ;
      $certFile = "$certsDir/$cert" ;
      unlink $certFile ;
   }

   } until $input == '0' ;

}

sub IPBinding {
   my $XMLSmhpd = "/opt/hp/hpsmh/conf/smhpd.xml" ;
   my $key ;
   my $IPBinding ;
   my @IPAddresses ;

IPBINDTOP:

   $IPBinding   = &GetXMLData      ($XMLSmhpd, "ip-binding") ;
   @IPAddresses = &GetXMLArrayData ($XMLSmhpd, "ip-binding-list") ;

   print "-------------------------------------------------------------------------------\n" ;
   print $lh->maketext("IP Binding\n\n") ;

   print $lh->maketext('_IP_BINDING_INSTRUCTIONS') ;

   do {
   print $lh->maketext("\n   IP Binding: ") ;
   if ((lc $IPBinding) eq "true") {
      print $lh->maketext(" ON\n\n") ;
   } else {
      print $lh->maketext(" OFF\n\n") ;
   }

   print $lh->maketext('_ON_OFF_OPTION') ;

   print $lh->maketext("Please enter your selection: ") ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') &&
           ($key != '2') &&
           ($key ne 'n') &&
           ($key ne 'N') &&
           ($key ne 'p') &&
           ($key ne 'p')
           ) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   if ($key == '1') {
      $IPBinding = "True" ;
   }

   if ($key == '2') {
      $IPBinding = "False" ;
   }

   print "\n" ;

   } until (($key eq 'n') || ($key eq 'N') || ($key eq 'p') || ($key eq 'P')) ;

   if (($key eq 'p') || ($key eq 'P')) {
      return ($key) ;
   }

   if ((lc $IPBinding) eq "true") {
   do {

   print $lh->maketext('_IP_BINDING_ADD_DELETE_INSTRUCTIONS') ;

   &printIPBindingList (@IPAddresses) ;

   print $lh->maketext('_ADD_DELETE_OPTION') ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2') && ($key ne 'n') && ($key ne 'N') && ($key ne 'p') && ($key ne 'P')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   print "\n" ;

   if ($key == '1') {
      if (scalar (@IPAddresses) < '5') {
          (*IPAddresses) = &AddIPAddress (\@IPAddresses) ;
      } else {
          print $lh->maketext("   The maximum allowed number of IP Addresses has been reached\n") ;
      }
   }

   if ($key == '2') {
      (*IPAddresses) = &DeleteIPAddress (\@IPAddresses) ;
   }

   print "\n" ;

   } until (($key eq 'n') || ($key eq 'N') || ($key eq 'p') || ($key eq 'P')) ;
   }

   &PutXMLData      ($XMLSmhpd, "ip-binding"     , $IPBinding) ;
   &PutXMLArrayData ($XMLSmhpd, "ip-binding-list", @IPAddresses) ;

   if (($key eq 'p') || ($key eq 'P')) {
      goto IPBINDTOP ;
   }

   return ($key) ;
}

sub printIPBindingList {
   my (@ipadd) = @_ ;
   my $ipCount = '0' ;

   print "\n";
   print $lh->maketext("   IP Binding List\n");
   print "   ----------------\n" ;
   if (scalar (@ipadd)) {
      foreach (@ipadd) {
         $ipCount++ ;
         print "   $ipCount) $_\n" ;
      }
   } else {
      print $lh->maketext("   ***empty list***\n") ;
   }
   print "   ----------------\n\n" ;

}

sub AddNetMask {
   my $NetMask ;
   my $validEntry = "false" ;
   my $rc ;

   do {

   ($rc, $NetMask) = &enterNetMask ;

   if ($rc eq "") {
      print $lh->maketext("\n\n   Netmask: [_1]\n", $NetMask) ;
      $validEntry = "true" ;
   } else {
      print $lh->maketext("\n\n   Invalid Netmask: [_1]\n", $NetMask) ;
      $validEntry = "false" ;
   }

   } until $validEntry eq "true" ;

   return ($NetMask) ;
}

sub AddIPAddress {
   local (*ipaddress) = @_ ;
   my $IPAddress ;
   my $netmask ;
   my $enrty ;
   my $validEntry = "false" ;
   my $rc ;

   do {

   ($rc, $IPAddress) = &enterIPAddress ;

   if ($rc eq "") {
      if ($IPAddress ne "") {
		if (rindex($IPAddress,":") eq "-1") {
			($rc, $netmask) = &enterNetmask ;      
			if ($netmask ne "") {
				(*ipaddress) = &addNetworkElement ($IPAddress, $netmask, \@ipaddress) ;
			}
		} else {
			if (!($IPAddress =~ m/^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}/) &&
			    !($IPAddress =~ m/^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)/) &&
				!($IPAddress =~ m/^((?:[0-9A-Fa-f]{1,4}:){6,6})(25[0-5]|2[0-4]\d|[0-1]?\d?\d)(\.(25[0-5]|2[0-4]\d|[0-1]?\d?\d)){3}/) &&
				!($IPAddress =~ m/^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?) ::((?:[0-9A-Fa-f]{1,4}:)*)(25[0-5]|2[0-4]\d|[0-1]?\d?\d)(\.(25[0-5]|2[0-4]\d|[0-1]?\d?\d)){3}/) ) {
				print $lh->maketext("\n\n   Invalid IPv6 Address: [_1] \n", $IPAddress) ;
			} else {
				(*ipaddress) = &addNetworkElement ($IPAddress, $netmask, \@ipaddress) ;
			}
		}
      }
      $validEntry = "true" ;
   } else {
      print $lh->maketext("\n\n   Invalid IP Address: [_1] - [_2]\n", $IPAddress, $rc) ;
   }

   } until $validEntry eq "true" ;

   return (\@ipaddress) ;
}

sub enterNetmask {
   my $Netmask ;
   my $validEntry = "false" ;
   my $rc ;

   do {
   print $lh->maketext('_ENTER_NETMASK') ;

   $Netmask = <STDIN> ;
   chomp ($Netmask) ;

   if ($Netmask ne "") {
       $rc = &validNetMask ($Netmask) ;
       if ($rc eq "") {
          $validEntry = "true" ;
       } else {
          print $lh->maketext("\n\n   Invalid netmask: [_1] - [_2]\n", $NetMask, $rc) ;
       }
   } else {
       $validEntry = "true" ;
   }
   } until $validEntry eq "true" ;

   return ($rc, $Netmask) ;
}

sub enterIPAddress {
   my $IPAddress ;
   my $rc ;

   print $lh->maketext('_ENTER_IP_ADDRESS') ;

   $IPAddress = <STDIN> ;
   chomp ($IPAddress) ;

   if ($IPAddress ne "") {
       $rc = &validIP ($IPAddress) ;
#		if (rindex($IPAddress,":") eq "-1") {
#			$rc = &validNetwork ($IPAddress) ;
#		}
   }

   return ($rc, $IPAddress) ;
}

sub DeleteIPAddress {
   local (*ipaddress) = @_ ;
   $input ;
   $bindCount ;

   do {
   &printIPBindingList (@ipaddress) ;

   $bindCount = scalar (@ipaddress) ;

   print $lh->maketext('_DELETE_IP_ADDRESS') ;

   $input = <STDIN> ;

   if (($input > '0') && ($input <= $bindCount)) {
      splice (@ipaddress, ($input - 1), 1) ;
   }

   } until $input == '0' ;

   return (\@ipaddress) ;

}

sub IPRestrictedLogins {
   my $XMLSmhpd = "/opt/hp/hpsmh/conf/smhpd.xml" ;
   $IPLogins = "false" ;
   @IPInclude ;
   @IPExclude ;

IPRESTRICTTOP:

   $IPLogins  = &GetXMLData      ($XMLSmhpd, "ip-restricted-logins") ;
   @IPInclude = &GetXMLArrayData ($XMLSmhpd, "ip-restricted-include") ;
   @IPExclude = &GetXMLArrayData ($XMLSmhpd, "ip-restricted-exclude") ;

   print "-------------------------------------------------------------------------------\n" ;
   print $lh->maketext("IP Restricted Logins\n\n") ;

   print $lh->maketext('_IP_RESTRICTED_LOGIN_INSTRUCTIONS') ;

   do {
   print $lh->maketext("\n   IP Restricted Logins: ") ;
   if ((lc $IPLogins) eq "true") {
      print " ON\n" ;
   } else {
      print " OFF\n" ;
   }

   print $lh->maketext('_IP_RESTRICTED_LOGIN_SELECT') ;

   print $lh->maketext('_IP_RESTRICTED_LOGIN_OPTION') ;

   print $lh->maketext("Please enter your selection: ") ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2') && ($key ne 'n') && ($key ne 'N') && ($key ne 'p') && ($key ne 'P')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   if ($key == '1') {
      $IPLogins = "True"  ;
   }

   if ($key == '2') {
      $IPLogins = "False"  ;
   }

   print "\n" ;

   } until (($key eq 'n') || ($key eq 'N') || ($key eq 'p') || ($key eq 'P')) ;

   if (($key eq 'p') || ($key eq 'P')) {
      return ($key) ;
   }

   if ((lc $IPLogins) eq "true") {
      ($key, *IPInclude, *IPExclude) = &SetIPAddressLogins ($key, \@IPInclude, \@IPExclude) ;
   } 

   &PutXMLData      ($XMLSmhpd, "ip-restricted-logins",  $IPLogins) ;
   &PutXMLArrayData ($XMLSmhpd, "ip-restricted-include", @IPInclude) ;
   &PutXMLArrayData ($XMLSmhpd, "ip-restricted-exclude", @IPExclude) ;

   if (($key eq 'p') || ($key eq 'P')) {
      goto IPRESTRICTTOP ;
   }

   print "\n\n\n" ;
   print "   ===============================================================\n" ;
   print $lh->maketext("                    Thank you for choosing hp\n") ;
   print $lh->maketext("   You have successfully set up the System Management HomePage\n\n") ;
   print "   ===============================================================\n\n\n" ;
   print $lh->maketext("   You can run this script by executing: perl /usr/local/hp/hpSMHSetup.pl\n\n") ;
   system('/etc/init.d/hpsmhd restart');
}

sub SetIPAddressLogins {
   local ($key, *ipinclude, *ipexclude) = @_ ;

   print "-------------------------------------------------------------------------------\n" ;
   print $lh->maketext("Set IP Address Restrictions\n\n") ;

   do {

   &printIPRestriction ("Inclusion", @ipinclude) ;
   &printIPRestriction ("Exclusion", @ipexclude) ;

   print $lh->maketext('_LOGIN_RESTRICTION_INCLUDE_EXCLUDE') ;

   print "Please enter your selection: " ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2') && ($key ne 'n') && ($key ne 'N') && ($key ne 'p') && ($key ne 'P')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   if ($key == '1') {
      (*ipinclude) = &IPAddressInclude (\@ipinclude) ;
   }

   if ($key == '2') {
      (*ipexclude) = &IPAddressExclude (\@ipexclude) ;
   }

   print "\n" ;

   } until (($key eq 'n') || ($key eq 'N') || ($key eq 'p') || ($key eq 'P')) ;

   return ($key, \@ipinclude, \@ipexclude) ;

}

sub IPAddressInclude {
   local (*ipinclude) = @_ ;

   print "-------------------------------------------------------------------------------\n" ;
   print $lh->maketext("IP Addresses to Include\n\n") ;

   print $lh->maketext('_IP_ADDRESS_INCLUDE_INSTRUCTIONS') ;

   do {

   &printIPRestriction ($lh->maketext("Inclusion"), @ipinclude) ;

   print $lh->maketext('_ADD_DELETE_NEXT_OPTION') ;

   print $lh->maketext("Please enter your selection: ") ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2') && ($key != 'n')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   if ($key == '1') {
      (*ipinclude) = &AddLoginIPAddress ($lh->maketext("Inclusion"), \@ipinclude) ;
   }

   if ($key == '2') {
      (*ipinclude) = &DeleteLoginIPAddress ($lh->maketext("Inclusion"), \@ipinclude) ;
   }

   print "\n" ;

   } until $key eq 'n' ;

   $key = '0' ;

   return (\@ipinclude) ;

}

sub IPAddressExclude {
   local (*ipexclude) = @_ ;

   print "-------------------------------------------------------------------------------\n" ;
   print $lh->maketext("IP Addresses to Exclude\n\n") ;

   print $lh->maketext('_IP_ADDRES_EXCLUDE_INSTRUCTIONS') ;

   do {

   &printIPRestriction ($lh->maketext("Exclusion"), @ipexclude) ;

   print $lh->maketext('_ADD_DELETE_NEXT_OPTION') ;

   print $lh->maketext("Please enter your selection: ") ;

   system "stty", '-echo', '-icanon', 'eol', "\001" ;
   while ((($key = getc) != '1') && ($key != '2') && ($key != 'n')) { } ;
   system "stty", 'echo', 'icanon', 'eol', '^@';

   print "\n\n" ;

   if ($key == '1') {
      (*ipexclude) = &AddLoginIPAddress ($lh->maketext("Exclusion"), \@ipexclude) ;
   }

   if ($key == '2') {
      (*ipexclude) = &DeleteLoginIPAddress ($lh->maketext("Exclusion"), \@ipexclude) ;
   }

   print "\n" ;

   } until $key eq 'n' ;

   $key = '0' ;

   return (\@ipexclude) ;
}

sub printIPRestriction {
   my ($name, @IPEntries) = @_ ;
   my $count = 0 ;

   print "
   IP Address $name List
   -------------------------\n" ;
   if (scalar (@IPEntries) > 0) {
      foreach (@IPEntries) {
         $count++ ;
         print "   $count) $_\n" ;
      }
   } else {
      print $lh->maketext("   ***empty list***\n") ;
   }
   print "   -------------------------\n\n" ;

}

sub AddLoginIPAddress {
	local ($name, *ipArray) = @_ ;
	my $rawInput ;
	my @lowerLimit ;
	my @upperLimit ;
	my @ipRanges ;
	my @ipAddresses ;
	my $upperIPAddress ;
	my $lowerIPAddress ;
	my $badRange ;
	my $badInput ;
	my $validLimit ;
	my $result ;
	my $count ;
	my $rc ;

	do {

		&printIPRestriction ($name, @ipArray) ;

		print $lh->maketext('_VALID_IP_ADDRESS_INSTRUCTIONS') ;

		$rawInput = <STDIN> ;
		chomp ($rawInput) ;

		@ipRanges = split (/;/, $rawInput) ;
		
		$badRange = "false" ;
		$badInput = "false" ;
		foreach (@ipRanges) {
			push (@ipArray, $_) ;
			@ipAddresses = split (/-/, $_) ;
			if (scalar @ipAddresses > 2) {
				$badRange = "true" ;
				print $lh->maketext("\n   Invalid range: [_1] \n\n", @ipRanges) ;
			} else {
				$lowerIPAddress = @ipAddresses [0];
				$rc = &validNetwork ($lowerIPAddress);
				if ($rc ne "") {
					$badInput = "true" ;
					print $lh->maketext("\n   Invalid IP Address: [_1] - [_2]\n\n", $lowerIPAddress, $rc) ;
					pop (@ipArray) ;
				} else {
					@lowerLimit = split (/\./, $lowerIPAddress) ;
					if (scalar (@ipAddresses) > 1) {
						$upperIPAddress = @ipAddresses [1] ;
						if (rindex($upperIPAddress,":") eq "-1") {
							$rc = &validNetwork ($upperIPAddress) ;
							if ($rc ne "") {
								$badInput = "true" ;
								print $lh->maktext("\n   Invalid IP Address: [_1] - [_2]\n\n", $upperIPAddress, $rc) ;
								pop (@ipArray) ;
							} else {
								@upperLimit = split (/\./, $upperIPAddress) ;
								$validLimit = "false" ;

								$octet4 = @upperLimit [0] - @lowerLimit [0] ;
								$octet3 = @upperLimit [1] - @lowerLimit [1] ;
								$octet2 = @upperLimit [2] - @lowerLimit [2] ;
								$octet1 = @upperLimit [3] - @lowerLimit [3] ;

								if ($octet4 > 0) {
									$validLimit = "true" ;
								} elsif ($octet4 == 0) {
									if ($octet3 > 0) {
										$validLimit = "true" ;
									} elsif ($octet3 == 0) {
										if ($octet2 > 0) {
											$validLimit = "true" ;
										} elsif ($octet1 > 0) {
											$validLimit = "true" ;
										}
									}
								}

								if ($validLimit eq "false") {
									$badRange = "true" ;
									print $lh->maketext("\n   Invalid range: [_1] - [_2]\n\n", $lowerIPAddress, $upperIPAddress) ;
								}
							}
						} else {
							if (!($upperIPAddress =~ m/^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}/) &&
							    !($upperIPAddress =~ m/^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)/) &&
								!($upperIPAddress =~ m/^((?:[0-9A-Fa-f]{1,4}:){6,6})(25[0-5]|2[0-4]\d|[0-1]?\d?\d)(\.(25[0-5]|2[0-4]\d|[0-1]?\d?\d)){3}/) &&
								!($upperIPAddress =~ m/^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?) ::((?:[0-9A-Fa-f]{1,4}:)*)(25[0-5]|2[0-4]\d|[0-1]?\d?\d)(\.(25[0-5]|2[0-4]\d|[0-1]?\d?\d)){3}/) ) {
								print $lh->maketext("\n   Invalid IPv6 Address: [_1] \n\n", $upperIPAddress) ;
							}
						}
					}
				}
			}
			if ($badRange eq "true") {
				pop (@ipArray) ;
			}
		}

	} until $rawInput eq "" ;

	return (\@ipArray) ;

}

sub DeleteLoginIPAddress {
   local ($name, *ipArray) = @_ ;
   my $input ;
   my $count ;

   do {
   &printIPRestriction ($name, @ipArray) ;

   $count = scalar (@ipArray) ;

   print $lh->maketext('_ENTER_IP_NUMBER_TO_DELETE') ;

   $input = <STDIN> ;

   if (($input > '0') && ($input <= $count)) {
      splice (@ipArray, ($input - 1), 1) ;
   }

   } until $input == '0' ;

   return (\@ipArray) ;

}

# A sub-routine to verify that an IP address is valid
sub validIP {

    my $ip = shift || return;

	my $ip_test = new Net::IP ($ip) or die (return "INVALID_IP");

	if ($ip_test->version() == 4) {
		# Check for on-digit characters
		if ($ip =~ m/ /) {
			return("INVALID_IP_HASSPACES");
		} elsif ($ip =~ m/[^\d\.]/) {
			return("INVALID_IP_HASNONDIGITS");
		} elsif (!($ip =~ m/^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})$/) ) {
			return("INVALID_IP");
		} elsif ($1 > 255 || $2 > 255 || $3 > 255 || $4 > 255) {
			return("INVALID_IP_OUTOFRANGE");
		} elsif ($4 == 255) {
			return ("INVALID_IP_BROADCAST");
		} elsif ($1 == 127) {
			return ("INVALID_IP_LOOPBACK");
		} elsif ($1 == 255 && $2 == 255 && $3 == 255 && $4 == 255) {
			return ("INVALID_IP_BROADCAST");
		} elsif ($1 == 0) {
			return ("INVALID_IP");
		} elsif ($1 == 0 && $2 == 0 && $3 == 0 && $4 == 0) {
			return ("INVALID_IP");
		} elsif ($4 == 0) {
			return ("INVALID_IP");
		} elsif ($1 > 223) {
			return ("INVALID_IP_MULTICAST");
		} else {
			return("");
		}
	} elsif ($ip_test->version() == 6) {
		# Cool, It's a valid IPv6
	} else {
		return("");
	}	
}

# A sub-routine to verify that a Network is valid
sub validNetwork {

    my $network = shift || return;
	
	my $ip_test = new Net::IP ($network) or die (return "INVALID_NETWORK");

	if ($ip_test->version() == 4) {
		# Check for non-digit characters
		if ($network =~ m/ /) {
			return("INVALID_NETWORK_HASSPACES");
		} elsif ($network =~ m/[^\d\.]/) {
			return("INVALID_NETWORK_HASNONDIGITS");
		} elsif (!($network =~ m/^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})$/) ) {
			return("INVALID_NETWORK");
		} elsif ($1 > 255 || $2 > 255 || $3 > 255 || $4 > 255) {
			return("INVALID_NETWORK_OUTOFRANGE");
		} elsif ($1 == 0) {
			return("INVALID_NETWORK");
		} else {
			return("");
		}
	} elsif ($ip_test->version() == 6) {
		# Cool, It's a valid IPv6
	} else {
		return("");
	}

}

# A sub-routine to veify the binary sequence of the octets
sub validOctets {
   local (@octets) = @_ ;
   my $count, $octet, $bitmask, $rc = "" ;
   my @bitmasks = (0, 128, 192, 224, 240, 248, 252, 254, 255) ; 

   $count = 0 ;      
   foreach $octet (@octets) {
      $count++;
      $tmprc = "FAILED" ;
      foreach $bitmask (@bitmasks) {
         if ($bitmask == $octet) {
            $tmprc = "" ;
         }
      }

      if ($tmprc eq "FAILED") {
         $rc = "NETMASK FAILED" ;
      }
   }

   return ($rc) ;
}


# A sub-routine to verify that a Net Mask is valid
sub validNetMask {

    my $netmask = shift || return;
    my $goodform = $netmask =~ m/^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})/;
    my @octets ;

    push (@octets, $1, $2, $3, $4) ;

#    print STDERR "Netmask octets = $1 $2 $3 $4\nGoodForm = $goodform\n";

    # Check for non-digit characters
    if ($netmask =~ m/ /) {
        return("INVALID_NETMASK_HASSPACES");
    }
    elsif ($netmask =~ m/[^\d\.]/) {
        return("INVALID_NETMASK_HASNONDIGITS");
    }
    elsif (!$goodform) {
        return("INVALID_NETMASK");
    }
    elsif ($1 > 255 || $2 > 255 || $3 > 255 || $4 > 255) {
        return("INVALID_NETMASK_OUTOFRANGE");
    }
    elsif ($1 == 0) {
        return ("INVALID_NETMASK");
    }
    elsif ($1 < 255 && ($2 != 0 || $3 != 0 || $4 !=0)) {
        return ("INVALID_NETMASK_SECOND_OCTET");
    }
    elsif ($1 == 255 && $2 < 255 && ($3 != 0 || $4 != 0)) {
        return ("INVALID_NETMASK_THIRD_OCTET");
    }
    elsif ($1 == 255 && $2 == 255 && $3 < 255 && $4 !=0) {
        return ("INVALID_NETMASK_FOURTH_OCTET");
    }
    elsif (&validOctets (@octets) ne "") {
        return ("INVALID_NETMASK_OCTET_SEQUENCE");
    }
    else {
        return("");
    }
}

sub GetXMLArrayData {
   my ($file, $parseVariable) = @_ ;
   my @XMLData ;

   open XMLFILE, $file ;

   while (<XMLFILE>) {
      if ($_ =~ m/<$parseVariable>(.*)<\/$parseVariable>/) {
         @XMLData = split (/;/, $1) ;
      }
   }

   close XMLFILE ;

   return (@XMLData) ;

}

sub GetXMLData {
   my ($file, $parseVariable) = @_ ;
   my $XMLData ;

   open XMLFILE, $file ;

   while (<XMLFILE>) {
      if ($_ =~ m/<$parseVariable>(.*)<\/$parseVariable>/) {
         $XMLData = $1 ;
      }
   }

   close XMLFILE ;

   return ($XMLData) ;

}

sub GetINIData {
   my ($file, $parseVariable) = @_ ;
   my $INIData ;
   my $tag ;
   my $entry ;
   my $member ;

   $tag = lc $parseVariable ;

   open INIFILE, $file ;

   $INIData = "" ;
   while (<INIFILE>) {
      $entry = lc $_ ;
      $entry =~ s/
//g ; 
      if ($entry =~ m/$tag=(.*)/) {
         $member = $1 ;
         $member = ~s/
//g ;
         chomp ($member) ;
         $member =~ s/,/;/g ;
         $INIData = $member ;
      }
   }

   close INIFILE ;

   return ($INIData) ;

}

sub PutXMLArrayData {
   my ($file, $parseVariable, @Data) = @_ ;
   my @tempData ;

   my $enrtryData ;

   $entryData = join ';', @Data ;

   chomp $entryData ;

   open XMLFILE, "$file" ;

   while (<XMLFILE>) {
      if (($_ =~ m/<$parseVariable>/) || ($_ =~ m/<$parseVariable\/>/)) {
         push (@tempData, "<$parseVariable>$entryData<\/$parseVariable>\n") ;
      } else {
         push (@tempData, $_) ;
      }
   }

   close XMLFILE ;

   open XMLFILE, ">$file" ;

   foreach $tmp (@tempData) {
      print XMLFILE $tmp ;
   }

   close XMLFILE ;
}

sub PutXMLData {
   my ($file, $parseVariable, $Data) = @_ ;
   my $found ;
   my @tempData ;

   open XMLFILE, "$file" ;

   while (<XMLFILE>) {
      if (($_ =~ m/<$parseVariable>/) || ($_ =~ m/<$parseVariable\/>/)) {
         push (@tempData, "<$parseVariable>$Data<\/$parseVariable>\n") ;
      } else {
         push (@tempData, $_) ;
      }
   }

   close XMLFILE ;

   open XMLFILE, ">$file" ;

   foreach $tmp (@tempData) {
      print XMLFILE $tmp ;
   }

   close XMLFILE ;
}

sub addNetworkElement {
   local ($ipaddress, $netmask, *array) = @_ ;
   my $duplicate ;

   chomp ($element) ;

   $duplicate = "false" ;
   foreach (@array) {
      $_ =~ m/(.*)\/(.*)/ ;
      print "   IPaddress = $1\n" ;
      print "   Netmask   = $2\n" ;
      if ($ipaddress eq $1 && $netmask eq $2) {
         $duplicate = "true" ;
      }
   }

	if ($duplicate eq "false") {
		if ($netmask eq "") {
			push (@array, "$ipaddress") ;
		} else {
			push (@array, "$ipaddress/$netmask") ;
		}		
	}

   return (\@array) ;
}

# test if the given array have the element already
sub testArrayElement {
   local ($element, *array) = @_ ;
   my $duplicate ;

   chomp ($element) ;

   $duplicate = "false" ;
   foreach (@array) {
      if ($element eq $_) {
         $duplicate = "true" ;
      }
   }

   return ($duplicate);
}


sub addArrayElement {
   local ($element, *array) = @_ ;
   my $duplicate ;

   chomp ($element) ;

   $duplicate = "false" ;
   foreach (@array) {
      if ($element eq $_) {
         $duplicate = "true" ;
      }
   }

   if ($duplicate eq "false") {
      push (@array, $element) ;
   }

   return (\@array) ;
}

sub removeArrayElement {
   local ($element, *array) = @_ ;
   my $member, $index = 0 ;

   chomp ($element) ;

   foreach $member (@array) {
      if ($member eq $element) {
         splice (@array, $index, 1) ;
      }
      $index++ ;
   }

   return (\@array) ;
}
