Summary     	: OpenIPMI +HP
Name        	: hp-OpenIPMI
Version		:        8.5.0
Release		:        1.rhel5
Group       	: System Environment/Kernel
Source		: hp-OpenIPMI.tar.gz
License		: GNU Public License
Packager    	: Hewlett-Packard Company
Vendor		: Hewlett-Packard Company
URL         	: http://www.hp.com/go/proliantlinux
Buildroot   	: /var/tmp/%{name}
Icon		: hprpm.xpm
AutoReqProv	: no
PreReq		: /bin/sh, /bin/bash

%define kernel_compat 2.6

%if "%{_vendor}" == "redhat"
 %define rhel_version %(lsb_release -rs)
  %if "0%{?rhel_version}"
    %if "%{?rhel_version}" <= "3"
      %define kernel_compat 2.4
    %endif
    %if "%{?rhel_version}" >= "5"
      %define kernel_compat 2.6.18+
    %endif
  %endif
%endif

%if "%{kernel_compat}" == "2.4"
  %define ipmi_si_mod ipmi_si_drv
%else
  %define ipmi_si_mod ipmi_si
%endif
%define ipmi_modules ipmi_devintf %{ipmi_si_mod} ipmi_msghandler

%description
This is an upgraded version of the OpenIPMI device driver that is shipped as
part of the standard Linux kernel. This release is for Linux %{kernel_compat}
kernels. It provides support for PCI Based Base Management Controllers that
are truly interrupt driven. This package will NOT activate on its own. The
drivers for this release are placed in /opt/hp/hp-OpenIPMI/bin with a script
that can be used to launch the IPMI drivers.  The changes made to the IPMI
drivers are expected to be included in future Linux kernels.

The hp-OpenIPMI driver can be built for any kernel like any other GPL Open
Source application.
%if %{_vendor} == redhat
You need to install the appropriate kernel-devel package to make use of this.
%endif

# Multiline defines are supposedly supported by newer versions of RPM,
# but not on all currently supported distros (e.g. SLES9). Until we drop these
# older distros, this has to be done in one line:
%define unload_modules modprobe -qr %{ipmi_modules} || true; UNLOADABLE_MODS=$(lsmod | cut -d" " -f1 | grep ^ipmi_ | tr '\\n' ' '); if [ -n "$UNLOADABLE_MODS" ]; then printf "WARNING: Unable to unload existing OpenIPMI modules: $UNLOADABLE_MODS\\n" >&2; printf "These modules are likely still in use by a running application.\\n" >&2; printf "Please stop any such applications and manually unload the OpenIPMI\\n" >&2; printf "modules or reboot your system.\\n" >&2; fi

%prep
%setup -n %{name}

%build
EFS_VER=%{version}\-%{release}
PKG_VER=%{version}\-CUSTOM
echo "$PKG_VER" > PKG_VERSION
make -f hp-OpenIPMI.mk OS_MODEL=LINUX EFS_VER="$EFS_VER" all

%install
if [ $RPM_BUILD_ROOT != "/" ]; then
	rm -rf $RPM_BUILD_ROOT
fi

mkdir -p $RPM_BUILD_ROOT

export RPM_BUILD_ROOT
export RPM_MAKE_ROOT=.
export RPM_NAME=%{name}

make -f hp-OpenIPMI.mk install


%post
#
# Try to remove any previously loaded OpenIPMI stack.
#
%unload_modules

#
# Let's see if we need to rebuild
#

sh /opt/hp/hp-OpenIPMI/check_install_kernel.sh

#
# Display EULA for Source Modules
#
echo "Please read the Licence Agreement for this software at"
echo
echo "         /opt/hp/hp-OpenIPMI/COPYING"
echo "                       and"
echo "         /opt/hp/hp-OpenIPMI/hp-OpenIPMI.license"
echo
echo "By not removing this package, you are accepting the terms"
echo "of the included licenses."
echo ""
echo "The man page, hp-OpenIPMI(4), describes how to enable and use"
echo "the hp-OpenIPMI device drivers."
exit 0

%preun
# Remove any previously loaded OpenIPMI stack.
%unload_modules
exit 0

# Only do this on removal (not upgrade)
if [ $1 -eq 0 ]; then
	if [ -f /opt/hp/hp-OpenIPMI/Makefile ]; then
		make -s -C /opt/hp/hp-OpenIPMI clean
	fi
fi

exit 0

%postun
# Only do this on removal (not upgrade)
if [ $1 -eq 0 ]; then
	rm -rf /opt/hp/hp-OpenIPMI
	printf "The hp-OpenIPMI package has been removed from this system\n\n"
fi
exit 0

%clean
rm -fR $RPM_BUILD_ROOT

%files 
%defattr(755,root,root)
/opt/hp/hp-OpenIPMI
%defattr(644,root,root)
/usr/share/man/man4/hp-OpenIPMI.4.gz


%changelog
* Fri Dec 18 2009 HP Linux Development <Linux_SWdeliverables@external.groups.hp.com> 8.4.0
- 8.4.0 release (Severity: Medium)
- ENHANCEMENTS
- Rebuilt the driver against current distribution kernels
