/* Copyright (c) 2006  Hewlett-Packard Development Company, L.P.  */

/* 
 *
 * Copyright (c) 2005  I.D.E.A.L. Technology Corporation
 * Author: Anthony Awtrey <tony@idealcorp.com>
 *
 * Template driver used: Copyright (c) 1998  Metro Link Incorporated
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, cpy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
 * OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Except as contained in this notice, the name of the Metro Link shall not be
 * used in advertising or otherwise to promote the sale, use or other dealings
 * in this Software without prior written authorization from Metro Link.
 *
 */
/* $XFree86: $ */

#define _EVDEV_C_

#include <linux/input.h>
#include <time.h>
#include <misc.h>
#include <xf86.h>
#include <xisb.h>
#define NEED_XF86_TYPES
#include <xf86_ansic.h>
#include <xf86_OSproc.h>
#include <xf86Xinput.h>
#include <exevents.h>

#include "xf86Evdev.h"


InputDriverRec EVDEV = {
        1,
        "hpmouse",
        NULL,
        EvdevPreInit,
        /*EvdevUnInit*/NULL,
        NULL,
        0
};        


#ifdef XFree86LOADER

static XF86ModuleVersionInfo VersionRec =
{
	"hpmouse",
	MODULEVENDORSTRING,
	MODINFOSTRING1,
	MODINFOSTRING2,
	XF86_VERSION_CURRENT,
	1, 0, 0,
	ABI_CLASS_XINPUT,
	ABI_XINPUT_VERSION,
	MOD_CLASS_XINPUT,
	{0, 0, 0, 0}		/* signature, to be patched into the file by a tool */
};


static const char *reqSymbols[] = {
	"AddEnabledDevice",
	"ErrorF",
	"InitButtonClassDeviceStruct",
	"InitProximityClassDeviceStruct",
	"InitValuatorAxisStruct",
	"InitValuatorClassDeviceStruct",
	"InitPtrFeedbackClassDeviceStruct",
	"RemoveEnabledDevice",
	"Xcalloc",
	"Xfree",
	"screenInfo",
	"xf86AddInputDriver",
	"xf86AllocateInput",
	"xf86CloseSerial",
	"xf86CollectInputOptions",
	"xf86ErrorFVerb",
	"xf86FindOptionValue",
	"xf86GetMotionEvents",
	"xf86GetVerbosity",
	"xf86MotionHistoryAllocate",
	"xf86NameCmp",
	"xf86OpenSerial",
	"xf86OptionListCreate",
	"xf86OptionListMerge",
	"xf86OptionListReport",
	"xf86PostButtonEvent",
	"xf86PostMotionEvent",
	"xf86PostProximityEvent",
	"xf86ProcessCommonOptions",
	"xf86ScaleAxis",
	"xf86SetIntOption",
	"xf86SetStrOption",
	"xf86XInputSetScreen",
	"xf86XInputSetSendCoreEvents",
	NULL
};


static pointer
EvdevSetupProc(	pointer module,
			pointer options,
			int *errmaj,
			int *errmin )
{
	xf86LoaderReqSymLists(reqSymbols, NULL);
	xf86AddInputDriver(&EVDEV, module, 0);
	return (pointer) 1;
}

XF86ModuleData hpmouseModuleData = { &VersionRec, EvdevSetupProc, NULL };


#endif /* XFree86LOADER */


/* 
 * Be sure to set vmin appropriately for your device's protocol. You want to
 * read a full packet before returning
 */
static const char *default_options[] =
{
	/*	"Device", "/dev/ttyS1",*/
	"BaudRate", "2400",
	"StopBits", "1",
	"DataBits", "8",
	"Parity", "None",
	"Vmin", "3",
	"Vtime", "1",
	"FlowControl", "None",
	NULL,
};


/*****************************************************************************
 *	Function Definitions
 ****************************************************************************/



static InputInfoPtr
EvdevPreInit(InputDriverPtr drv, IDevPtr dev, int flags)
{              
	InputInfoPtr pInfo;
   	EvdevPrivatePtr priv = xcalloc (1, sizeof (EvdevPrivateRec));
	char *s;
	char *dname;

	if (!priv)
		return NULL;

	if (!(pInfo = xf86AllocateInput(drv, 0))) {
		xfree(priv);
		return NULL;
	}
  
	priv->min_x = 0;
	priv->max_x = 3000; /* Should be determined programatically somehow */
	priv->min_y = 0;
	priv->max_y = 3000; /* Should be determined programatically somehow */
	priv->screen_num = 0;
	priv->screen_width = -1;
	priv->screen_height = -1;
	priv->swap_xy = 0;
	priv->button_number = 3;

	pInfo->type_name = XI_MOUSE; /* Should be determined programatically somehow */
	pInfo->device_control = DeviceControl;
	pInfo->read_input = ReadInput;
	pInfo->control_proc = ControlProc;
	pInfo->close_proc = CloseProc;
	pInfo->switch_mode = SwitchMode;
	pInfo->conversion_proc = ConvertProc;
	pInfo->dev = NULL;
	pInfo->private = priv;
	pInfo->private_flags = 0;
	pInfo->flags = XI86_POINTER_CAPABLE | XI86_SEND_DRAG_EVENTS;
	pInfo->conf_idev = dev;

	xf86CollectInputOptions(pInfo, default_options, NULL);

	xf86OptionListReport( pInfo->options );

	dname = xf86SetStrOption(pInfo->options, "Device", 0);
        priv->dev_name= xf86strdup(dname);
	priv->helper = xf86SetStrOption( pInfo->options, "Helper", 0);
	priv->min_x = xf86SetIntOption( pInfo->options, "MinX", 0 );
	priv->max_x = xf86SetIntOption( pInfo->options, "MaxX", priv->max_x ); /* should be determined programatically */
	priv->min_y = xf86SetIntOption( pInfo->options, "MinY", 0 );
	priv->max_y = xf86SetIntOption( pInfo->options, "MaxY", priv->max_y ); /* should be determined programatically */
	priv->screen_num = xf86SetIntOption( pInfo->options, "ScreenNumber", 0 );
	priv->button_number = xf86SetIntOption( pInfo->options, "ButtonNumber", 3 );
	priv->swap_xy = xf86SetIntOption( pInfo->options, "SwapXY", 0 );
	priv->buffer = NULL;
	s = xf86FindOptionValue (pInfo->options, "ReportingMode");
	if ((s) && (xf86NameCmp (s, "raw") == 0))
		priv->reporting_mode = TS_Raw;
	else
		priv->reporting_mode = TS_Scaled;

	/* this results in an xstrdup that must be freed later */
	pInfo->name = xf86SetStrOption( pInfo->options, "DeviceName", "hpmouse");
	xf86ProcessCommonOptions(pInfo, pInfo->options);

	pInfo->flags |= XI86_CONFIGURED;
	return (pInfo);
}

static Bool
DeviceControl (DeviceIntPtr dev, int mode)
{
	InputInfoPtr pInfo = dev->public.devicePrivate;
	EvdevPrivatePtr priv = (EvdevPrivatePtr) (pInfo->private);
	unsigned char map[] =
	{0, 1, 2, 3};

	switch (mode)
	{
	case DEVICE_INIT:
		/*
		 * these have to be here instead of in the SetupProc, because when the
		 * SetupProc is run at server startup, screenInfo is not setup yet
		 */
		priv->screen_width = screenInfo.screens[priv->screen_num]->width;
		priv->screen_height = screenInfo.screens[priv->screen_num]->height;
		
		/*
		 * Device reports button press for 1 button.
		 */
		if (InitButtonClassDeviceStruct (dev, 3, map) == FALSE)
			{
				ErrorF ("Unable to allocate Evdev ButtonClassDeviceStruct\n");
				return !Success;
			}
		
		/*
		 * Device reports motions on 2 axes in absolute coordinates.
		 * Axes min and max values are reported in raw coordinates.
		 */
		if (InitValuatorClassDeviceStruct (dev, 2, xf86GetMotionEvents,
						   pInfo->history_size, Absolute) == FALSE)
			{
				ErrorF ("Unable to allocate Evdev ValuatorClassDeviceStruct\n");
				return !Success;
			}
		else
			{
				InitValuatorAxisStruct (dev, 0, priv->min_x, priv->max_x,
							9500,
							0 /* min_res */ ,
							9500 /* max_res */ );
				InitValuatorAxisStruct (dev, 1, priv->min_y, priv->max_y,
							10500,
							0 /* min_res */ ,
							10500 /* max_res */ );
			}
		
		if (InitProximityClassDeviceStruct (dev) == FALSE)
			{
				ErrorF ("unable to allocate Evdev ProximityClassDeviceStruct\n");
				return !Success;
			}
		
		if (InitPtrFeedbackClassDeviceStruct(dev, EvdevPtrCtrl) == FALSE)
			{
				ErrorF ("unable to allocate Evdev PtrFeedbackClassDeviceStruct\n");
				return !Success;
			}
		
		/* 
		 * Allocate the motion events buffer.
		 */
		xf86MotionHistoryAllocate (pInfo);
		return (Success);
		
	case DEVICE_ON:
        {
           int rc = 0;

           /* Start the Helper */
           if (priv->helper) 
           {
              xf86Msg(X_INFO, "%s: spawning %s %s %s \n", pInfo->name, priv->helper, "-p", priv->dev_name);
              rc = execl(priv->helper, priv->helper, "-p", priv->dev_name, (char*)NULL);
           }

           if(rc == 0)
           {
              pInfo->fd = xf86OpenSerial(pInfo->options);
              if (pInfo->fd == -1)
              {
                 xf86Msg(X_WARNING, "%s: cannot open input device\n", pInfo->name);
                 return (!Success);
              }
		
              xf86AddEnabledDevice(pInfo);
              dev->public.on = TRUE;
              return (Success);
           }
           return (!Success);
        }
	case DEVICE_OFF:
	case DEVICE_CLOSE:
        {
           if (pInfo->fd != -1)
           { 
              xf86RemoveEnabledDevice(pInfo);
              xf86CloseSerial(pInfo->fd);
           }
           pInfo->fd = -1;
           dev->public.on = FALSE;
           if (priv->helper) 
           {
              xf86Msg(X_INFO, "%s: spawning %s %s\n", pInfo->name, priv->helper, "-d");
              execl(priv->helper, priv->helper, "-d", (char*)NULL);
           }
           return (Success);
        }
	default:
		return (BadValue);
	}

}


/* 
 * The ReadInput function will have to be tailored to your device
 */
static void
ReadInput (InputInfoPtr pInfo)
{
	EvdevPrivatePtr priv = (EvdevPrivatePtr) (pInfo->private);
	int x,y;

	while ( xf86ReadSerial(pInfo->fd, priv->packet, sizeof(struct input_event)) >= 0 )
	{

		xf86memcpy(&priv->evdev, priv->packet, sizeof(struct input_event));

		/*
		 * If we get to this point, we have a structure called priv->evdev that
		 * contains the timestamp, type, code and value of a specific evdev event.
		 * This structure is the 'input_event' structure defined in input.h.
		 * This driver was created to provide support for an otherwise unsupported
		 * touchscreen, so you will see 'touchscreen-isms' in this code.
		 * If you want to add handlers for other event stream data, just use the
		 * evtest program to interrogate the device you are interested in and drop
		 * in the code to check for them.
		 */

		 /* If we have x/y absolute positional data, update current position */
		if ( priv->evdev.type == 3 )
		{
			if ( priv->evdev.code == 0 ) { priv->cur_x = priv->evdev.value; }
			if ( priv->evdev.code == 1 ) { priv->cur_y = priv->evdev.value; }
		}

		if (priv->swap_xy)
		{
			y = priv->cur_x;
			x = priv->cur_y;
		} else {
			x = priv->cur_x;
			y = priv->cur_y;
		}
			    
		if (priv->reporting_mode == TS_Scaled)
		{	
			x = xf86ScaleAxis (x, 0, priv->screen_width, priv->min_x, priv->max_x);
			y = xf86ScaleAxis (y, 0, priv->screen_height, priv->min_y, priv->max_y);
		}        		

		xf86XInputSetScreen (pInfo, priv->screen_num, x, y);

		/*
		 * Send events.
		 *
		 * We *must* generate a motion before a button change if pointer
		 * location has changed as DIX assumes this. This is why we always
		 * emit a motion, regardless of the kind of packet processed.
		 */

		xf86PostMotionEvent (pInfo->dev, TRUE, 0, 2, x, y);

		/*
		 * Emit a button press or release.
		 */
		if ((priv->evdev.type == 1) && (priv->evdev.code == 272)) /* 272 is left mouse button */
		{
			if (priv->evdev.value == 1)
			{
				xf86PostButtonEvent (pInfo->dev, TRUE, 1, 1, 0, 2, x, y); /* down */
			}
			if (priv->evdev.value == 0)
			{
				xf86PostButtonEvent (pInfo->dev, TRUE, 1, 0, 0, 2, x, y); /* up */
			}
		}
		if ((priv->evdev.type == 1) && (priv->evdev.code == 273)) /* 273 is right mouse button */
		{
			if (priv->evdev.value == 1)
			{
				xf86PostButtonEvent (pInfo->dev, TRUE, 3, 1, 0, 2, x, y); /* down */
			}
			if (priv->evdev.value == 0)
			{
				xf86PostButtonEvent (pInfo->dev, TRUE, 3, 0, 0, 2, x, y); /* up */
			}
		}
	}
}

/* 
 * The ControlProc function may need to be tailored for your device
 */
static int
ControlProc (InputInfoPtr pInfo, xDeviceCtl * control)
{
	xDeviceTSCalibrationCtl *c = (xDeviceTSCalibrationCtl *) control;
	EvdevPrivatePtr priv = (EvdevPrivatePtr) (pInfo->private);

        priv->min_x = c->min_x;
        priv->max_x = c->max_x;
        priv->min_y = c->min_y;
        priv->max_y = c->max_y;
 
	return (Success);
}

/* 
 * the CloseProc should not need to be tailored to your device
 */
static void
CloseProc (InputInfoPtr pInfo)
{

}

/* 
 * The SwitchMode function may need to be tailored for your device
 */
static int
SwitchMode (ClientPtr client, DeviceIntPtr dev, int mode)
{
	InputInfoPtr pInfo = dev->public.devicePrivate;
        EvdevPrivatePtr priv = (EvdevPrivatePtr) (pInfo->private);


	if ((mode == TS_Raw) || (mode == TS_Scaled))
        {
                priv->reporting_mode = mode;
                return (Success);
        }
        else if ((mode == SendCoreEvents) || (mode == DontSendCoreEvents))
        {
                xf86XInputSetSendCoreEvents (pInfo, (mode == SendCoreEvents));
                return (Success);
        }
        else
                return (!Success);   
}

/* 
 * The ConvertProc function may need to be tailored for your device.
 * This function converts the device's valuator outputs to x and y coordinates
 * to simulate mouse events.
 */
static Bool
ConvertProc (InputInfoPtr pInfo,
			 int first,
			 int num,
			 int v0,
			 int v1,
			 int v2,
			 int v3,
			 int v4,
			 int v5,
			 int *x,
			 int *y)
{
	EvdevPrivatePtr priv = (EvdevPrivatePtr) (pInfo->private);

	if (priv->reporting_mode == TS_Raw)
	{
                *x = xf86ScaleAxis (v0, 0, priv->screen_width, priv->min_x, priv->max_x);
                *y = xf86ScaleAxis (v1, 0, priv->screen_height, priv->min_y, priv->max_y);
        }
        else
        {
                *x = v0;
                *y = v1;
	}
	return (TRUE);
}

static void
EvdevPtrCtrl(DeviceIntPtr device, PtrCtrl *ctrl)
{
  /*
   * This empty function stops the X server segfaulting in ProcGetPointerMapping()
   */
}

