<?php

function addLanguage($app_path) {
    global $LANG_APP;
    // --- LANGUAGE DEFINITION BLOCK -- //
    $languages = $_SERVER["HTTP_ACCEPT_LANGUAGE"];
    $languages_array = explode(";", $languages);
    $primary_languages = explode(",", $languages_array[0]);
    
    $primary_language = "en";
    for ($i=0; $i<count($primary_languages); $i++) {
        // by default use only the main language (eg: en-bt and en-us are both en)
        $primary_languages[$i] = substr($primary_languages[$i], 0, 2);
        // test if the language pack exists
		if (file_exists($app_path."/lang/".$primary_languages[$i]."/language.php")) {
            $primary_language = $primary_languages[$i];
            break;
        }
    }
    if (!file_exists($app_path."/lang/".$primary_language."/language.php")) {
        echo "<font color='red'><strong>ERROR: The webapp path '$app_path' for the language packs is invalid</strong></font><br>";
    } else {
        include_once($app_path."/lang/".$primary_language."/language.php");
        // output the character encoding (this means this file should be always included inside html header)
        if (!$ENCODING) {
            $ENCODING = "iso-8859-1";
        }
        echo '<meta http-equiv="content-type" content="text/html; charset='.$ENCODING.'" />';
    }
}

$APP_PATH = strip_tags($APP_PATH);
addLanguage($APP_PATH);    
    
?>
