firewall {
    all-ping enable
    broadcast-ping disable
    ipv6-receive-redirects disable
    ipv6-src-route disable
    ip-src-route disable
    log-martians enable
    name ETH1_IN {
        default-action drop
        description ""
        rule 1 {
            action accept
            description ICMP
            log disable
            protocol icmp
        }
        rule 2 {
            action accept
            description "Allow established/related"
            log disable
            protocol all
            state {
                established enable
                invalid disable
                new disable
                related enable
            }
        }
        rule 3 {
            action drop
            description "Drop invalid state"
            log disable
            protocol all
            state {
                established disable
                invalid enable
                new disable
                related disable
            }
        }
    }
    name ETH1_Local {
        default-action drop
        description ""
        rule 1 {
            action accept
            description ICMP
            log disable
            protocol icmp
        }
        rule 2 {
            action accept
            description "Allow established/related"
            log disable
            protocol all
            state {
                established enable
                invalid disable
                new disable
                related enable
            }
        }
        rule 3 {
            action drop
            description "Drop invalid state"
            log disable
            protocol all
            state {
                established disable
                invalid enable
                new disable
                related disable
            }
        }
        rule 4 {
            action drop
            description Drop_Traffic
            log disable
            protocol all
        }
    }
    name WAN_IN {
        default-action drop
        description "WAN to internal"
        rule 3 {
            action accept
            description "Allow established/related"
            log disable
            state {
                established enable
                related enable
            }
        }
        rule 4 {
            action drop
            description "Drop invalid state"
            state {
                invalid enable
            }
        }
    }
    name WAN_LOCAL {
        default-action drop
        description "WAN to router"
        rule 10 {
            action accept
            description Permit_SSH
            destination {
                port 22
            }
            log disable
            protocol tcp
        }
        rule 20 {
            action accept
            description VPN_In
            destination {
                address 10.10.127.0/24
            }
            ipsec {
                match-ipsec
            }
            log disable
            protocol all
            source {
                address 10.0.100.0/24
            }
        }
        rule 30 {
            action accept
            description VPN_In
            destination {
                address 10.10.127.0/24
            }
            ipsec {
                match-ipsec
            }
            log disable
            protocol all
            source {
                address 10.254.0.0/16
            }
        }
        rule 40 {
            action accept
            description "Allow established/related"
            state {
                established enable
                related enable
            }
        }
        rule 50 {
            action drop
            description "Drop invalid state"
            log enable
            state {
                invalid enable
            }
        }
        rule 60 {
            action drop
            description Drop_Traffic
            log disable
            protocol all
        }
    }
    options {
        mss-clamp {
            interface-type all
            mss 1380
        }
    }
    receive-redirects disable
    send-redirects enable
    source-validation disable
    syn-cookies enable
}
interfaces {
    ethernet eth0 {
        address dhcp
        description Internet
        duplex auto
        firewall {
            in {
                name WAN_IN
            }
            local {
                name WAN_LOCAL
            }
        }
        poe {
            output off
        }
        speed auto
    }
    ethernet eth1 {
        address 207.195.100.239/24
        description "Citrix Connection"
        duplex auto
        firewall {
            in {
                name ETH1_IN
            }
            local {
                name ETH1_Local
            }
        }
        poe {
            output off
        }
        speed auto
    }
    ethernet eth2 {
        address 10.10.127.1/24
        description "Local 2"
        duplex auto
        mtu 1500
        speed auto
        vif 2 {
            address 192.168.254.1/24
            description "Guest Network"
            mtu 1500
        }
    }
    loopback lo {
    }
}
port-forward {
    auto-firewall enable
    hairpin-nat enable
    lan-interface eth2
    lan-interface eth2.2
    rule 1 {
        description platforms
        forward-to {
            address 10.10.127.160
            port 5011
        }
        original-port 5011
        protocol tcp_udp
    }
    rule 2 {
        description platform
        forward-to {
            address 10.10.127.160
            port 3011
        }
        original-port 3011
        protocol tcp_udp
    }
    rule 3 {
        description foxs
        forward-to {
            address 10.10.127.160
            port 4911
        }
        original-port 4911
        protocol tcp_udp
    }
    rule 4 {
        description fox
        forward-to {
            address 10.10.127.160
            port 1911
        }
        original-port 1911
        protocol tcp_udp
    }
    rule 5 {
        description https
        forward-to {
            address 10.10.127.160
            port 443
        }
        original-port 443
        protocol tcp_udp
    }
    rule 6 {
        description foxs2
        forward-to {
            address 10.10.127.160
            port 4912
        }
        original-port 4912
        protocol tcp_udp
    }
    wan-interface eth0
}
protocols {
    static {
        route 0.0.0.0/0 {
            next-hop 64.251.67.181 {
            }
            next-hop 108.172.159.125 {
                disable
            }
        }
        route 10.0.100.69/32 {
            blackhole {
                distance 1
            }
        }
        route 10.0.100.70/32 {
            blackhole {
                distance 1
            }
        }
        route 10.0.100.71/32 {
            blackhole {
                distance 1
            }
        }
    }
}
service {
    dhcp-server {
        disabled false
        hostfile-update disable
        shared-network-name Guest_Wifi {
            authoritative disable
            subnet 192.168.1.0/24 {
                default-router 192.168.1.1
                dns-server 192.168.1.1
                domain-name guest.wifi
                lease 86400
                start 192.168.1.10 {
                    stop 192.168.1.250
                }
            }
        }
        shared-network-name Kelowna {
            authoritative disable
            subnet 10.10.127.0/24 {
                default-router 10.10.127.1
                dns-server 10.10.127.1
                lease 86400
                start 10.10.127.50 {
                    stop 10.10.127.250
                }
                static-mapping XRX5A458C {
                    ip-address 10.10.127.60
                    mac-address 64:6e:69:5a:45:8c
                }
                static-mapping XRX5069D0 {
                    ip-address 10.10.127.59
                    mac-address 9c:93:4e:50:69:d0
                }
                tftp-server-name 10.0.100.187
                unifi-controller 204.11.51.229
            }
        }
        static-arp disable
        use-dnsmasq disable
    }
    dns {
        dynamic {
            interface eth0 {
                service dyndns {
                    host-name westkelfw02.dyndns.org
                    login ksptechnology
                    password H3!p2020!
                    protocol dyndns1
                }
                web dyndns
            }
        }
        forwarding {
            cache-size 150
            listen-on eth2
            listen-on eth2.2
        }
    }
    gui {
        http-port 80
        https-port 443
        older-ciphers enable
    }
    nat {
        rule 5001 {
            description "masquerade for WAN"
            log disable
            outbound-interface eth0
            protocol all
            type masquerade
        }
        rule 5002 {
            description ETH_1
            log disable
            outbound-interface eth1
            protocol all
            type masquerade
        }
    }
    snmp {
        community kspro {
            authorization ro
        }
        contact "Kevin Pare"
        location Regina
    }
    ssh {
        port 22
        protocol-version v2
    }
    unms {
        connection wss://unms.ksphosting.com:443+qWP9WGkOhOAIuDMso5Jts_wA-1Jb_OefT38cj9__1h8AAAAA+allowSelfSignedCertificate
    }
}
system {
    analytics-handler {
        send-analytics-report true
    }
    crash-handler {
        send-crash-report true
    }
    domain-name internal.yourdomain.com
    host-name WESTKELFW03
    login {
        user parek {
            authentication {
                encrypted-password $6$6HtbOH6kLcu$DnCM/cqZGrunG080kJwS3WbzKNIxdxXm1OakUNcbfl3EJAQwvjGoLat/pfuj/qqGhuJQmsrFSdYLcZOabOSTx0
                plaintext-password ""
            }
            full-name parek
            level admin
        }
    }
    name-server 8.8.8.8
    name-server 8.8.4.4
    ntp {
        server 0.ubnt.pool.ntp.org {
        }
        server 1.ubnt.pool.ntp.org {
        }
        server 2.ubnt.pool.ntp.org {
        }
        server 3.ubnt.pool.ntp.org {
        }
    }
    syslog {
        global {
            facility all {
                level notice
            }
            facility protocols {
                level debug
            }
        }
    }
    task-scheduler {
        task SNMP_RESTART {
            crontab-spec "00 04 * * *"
            executable {
                arguments restart
                path /etc/init.d/snmpd
            }
        }
        task fixVPN {
            executable {
                path /config/scripts/fix_vpn.sh
            }
            interval 20m
        }
    }
    time-zone America/Regina
    traffic-analysis {
        dpi disable
        export disable
    }
}
traffic-control {
}
vpn {
    ipsec {
        allow-access-to-local-interface disable
        auto-firewall-nat-exclude enable
        esp-group FOO0 {
            compression disable
            lifetime 3600
            mode tunnel
            pfs enable
            proposal 1 {
                encryption aes256
                hash sha1
            }
        }
        ike-group FOO0 {
            ikev2-reauth no
            key-exchange ikev1
            lifetime 28800
            proposal 1 {
                dh-group 2
                encryption aes256
                hash sha1
            }
        }
        site-to-site {
            peer 64.203.75.8 {
                authentication {
                    mode pre-shared-secret
                    pre-shared-secret West3Kelowna2018
                }
                connection-type initiate
                description KSP_1_VPN
                ike-group FOO0
                ikev2-reauth inherit
                local-address any
                tunnel 1 {
                    allow-nat-networks disable
                    allow-public-networks disable
                    esp-group FOO0
                    local {
                        prefix 10.10.127.0/24
                    }
                    remote {
                        prefix 10.0.100.0/24
                    }
                }
                tunnel 2 {
                    allow-nat-networks disable
                    allow-public-networks disable
                    esp-group FOO0
                    local {
                        prefix 10.10.127.0/24
                    }
                    remote {
                        prefix 10.254.0.94/32
                    }
                }
                tunnel 3 {
                    allow-nat-networks disable
                    allow-public-networks disable
                    esp-group FOO0
                    local {
                        prefix 10.10.127.0/24
                    }
                    remote {
                        prefix 10.254.0.95/32
                    }
                }
            }
            peer 69.11.97.43 {
                authentication {
                    id 162.156.6.215
                    mode pre-shared-secret
                }
                connection-type initiate
                ikev2-reauth inherit
            }
        }
    }
}


/* Warning: Do not remove the following line. */
/* === vyatta-config-version: "config-management@1:conntrack@1:cron@1:dhcp-relay@1:dhcp-server@4:firewall@5:ipsec@5:nat@3:qos@1:quagga@2:suspend@1:system@5:ubnt-l2tp@1:ubnt-pptp@1:ubnt-udapi-server@1:ubnt-unms@2:ubnt-util@1:vrrp@1:vyatta-netflow@1:webgui@1:webproxy@1:zone-policy@1" === */
/* Release version: v2.0.9-hotfix.2.5402463.210511.1317 */

