#!/bin/vbash

# Script should be stored in /config/scripts
# Script needs to be executable:
## chmod +x /config/scripts/fix_vpn.sh
# Script nees to be added to Cron (Run in configure mode):
## set system task-scheduler task fixVPN executable path /config/scripts/fix_vpn.sh
## set system task-scheduler task fixVPN interval 1m

# /opt/vyatta/bin/vyatta-op-cmd-wrapper is the wrapper for running operational mode commands from Bash
# /opt/vyatta/sbin/vyatta-cfg-cmd-wrapper is the wrapper for running configuration mode commands from Bash

# Ping returns 0 on any success, and some other error codes on failures
# Any success in '-c #' pings triggers the update of the VPN tunnel
ping -c 10 10.0.100.19 > /dev/null 2>&1
if [[ $? -eq 0 ]]
then
    echo "$(date +'%h %e %T')" `hostname` "/config/scripts/fix_vpn.sh --- Ping Success" >> /var/log/messages
else
    echo "$(date +'%h %e %T')" `hostname` "/config/scripts/fix_vpn.sh --- Ping Fail" >> /var/log/messages
    my_ip=$(curl ifconfig.me) > /dev/null 2>&1
    echo "$(date +'%h %e %T')" `hostname` "/config/scripts/fix_vpn.sh --- Public IP is " $my_ip "."  >> /var/log/messages
    echo "$(date +'%h %e %T')" `hostname` "/config/scripts/fix_vpn.sh --- Now updating VPN config & Resetting tunnels"  >> /var/log/messages
    /opt/vyatta/sbin/vyatta-cfg-cmd-wrapper begin
    /opt/vyatta/sbin/vyatta-cfg-cmd-wrapper set vpn ipsec site-to-site peer 69.11.97.43 authentication id "$my_ip"
    /opt/vyatta/sbin/vyatta-cfg-cmd-wrapper commit
    /opt/vyatta/sbin/vyatta-cfg-cmd-wrapper save
    /opt/vyatta/bin/vyatta-op-cmd-wrapper clear vpn ipsec-peer 69.11.97.43
fi

exit 0
# Note the empty line below
