#!/bin/sh

baseDir=`dirname $0`

# Change to the directory where this script is located, which should be
# the <repository root>\<product> directory
cd $baseDir

# List all sub-directories in the current directory.  They should all
# be <package groups> (e.g. platform, 3rdparty, etc..)
list=`ls`
rm -f info.txt
for entry in $list ; do
    if [ -d $entry ]; then
        if [ "$entry" = "POOL" ]; then
            echo Skipping $entry
        elif [ "$entry" = "pool" ]; then
            echo Skipping $entry
        else
            echo $entry >> info.txt
        fi
    fi
done

echo Generated info.txt with content: `cat info.txt`
