#!/bin/sh

# Remove the release directory chosen by the user.
# This script must be stored in all <repository root>\<product>\<package group> 
# directories.  It finds and displays the list of release directories in this
# directory and enables the user to select the desired release directory to be removed.
# NOTE: grep and awk must be installed as this script utilizes them

baseDir=`dirname $0`
baseName=`basename $0`
selectedRelDir=$1
listOptions=1

# return values from boolean functions
# ( 0/"success" is interpreted as "true" in scripts )
TRUE=0
FALSE=1

isValidRelDir()
{
    if [ ! -z "$1" ] && \
       [ -d "$1" ] && \
       [ "$1" != "current" ] && \
       [ -f "$1/release.txt" ] && \
       [ -f "$1/release.sig" ] && \
       [ -f "$1/mars/packages.txt" ] && \
       [ -f "$1/mars/packages.txt" ]; then 
        return $TRUE
    fi
    return $FALSE
}

isCurrentRel()
{
    if isValidRelDir $1 && \
       [ -f "current/release.txt" ]; then 
        givenrel=`cat $1/release.txt`
        currel=`cat current/release.txt`
        if [ "$givenrel" = "$currel" ]; then
            return $TRUE
        fi
    fi
    return $FALSE
}

# return the list of release dirs in the current dir
getRelDirList()
{
    dirList=""
    for entry in `ls` ; do
        if isValidRelDir "$entry" ; then
           dirList="$dirList $entry"
        fi
    done
    echo $dirList
}

# Change to the directory where this script is located, which should be
# the <repository root>\<product>\<package group> directory
cd "$baseDir"

if [ ! -z "$selectedRelDir" ]; then
    if isValidRelDir "$selectedRelDir" ; then
        if ! isCurrentRel "$selectedRelDir" ; then
            for entry in `getRelDirList` ; do
                echo getRelDirLst entry=$entry
                if [ "$entry" != "$selectedRelDir" ]; then
                    pkgKeepLst_mars="$pkgKeepLst_mars `cat $entry/mars/packages.txt | grep Filename: | awk '{print $2}'`"
                    pkgKeepLst_saturn="$pkgKeepLst_saturn `cat $entry/saturn/packages.txt | grep Filename: | awk '{print $2}'`"
                    pkgKeepLst_qinghe="$pkgKeepLst_qinghe `cat $entry/qinghe/packages.txt | grep Filename: | awk '{print $2}'`"
                    pkgKeepLst_quicksilver="$pkgKeepLst_quicksilver `cat $entry/mars/packages.txt | grep Filename: | awk '{print $2}'`"
                fi
            done

            # make a list of packages in the other releases
            pkgKeepLst="$pkgKeepLst_mars $pkgKeepLst_saturn $pkgKeepLst_qinghe $pkgKeepLst_quicksilver"

            for pkg in `cat $selectedRelDir/saturn/packages.txt | grep Filename: | awk '{print $2}'` ; do
                echo $pkgKeepLst | grep -w $pkg > /dev/null
                if [ $? -ne 0 ]; then
                    rm -rf ../pool/$pkg
                    echo Removed $pkg
                else
                    echo skip $pkg
                fi
            done
            rm -rf $selectedRelDir
            echo "Release $selectedRelDir removed from repository."
            exit 0
        fi
    else
        echo
        echo "ERROR: Release $selectedRelDir is not a valid option.  Try again."
        echo
    fi
fi

if [ "$listOptions" -eq 1 ]; then
    # List all of the release directories in the current directory.
    echo
    echo "Removable Release Options:"
    for entry in `getRelDirList` ; do
        if isCurrentRel "$entry" ; then
            curRel=$entry
        else
            echo "  $entry"
            expRelDir=$entry
        fi
    done

    if [ -z "$expRelDir" ]; then
        echo "  No removable releases options found"
        if [ -z "$curRel" ]; then
            echo
            exit 1
        fi
    fi

    if [ ! -z "$curRel" ]; then
        echo
        echo "Release $curRel is set as the current release, so it is currently not a valid option for removal."
        if [ -z "$expRelDir" ]; then
            echo
            exit 1
        fi
    fi

    echo
    echo "To remove a release from this repository, re-run $baseName with desired Release Options above."
    echo "  Example: $0 $expRelDir"
    echo
fi
