@echo off
rem Make the 'current' directory equivalent to the release directory chosen
rem by the user.
rem This script must be stored in all <repository root>\<product>\<package group>
rem directories.  It finds and displays the list of release directories in this
rem directory and enables the user to select the desired release directory as the
rem current release.

setlocal EnableDelayedExpansion

set origDir=%CD%
set baseDir=%~dp0%
set cancelKey=C

rem Change to the directory where this script is located, which should be
rem the <repository root>\<product>\<package group> directory
cd /d %baseDir%

rem Find all of the release directories in the current directory.
set numRelDirs=0
for /d %%a in (*) do (
    if not %%a == current (
        if exist %%a\release.txt (
            if exist %%a\release.sig (
                if exist %%a\mars\packages.txt (
                    set relDirs=!relDirs! %%a
                    set /a numRelDirs+=1
    )   )   )   )
)

if "%relDirs%" == "" (
    @echo No valid release directories found
    goto end
)

rem Create and display a menu of release directories from which the user
rem will choose to set as the current release.
:userprompt
echo.
@echo Key    Release Directory
set i=0
for %%a in (%relDirs%) do (
    @echo !i!      %%a
    set /a i+=1
)
@echo %cancelKey%      Cancel
echo.
set /p selection="Select the Key corresponding to the desired current release or Cancel. "

if "%selection%" == "%cancelKey%" (
    @echo Exiting with no change to current release directory.
    goto end
)

if "%selection%" GEQ "0" (
    if "%selection%" LSS "%numRelDirs%" (
        set i=0
        for %%a in (%relDirs%) do (
            if "!i!"=="%selection%" (
                set selectedDir=%%a
                goto gotCurDir
            )
            set /a i+=1
        )
:gotCurDir
        @echo Setting current release to %selectedDir%
        rmdir /s /q current
        mkdir current
        xcopy /s /e /q %selectedDir%\* current
        goto end
)   )

echo.
@echo ERROR: "%selection%" is not a valid Key, try again.
echo.
goto userprompt

:end

cd %origDir%

endlocal
