#!/bin/sh

# Make the 'current' directory equivalent to the release directory chosen
# by the user.
# This script must be stored in all <repository root>\<product>\<package group>
# directories.  It finds and displays the list of release directories in this
# directory and enables the user to select the desired release directory as the
# current release.

baseDir=`dirname $0`
baseName=`basename $0`
selectedRelDir=$1
listOptions=1

# Change to the directory where this script is located, which should be
# the <repository root>\<product>\<package group> directory
cd "$baseDir"

if [ ! -z "$selectedRelDir" ]; then
    if [ -d "$selectedRelDir" ] && \
       [ "$selectedRelDir" != "current" ] && \
       [ -f "$selectedRelDir/release.txt" ] && \
       [ -f "$selectedRelDir/release.sig" ] && \
       [ -f "$selectedRelDir/mars/packages.txt" ]; then
            rm -rf current
            mkdir current
            cp -R $selectedRelDir/* current
            echo "Current release set to $selectedRelDir"
            listOptions=0
    else
        echo
        echo "ERROR: $selectedRelDir is not a valid option.  Try again."
        echo
    fi
fi

if [ "$listOptions" -eq 1 ]; then
    # List all of the release directories in the current directory.
    echo
    echo "Release Directory Options:"
    for entry in `ls` ; do
        if [ -d "$entry" ] && \
           [ "$entry" != "current" ] && \
           [ -f "$entry/release.txt" ] && \
           [ -f "$entry/release.sig" ] && \
           [ -f "$entry/mars/packages.txt" ]; then
           echo "  $entry"
           expRelDir=$entry
        fi
    done

    if [ -z "$expRelDir" ]; then
        echo "No valid release directories found"
        exit 1
    fi

    echo
    echo "To set current release, re-run $baseName with desired release directory option above."
    echo "  Example: $0 $expRelDir"
    echo
fi
