#!/var/python/bin/python
"""
Copyright 2000-2022 Citrix Systems, Inc. All rights reserved.
This software and documentation contain valuable trade
secrets and proprietary property belonging to Citrix Systems, Inc.
None of this software and documentation may be copied,
duplicated or disclosed without the express
written permission of Citrix Systems, Inc.

About:
  Azure Auto Configurator
  This scripts reads customdata injected via Azure Portal or a template
  and attempts to configure NetScaler accordingly. azureautoconfig is
  launched on startup by nsstartpe.sh right after starting waagent.
"""

import time
import string

DEFAULT_LOG_FILE_PATH = '/var/log/waagent/azure-auto-config.log'
GLOBALS = {'logger': None}


class Logger(object):
    def __init__(self, filepath):
        """
        Log level defines normal msg, error etc.
        currently we are passing 0 and not used.
        """
        self.file_path = filepath

    def log_to_file(self, message):
        if self.file_path:
            try:
                with open(self.file_path, "a") as log_file:
                    message = "".join(
                        [ch for ch in message if ch in string.printable])
                    log_file.write(f"{message.encode('ascii', 'ignore')}\n")
            except IOError as err:
                # Log error in /var/log/error.log file
                print(str(err))

    def log(self, msg):
        t_s = time.localtime()
        t_s = "%04u/%02u/%02u %02u:%02u:%02u " % (
            t_s.tm_year, t_s.tm_mon, t_s.tm_mday, t_s.tm_hour, t_s.tm_min, t_s.tm_sec)
        for line in msg.split('\n'):
            line = t_s + line
            self.log_to_file(line)


##### Log Methods #####

def log_init(log_file_path):
    GLOBALS['logger'] = Logger(log_file_path)


def log(msg):
    if not GLOBALS['logger']:
        log_init(DEFAULT_LOG_FILE_PATH)
    GLOBALS['logger'].log(msg)


def info(msg):
    log("INFO: " + msg)


def debug(msg):
    log("DEBUG: " + msg)


def fail(msg):
    log("FAIL: " + msg)


def error(msg):
    log("ERROR: " + msg)


##### Util Methods #####

def get_net_mask(cidr_blk):
    """
    return subnet mask from CIDR
    """
    mask = [0, 0, 0, 0]
    cidr = int(cidr_blk)
    for i in range(cidr):
        mask[int(i/8)] += (1 << (7 - i % 8))
    return ".".join(map(str, mask))
