<?php 
if(!defined("BASEPATH"))
{
    exit("No direct script access allowed");
}

class curl_response
{
    private $body;
    private $resp_code;

    public function __construct($body, $resp_code, $response_headers) 
    {
        $this->body = $body;
        $this->resp_code = $resp_code;
        $this->response_headers = $response_headers;
    }    

    public function get_body()
    {
        return $this->body;
    }

    public function get_response_code()
    {
        return $this->resp_code;
    }   

    public function get_response_headers()
    {
        return $this->response_headers;
    }   
};

class curl_request
{
    const METH_GET = 'METH_GET';    
    const METH_POST = 'METH_POST';  
    const METH_PUT = 'METH_PUT';  
    const METH_DELETE = 'METH_DELETE';  

    private $method;
    private $url;
    private $cookies;
    private $post_fields;
    private $status;
    private $response;
    private $options = array(
                        "follow_redirect" => false,
                        "max_redirects" => 0,
                        "timeout" => 15
                    );    
    private $request_headers = array("Expect:");
    private $response_headers;

    public function __construct($url, $method = 'METH_GET', $resolve_to_path = null) 
    {
        if ($method == "METH_GET" || $method == "METH_POST" || $method == "METH_PUT" || $method == "METH_DELETE") 
        {
            $this->method = $method;
        } 
        else 
        {
            $this->set_error("Invalid method: $method");

            return;
        }

        $this->url  = $url;
        $this->resolve_to_path = $resolve_to_path;
    }

    private function set_error($msg) 
    {
        $this->error = $msg;
    }    

    private function do_curl($allow_self_signed_ssl_cert = false) 
    {
        $curl_handle = curl_init();

        // Set options
        curl_setopt($curl_handle, CURLOPT_URL, $this->url);
        curl_setopt($curl_handle, CURLOPT_RETURNTRANSFER ,true);
        curl_setopt($curl_handle, CURLOPT_FOLLOWLOCATION, $this->options['follow_redirect']);
        curl_setopt($curl_handle, CURLOPT_MAXREDIRS, $this->options['max_redirects']);        
        curl_setopt($curl_handle, CURLOPT_TIMEOUT, $this->options['timeout']);
        curl_setopt($curl_handle, CURLOPT_HTTPHEADER, $this->request_headers);
        
        if ($this->resolve_to_path != null) {
            curl_setopt($curl_handle, CURLOPT_RESOLVE, [$this->resolve_to_path]);
        }

        $url_parts = parse_url($this->url);

        if ($url_parts['scheme'] == 'https') // Secure access
        {
            if ($allow_self_signed_ssl_cert) {
                curl_setopt($curl_handle, CURLOPT_SSL_VERIFYHOST, false);
                curl_setopt($curl_handle, CURLOPT_SSL_VERIFYPEER, false);
            } else {
                curl_setopt($curl_handle, CURLOPT_SSL_VERIFYHOST, 2);
                curl_setopt($curl_handle, CURLOPT_SSL_VERIFYPEER, true);
            }
        }

        // Set cookie
        $cookie_string="";

        if (!empty($this->cookies)) {
            foreach ($this->cookies as $key => $value) {
                $cookie_string .= "$key=$value;";
            }
        }

        curl_setopt($curl_handle, CURLOPT_COOKIE, $cookie_string);

        // POST
        if($this->method == "METH_POST") 
        {
            curl_setopt($curl_handle, CURLOPT_POST, true);
            curl_setopt($curl_handle, CURLOPT_POSTFIELDS, http_build_query($this->post_fields));
        }

        // PUT
        if($this->method == "METH_PUT") 
        {
            curl_setopt($curl_handle, CURLOPT_CUSTOMREQUEST, "PUT");
            curl_setopt($curl_handle, CURLOPT_POSTFIELDS, http_build_query($this->post_fields));
        }

        // DELETE
        if($this->method == "METH_DELETE") 
        {
            curl_setopt($curl_handle, CURLOPT_CUSTOMREQUEST, "DELETE");
            if((($this->post_fields) != null))
            {
            curl_setopt($curl_handle, CURLOPT_POSTFIELDS, http_build_query($this->post_fields));
            }
        }

        // Default
        curl_setopt($curl_handle, CURLOPT_USERAGENT, "Mozilla/5.0");
        
        $this->response    = curl_exec($curl_handle);
        $curl_info = curl_getinfo($curl_handle);  
        if(curl_errno($curl_handle)) error_log("Curl error: " . curl_error($curl_handle) . " on URL: " . $this->url);      
        $this->status = $curl_info["http_code"];
        $this->response_headers = array(
            "Content-Type" => $curl_info["content_type"],
            "Server" => "Apache"
        );

        curl_close($curl_handle);
    }    

    public function set_options($array)
    {
        if (is_array($array)) 
        {
            foreach($array as $key => $value) 
            {
                $this->options[$key] = $value;
            }
        }
    }    

    public function set_request_headers($array)
    {
        $this->request_headers = $array;
    }    

    public function add_cookies($array)
    {
        $this->cookies = $array;
    }    

    public function set_post_fields($array)
    {
        $this->post_fields = $array;
    }    

    public function send($allow_self_signed_ssl_cert = false)
    {   
        $this->do_curl($allow_self_signed_ssl_cert);

        return new curl_response($this->response, $this->status, $this->response_headers);
    }

    public function get_status() 
    {
        return $this->status;
    }    

    public function get_response() 
    {
        return $this->response;
    }    

    public function get_error() 
    {
        return $this->error;
    }        
}
?>
