<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require_once("Abstract_controller.php");


class login extends abstract_controller
{
    function __construct()
    {
        parent::__construct();
        require_once(APPPATH."controllers/Nonce.php");
        $nonceClass = new nonce();
        $nonce = $nonceClass->setNewNonce();
        require_once(APPPATH."controllers/Utils.php");
        utils::set_content_security_policy_header("LOGIN");        
        detect_xen_center();
    }

    private $doLoginData = 
    [
        "1046" => "Force Password Change feature is enabled. Please change the default nsroot password.",
        "1047" => "Default nsroot password is not allowed. Please enter a new password.",
        "400"  => "Password has expired. Please set a new password.",
        "1081" => "Old password cannot be reused. Enter a new password.",
        "354"  => "Invalid username or password"
    ];

    protected function getView()
    {
        return 'common/login_view';
    }

    protected function getViewData($clientAuth)
    {
        $data['loginerror'] = false;
        $data['https_port'] = "443";
        $data['clientAuth'] = $clientAuth;
        $is_sgw = $this->check_for_simplified_gateway();

        if($is_sgw == "true")
        {
        	$data['https_port'] = "8443";
        }
        
        return $data;
    }

    public function change_password()
    {
        if (isset($_COOKIE["login_redirect_data"])) {
            $cookieData = json_decode($_COOKIE["login_redirect_data"], true);
        }
        $username = $cookieData['username'] ?? '';
        $https_port = $cookieData['https_port'] ?? '';
        $data = $this->input->get();
        $errorCode = $data['errorcode'];
        $this->load->view('common/login_change_password_view', array('errorcode' => $errorCode, 'loginerror' => $this->doLoginData[$errorCode], 'username' => $username, 'https_port' => $https_port));
    }

    public function loginview()
    {
        if (isset($_COOKIE["login_redirect_data"])) {
            $data = json_decode($_COOKIE["login_redirect_data"], true);
        }
        $username = $data["username"] ?? '';
        $https_port = $data['https_port'] ?? '';
        $errorCode = $this->input->get('errorcode');
        if ($errorCode == 1045) {
            $this->load->view('common/login_view', array('eula_failed' => true, 'username' => $username, 'https_port' => $https_port, 'clientAuth' => $data['clientAuth']));
        } else if($errorCode == 1074) {
            $this->load->view('common/login_view', array('errorcode' => $errorCode, 'loginerror' => $data['loginerror'], 'https_port' => $https_port, 'clientAuth' => $data['clientAuth']));
        } else if ($errorCode == 3816) {
            $password = $this->decryptSessionData($data['password'], $data['piv'] ?? null);
            $sessionid = $this->decryptSessionData($data['sessionid'], $data['siv'] ?? null);
            $this->load->view("common/login_nextfactor_view", array('errorcode' => $errorCode, 'loginerror' => $data['loginerror'], 'username' => $username, 'password' => $password, 'sessionid' => $sessionid, 'startupapp' => $data['startupapp'], 'https_port' => $https_port));
        } else if ($errorCode == 1081) {
            $this->load->view('common/login_change_password_view', array('errorcode' => $errorCode, 'loginerror' => $data['loginerror'], 'username' => $username, 'https_port' => $https_port));
        } else if ($errorCode == 1034) {
            $password = $this->decryptSessionData($data['password'], $data['piv'] ?? null);
            $sessionid = $this->decryptSessionData($data['sessionid'], $data['siv'] ?? null);
            $this->load->view("common/login_challenge_view", array('errorcode' => $errorCode, 'loginerror' => $data['loginerror'], 'username' => $username, 'password' => $password, 'sessionid' => $sessionid, 'startupapp' => $data['startupapp'], 'https_port' => $https_port));
        } else if ($errorCode == -1) {
            $this->load->view('common/login_view', array('loginerror' => $this->input->get('loginerror'), 'clientAuth' => $data['clientAuth']));
        } else {
            $this->load->view('common/login_view', array('errorcode' => $errorCode, 'loginerror' => $this->doLoginData[$errorCode], 'clientAuth' => $data['clientAuth']));
        }        
    }

    public function encryptSessionData($data)
    {
        $encryptionKey = $this->config->item('encryption_key');
        if (strlen($encryptionKey) !== 32) {
            $encryptionKey = substr(hash('sha256', $encryptionKey, true), 0, 32);
        }
        $iv = openssl_random_pseudo_bytes(12);
        $encryptedData = openssl_encrypt($data, 'aes-256-cbc', $encryptionKey, 0, $iv);
        if ($encryptedData === false) {
            error_log("Encryption failed: " . openssl_error_string());
        }
        
        // Store the base64 encoded IV for cookie usage
        $this->ivValueForCookie = base64_encode($iv);
        
        return base64_encode($encryptedData);
    }

    public function decryptSessionData($data, $cookieIv = null)
    {
        // Fetch the encryption key
        $encryptionKey = $this->config->item('encryption_key');

        // Ensure the key is 32 bytes long
        if (strlen($encryptionKey) !== 32) {
            $encryptionKey = substr(hash('sha256', $encryptionKey, true), 0, 32);
        }

        // Retrieve the encrypted data and IV from cookie only
        $encryptedData = base64_decode($data);

        if ($cookieIv !== null) {
            // Use IV from cookie
            $iv = base64_decode($cookieIv);
        } else {
            error_log("Decryption failed: No IV provided in cookie");
            return false;
        }

        // Decrypt the data
        $decryptedData = $decrypted = openssl_decrypt($encryptedData, 'aes-256-cbc', $encryptionKey, 0, $iv);
        if ($decryptedData === false) {
            error_log("Decryption failed: " . openssl_error_string());
            return false;
        }
        return $decryptedData;
    }

    public function do_cert_login()
    {
        $rand_key = rawurlencode($_GET['Rand_key']);
        $ctoken =rawurlencode($_GET['ctoken']);
        if (isset($ctoken) && $ctoken != "")
        {
            $rand_key_to_compare = str_replace(" ", "+", $_GET['Rand_key']);
            if (isset($_GET['Rand_key']) && isset($_COOKIE['Rand_key']) && $rand_key_to_compare == $_COOKIE['Rand_key'])
            {
                // Split the decoded ctoken based on '.'
                $ctoken_parts = explode('.', rawurldecode($ctoken));

                // Base64 decode the first part to fetch the JSON
                $decoded_json = base64_decode($ctoken_parts[0]);

                // Decode the JSON to extract the username
                $json_data = json_decode($decoded_json, true);
                $username = $json_data['username'];
                $_SERVER['HTTPS-X-CTOKEN'] = $ctoken;
                if (isset($username)) {
                    $certUser = $headers['X-CUSER'];
                    $_SERVER['X-CUSER'] = $username;
                }
                unset($_COOKIE["NITRO_SK"]);
                $this->do_login(true, $username, $ctoken);
                }
            else
            {
                $_SERVER['CTOKEN'] = false;
                $this->loginFail("Invalid request");
            } 
        } else {
            $_SERVER['CTOKEN'] = false;
            $this->loginFail("Invalid Certificate. Please close the browser window and try again.");
        }
    }

    public function do_login($certLogin = false, $certUser = '', $ctoken = null)
    {
        require_once("Utils.php");
        $this->load->helper('cookie');
        $returnVal = 0;
        $startupapp = "";
        $timeout = "";
        $unit = "";
        $timezone_offset = "";
        $jvm_memory = "";
        $bw = BW_NOT_SET;

        $NITRO_WEB_APPLICATION = $this->input->get_request_header('X-Nitro-Web-Application');
       
        if(isset($NITRO_WEB_APPLICATION) && strtolower($NITRO_WEB_APPLICATION) === "true" || $ctoken !== null)
        {
            if(strcmp($this->input->post('challengepassword') ?? "", ""))
            {
                $challengepassword = $this->input->post('challengepassword');
                $challenge_sessionid = $this->input->post('prev_session_sessionid');
                $challenge_session_username = $this->input->post('prev_session_username');
                $challenge_session_password = $this->input->post('prev_session_password');
                $challenge_startupapp = $this->input->post('prev_session_startupapp');
                $challenge_timezone_offset = intval(input_validator::validate_and_get("timezone_offset", $this->input->post("timezone_offset")));
                $challengepassword_array = array("challengepassword" => $challengepassword);
                $challengeresponse_parameters = array("loginchallengeresponse" => $challengepassword_array, "sessionid" => $challenge_sessionid);
                $returnVal = $this->execute_login_command("loginchallengeresponse", $challengeresponse_parameters);

                if($returnVal != 0 && $returnVal != 1034 && $returnVal != 1045 && $returnVal != 354 && $returnVal != 3816)
                {
                    $result = $this->get_model()->get_result();
                    $this->redirect("/login/loginview?errorcode=-1&loginerror=".$result["message"]);
                }
            }
            else if(strcmp($this->input->post('nextfactorpassword') ?? "", "")) // Check if the post body contains response to the next factor password
            {
                $nextfactorpassword = $this->input->post('nextfactorpassword');
                $nextfactor_sessionid = $this->input->post('prev_session_sessionid');
                $nextfactor_session_username = $this->input->post('prev_session_username');
                $nextfactor_session_password = $this->input->post('prev_session_password');
                $nextfactor_startupapp = $this->input->post('prev_session_startupapp');
                $nextfactor_timezone_offset = intval(input_validator::validate_and_get("timezone_offset", $this->input->post("timezone_offset")));
                $nextfactorpassword_array = array("nextfactorpassword" => $nextfactorpassword);
                $nextfactorresponse_parameters = array("loginnextfactorresponse" => $nextfactorpassword_array, "sessionid" => $nextfactor_sessionid);
                $returnVal = $this->execute_login_command("loginnextfactorresponse", $nextfactorresponse_parameters);

                if($returnVal != 0 && $returnVal != 1034 && $returnVal != 1045 && $returnVal != 354 && $returnVal != 3816)
                {
                    $result = $this->get_model()->get_result();
                    $this->redirect("/login/loginview?errorcode=-1&loginerror=".$result["message"]);
                }
            }
            else
            {
                if($certLogin == true)
                {   
                    abstract_controller::delete_cookie("NITRO_SK");
                    unset($_COOKIE["NITRO_SK"]);
                    $parameters = array();
                    $username = $certUser;
                    $returnVal = $this->execute_login_command("login", $parameters);
                }
                else 
                {
                    // User has submitted inital login request using username & password
                    $username = $this->input->post("username");
                    $password = $this->input->post("password");
                    $standalone = $this->input->post("standalone");
                    $startupapp = input_validator::validate_and_get_cookie("startupapp");
                    $timezone_offset = intval(input_validator::validate_and_get("timezone_offset", $this->input->post("timezone_offset")));
                    $eula = $this->input->post("eula");
                    $parameters = array("username" => $username,
                                        "password" => $password);

                    if(isset($eula) && $eula == true)
                    {
                        $parameters["eula"] = true;
                    }

                    $newPassword = $this->input->post("new_password");

                    if(strcmp($newPassword ?? "", ""))
                    {
                        $parameters["new_password"] = $newPassword;
                    }

                // reset NITRO_SK if any sent by user. initial login requests should generate a fresh NITRO_SK.
            abstract_controller::delete_cookie("NITRO_SK");
            unset($_COOKIE["NITRO_SK"]);

                if($username !== null && strpos($username, "##") === 0) // If token is used to login, get username from actual_username field (used in SSO from SDX)
                {
                    $actual_username = $this->input->post("actual_username");
                    $url = "/menu/ss?" . "sid=" . urlencode($username) . $password;

                    if($actual_username !== false)
                    {
                        $username = $actual_username;
                    }
                    else
                    { 
                        $username = "";
                    }

                    $url = $url . "&username=" . $username;
                    $url = $url . "&startin=" . $startupapp;

                    if(isset($standalone))
                    {
                        $url = $url . "&standalone=" . $standalone;
                    }

                    $this->redirect($url);
                }
            if($username !== null && strpos($username, "##") === 0) // If token is used to login, get username from actual_username field (used in SSO from SDX)
                {
                    $actual_username = $this->input->post("actual_username");
                    $url = "/menu/ss?" . "sid=" . urlencode($username) . $password;

                    if($actual_username !== false)
                    {
                        $username = $actual_username;
                    }
                    else
                    { 
                        $username = "";
                    }

                    $url = $url . "&username=" . $username;
                    $url = $url . "&startin=" . $startupapp;

                    if(isset($standalone))
                    {
                        $url = $url . "&standalone=" . $standalone;
                    }

                    $this->redirect($url);
                }

                $returnVal = $this->execute_login_command("login", $parameters);
                }
            }
            
            $is_sgw = $this->check_for_simplified_gateway();
            $https_port = "443";

            if($is_sgw == "true")
            {
                $https_port = "8443";
            }
        
            if($returnVal == 0)
            {
                if(isset($challenge_startupapp) && ($challenge_startupapp != null))
                {
                    $startupapp = $challenge_startupapp;
                }

                if(isset($nextfactor_startupapp) && ($nextfactor_startupapp != null))
                {
                    $startupapp = $nextfactor_startupapp;
                }

                set_cookie("startupapp","$startupapp", 60*60*24*30*12);

                if(isset($challenge_timezone_offset) && ($challenge_timezone_offset != null))
                {
                    $timezone_offset = $challenge_timezone_offset;
                }

                if(isset($nextfactor_timezone_offset) && ($nextfactor_timezone_offset != null))
                {
                    $timezone_offset = $nextfactor_timezone_offset;
                }

                if(isset($challenge_session_username) && ($challenge_session_username != null))
                {
                    $username = $challenge_session_username;
                }

                if(isset($nextfactor_session_username) && ($nextfactor_session_username != null))
                {
                    $username = $nextfactor_session_username;
                }

                if(isset($challenge_session_password) && ($challenge_session_password != null))
                {
                    $password = $challenge_session_password;
                }

                if(isset($nextfactor_session_password) && ($nextfactor_session_password != null))
                {
                    $password = $nextfactor_session_password;
                }
                setcookie("login_redirect_data", "", time() - 3600, "/");
                unset($_COOKIE["login_redirect_data"]);
                $this->setupUserSession($username, $timeout, $unit, $timezone_offset, $jvm_memory, $password, $ctoken);
                $this->loginSuccess($startupapp);   
            }
            else 
            {
                setcookie("login_redirect_data", json_encode([
                    "username" => $username,
                    "https_port" => $https_port,
                    "clientAuth" => $this->input->get_request_header('X-Client-Auth')
                ]), 0, "/");

                if($returnVal == 1034)
                {
                    if(isset($challenge_startupapp) && ($challenge_startupapp != null))
                    {
                        $startupapp = $challenge_startupapp;
                    }

                    if(isset($nextfactor_startupapp) && ($nextfactor_startupapp != null))
                    {
                        $startupapp = $nextfactor_startupapp;
                    }

                    set_cookie("startupapp","$startupapp", 60*60*24*30*12);

                    if(isset($challenge_session_username) && ($challenge_session_username != null))
                    {
                        $username = $challenge_session_username;
                    }

                    if(isset($nextfactor_session_username) && ($nextfactor_session_username != null))
                    {
                        $username = $nextfactor_session_username;
                    }

                    if(isset($challenge_session_password) && ($challenge_session_password != null))
                    {
                        $password = $challenge_session_password;
                    }

                    if(isset($nextfactor_session_password) && ($nextfactor_session_password != null))
                    {
                        $password = $nextfactor_session_password;
                    }

                    $result = $this->get_model()->get_result();

                    if(isset($result['message']))
                    {
                        if (strpos($result['message'], "Enter your EMERG one-time password") !== false)
                        {
                            $_SESSION['loginerror'] = "Enter your EMERG one-time password";
                        }
                        else
                        {
                            $_SESSION['loginerror'] = $result['message'];
                        }

                        // Encrypt session data and store IVs for cookie
                        $encryptedSessionId = $this->encryptSessionData($result['sessionid']);
                        $sivValue = $this->ivValueForCookie;
                        $encryptedPassword = $this->encryptSessionData($password);
                        $pivValue = $this->ivValueForCookie;

                        setcookie("login_redirect_data", json_encode([
                            "username" => $username,
                            "startupapp" => $startupapp,
                            "sessionid" => $encryptedSessionId,
                            "password" => $encryptedPassword,
                            "https_port" => $https_port,
                            "siv" => $sivValue,
                            "piv" => $pivValue,
                            "clientAuth" => $this->input->get_request_header('X-Client-Auth')
                        ]), 0, "/");

                        $this->redirect("/login/loginview?errorcode=1034");
                    }
                }
                else if($returnVal == 3816)
                {
                    if(isset($challenge_startupapp) && ($challenge_startupapp != null))
                    {
                        $startupapp = $challenge_startupapp;
                    }

                    if(isset($nextfactor_startupapp) && ($nextfactor_startupapp != null))
                    {
                        $startupapp = $nextfactor_startupapp;
                    }

                    set_cookie("startupapp","$startupapp", 60*60*24*30*12);

                    if(isset($challenge_session_username) && ($challenge_session_username != null))
                    {
                        $username = $challenge_session_username;
                    }

                    if(isset($nextfactor_session_username) && ($nextfactor_session_username != null))
                    {
                        $username = $nextfactor_session_username;
                    }

                    if(isset($challenge_session_password) && ($challenge_session_password != null))
                    {
                        $password = $challenge_session_password;
                    }

                    if(isset($nextfactor_session_password) && ($nextfactor_session_password != null))
                    {
                        $password = $nextfactor_session_password;
                    }

                    $result = $this->get_model()->get_result();

                    if(isset($result['message']))
                    {
                        // Encrypt session data and store IVs for cookie
                        $encryptedSessionId = $this->encryptSessionData($result['sessionid']);
                        $sivValue = $this->ivValueForCookie;
                        $encryptedPassword = $this->encryptSessionData($password);
                        $pivValue = $this->ivValueForCookie;

                        setcookie("login_redirect_data", json_encode([
                            "username" => $username,
                            "https_port" => $https_port,
                            "startupapp" => $startupapp,
                            "loginerror" => $result['message'],
                            "sessionid" => $encryptedSessionId,
                            "password" => $encryptedPassword,
                            "clientAuth" => $this->input->get_request_header('X-Client-Auth'),
                            "siv" => $sivValue,
                            "piv" => $pivValue
                        ]), 0, "/");

                        $this->redirect("/login/loginview?errorcode=3816");
                    }
                }        
                else if($returnVal == 1045)
                {
                    $this->redirect("/login/loginview?errorcode=1045");
                }
                else if($returnVal == 1046) // This error code is returned when force password change feature is enabled. Requesting user to enter new password before login.
                {
                    $this->redirect("/login/change_password?errorcode=1046");
                }
                else if($returnVal == 1047) // This error code is returned when the new password entered is again 'nsroot'.
                {
                    $this->redirect("/login/change_password?errorcode=1047");
                }
                else if($returnVal  == 400) // This error code is returned when the password is expired and user is requested to enter new password.
                {
                    $this->redirect("/login/change_password?errorcode=400");
                }
                else if($returnVal == 1081)
                {
                    $result = $this->get_model()->get_result();
                    if(isset($result['message'])) {
                        $returnMessage = $result['message'];
                    } else {
                        $returnMessage = "Old password cannot be reused. Enter a new password";
                    }
                     //$_SESSION['loginerror'] = $returnMessage;

                    setcookie("login_redirect_data", json_encode([
                        "username" => $username,
                        "https_port" => $https_port,
                        "clientAuth" => $this->input->get_request_header('X-Client-Auth'),
                        "loginerror" => $returnMessage
                    ]), 0, "/");


                    $this->redirect("/login/loginview?errorcode=1081");

                }
                else if($returnVal == 1074)
                {
                    $result = $this->get_model()->get_result();
                    preg_match_all('/\d+/', $result["message"], $matches);
                    //$_SESSION['loginerror'] = "Timeout cannot be greater than " .$matches[0][0] ."sec";

                    setcookie("login_redirect_data", json_encode([
                        "username" => $username,
                        "https_port" => $https_port,
                        "clientAuth" => $this->input->get_request_header('X-Client-Auth'),
                        "loginerror" => "Timeout cannot be greater than " .$matches[0][0] ."sec"
                    ]), 0, "/");
                    $this->redirect("/login/loginview?errorcode=1074");
                }
                else if($returnVal == 354)
                {
                    setcookie("login_redirect_data", json_encode([
                        "clientAuth" => $this->input->get_request_header('X-Client-Auth'),
                    ]), 0, "/");
                    $this->redirect("/login/loginview?errorcode=354");
                }
                else
                {
                    $result = $this->get_model()->get_result();
                    $this->redirect("/login/loginview?errorcode=-1&loginerror=".$result["message"]);
                }
            }
        }
        else
        {
            $this->redirect("/login/loginview?errorcode=-1&loginerror=Invalid Request");
            return;
        }
    }

    // Login success should always return a redirect (status code: 302) - security requirement
    private function loginSuccess($startupapp)
    {
        $url = $this->input->post('url');
        $valid_url = false;

        //If bookmarked URL is available, validate and use it.
        //Else goto the app selected
        if($url != "")
        {
            $RTR =& load_class("Router");
            $valid_url = $RTR->validate_uri($url);
        }

        if(!$valid_url)
        {
            $url = $this->get_url_for_app($startupapp);
        }
        
        $this->check_and_redirect_banner($url);
    }

    private function loginFail($error_message)
    {
        $logout_view_data['url'] = "https://".$_SERVER['HTTP_HOST'];
        $logout_view_data['error'] = $error_message;
        $this->load->view('common/logout_view', $logout_view_data);
    }

    public function banner()
    {
        if(!$this->start_session(true))
            return;
        $data['title'] = get_branding()->get_title() . ' - Logon notice';
        $banner_contents = false;
        if(file_exists(LOGIN_BANNER_FILE) && (filesize(LOGIN_BANNER_FILE) > 0))
            $banner_contents = file_get_contents(LOGIN_BANNER_FILE);
        if($banner_contents == false) //If file read returns failure, goto original URL
        {
            $url = "";
            if(isset($_SESSION["redirect_url"]))
                $url = $_SESSION["redirect_url"];
            else
                $url = $this->get_url_for_app(input_validator::get_default_value("startupapp"));
            parent::redirect($url);
        }
        else
            $data['banner_contents'] = preg_replace("/\\\n/", "<br>", htmlspecialchars($banner_contents));
        $data['url'] = $_SESSION['redirect_url'];
        //To avoid printing top banner on login banner screen
        $data['standalone'] = "YES";
        $this->load->view('common/login_banner', $data);
    }

    private function getTimeout($timeout, $unit)
    {
        if($unit == "Minutes")
            return $timeout * 60;
        if($unit == "Hours")
            return $timeout * 60 * 60;
        return $timeout * 60 * 60 * 24; //$unit is "Days"
    }

    //Takes (client - GMT) seconds and calculates (local - GMT) seconds, where this script runs
    //Using these, it computes the offset to be ADDED to local time to convert into client time.
    private function getTimeZoneOffset($client_timezone_offset)
    {
        //Assume XML API is always on board. If we connect to ADC 'N1' using API and this script
        //runs in ADC 'N2', then we need to find out the timezone offset of 'N1'.
        $local_timezone_offset = date('Z');
        return intval($client_timezone_offset) - intval($local_timezone_offset);
    }
    
    public function setupUserSession($username, $timeout, $unit, $timezone_offset, $jvm_memory, $password="", $ctoken = null)
    {
        // Obtain product skew, AGEE or NS
        $nslicense = NS;
        $nsvpx = "";
        $is_fips = false;
        $licenseList = "";
        $_SESSION["sysid"] = get_sysid();
        $_SESSION["oemid"] = get_oem_id();
        $_SESSION["superuser"] = $this->isSuperUser($username);
		$ns_hardware = "";
        if (isset($ctoken))
        {
            $_SESSION['logintype'] = "cert";
        } else {
            $_SESSION['logintype'] = "password";
        }
        if($this->execute_command('getnslicense', '') == 0)
        {
            $result = $this->get_model()->get_result();
            $licenseList = $result['List'][0];

            if($this->is_agee_brand_from_license($licenseList))
            {
                $nslicense = AGEE;
            }
            else if($this->is_ocb_brand_from_license($licenseList))
            {
                $nslicense = OCB;
            }
            else if($this->is_swg_brand_from_license($licenseList))
            {
                $nslicense = SWG;
                $_SESSION['nsbrand'] = SWG;
            }

            if(isset($licenseList["nsxn"]) && $licenseList["nsxn"])
            {
                $nsvpx = "VPX";
            }
        }
        if($this->execute_command("getsystemfipsstatus", array()) == 0)
        {
            $result = $this->get_model()->get_result();
            if($result["rc"] != 0 || count($result["List"]) == 0 || !isset($result["List"][0]["fipsstatus"]))
            {
                $is_fips = false;
            }

            if($result["List"][0]["fipsstatus"] === "System is operating in FIPS mode")
            {
                $is_fips = true;
            }
        }
		$retn = $this->execute_command('getsystembwserver','');

		if( $retn == 0)
		{
			$bw = BW_SET;	
		}
		else 
        {
			$bw = BW_NOT_SET;
		}
		
        $_SESSION['nsbw'] = $bw;

        if(is_bytemobile())
        {
            $nslicense = BYTEMOBILE;
        }

        // Obtain NS Version
        $nsversion = "";
        $ns_mode = NS_KMPE_MODE;
        $nsversion_error = false;
        if($this->execute_command('getnsversion', '') == 0)
        {
            $result = $this->get_model()->get_result();
            $versionList = $result['List'][0];
            $nsversion = $versionList['version'];
        
            if(isset($versionList['mode']) && $versionList['mode'] > 0)
            {
                $ns_mode = NS_VMPE_MODE;
            }

            $nsversion = str_replace( '"', '', $nsversion);
            $nsversion = str_replace( 'NetScaler', '', $nsversion);
        }
        else
        {
            $error = $this->get_model()->get_error_message() . " - getnsversion.";
            $nsversion_error = true;

            if($this->get_model()->get_error_code() == NSERR_NOTAUTHORIZED)
            {
                $nsversion = "<div title='$error' class='inline_display'><img src='/admin_ui/common/images/stop.png' alt='Error'> Not authorized to retrieve version information </div>";
            }
            else
            {
                $nsversion = "<div title='$error' class='inline_display'><img src='/admin_ui/common/images/stop.png' alt='Error'> Error retrieving version information </div>";
            }
        }
        // Obtain host name
        $hostDesc = $this->get_http_host_ip();

        if( $this->execute_command('getnshostname', '') == 0)
        {
            $result = $this->get_model()->get_result();
            $hostDescList = $result['List'][0];
        
            if(isset($hostDescList['hostname']))
            {
                $hostName = preg_replace("/\"/", "", $hostDescList['hostname']);
                $hostName= htmlentities($hostName);
                $hostDesc = $hostDesc . ' (' . $hostName . ')';
                $hostDesc= htmlentities($hostDesc);
            }
        }
        // Obtain hardware description or model info (if it is not VPX)
        $ns_model = "";

        if($this->execute_command("getnshardware", "") == 0)
        {
            $result = $this->get_model()->get_result();
            $ns_hardware = $result["List"][0];
        }
        
        $_SESSION["ns_is_sgw"] = $this->check_for_simplified_gateway();
        $is_cisco_platform = is_cisco_paltform(); // is_cisco_platform cookie is used by docs team to hide citrix liks in context help
        set_cookie("is_cisco_platform", get_oem_id(), 60*60*24*30*12, "", '/', "", true);
        
        if(!empty($licenseList) && isset($licenseList["modelid"]) && $licenseList["modelid"] > 0)
        {
            $ns_model = $licenseList["modelid"];

            if(isset($licenseList["licensingmode"]) && $licenseList["licensingmode"] == "EXPRESS")
            {
                $ns_model = "Freemium";
            }
        }
        else if($nsvpx == "" && isset($ns_hardware["hwdescription"]))
        {
            $ns_model = $ns_hardware["hwdescription"];
            $index = strpos($ns_model, " ");
         
            if($index !== false)
            {
                $ns_model = substr($ns_model, 0, $index);
            }
        }
        // If this is a new session, then the variable
        // $username will not be registered
        if(is_agee())
        {
            $_SESSION['nsbrandDesc'] = "Gateway";
        }
        else if(is_sgw())
        {
        	$_SESSION['nsbrandDesc'] = "ADC HDX Proxy";
        }
        else if(is_ocb())
        {
            if($this->execute_command("getnshardware", "") == 0)
            {
                $result = $this->get_model()->get_result();
                $ns_hardware = $result["List"][0];

                if(is_sdx_present($ns_hardware["sysid"]))
                {
                    $_SESSION['nsbrandDesc'] = "ADC";
                }
                else
                {
                    $_SESSION['nsbrandDesc'] = "Citrix CloudBridge Connector";
                }
            }
        }
        else if($is_cisco_platform)
        {
            $_SESSION['nsbrandDesc'] = "ADC 1000V";
        }
        else if(is_swg())
        {
            $_SESSION['nsbrandDesc'] = "Secure Web Gateway";
        }        
        else
        {
            $_SESSION['nsbrandDesc'] = "ADC";
        }
        $_SESSION['username'] = $username;
        $_SESSION['timezone_offset'] = $this->getTimeZoneOffset($timezone_offset);
        $_SESSION['nsversion'] = $nsversion;
        $_SESSION['nsversion_error'] = $nsversion_error;
        $_SESSION['ns_mode'] = $ns_mode;
        $_SESSION['nshostDesc'] = $hostDesc;
        $_SESSION['nsbrand'] = $nslicense;
        $_SESSION['nsvpx'] = $nsvpx;
        $_SESSION["ns_model"] = $ns_model;
        $_SESSION["is_fips"] = $is_fips;
        if($nsvpx != '' && !$is_cisco_platform)
        {
            $_SESSION['nsbrandDesc'] = $_SESSION['nsbrandDesc'] . " " . $nsvpx;
        }
        if(is_bytemobile())
        {
            $_SESSION['nsbrandDesc'] = get_branding()->get_brand_name();
        }
        $this->check_for_aws_instance($licenseList);

        $this->check_for_azure_instance($licenseList);

        $this->check_for_gcp_instance($licenseList);

        $this->check_for_blx_instance($licenseList, $ns_hardware);
        $this->check_for_linux_instance();
        $this->check_for_reporting_state();

        $this->check_for_cpx_instance($licenseList, $ns_hardware);
        
        $this->check_for_ali_instance($licenseList);
        $_SESSION["rand"] = utils::generate_random_number();
        $_SESSION["rand_key"] = preg_replace("/\./", "", utils::generate_random_number()); //dot in POST key names get converted to underscore.
        
        if(!empty($licenseList))
        {
            $_SESSION['licenseMap'] = $licenseList;
        }

        require_once(APPPATH."views/common/locale_utils.php");
        locale_utils::set_up_locale();
    }

    private function is_agee_brand_from_license($licenselist)
    {
        $agee_brand_keys_list = array("agee" =>true, "wl" =>true, "cmp" =>true, "ssl" =>true, "routing" =>true, "ospf" =>true, "rip" =>true, "bgp" =>true, "isis" =>true, "sslvpn" =>true, "rewrite" =>true, "responder" =>true, "appflow" =>true);
        return $this->is_brand_from_license($licenselist, $agee_brand_keys_list);
    }

    private function is_swg_brand_from_license($licenselist)
    {
        $mandatory_keys_found = 0;
        $swg_brand_mandatory_keys_list = array("forwardproxy" => true, "sslinterception" => true, "isplatinumlic" => false);

        foreach($licenselist as $license_key => $license_value)
        {
            if(isset($swg_brand_mandatory_keys_list[$license_key]))
            {
                if(isset($licenselist[$license_key]) && $licenselist[$license_key] === $swg_brand_mandatory_keys_list[$license_key])
                {
                    $mandatory_keys_found++; // Mandatory key set and true

                    if($mandatory_keys_found === count($swg_brand_mandatory_keys_list))
                    {
                        return true; // All mandatory keys set and true
                    }
                }
            }
        }

        return false;
    }

    private function is_ocb_brand_from_license($licenselist)
    {
        $ocb_brand_keys_list = array("cloudbridgeappliance" =>true, "cloudbridge" =>true, "lb" =>true,  "cs" =>true, "wl" =>true, "ssl" =>true, "gslb" =>true, "routing" =>true, "cf" =>true, "ospf" =>true, "rip" =>true, "bgp" =>true, "rewrite" =>true, "ipv6pt" =>true, "responder" =>true, "appflow" =>true, "wionns" =>true, "isis" =>true);
        
        return $this->is_brand_from_license($licenselist, $ocb_brand_keys_list);
    }

    private function is_brand_from_license($licenselist, $brandkeyslist)
    {
        $is_brand = true;
        $ignore_license_keys = array("nsxn" => true, "modelid" => true, "f_ica_users" => true, "f_sslvpn_users" => true, "ch" =>true, "htmlinjection" => true);
        foreach($licenselist as $license_key => $license_value)
        {
            if(isset($ignore_license_keys[$license_key]))
            {
                continue;
            }

            if(isset($brandkeyslist[$license_key]))
            {
                if(!(isset($licenselist[$license_key]) && $licenselist[$license_key]))
                {
                    $is_brand = false;
            
                    break;
                }
            }
            else if(isset($licenselist[$license_key]) && $licenselist[$license_key] === true)
            {
                $is_brand = false;
            
                break;
            }
        }

        return $is_brand;
    }
    
    private function check_for_simplified_gateway()
    {
        /*Removed the sys ctl command to check for simplified gateway. Returning false just to support any code that might be using it*/
        $ns_is_sgw = "false";
        return $ns_is_sgw;
    }
    
    private function check_for_aws_instance($licenseList)
    {
        $_SESSION["ns_aws_pin"] = "";
        $aws_ns_brand  = trim((string)exec("sysctl -n netscaler.cloud_descr"));
        
        /*
         *Un comment to test it
         *$aws_ns_brand  = trim('ADC VPX AWS MP Enterprise Edition - 200 Mbps (PIN# 4051153)');
         */

        $ns_is_aws = "false";
        
        /*
    	 *Uncomment these changes once we have marketplace AMI. For testing on private AMI, we need to make a check on netscaler.sysid
    	 *
            if (isset($aws_ns_brand) &&  !(strpos($aws_ns_brand, "Unknown") > 0) && !(strpos($aws_ns_brand, "unknown") > 0) && strlen($aws_ns_brand) > 0)
            {
        	    if(strpos($aws_ns_brand, "AWS") > 0)
        	    {
        	        $ns_is_aws = "true";
        	    }
            }
         */
	
        /*
         *Comment/Remove these changes once we have marketplace AMI.
         *For testing on private AMI, we need to make a check on netscaler.sysid
         */
        
        $aws_ns_sysid  = trim((string)exec("sysctl -n netscaler.sysid"));
        
        if(isset($aws_ns_sysid) &&  $aws_ns_sysid == 450040)
        {
            $ns_is_aws = "true";
        }
	
        $_SESSION["ns_is_aws"] = $ns_is_aws;
	
        if(isset($aws_ns_brand) &&  !(strpos($aws_ns_brand, "Unknown") > 0) && strlen($aws_ns_brand) > 0)
        {
            $aws_pin = "";

            if($this->execute_command("getnsvpxparam", "") == 0)
            {
                $result = $this->get_model()->get_result();
                $nsvpxparam = $result["List"][0];
                
                if(isset($nsvpxparam["technicalsupportpin"]))
                {
                    $aws_pin = $nsvpxparam["technicalsupportpin"];
                }
            }            
            
            $_SESSION["nsbrandDesc"] = $aws_ns_brand;
            $_SESSION["ns_aws_pin"] = $aws_pin;
            $_SESSION["ns_model"] = "";

            if(isset($licenseList["licensingmode"]) && ($licenseList["licensingmode"] == "Pooled" || $licenseList["licensingmode"] == "CICO" || $licenseList["licensingmode"] == "Local"))
            {
                $_SESSION["ns_model"] = $licenseList["modelid"];
            }            
        }
    }

    private function check_for_azure_instance($licenseList)
    {
        $ns_is_azure = "false";
        
        $azure_ns_sysid  = trim((string)exec("sysctl -n netscaler.sysid"));
        $azure_ns_brand  = trim((string)exec("sysctl -n netscaler.cloud_descr"));    

        if (isset($azure_ns_sysid) &&  $azure_ns_sysid == 450020)
        {
            $vpx_on_cloud  = trim((string)exec("sysctl -n netscaler.vpx_on_cloud"));

            if (isset($vpx_on_cloud) &&  $vpx_on_cloud == 3)
            {
                $ns_is_azure = "true";
            }
        }
    
        $_SESSION["ns_is_azure"] = $ns_is_azure;
    
        if (isset($azure_ns_brand) &&  !(stripos($azure_ns_brand, "Unknown") > 0) && strlen($azure_ns_brand) > 0)
        {
            $_SESSION["nsbrandDesc"] = $azure_ns_brand;
            $_SESSION["ns_model"] = "";

            if(isset($licenseList["licensingmode"]) && ($licenseList["licensingmode"] == "Pooled" || $licenseList["licensingmode"] == "CICO" || $licenseList["licensingmode"] == "Local"))
            {
                $_SESSION["ns_model"] = $licenseList["modelid"];
            }  
        }
    }

    private function check_for_gcp_instance($licenseList) // Google Cloud Platform
    {
        $ns_is_gcp = "false";
        
        $gcp_ns_sysid  = trim((string)exec("sysctl -n netscaler.sysid"));
        $gcp_ns_brand  = trim((string)exec("sysctl -n netscaler.cloud_descr"));    

        if (isset($gcp_ns_sysid) &&  $gcp_ns_sysid == 450070)
        {
            $vpx_on_cloud  = trim((string)exec("sysctl -n netscaler.vpx_on_cloud"));

            if (isset($vpx_on_cloud) &&  $vpx_on_cloud == 4)
            {
                $ns_is_gcp = "true";
            }
        }
    
        $_SESSION["ns_is_gcp"] = $ns_is_gcp;
    
        if (isset($gcp_ns_brand) &&  !(stripos($gcp_ns_brand, "Unknown") > 0) && strlen($gcp_ns_brand) > 0)
        {
            $_SESSION["nsbrandDesc"] = $gcp_ns_brand;
            $_SESSION["ns_model"] = "";

            if(isset($licenseList["licensingmode"]) && ($licenseList["licensingmode"] == "Pooled" || $licenseList["licensingmode"] == "CICO" || $licenseList["licensingmode"] == "Local"))
            {
                $_SESSION["ns_model"] = $licenseList["modelid"];
            }  
        }
    }
    private function check_for_linux_instance() // Linux Platform
    {
        $ns_is_linux = "false";
        $appEnv = getenv('NS_APPLIANCE');
        
        if ( $appEnv == 1) {
            $ns_is_linux = "true";
        }
         
       $_SESSION["ns_is_linux"] = $ns_is_linux;
    
    }
    private function check_for_reporting_state() // reporting disabled
    {
        $ns_reporting = "false";
        $app_reporting= $this->execute_command("getreporting", "");
        if ($app_reporting == 0) {
            $result = $this->get_model()->get_result();
            if (isset($result['List'][0]['state']) && $result['List'][0]['state'] == "ENABLED") {
                $ns_reporting = "true";
            }
        }
         
         $_SESSION["ns_reporting"] = $ns_reporting;
    
    }

    private function check_for_blx_instance($licenseList, $nshardware) // BLX Platform
    {
        $ns_is_blx = "false";
            
        if(isset($nshardware["sysid"]))
        {
            $blx_ns_sysid = $nshardware["sysid"];
        }

        if ((isset($blx_ns_sysid) &&  $blx_ns_sysid == 450091) || ((int)shell_exec("uname -a | grep -c 'Linux' ") > 0)) // Check for BLX or Linux platform
        {
            $ns_is_blx = "true";

            if(isset($nshardware["hwdescription"]))
            {
                $blx_ns_brand = $nshardware["hwdescription"];
            }            
        }
        $_SESSION["ns_is_blx"] = $ns_is_blx;
        
       if (isset($blx_ns_brand) &&  !(stripos($blx_ns_brand, "Unknown") > 0) && strlen($blx_ns_brand) > 0)
        {
            $_SESSION["nsbrandDesc"] = $blx_ns_brand;
            $_SESSION["ns_model"] = "";

            if(isset($licenseList["licensingmode"]) && ($licenseList["licensingmode"] == "Pooled" || $licenseList["licensingmode"] == "CICO" || $licenseList["licensingmode"] == "Local"))
            {
                $_SESSION["ns_model"] = $licenseList["modelid"];
            }  
        }
    }   
   
    private function check_for_cpx_instance($licenseList, $nshardware) // CPX Platform
    {
        $ns_is_cpx = "false";
            
        if(isset($nshardware["sysid"]))
        {
            $cpx_ns_sysid = $nshardware["sysid"];
        }

        if (isset($cpx_ns_sysid) &&  $cpx_ns_sysid == 450090)
        {
            $ns_is_cpx = "true";

            if(isset($nshardware["hwdescription"]))
            {
                $cpx_ns_brand = $nshardware["hwdescription"];
            }            
        }
    
        $_SESSION["ns_is_cpx"] = $ns_is_cpx;
    
        if (isset($cpx_ns_brand) &&  !(stripos($cpx_ns_brand, "Unknown") > 0) && strlen($cpx_ns_brand) > 0)
        {
            $_SESSION["nsbrandDesc"] = $cpx_ns_brand;
            $_SESSION["ns_model"] = "";

            if(isset($licenseList["licensingmode"]) && ($licenseList["licensingmode"] == "Pooled" || $licenseList["licensingmode"] == "CICO" || $licenseList["licensingmode"] == "Local"))
            {
                $_SESSION["ns_model"] = $licenseList["modelid"];
            }  
        }
    }      

    private function check_for_ali_instance($licenseList)
    {
        $ns_is_ali = "false";
        
        $ali_ns_sysid  = trim((string)exec("sysctl -n netscaler.sysid"));
        $ali_ns_brand  = trim((string)exec("sysctl -n netscaler.cloud_descr"));    

        if (isset($ali_ns_sysid) &&  $ali_ns_sysid == 450070)
        {
            $vpx_on_cloud  = trim((string)exec("sysctl -n netscaler.vpx_on_cloud"));

            if (isset($vpx_on_cloud) &&  $vpx_on_cloud == 5)
            {
                $ns_is_ali = "true";

                if (isset($ali_ns_brand) &&  !(stripos($ali_ns_brand, "Unknown") > 0) && strlen($ali_ns_brand) > 0)
                {
                    $_SESSION["nsbrandDesc"] = $ali_ns_brand;
                    $_SESSION["ns_model"] = "";
                }
            }
        }
    
        $_SESSION["ns_is_ali"] = $ns_is_ali;
    }
}
?>
