<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

require_once(APPPATH."controllers/Abstract_controller.php");

class menu extends abstract_controller
{
	function __construct()
	{
		parent::__construct();
        require_once(APPPATH."controllers/Utils.php");
        require_once(APPPATH."controllers/Nonce.php");
        $nonceClass = new nonce();
        $nonce = $nonceClass->setNewNonce();
        utils::set_content_security_policy_header("MENU");
   	}


    private function set_content_security_policy_with_nonce($module = "MENU") {
        // Create a new nonce and set the content security policy before serving the doc
        
        require_once(APPPATH."controllers/Nonce.php");
        $nonceClass = new nonce();
        $nonce = $nonceClass->setNewNonce();
        
        require_once(APPPATH."controllers/Utils.php");
        $csp_header = utils::set_content_security_policy_header($module);

        $this->output->set_header("Content-Security-Policy: ".$csp_header);
    }

	public function documentation()
	{
        if(!$this->start_session(true))
            return;
        
        $this->set_content_security_policy_with_nonce();

        $this->load->helper('cookie');
        set_cookie("startupapp","doc", 60*60*24*30*12);

        abstract_controller::delete_cookie("logintype");
        unset($_COOKIE["logintype"]);
        if (isset($_SESSION['logintype']))
        {
            set_cookie("logintype", $_SESSION['logintype'], 60*60*24*30*12);
        }
        
        $data['title'] = get_branding()->get_title() . " - Documentation";
        $data['is_sgw'] = "false";
        if(isset($_SESSION["ns_is_sgw"])){
            $data['is_sgw'] = $_SESSION["ns_is_sgw"];
        }
		if(is_agee())
			$this->load->view("docs/agee_docs", $data);
		else if(is_cisco_paltform())
			$this->load->view("docs/cisco_docs", $data);
		else
            $this->load->view("docs/docs", $data);
	}

	public function configuration()
	{
        if(!$this->start_session(true))
            return;
        $data['ns_version'] = $this->get_ns_version();
	    $data['title'] = get_branding()->get_title() . ' - Configuration';
        // Note: no need to add csp nonce enforcement
		$this->load->view("gui/gui", $data);
	}

    // Returns the build number with extra characters removed
    private function get_ns_version()
    {
        if($_SESSION['nsversion_error'] == false)
        {
            $version_arr = explode(",", $_SESSION['nsversion']);
            $return_str = $version_arr[0];
            //Remove dot, semi-colon and space
            return preg_replace("/\.|:| /", "", $return_str);
        }
        return preg_replace("/\./", "", $_SESSION['rand']);
    }

    public function downloads()
	{
        if(!$this->start_session(true))
            return;
		
        $this->set_content_security_policy_with_nonce();
        $this->load->helper('cookie');
        set_cookie("startupapp","dw", 60*60*24*30*12);

        abstract_controller::delete_cookie("logintype");
        unset($_COOKIE["logintype"]);
        if (isset($_SESSION['logintype']))
        {
            set_cookie("logintype", $_SESSION['logintype'], 60*60*24*30*12);
        }
        
	   $data['title'] = get_branding()->get_title() . ' - Downloads';
	   $data['is_sgw'] = "false";
	   if(isset($_SESSION["ns_is_sgw"])){
		$data['is_sgw'] = $_SESSION["ns_is_sgw"];
	   }
		if(is_cisco_paltform())
			$this->load->view("docs/cisco_downloads", $data);
		else
			$this->load->view("docs/downloads", $data);
	}

    public function branding()
    {
        $session_started = $this->start_session(true, false);
        if (!$session_started) {
            exit($this->show_error_page("SESSION_CORRUPTED"));
        }

        $this->output->set_header("Content-type: application/javascript");
        $branding_folder = $_SERVER["DOCUMENT_ROOT"] . "/admin_ui/common/js/ns/branding/";
        $output = file_get_contents($branding_folder . "branding.js.txt");
        if($session_started && !is_ns())
            $output .= "\n\n" . file_get_contents($branding_folder . "branding_" . strtolower($_SESSION["nsbrand"]) . ".js.txt");
        $this->output->set_output($output);
    }
    
    public function neoglobaldata()
    {
        $session_started = $this->start_session(true, false);
        if (!$session_started) {
            exit($this->show_error_page("SESSION_CORRUPTED"));
        }

        $this->output->set_header("Content-type: application/javascript");

        $current_partition = $this->get_default_partition();
        $current_path = isset($current_partition["partitionid"]) ? ("/" . $current_partition["partitionname"]) : "";
        $is_ha_supported = "true";

        if(isset($_SESSION["ns_is_sgw"]) && $_SESSION["ns_is_sgw"] == "true")
        {
            $is_ha_supported = "false";
        }

        if(isset($_SESSION["login_warning"]))
        {
            $login_warning = $_SESSION["login_warning"];
            $_SESSION["login_warning"] = "";
        }
        else
        {
            $login_warning = "";
        }        

        $output = "var neo_logout_url = \"".get_logout_url()."\";";
        $output = $output."\nvar agee_logout_url = \"".get_logout_url()."\";";
        $output = $output."\nvar neo_machine_sysid = \"".get_sysid()."\";";
        $output = $output."\nvar rand = \"".$_SESSION["rand"]."\";";
        $output = $output."\nvar partition_dir = \"".$current_path."\";";
        $output = $output."\nvar is_ha_supported_in_gui = \"".$is_ha_supported."\";";
        $output = $output."\nvar login_warning = \"".$login_warning."\";";
        $output = $output."\nvar global_data = ".$this->getData().";";
        $output = $output."\nvar cb_logout_url = \"".get_logout_url()."\";";
        $output = $output."\nvar topn_logout_url = \"".get_logout_url()."\";";

        //ob_start("ob_gzhandler");
        $this->output->set_output($output);
    }

    public function authorize_content()
    {
        if (!(strpos($_SERVER['SCRIPT_URI'], 'citrix_white_bg') !== false || strpos($_SERVER['SCRIPT_URI'], 'font') !== false))
        {
            if(!$this->start_session(true))
            {
                return;
            }
        }
        // 1. Transform: Extract path from user input
        $request_path = parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH);
        if ($request_path === false) {
            $this->show404();
            return;
        }

        // 2. Normalize: Convert to consistent format
        $normalized_path = str_replace('\\', '/', $request_path);
        $normalized_path = preg_replace('/\/+/', '/', $normalized_path);
        $normalized_path = rtrim($normalized_path, '/');

        // 3. Sanitize: Ensure security constraints
        $base_dir = rtrim($_SERVER['DOCUMENT_ROOT'], '/') . '/';
        $url = $base_dir . ltrim($normalized_path, '/');        
        $url_query_params = explode("?", $url);

        if(is_array($url_query_params)) {
            $url =  $url_query_params[0]; // Ignore query params
        }

        $extn = pathinfo($url, PATHINFO_EXTENSION); // Get file extension
        if((file_exists($url) && is_file($url)) || (file_exists($url.".gz") && is_file($url.".gz")))
        {
            $content_type = "application/octet-stream";
            require_once(APPPATH . "controllers/Rapi_utils.php");
            $content_types_list = rapi_utils::get_mime_types();
            if (array_key_exists($extn, $content_types_list))
            {
                $content_type = $content_types_list[$extn];
            }

            $this->output->set_header("Content-type: ".$content_type);

            require_once(APPPATH."controllers/Nonce.php");
            $nonceClass = new nonce();
            $nonce = $nonceClass->setNewNonce();
            require_once(APPPATH."controllers/Utils.php");
            $csp_header = utils::set_content_security_policy_header("DOCUMENTATION", true);
            $this->output->set_header("Content-Security-Policy: ".$csp_header);
            
            if($extn == "pdf" || $extn == "gz")
            {
                session_cache_limiter('must-revalidate');
            }

            if($extn == "pdf")
            {
                // Setting max age to 5 because on logout and directly pasting the URL in the same browser should not open the pdf
                $this->output->set_header("Cache-Control: max-age=5");
            }
            else if($extn == "gz")
            {
                $this->output->set_header("Cache-Control: ");
                $this->output->set_header("Content-disposition: attachment; filename=" . basename($url)); // Required for IE - http://support.microsoft.com/?id=260519
                $this->output->set_header("Content-Length: ".filesize($url));
            }

            // Read the file and serve the contents
            if(is_file($url.".gz"))
            {
                # To handle the gz html files inside nitro_client folder - Open the file -> add nonce and serve the html.
                if (true && preg_match("/nitro_client\/.*\.html/", $url)) {
                    $search = array("/\{NONCE\}/");
                    $replace = array($nonce);
                    $nitro_html = gzdecode(file_get_contents($url.".gz"));
                    $nitro_html = preg_replace($search, $replace, $nitro_html);
                } else {
                    $nitro_html = file_get_contents($url.".gz");
                    $this->output->set_header("Content-Encoding: gzip");
                }

                $this->output->set_output($nitro_html);
            }
            else
            {
                $search = array("/\{NONCE\}/");
                $replace = array($nonce);
                $html_content = file_get_contents($url);
                $html_content = preg_replace($search, $replace, $html_content);

                $this->output->set_output($html_content);
            }
            return;
        }
        else
        {
            $this->show404();
            return;            
        }
    }  

    public function neo()
    {
        if(!$this->start_session(true))
        {
            return;
        }
        $this->set_content_security_policy_with_nonce("CONFIGURATION");
        $this->load->helper('cookie');
        set_cookie("startupapp","neo", 60*60*24*30*12);

        abstract_controller::delete_cookie("logintype");
        unset($_COOKIE["logintype"]);
        if (isset($_SESSION['logintype']))
        {
            set_cookie("logintype", $_SESSION['logintype'], 60*60*24*30*12);
        }

        $current_partition = $this->get_default_partition();
        $current_path = isset($current_partition["partitionid"]) ? ("/" . $current_partition["partitionname"]) : "";
    	$is_ha_supported = "true";

    	if(isset($_SESSION["ns_is_sgw"]) && $_SESSION["ns_is_sgw"] == "true")
        {
    		$is_ha_supported = "false";
    	}
        
        if(isset($_SESSION["login_warning"]))
        {
            $login_warning = $_SESSION["login_warning"];
            // might need this in future
            // $_SESSION["login_warning"] = "";  
        }
        else
        {
            $login_warning = "";
        }
        $nonce = $_SERVER['nonce'];
        $search = array("/\{title_brand\}/", "/\{neo_logout_url\}/", "/\{neo_machine_sysid\}/", "/\{user_rand}/", "/\{gui_rand_token}/", "/\{partition_dir}/", "/\{is_ha_supported_in_gui}/", "/\{login_warning}/", "/\{NONCE}/");
        $replace = array(get_branding()->get_title(), get_logout_url(), get_sysid(), $_SESSION["rand"], $_SESSION["rand"], $current_path, $is_ha_supported, $login_warning, $nonce);
        $neo_html = file_get_contents($_SERVER["DOCUMENT_ROOT"] . "/admin_ui/neo/html/neo.html");
        $neo_html = preg_replace($search, $replace, $neo_html);
        
        //ob_start("ob_gzhandler");

        // Set headers
        $this->output->set_header("Content-type: text/html;application/octet-stream;application/ecmascript;application/json;application/xml");
        // Set output content
        $this->output->set_output($neo_html);
    }
    
    private function getCmdPolicy(&$global_data_index, &$global_data_array)
    {
        $username = $_SESSION['username'];
        
        if($username == "nsroot")
        {
            $result = array();
            $result["message"] = "Done";
            $result["severity"] = "NONE";
            $result["cmdpolicy_binding"] = array("superuser");
            $global_data_index ["cmdpolicy"] = sizeof($global_data_index);
            array_push($global_data_array,$result);
            return;
        }
	
	if($this->execute_command('getsystemuser_systemgroup_binding', array("username" => $username)) == 0)
        {
            $result = $this->get_model()->get_result();
            if($result["rc"] === 0 && count($result["List"]) > 0)
            {
                foreach( $result["List"] as $systemgroup)
                {
		    if($this->execute_command('getsystemgroup_systemcmdpolicy_binding', array("groupname" => $systemgroup["groupname"])) == 0)
		    {
		       $systemgroupcmdpolicybindresult = $this->get_model()->get_result();
		       if($systemgroupcmdpolicybindresult["rc"] === 0 && count($systemgroupcmdpolicybindresult["List"]) > 0)
		       {
			    foreach( $systemgroupcmdpolicybindresult["List"] as $systemgroupcmdpolicybindobj)
			    {
				if($systemgroupcmdpolicybindobj["policyname"] ==  "superuser")
				{
					$result = array();
					$result["message"] = "Done";
					$result["severity"] = "NONE";
					$result["cmdpolicy_binding"] = array("superuser");
					$global_data_index ["cmdpolicy"] = sizeof($global_data_index);
					array_push($global_data_array,$result);
					return;
				}
			    }
		       }       
		    }		
                }
            }     
        }
        
        if($this->execute_command('getsystemuser_systemcmdpolicy_binding', array("username" => $username)) == 0)
        {
            $result = $this->get_model()->get_result();
            if($result["rc"] === 0 && count($result["List"]) > 0)
            {
                $cmdpolicy_binding = array();
                foreach( $result["List"] as $systemcmdpolicy)
                {
                   $cmdpolicy_binding[ ] = $systemcmdpolicy["policyname"];
                }
                
                $result["cmdpolicy_binding"] = $cmdpolicy_binding;
                unset($result["List"]);
                unset($result["rc"]);
            
                $global_data_index ["cmdpolicy"] = sizeof($global_data_index);
                array_push($global_data_array,$result);
            }   
        }
    }
    
    private function getData()
    {
        $global_data_array = array();
        $global_data_index = array();
        $global_data_requests = array("getclusterinstance", "getnsconfig", "getnshardware", "system_info", "getsystembwserver", "getnslicense", "getsslfipskey", "getsslfips",
                                 "getnsfeature", "getnsversion", "getsslparameter", "statssl","getnslicenseserver", "getsystemfipsstatus");
        
        $global_data_requests_count = count($global_data_requests);
        for($i = 0; $i < $global_data_requests_count; $i++)
        {
            $global_data_request = $global_data_requests[$i];

            if(preg_match('/^get/', $global_data_request))
                $this->getDataFromNitro($global_data_request, $global_data_array);
            else if(preg_match('/^stat/', $global_data_request))
                $this->getDataFromNitro($global_data_request, $global_data_array);
            else
                $this->getDataFromRapi($global_data_request, $global_data_array);   
            
            if(preg_match("/^stat/", $global_data_request))
            {
                $global_data_index[$global_data_request] = $i;
            }
            else if(preg_match("/^get/", $global_data_request))
            {
                $global_data_index[preg_replace('/^get/', '', $global_data_request)] = $i;
            }
            else
            {
                $global_data_index[$global_data_request] = $i;
            }
            
        }
        
        $this->getCmdPolicy($global_data_index, $global_data_array);
        
        return json_encode(array("data" => $global_data_array, "indexof" => $global_data_index));
    }
    
    private function getDataFromNitro($cmd, &$global_data_array)
    {
        $this->execute_command($cmd, array());
        $result = $this->get_model()->get_result();

        if($result["rc"] === 0)
        {
            if(count($result["List"]) > 0)
                $result[preg_replace('/^get/', '', $cmd)] = $result["List"][0];
            
            unset($result["List"]);
            unset($result["rc"]);
            
            array_push($global_data_array,$result);
        }
        else
        {
            array_push($global_data_array,$result['message']);
        }
        
    }
    
    private function getDataFromRapi($cmd, &$global_data_array)
    {
        require_once(APPPATH . "controllers/Rapi.php");
        $rapi = new rapi(true, true);
        $result = $rapi->main($cmd);
        array_push($global_data_array,$result);
    }

    public function topn()
    {
        if(!$this->start_session(true))
        {
            return;
        }

        $this->set_content_security_policy_with_nonce("TOPN");
        $nonce = $_SERVER['nonce'];

        $data = $this->validate_arguments($this->convert_args_obj_to_array($this->input->get()), array("name"));
        $data["name"] = urldecode($data["name"]);

        if(isset($data["name"]))
        {
            $data["name"] = htmlentities($data["name"], ENT_QUOTES, "UTF-8");
        }

        $search = array("/\{title_brand\}/", "/\{topn_logout_url\}/", "/\{GLOBAL_STREAM_IDENTIFIER_NAME\}/", "/\{user_rand}/", "/\{NONCE}/");
        $replace = array($_SESSION["nsbrandDesc"], get_logout_url(), $data["name"], $_SESSION["rand"], $nonce);
        $topn_html = file_get_contents($_SERVER["DOCUMENT_ROOT"] . "/admin_ui/reporting/topn/html/topn.html");
        $topn_html = preg_replace($search, $replace, $topn_html);

        // Set headers
        $this->output->set_header("Content-type: text/html");

        // Set output content        
        $this->output->set_output($topn_html);
    }

    public function agee()
    {
        $data = $this->validate_arguments($this->convert_args_obj_to_array($this->input->get()), array("standalone"), array("show_ftu"));

        if(!$this->start_session(true))
            return;

        $this->set_content_security_policy_with_nonce();
        $nonce = $_SERVER['nonce'];

        $search = array("/\{title_brand\}/", "/\{NONCE}/");
        $replace = array($_SESSION["nsbrandDesc"], $nonce);
        $agee_html = file_get_contents($_SERVER["DOCUMENT_ROOT"] . "/admin_ui/home/agee/html/agee.html");
        $agee_html = preg_replace($search, $replace, $agee_html);

        //TODO: Need to implement CSP nonce here
        $this->output->set_header("Content-type: text/html");

        $this->output->set_output($agee_html);
    }

    public function xenmobile()
    {
        $data = $this->validate_arguments(func_get_args(), array("standalone"));

        if(!$this->start_session())
        {
            return;
        }

        $this->set_content_security_policy_with_nonce("XENMOBILE");
        $nonce = $_SERVER['nonce'];

        $search = array("/\{title_brand\}/", "/\{neo_logout_url\}/", "/\{user_rand}/", "/\{NONCE}/");
        $replace = array($_SESSION["nsbrandDesc"], get_logout_url(), $_SESSION["rand"], $nonce);
        $agee_html = file_get_contents($_SERVER["DOCUMENT_ROOT"] . "/admin_ui/home/xenmobile/html/xenmobile.html");
        $agee_html = preg_replace($search, $replace, $agee_html);

        //TODO: Need to implement CSP nonce here
        // Set headers
        $this->output->set_header("Content-type: text/html");

        // Set output content
        $this->output->set_output($agee_html);
    }

	public function cb()
    {
    	$data = $this->validate_arguments($this->convert_args_obj_to_array($this->input->get()), array("standalone"), array("show_ftu"));

        if(!$this->start_session(true))
        {
            return;
        }

        $this->set_content_security_policy_with_nonce("CLOUDBRIDGE");
        $nonce = $_SERVER['nonce'];

        $this->load->helper('cookie');
        
        $search = array("/\{title_brand\}/", "/\{cb_logout_url\}/", "/\{user_rand}/", "/\{NONCE}/");
        $replace = array($_SESSION["nsbrandDesc"], get_logout_url(), $_SESSION["rand"], $nonce);
        $cb_html = file_get_contents($_SERVER["DOCUMENT_ROOT"] . "/admin_ui/home/cloudbridge/html/cloudbridge.html");
        $cb_html = preg_replace($search, $replace, $cb_html);

        // Set headers
        $this->output->set_header("Content-type: text/html");

        // Set output content
        $this->output->set_output($cb_html);
    }

    public function error()
    {
        $arg_list = $this->convert_args_obj_to_array($this->input->get());
        $headers = getallheaders();
        $data = $this->validate_arguments($arg_list, array('error'));
        $data['loginType'] = isset($_COOKIE['logintype']) && $_COOKIE['logintype'] == "cert" ? "cert" : "password";
        if($_SERVER["REQUEST_METHOD"] != "GET")
        {
            echo "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\"><HTML><HEAD><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" /><TITLE>403 Forbidden</TITLE>";
            echo "</HEAD><BODY><H1>Forbidden</H1>The page you requested is Forbidden.<P></BODY></HTML>";

            return;
        }

        if($data['error'] == "INVALID_USERNAME_PASSWORD")
        {
            print $this->load->view('common/login_view', array('loginerror' => "Invalid Username or password",'clientAuth' => $headers['X-ClientAuth']), true);
            exit();
        }
        if($data["error"] == "CERT_SESSION_LOGOUT")
        {
            $data['error'] = 'User has logged out successfully. Please close the browser window.';
            print $this->load->view('common/logout_view', $data, true);
            exit();
        }        
        $this->set_content_security_policy_with_nonce();

        if($data['error'] == "SESSION_CORRUPTED")
        {
            $additional_message = "Please login again."; 
            $freespace = disk_free_space("/var");
            $headers = getallheaders();
            
            if(!is_bool($freespace)  && intval($freespace)  == 0)
            {
                $additional_message = "File system (/var) is full on the appliance";
            }

            if($data['loginType'] === 'cert'){
                $data['error'] = 'Session is invalid. Please close the browser window and try again.';
                print $this->load->view('common/logout_view', $data, true);
                $this->destroy_session();
                exit();
            }
            
            print $this->load->view('common/login_view', array('loginerror' => "Session is invalid. " .$additional_message,'clientAuth' => $headers['X-ClientAuth']), true);
            $this->destroy_session();
            exit();
        }
        else
        {
            require_once("Utils.php");
            $this->load->view('common/errormessage', $data);
        }
    }

    public function logout()
    {
        error_log("server".json_encode($_SERVER));
        error_log("SESSION".json_encode($_SESSION));
        $arg_list = $this->convert_args_obj_to_array($this->input->get());
        if(!$this->start_session())
        {
            return;
        }
        $data = $this->validate_arguments($arg_list, array('rand'));
        abstract_controller::delete_cookie('NITRO_SK');
        
        if(!isset($_SESSION['rand']) || strcmp($data['rand'], $_SESSION['rand']) !== 0)
    	{
            if(isset($_COOKIE['logintype']) && $_COOKIE['logintype'] == "cert") {
                $_SERVER['CTOKEN'] = "true";
                $this->execute_command('logout', '');
                $this->destroy_session();
                $data['error'] = 'User has logged out successfully. Please close the browser window.';
                $this->show_error_page("CERT_SESSION_LOGOUT");
            } else {
                parent::redirect('', 'location');
            }
    	}
    	else
    	{
    		$this->execute_command('logout', '');
            $this->destroy_session();
            if(isset($_COOKIE['logintype']) && $_COOKIE['logintype'] == "cert") {
                $data['error'] = 'User has logged out successfully. Please close the browser window.';
                $this->show_error_page("CERT_SESSION_LOGOUT");
            } else {
                parent::redirect('', 'location');
            }
    	}
    }

    public function logout_view()
    {
        $arg_list = func_get_args();
        $data = $this->validate_arguments($arg_list, array('error'));
        $data['url'] = "https://".$_SERVER['HTTP_HOST'];
        if (!isset($data['error'])) {
            $data['error'] = 'User has logged out successfully. Please close the browser window.';
        }
        print $this->load->view('common/logout_view', $data, true);
        $this->execute_command('logout', '');
        $this->destroy_session();
    }

    // Used as part of SSO from SDX GUI to NS GUI to find whether a PHP session exists
    public function check_session_sdx()
    {
        $session_started = $this->start_session(false, false);

        if(!$session_started)
        {
            $this->send_no_cache_headers();
        }

        $host_ip = $this->get_http_host_ip();
        $session_started_str = $session_started ? "true" : "false";

        print "\tif(typeof(svm) != 'undefined' && typeof(svm.session_started) == 'function')\n";
        print "\t\tsvm.session_started('$host_ip', $session_started_str, true);\n";
    }

    // Used by SDX GUI to pass the token & username to NS GUI and skip login step (after check_session_sdx() above)
    public function setup_session()
    {
        $arg_list = $this->convert_args_obj_to_array($this->input->get());
        $data = $this->validate_arguments($arg_list, array("sid", "username"), array("startin", "standalone", "force_setup"));
        $is_session_setup = $this->start_session(false, false);
	
        require_once(APPPATH . "controllers/Utils.php");
    
        if(!$is_session_setup)
        {
            $this->load->helper('cookie');
            // Spoof as if user has logged in with the passed token
            utils::setup_webstart_session($data["sid"]);


            // Fire a command and validate the token
            $response = array();
            if(!$this->validate_session($response)) // Invalid token
            {
                $this->destroy_session();
                $this->set_content_security_policy_with_nonce();
                $login_data["loginerror"] = $response["message"];
                print $this->load->view("common/login_view", $login_data, true);

                exit;
            }

            // Valid token - setup the real PHP session (as if user has logged in from login page)
            // and redirect to the right app
            utils::setup_webstart_user_session($data["sid"], $data["username"]);

            // Fire a command and validate the token after session file update. This is to avoid session fixation.
            $response = array();
            if(!$this->validate_session($response)) // Invalid token
            {
                $this->destroy_session();
                $this->set_content_security_policy_with_nonce();
                $login_data["loginerror"] = $response["message"];
                print $this->load->view("common/login_view", $login_data, true);

                exit;
            }            
        }
    	else if(isset($data["force_setup"]))
    	{
            $this->load->helper('cookie');
    	    utils::setup_webstart_user_session(urldecode($data["sid"]), $data["username"], null, true);

            // Fire a command and validate the token after session file update. This is to avoid session fixation.
            $response = array();
            if(!$this->validate_session($response)) // Invalid token
            {
                $this->destroy_session();
                $this->set_content_security_policy_with_nonce();
                $login_data["loginerror"] = $response["message"];
                print $this->load->view("common/login_view", $login_data, true);

                exit;
            }              
    	}

    	if(isset($data["startin"]) && isset($data["standalone"]))
    	{
    		$url = $this->get_url_for_app($data["startin"]);
    		$url = $url . "?" . "standalone=" . $data["standalone"];
    		$this->check_and_redirect_banner($url);
    	}
    	else
        {
            $this->check_and_redirect_banner($this->get_url_for_app(input_validator::validate_and_get_cookie("startupapp")));
        }
    }
    
    public function import_file($url = "/nsconfig/ssl/", $start_Session = true, $use_ssh = false, $add_quotes = false, $validate_filename = false)
    {
        if($start_Session && !$this->start_session(true, false))
        {
            $retVal = $this->print_error_mess("SESSION_CORRUPTED_PLAIN", false);
            $response["errorcode"] = -1;
            $response["message"] = $retVal;
	    
            print json_encode($response);

            return;
        }
	
    
        if($this->validate_request() === false)
        {
            return;
        }
	
        $url = $this->get_directory_path($url);
        $response = array("errorcode" => 0, "message" => "Upload Successful", "severity" => "NONE");
	
        if(!isset($_FILES["import_file_name"]))
        {
            $retVal = $this->print_error_mess("IMPORT_REPORTS_INVAL_REQUEST", false);
            $response["errorcode"] = -1;
            $response["message"] = $retVal;
	    
            print json_encode($response);

            return;
        }

        $imported_file_details = $_FILES["import_file_name"];

        if(!is_uploaded_file($imported_file_details["tmp_name"]))
        {
            switch($imported_file_details["error"])
            {
                case UPLOAD_ERR_INI_SIZE:
                    $retVal = $this->print_error_mess("IMPORT_REPORTS_ERR_INI_SIZE", false);
                case UPLOAD_ERR_FORM_SIZE:
                    $retVal = $this->print_error_mess("IMPORT_REPORTS_ERR_FORM_SIZE", false);
                case UPLOAD_ERR_PARTIAL:
                    $retVal = $this->print_error_mess("IMPORT_REPORTS_ERR_PARTIAL", false);
                case UPLOAD_ERR_NO_FILE:
                    $retVal = $this->print_error_mess("IMPORT_REPORTS_ERR_NO_FILE", false);
                case UPLOAD_ERR_NO_TMP_DIR:
                    $retVal = $this->print_error_mess("IMPORT_REPORTS_ERR_NO_TMP_DIR", false);
                case UPLOAD_ERR_CANT_WRITE:
                    $retVal = $this->print_error_mess("IMPORT_REPORTS_ERR_CANT_WRITE", false);
                case UPLOAD_ERR_EXTENSION:
                    $retVal = $this->print_error_mess("IMPORT_REPORTS_ERR_EXTENSION", false);
                default:
                {
                    $retVal = "There was a problem with your upload. Failed with error code: " . $imported_file_details["error"] . ".\nPlease try again.";
                    $response["errorcode"] = -1;
                    $response["message"] = $retVal;
                    $response["severity"] = "ERROR";
		    
                    print json_encode($response);
                    
                    return;
                }
            }
        }

        if($imported_file_details["size"] == 0)
        {
            $retVal = $this->print_error_mess("IMPORT_REPORTS_ERR_EMPTY_FILE", false);
            $response["errorcode"] = -1;
            $response["message"] = $retVal;
            $response["severity"] = "ERROR";

            print json_encode($response);
            
            return;
        }

		if(preg_match('/ssl|locdb\/*/', $url) && $this->check_permissions("shell", true) != 0) // SSL file upload when no shell access
        {
            $file_content = file_get_contents($_FILES['import_file_name']['tmp_name']);  
            $nitro_response = $this->move_files_using_nitro($url, $imported_file_details["name"], $file_content);

            if($nitro_response == null)
            {
                $response["errorcode"] = -1;
                $response["message"] = "Failed to upload file";
                $response["severity"] = "ERROR";

                print json_encode($response);
                
                return;
            }

            if($nitro_response["errorcode"] != 0)
            {
                $response["errorcode"] = $nitro_response["errorcode"];
                $response["message"] = $nitro_response["message"];
                $response["severity"] = $nitro_response["severity"];

                print json_encode($response);
                
                return;                
            }
        }
        else
        {
            if ($add_quotes == true) 
            {
                $imported_file_details["name"] = "'".$imported_file_details["name"]."'";
            }
            
            if($validate_filename == true)
            {
                require_once(APPPATH . "controllers/Rapi_utils.php");
                // This validator rules out all of these characters: "`", "$", "|", ";","&", ">", "<", "@", "#", "%", "?", "^", "~", "!", "..", "[", "]", "/", "\"
                $sanitized_data = rapi_utils::sanitize_file_name($imported_file_details["name"]);
                if($sanitized_data == NULL)
                {
                    $retVal = "The file name contains invalid characters. Please try with a valid filename.";
                    $response["errorcode"] = -1;
                    $response["message"] = $retVal;

                    print json_encode($response);
                    
                    return;
                }
            }

            if(!$this->move_files($url . $imported_file_details["name"], $imported_file_details["tmp_name"], $use_ssh) === true)
            {
                return;
            }
        }
        
        print json_encode($response);

        return SUCCESS_RESULT;
    }
}
?>
