<?php

/*
  Copyright (C) 2009-2024 Citrix Systems, Inc. All rights reserved.
  This software and documentation contain valuable trade
  secrets and proprietary property belonging to Citrix Systems, Inc.
  None of this software and documentation may be copied,
  duplicated or disclosed without the express
  written permission of Citrix Systems, Inc.
*/

/**
 * IMPORTANT NOTE: Any change done in decryption logic should be done in Net-Gen API file as well:
 * adc/usr.src/netscaler/config/nextgenapi/ngapi_fe/src/ngapi_frontend/common/gui_session.py
 */
function encrypt($text, $key_b64, $iv, $tag_length, $aad) {
	$key = base64_decode($key_b64);
	$ciphertext = openssl_encrypt($text, "aes-256-gcm", $key, OPENSSL_RAW_DATA, $iv, $auth_tag, $aad, $tag_length);
	$ciphertext_b64 = base64_encode($iv.$auth_tag.$ciphertext);
	return $ciphertext_b64;
}

function decrypt($text, $key_b64, $iv, $auth_tag, $aad) {
	$key = base64_decode($key_b64);
	$original_plaintext = openssl_decrypt($text, "aes-256-gcm", $key, OPENSSL_RAW_DATA, $iv, $auth_tag, $aad);
	return $original_plaintext;
}

class EncryptedSessionHandler extends SessionHandler
{
    private $ivlen;
	private $tag_length;
    public function __construct()
    {
		$this->ivlen = openssl_cipher_iv_length($cipher="aes-256-gcm");
		$this->tag_length = 16;
		// Set file permissions to rw-r--r-- (readable by everyone)
		$this->session_file_perm = 0644;
		return true;
    }
	#[\ReturnTypeWillChange]
	public function read($id)
    {
		$data = parent::read($id);
		if (!$data) {
                return "";
		} else {
			$data = base64_decode($data);
			$iv = substr($data,0,$this->ivlen);
			$auth_tag = substr($data,$this->ivlen, $this->tag_length);
		    $ciphertext=substr($data, $this->ivlen+$this->tag_length);
			$aad = "";
			if (!isset($_COOKIE["NITRO_SK"])) {
				return "";
			} else {
				$key = trim($_COOKIE["NITRO_SK"]);
				// to fail the validation of extra characters added after valid NITRO_SK
				if(strlen($key) != 44) {
					return "";
				}
			}
			$data = decrypt($ciphertext, $key, $iv, $auth_tag, $aad);
		}
		return $data;
    }

    public function write($id, $data):bool
    {
		if (!isset($_COOKIE["NITRO_SK"])) {
		        $secure = false;
			if(isset($_SERVER['HTTP_CITRIX_FRONT_END_HTTPS']) && $_SERVER['HTTP_CITRIX_FRONT_END_HTTPS'] === 'On')
				$secure = true;
			$key = base64_encode(random_bytes(32));
			$args = array(
			      	'samesite' => "Lax",
			      	'path'=>"/",
			        'httponly'=>true,
			        'secure'=>$secure
			        );
			setcookie("NITRO_SK", $key, $args);
		} else {
			$key = trim($_COOKIE["NITRO_SK"]);
		}
		$iv = random_bytes($this->ivlen);
		$aad = "";
		$data = encrypt($data, $key, $iv, $this->tag_length, $aad);
		$result = parent::write($id, $data);
		if ($result) {
			$file = session_save_path() . '/sess_' . $id;
			chmod($file, $this->session_file_perm);
		}
		return $result;
    }
}
?>
