<?php  if (!defined('BASEPATH')) exit('No direct script access allowed');

function print_options()
{
    $links = get_branding()->get_login_page_links();
    foreach($links as $obj)
    {
        $text = $obj["text"];
        $value = $obj["value"];
        $default = isset($obj["default"]) ? $obj["default"] : false;

        if($default)
            print " <option value=\"$value\" selected>$text</option> \n" ;
        else
            print " <option value=\"$value\">$text</option> \n" ;

    }
};

if (isset($_SERVER['nonce'])) {
    // Access the 'nonce' key in the array
    $nonce = $_SERVER['nonce'];
} else{
    $nonce = "";
}

?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">

<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta http-equiv="Pragma" content="no-cache" />
<title><?=get_branding()->get_brand_name()?> Login</title>

<link rel="icon" type="image/ico" href="/favicon.ico"/>
<link rel="stylesheet" href="/admin_ui/common/css/ns/ui.css" type="text/css">
<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/common/js/jquery/jquery.min.js"></script>
<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/common/js/jquery/jquery.keyfilter.min.js"></script>
<?php
if ( isset($eula_failed))
{
    print '<script nonce="'.$nonce.'" src="/admin_ui/common/js/ns/eula_message.js" type="text/javascript"> </script>';
}
?>
<style type="text/css">
.ns_alert_text a:hover
{
    color: #0000FF !important;
}

</style>
<script nonce="<?=$nonce?>" language="JavaScript" type="text/javascript">
var display_flag = "block";
var admin_gui_https_port = "443";
<?php 
    if( isset($https_port) && $https_port == "8443"){
        print "admin_gui_https_port = '8443';\n";
    }
    if(!isset($clientAuth)){
        $clientAuth = "disabled";
    }
?>
if(!document.all)
    display_flag = "table-row";

function checkform ( form, event )
{
    var clickedButton = event.submitter;
    if (clickedButton.classList.contains("ns_cert_login_link")) {
        return false; // Return from the function if the button has the specific class
    }
    //getTimezoneOffset() will return (GMT - client) minutes. We need (client - GMT) seconds
    document.form1.timezone_offset.value = new Date().getTimezoneOffset() * -60;

    if (form.username.value === "") {
      show_error("Please enter user name", form.username);
      event.preventDefault();
      return false;
    }
    if (form.password.value === "") {
      show_error("Please enter password", form.password);
      event.preventDefault();
      return false;
    }
  
    form.username.value = addslashes(form.username.value);
    form.password.value = addslashes(form.password.value);
    
    form.username.value = encodeURIComponent(form.username.value);
    form.password.value = encodeURIComponent(form.password.value);
    
    loggingInText();
    var intervalId = setInterval(loggingInText, 200);
    $(".login_button").prop("disabled", true);
    
    return true ;
}

function checkForm2 ( form )
{
    return true ;
}

function addslashes(string) {
    return string.replace(/\\/g, '\\\\').
        replace(/\t/g, '\\t').
        replace(/\n/g, '\\n').
        replace(/\f/g, '\\f').
        replace(/\r/g, '\\r').
        replace(/"/g, '\\"');
}

function checkHTTP() 
{
    if (location.protocol == "http:") 
    {
        //var login_link_anchor = $("<a>").attr("tabindex", "0").addClass("ns_login_link").append("Use https");
        var login_link_anchor = $('.ns_login_link');

        login_link_anchor.click(function() {
            redirectToHTTPS();
        });
        
        login_link_anchor.keypress(function(e) {
            var keynum;

            if(window.event) // IE
            {
                keynum = e.keyCode;
            }
            else if(e.which) // Netscape/Firefox/Opera
            {
                keynum = e.which;
            }

            if(keynum == 13) //Enter key
            {
                login_link_anchor.click();
            }
        });        

        $('.cert-login-container').hide();
    } 
    else 
    {
        var cert_login_link_anchor = $(".ns_cert_login_link");
        // cert_login_link_anchor.click(function() {
        //     submit_form2();
        // });
        $('.https-link').hide();
        return "";
    }
}

function redirectToHTTPS() 
{
    var url_suffix = (admin_gui_https_port != "443" && admin_gui_https_port != 443) ? (":" + admin_gui_https_port): "";
    var url = "https://" + location.host + url_suffix;

    window.location.href = url;
}

function key_pressed(e)
{
    var keynum;
    
    if(window.event) // IE
        keynum = e.keyCode;
    else if(e.which) // Netscape/Firefox/Opera
        keynum = e.which;

    if(keynum == 13) //Enter key
        submit_form();

    return true;
}

var dots = 0;

function loggingInText() {
	$("#logintext").text("Signing In");
	if (dots < 3) {
		$('#loadingdots').append('.');
		dots++;
	} else {
		$('#loadingdots').html('');
		dots = 0;
	}
}

function submit_form()
{
    if(checkform(document.form1, event))
    {
        document.form1.submit();
    }
}

function submit_form2()
{
    if(checkForm2(document.form2))
    {
        document.form2.submit();
    }
}

function is_options_shown()
{
    var startin_row = document.getElementById("ns_login_options");
    return (!startin_row.style || startin_row.style.display == "" || startin_row.style.display == display_flag);
}

function show_hide_login_options(clientAuth)
{
    if(clientAuth == 'disabled') {
        $('.cert-login-container-button').hide();
        $('.cert-login-container-link').hide();
        $('.or-divider').hide();
    } else if (clientAuth == 'optional') {
        $('.cert-login-container-link').show();
        $('.or-divider').show();
        $('.cert-login-container-button').hide();
    } else{
        $('.cert-login-container-button').show();
        $('.cert-login-container-link').hide();
        $('.or-divider').hide();
        $('#ns_user_pass_section').hide();
    }
}

function show_error(message, element)
{
    if(element)
    {
        setTimeout(function(){ element.focus();}, 500);    
    }
    
    if(message)
    {
        $("#login_error").text(message);
        $("#login_error").css('visibility', 'visible');
    }
}

// Mapping used by decodeXml
var escaped_one_to_xml_special_map = {
    '&amp;': '&',
    '&quot;': '"',
    '&lt;': '<',
    '&gt;': '>',
    "&#039;": "'"
};

// To decode the strings which are encoded using php function htmlspecialchars in the backend
function decodeXml(string) {
    return string.replace(/(&quot;|&#039;|&lt;|&gt;|&amp;)/g,
        function(str, item) {
            return escaped_one_to_xml_special_map[item];
    });
}

function isSafari() {
  return /Safari/.test(navigator.userAgent) && /Apple Computer/.test(navigator.vendor);
}

function getSupportedVersionString() {
    try {
		var display_string = "Best viewed in Microsoft Edge, Firefox 3.6.25+, Chrome v19+ or Safari 5.1.1+(for Mac)";
		var nAgt = navigator.userAgent;
		var browserName = navigator.appName;
		var fullVersion = '' + parseFloat(navigator.appVersion);
		var majorVersion = parseInt(navigator.appVersion, 10);
		var nameOffset, verOffset, ix;
		var vendor = null;
		if (navigator.vendor !== null) vendor = navigator.vendor.toLowerCase();
		// For Edge.
        if ((nAgt.indexOf("Edge")) != -1) {
            browserName = "EDGE";
        }
		// In Chrome, the true version is after "Chrome"
		else if ((verOffset = nAgt.indexOf("Chrome")) != -1) {
			browserName = "Chrome";
			fullVersion = nAgt.substring(verOffset + 7);
		}
		// In Safari, the true version is after "Safari" or after "Version"
		else if ((verOffset = nAgt.indexOf("Safari")) != -1) {
			browserName = "Safari";
			fullVersion = nAgt.substring(verOffset + 7);
			if ((verOffset = nAgt.indexOf("Version")) != -1) fullVersion = nAgt.substring(verOffset + 8);
		}
		// In Firefox, the true version is after "Firefox"
		else if ((verOffset = nAgt.indexOf("Firefox")) != -1) {
			browserName = "Firefox";
			fullVersion = nAgt.substring(verOffset + 8);
		}
		// If you can't detect the browser, return the not-supported warning string
		else {
			$(".ns_browser_not_supported_center").show();
			return;
		}
		// trim the fullVersion string at semicolon/space if present
		if ((ix = fullVersion.indexOf(";")) != -1) fullVersion = fullVersion.substring(0, ix);
		if ((ix = fullVersion.indexOf(" ")) != -1) fullVersion = fullVersion.substring(0, ix);
		majorVersion = parseInt('' + fullVersion, 10);
		if (isNaN(majorVersion)) {
			fullVersion = '' + parseFloat(navigator.appVersion);
			majorVersion = parseInt(navigator.appVersion, 10);
		}
		if ((browserName == "EDGE") || 
            (browserName == "Firefox" && compareFullVersion(fullVersion, "3.6.25")) || //Firefox
			(browserName == "Chrome" && compareFullVersion(fullVersion, "19") && vendor !== null && vendor.indexOf('google') != -1) || //chrome
			(browserName == "Safari" && compareFullVersion(fullVersion, "5.1.1") && vendor !== null && vendor.indexOf('apple') != -1) && nAgt.toLowerCase().indexOf('mac') != -1) //Safari for mac
		{
			$(".ns_login_center_content").show();
			return;
		} else {
			$(".ns_browser_not_supported_center").show();
			return;
		}
	} catch (err) {
		$(".ns_login_center_content").show();
		return;
	}
	$(".ns_login_center_content").show();
}

function show_login_pane()
{
    $(".ns_browser_not_supported_center").hide();
    $(".ns_login_center_content").show();
}

function compareFullVersion(a, b) //if a>b, return true, else return false
{
    
	if (a === b)
    {
       return true;
    }

    var a_components = a.split(".");
    var b_components = b.split(".");

    var len = Math.min(a_components.length, b_components.length);

    // loop while the components are equal
    for (var i = 0; i < len; i++)
    {
        // A bigger than B
        var val_a = parseInt(a_components[i]);
		var val_b = parseInt(b_components[i]);
		if(isNaN(val_a) || isNaN(val_b))
		 return false;
		if (parseInt(a_components[i]) > parseInt(b_components[i]))
        {
            return true;
        }

        // B bigger than A
        if (parseInt(a_components[i]) < parseInt(b_components[i]))
        {
            return false;
        }
    }

    // If one's a prefix of the other, the longer one is greater.
    if (a_components.length >= b_components.length)
    {
        return true;
    }

    return false;
}

show_eula = function(uname)
{
   $("#eula-text").html(eula_message);
   $("#ns_login_content").addClass("overlay");
   $("#eula-container").show();
   $("#eula-accepted").prop('checked', false);
   $("#username").val(uname)
   
}

close_eula = function()
{
   $("#ns_login_content").removeClass("overlay")
   $("#eula-container").hide();
   
}

continue_eula = function()
{
    var eula_accepted = $("#eula-checkbox").prop('checked');
    if (eula_accepted)
    {
        close_eula();
        $("#eula-accepted").prop('checked', eula_accepted);
    }
    else
    {
        $("#eula_error").show();
    }
}
function initializeLoginHandlers() {
    const form = document.getElementById("main_login_form");
    <?php if ( isset($clientAuth) && $clientAuth): ?>
        var clientAuth = "<?php echo htmlspecialchars($clientAuth); ?>";
	<?php endif; ?>
    if (form) {
        form.removeEventListener("submit", checkform);
        form.addEventListener("submit", function(event) {
            event.preventDefault();
            if (!checkform(this, event)) {
                return;
            }
            const intervalId = setInterval(loggingInText, 200);
            $(".login_button").prop("disabled", true);
            
            fetch(this.action, {
                method: 'POST',
                headers: {
                    'X-Nitro-Web-Application': 'true',
                    'X-Client-Auth': clientAuth
                },
                body: new URLSearchParams(new FormData(this)),
                redirect: 'follow'
            }).then(response => {
                clearInterval(intervalId);
                if (response.ok || response.status === 303) {
                    const redirectUrl = response.redirected ? response.url : window.location.href;
                    window.location.href = redirectUrl;
                } else {
                    return response.text().then(html => {
                        document.documentElement.innerHTML = html;
                        setTimeout(initializeLoginHandlers, 0);
                    });
                }
            }).catch(error => {
                clearInterval(intervalId);
                $(".login_button").prop("disabled", false);
            });
            
            return false;
        });
    }
    // Attach click handler to smart card button(s) to trigger GET redirect
    const smartCardButtons = document.querySelectorAll('.ns_cert_login_link');
    smartCardButtons.forEach(function(btn) {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopImmediatePropagation();
            window.location.href = '/login/do_cert_login';
        });
    });
}

</script>

</head>
<body class="ns_login_body">
<noscript>
    <div class="center_panel ns_alert_text">
        JavaScript is either disabled in or not supported by the Web browser. To continue logon, use a Web browser that supports JavaScript or enable JavaScript in your current browser.
    </div>
</noscript>

<form name="form1" action="/login/do_login" method="post" autocomplete="off" autocapitalize="off" id="main_login_form">
    <div class="ns_login_wrapper">
	    <div class="ns_login_inner_wrapper">
            <div class="ns_login_top" style="display: none;"></div>
			<div class="ns_login_center">
			    <div class="ns_browser_not_supported_center" >
		        	<span>NetScaler ADC</span>
	              	<div class="ns_browser_not_supported_center_content">
		                <div class="ns_browser_not_supported_center_message"> Your browser is not supported. Please use one of the following browsers
		                </div>
	                 	<div>
						    <div class="ns_browser_not_supported_browser_icon">
	                       		<div>
	                       			<img src="/admin_ui/common/images/edge.png" alt="Microsoft Edge">
									<div> Microsoft Edge </div>
	                   			</div>
	               			</div>							
	                        <div class="ns_browser_not_supported_browser_icon">
	                       		<div>
	                       			<img src="/admin_ui/common/images/firefox.png" alt="Firefox">
	                       			<div>3.6.25 and above</div>
	                   			</div>
	               			</div>
	                        <div class="ns_browser_not_supported_browser_icon">
	                       		<div>
	                       			<img src="/admin_ui/common/images/chrome.png" alt="Chrome">
	                       			<div>15 and above</div>	
	                       		</div>
	                   		</div>
	                        <div class="ns_browser_not_supported_browser_icon  no_boder">
	                       		<div>
	                       			<img src="/admin_ui/common/images/safari.png" alt="Safari">
	                       			<div>5.1.3 and above</div>	
	                   			</div>
	               			</div>
	                  	</div>
	                 	<p class="ns_browser_not_supported_center_message">
	                 		<a id="unsupported_browser_warn_continue"> Continue, </a> I understand this browser may not be compatible.
	         			</p>
	              	</div>
		        </div>
		        <div class="ns_login_center_content">
					<div  class="ns_login_inner_div">
                        <div class="ns_login_logo ns_logo_placement">
                            <!-- <img src="/admin_ui/common/css/ns/ns_logo2_color_negative.png" width="100%" alt="NetScaler logo image" class="product_brand_logo"/> -->
                            <img src="/admin_ui/common/css/ns/ns_logo_with_name.svg" width="100%" alt="NetScaler logo image" class="product_brand_logo"/>
                        </div>
                        <div class="ns_login_background_logo">
                            <img src="/admin_ui/common/css/ns/grey_arrow.svg" width="100%" alt="NetScaler background logo image" class="product_brand_logo"/>
                        </div>
						<div  class="ns_login_form" >
                            <div id="login_error" class="login_error"> 
                            </div>
						   	<div id="ns_user_pass_section">
								<div class="ns_grid_text user_name">
                                    <span>User Name</span>
									
                                    <label for="username" style="display: none;">User Name</label>
                                    <input type="text" id="username" name="username" class="login_input">
								</div>

								<div class="ns_grid_text login_password">
                                    <span>Password</span>

									<label for="password" style="display: none;">Password</label>
                                    <input type="password" name="password" id="password" class="login_input" autocomplete="off">
								</div>
                                    <div style="display:none">
                                        <label for="eula-accepted" style="display: none;">EULA</label>
                                        <input type="checkbox" name="eula" id="eula-accepted" value="TRUE">
                                    </div>
                                    <div class="login_button_cell">
                                        <label for="url" style="display: none;">URL</label>
                                        <input type="hidden" name="url" id="url" value="">

                                        <label for="timezone_offset" style="display: none;">Timezone Offset</label>
                                        <input type="hidden" name="timezone_offset" id="timezone_offset" value="">

                                        <button type="submit" class="login_button rdx_blue_button"><span id="logintext">Sign In</span><span id="loadingdots"></span></button>
                                    </div>
                            </div>
                            <div class='https-link-container' style='padding-top: 20px; text-align: right'>
                                <span class="https-link" style="white-space:nowrap;"> <b>Note:</b> You are using http. We recommend to use https. <a class='ns_login_link' style="white-space:nowrap;">Switch to https</a></span>
                                <div class='or-divider' style="display:flex;margin-bottom:18px;width: 92%; margin-left: 10px">
                                    <hr width="60%" size="2">
                                    <span style="padding-left:18px;"> OR </span>
                                    <hr width="60%" size="2">
                                </div>
                            </div>
                            <div class='cert-login-container-link' style='text-align: left;padding-left: 10px'>
                                    <span class="cert-login-link"> <a class='ns_cert_login_link' style='font-size: 15px'>Sign in using Smart Card</a></span>
                                </div>
                               <div class='cert-login-container-button'>
                                    <div class="ns_motd_text user_name"><span class="ns_motd_banner_contents" style="font-size:16px;">Admin has made it mandatory to login using a Smart Card. <br/>
                                    Click the button below to login.<br/></span>
                                    <button class='ns_cert_login_link' style="border-radius:20px;background-color: #05758a; color:white;font-size:14px; padding: 15px 32px;border: none;text-decoration:none;margin-top:20px;">Sign In using Smart Card</button>
                               </div>
                            </div>
                        </div>
						</div>
					</div>
			</div>
		    </div>
		    </div>
		</div>
	</div>
</form>



<script nonce="<?=$nonce?>" language="JavaScript" type="text/javascript">
//Don't allow this page to be embedded inside a frame
if(self != top)
{
    document.getElementsByTagName("body")[0].style.display = "none";
    top.location = self.location;
}
else
{   
    <?php if ( isset($loginerror) && $loginerror): ?>
        show_error(decodeXml("<?php echo htmlspecialchars($loginerror); ?>"));  
	<?php endif; ?>
     <?php if ( isset($clientAuth) && $clientAuth): ?>
        show_hide_login_options(decodeXml("<?php echo htmlspecialchars($clientAuth); ?>"));  
	<?php endif; ?>
    
    $('form[name="form1"] #username').focus();
}

function input_hints() {
    var inputs = document.getElementsByTagName("input");
    for (var i = 0; i < inputs.length; i++) {
            // test to see if the hint span exists first
            if (inputs[i].parentNode.getElementsByTagName("span")[0]) {
                    // the span exists!  on focus, show the hint
                    inputs[i].onfocus = function() {
                            this.parentNode.getElementsByTagName("span")[0].className = "ns_active ns_active_color";
                    };
                            // when the cursor moves away from the field, hide the hint
                    inputs[i].onblur = function() {
                            this.parentNode.getElementsByTagName("span")[0].className = "ns_active";
                    };
            }
    }
    // repeat the same tests as above for selects
    var selects = document.getElementsByTagName("select");
    for (var k = 0; k < selects.length; k++) {
            if (selects[k].parentNode.getElementsByTagName("span")[0]) {
                    selects[k].onfocus = function() {
                            this.parentNode.getElementsByTagName("span")[0].className = "ns_active ns_active_color";
                    };
                    selects[k].onblur = function() {
                            this.parentNode.getElementsByTagName("span")[0].className = "ns_active";
                    };
            }
    }
}

function login_page_resize_handler() {
    var window_height = $(window).height();
    var container_height = $('.ns_login_center_content').outerHeight();
    var container_top = Math.ceil((window_height - container_height) / 2);
    $('.ns_login_center_content').css("margin-top", container_top);
    var login_title_and_lable_width = $('.login_title_and_lable').outerWidth();
    var left_position = login_title_and_lable_width + 20;
    $('.login_title_and_lable').css("left", "-" + left_position);
}

function set_focus(){
    $("#username").focus();
}

$(document).ready(function(){
    getSupportedVersionString();
    login_page_resize_handler(); 
    input_hints();
    document.form1.username.value = "";
    document.form1.password.value = "";
    set_focus();
    checkHTTP();
    $(window).resize(function() {
        login_page_resize_handler();
    });
    
   <?php
   if ( isset($eula_failed))
    {
        print "var uname = \"$username\";";
        print "show_eula(uname);";
    }
    ?>

    initializeLoginHandlers();
});


</script>
<div id="eula-container" class="eula-container show-modal" style="height: 480px;width:670px;display:none;">
            <div class="eula-header">
                <span>End User License Aggrement</span>
                <span id="eula_window_close" class="eula_window_close eula-right">
                    <a href="#noAnchor" id="eula_close_icon">X</a>
                </span>
            </div>
            <div class="eula-content">
                <p> Please read and agree to the following terms and conditions in order to continue</p>
                <div id= "eula-text" class="eula-text"> </div>
                <div class="eula-terms">
                    <label for="eula-checkbox" style="display: none;">EULA</label>
                    <input id="eula-checkbox" type="checkbox" style="width : auto;height: auto">I have read and agree to the Terms and Conditions
                </div>
                <div id="eula_error" class= "eula_error_text" style="display:none">
                    In order to use our services, you must agree to NetScaler's Terms of Service.
                </div>
                <br/>
                <div class="">
                    <input type="button" value="Continue" id="eula_continue_icon" class="button_blue buttons" /> 
                    <input type="button" value="Cancel" id="eula_cancel_icon" class="button_grey buttons"/>
                </div>
            </div>
            </div>
    <script nonce="<?= $nonce ?>" language="JavaScript" type="text/javascript">
        document.getElementById("unsupported_browser_warn_continue").addEventListener("click", show_login_pane);
        document.getElementById("unsupported_browser_warn_continue").addEventListener("keypress", function (event) {
            if(event.keyCode == 13) {
                show_login_pane();
                event.preventDefault();
            }
        });
        document.getElementById("eula_close_icon").addEventListener("click", close_eula);
        document.getElementById("eula_close_icon").addEventListener("keypress", function (event) {
            if(event.keyCode == 13) {
                close_eula();
                event.preventDefault();
            }
        });
        document.getElementById("eula_continue_icon").addEventListener("click", continue_eula);
        document.getElementById("eula_continue_icon").addEventListener("keypress", function (event) {
            if(event.keyCode == 13) {
                continue_eula();
                event.preventDefault();
            }
        });

        document.getElementById("eula_cancel_icon").addEventListener("click", close_eula);
        document.getElementById("eula_cancel_icon").addEventListener("keypress", function (event) {
            if(event.keyCode == 13) {
                close_eula();
                event.preventDefault();
            }
        });
    </script>
</body>
</html>
