var Resources = new ResourceManager("/logon/themes/Default/resources/{lang}", "postepa");

var nsversion="1,1,1,1";

var nstrace="DEBUG";
var nsvip="255.255.255.255";
var epaActiveX;
var epaPlugin;
var timerID=0;
var ns_location;
var require64bitPlugin = false;
var NS_OLD_COOKIE_LEN = 32; //NSC_AAAC= and cookie value 
var supports65BytesCookie = false;

function ns_getepacookie(NameOfCookie)
{
	var cookie=document.cookie;
	if(cookie.length < 1) return null;
	var begin=cookie.indexOf(NameOfCookie);
	if(begin === -1) return null;
	
	begin+=NameOfCookie.length+1;
	var end=cookie.indexOf(";", begin);
	if(end==-1) end=cookie.length;
	if(!supports65BytesCookie && NameOfCookie == "NSC_AAAC") {
		end = Math.min(end, begin + NS_OLD_COOKIE_LEN );
	}
	return decodeURIComponent(cookie.substring(begin, end));
}

function UnsetCookie(cookieName) {
document.cookie=cookieName+"=nothing;expires=Thursday, 1 Jan 1970 00:00:00 GMT; path=/";
}

function ns_display3006()
{
  document.cookie = "NSC_EPAFALLBACK=1; path=/";
}

function displayBrowserTypeError()
{
  var d = document.getElementById("nsepadiv");
  if(!d) {
        alert(_('Internal Error'));
        return;
  }


  var strActivateAgent;
  if (navigator.userAgent.indexOf("Mac OS X") > -1)  //MAC
  {
        strActivateAgent = _('You can ') + "<A HREF=\"/vpns/m_services.html\" onclick=ns_display3006()>" + _('(You can) use the Access Gateway Plug-in to run the check of your device. ');
  }
  else if (navigator.userAgent.indexOf("Windows NT") > -1) //windows
  {
	strActivateAgent = _('You can ') + "<A HREF=\"/vpns/f_services.html\" onclick=ns_display3006()>" + _('(You can) use the Access Gateway Plug-in to run the check of your device. ');
  }
  else
  {
	strActivateAgent = "";
  }
   d.innerHTML =
	'<div class="field CredentialTypenone"><div class="error" id="feedbackStyle">' +
	'<span id="errorMessageLabel">' +
	'<B>3006:  ' + _('The Endpoint Analysis Plug-in failed to start. ') +
	strActivateAgent +
	_('For further help or information, contact your help desk or system administrator.') + '</B>'+
	'</span>' +
	'</div></div>';

}

  function SetErrMsg(errmsg) {
  var today = new Date();
  var expire = new Date();
  expire.setTime(today.getTime() + 3600000*24);
  document.cookie = "NSC_ERRM="+encodeURIComponent(errmsg)+";path=/;expires="+expire.toGMTString();
  }

  function ns_skipepa()
  {
  SetErrMsg(_('The user skipped the scan'));
  }

  function ns_getredirpage(errcookie)
  {
  var cookie=document.cookie;
  if(errcookie.indexOf("plugin")!=-1) {
  ns_location = "/cgi/setclient?plgn";
  }
  else if(errcookie.indexOf("agent")!=-1) {
  ns_location = "/cgi/setclient?agnt";
  }
  else if(errcookie.indexOf("wicps")!=-1) {
  ns_location = "/cgi/setclient?wica";
  }
  else if(errcookie.indexOf("cvpn")!=-1) {
  ns_location = "/cgi/setclient?cvpn";
  }
  else if(errcookie.indexOf("java")!=-1) {
  ns_location = "/cgi/setclient?java";
  }
  else if(errcookie.indexOf("mac")!=-1) {
  ns_location = "/cgi/setclient?macc";
  }
  // Cookie didnt have any valid choices - go to choices
  else
  ns_location = "/vpns/choices.html";

  }
var bIsUserAdmin = 0;

function setVersionVars(pluginVersion)
{
	if(util.compareVersion(pluginVersion, "12,0,0,0") > 0) {
		supports65BytesCookie = true;
	}
}

function isUpgradeRequired(pluginVersion)
{
	setVersionVars(pluginVersion);

	if(util.compareVersion(pluginVersion, "1,"+"1,"+"1,"+"1") == 0) {
		return false;
	}

	if(util.compareVersion(pluginVersion, "11,0,0,0") < 0)
	{
		return true
	}

	var pluginInfo = util.getPluginInfo("WIN", "EPA", use64BitEPA() ? "EPA64" : "EPA");
	if(pluginInfo.upgradeType == "Never")
	{
		return false;
	}
	else if(pluginInfo.upgradeType == "Essential")
	{
		// Most of the time "compatibleTill" will not be defined. So compare it only when it is defined
		if(pluginInfo.compatibleTill && pluginInfo.compatibleTill !== "")
		{
			if(util.compareVersion(pluginVersion, pluginInfo.compatibleTill) > 0)
				return true;
		}

		return (util.compareVersion(pluginVersion, pluginInfo.compatibleFrom) < 0)
	}
	else
	{
		return (util.compareVersion(pluginInfo.version, pluginVersion) != 0);
	}
}

function versionMismatchFallbackNonIE()
{
	document.getElementById("downloadbutton").style.display = '';
	try
	{
		var userActionRequired = 0;
		if ( ! bIsUserAdmin )
		{
			userActionRequired = epaPlugin.isUserActionRequired(nsversion);
		}

		if (userActionRequired  == "1")
		{
			if(timerID) window.clearTimeout(timerID);
			document.getElementById("downloadbutton").style.display = 'none';
			return;
		}
		else if (userActionRequired  == "-1")
		{ 	//user is admin, set cookie and never check isUserActionRequired again
			document.cookie = "EPA_ADMIN_USER=1; path=/";
		}
		document.cookie = "EPA_VERMISMATCH=1; path=/";
		location.reload(false);
	}
	catch (err)
	{
		document.cookie = "EPA_VERMISMATCH=1; path=/";
		location.reload(false);
	}
}

function versionMismatchFallback()
{
	document.getElementById("downloadbutton").style.display = '';
	try
	{
		var userActionRequired = 0;
		if ( ! bIsUserAdmin )
		{
			userActionRequired = epaActiveX.isUserActionRequired(nsversion);
		}

		if (userActionRequired  == "1")
		{
			if(timerID)
				window.clearTimeout(timerID);
			document.getElementById("downloadbutton").style.display = 'none';
			return;
		}
		else if (userActionRequired  == "-1")
		{ //user is admin, set cookie and never check isUserActionRequired again
			document.cookie = "EPA_ADMIN_USER=1; path=/";
		}
		document.cookie = "EPA_VERMISMATCH=1; path=/";
		location.reload(false);
	}
	catch (err)
	{
		document.cookie = "EPA_VERMISMATCH=1; path=/";
		location.reload(false);
	}
}

function launchEPAPluginNonIE(pluginVersion)
{
	UnsetCookie("EPA_VERMISMATCH");
	UnsetCookie("EPA_ADMIN_USER");
	document.getElementById("downloadbutton").style.display = 'none';
	epaPlugin.StartEpa(ns_getepacookie("NSC_AAAC"), window.location.href, nstrace, nsvip, pluginVersion, navigator.userAgent + ", " + navigator.platform, document.title);
	timerID = window.setTimeout( "probeEPAResultPlugin()", 1000 );
}

function launchEPAPlugin(pluginVersion)
{
	UnsetCookie("EPA_VERMISMATCH");
	UnsetCookie("EPA_ADMIN_USER");
	document.getElementById("downloadbutton").style.display = 'none';
	epaActiveX.StartEpa(ns_getepacookie("NSC_AAAC"), document.location.href, nstrace, nsvip, pluginVersion, navigator.userAgent + ", " + navigator.platform, document.title);
	timerID = window.setTimeout( "probeEPAResult()", 1000 );
}



function detectActiveX()
{
	if(timerID) window.clearTimeout(timerID);

	try
	{
		if( ns_getepacookie("EPA_VERMISMATCH") == 1 ) {
			if( ns_getepacookie("EPA_ADMIN_USER") == 1 ) {
				bIsUserAdmin = 1;
			}
			document.getElementById("downloadbutton").style.display = '';
			UnsetCookie("EPA_VERMISMATCH");
			setTimeout("detectActiveX()", 12000);
			return;
		}

		epaActiveX = new ActiveXObject("nsepacom.nsepaclass");

		if(epaActiveX)
		{

			var epaVersion = epaActiveX.getEPAVersion();
			if( ! isUpgradeRequired(epaVersion))
			{
				launchEPAPlugin(epaVersion);
				return;
			}
			else
			{
				versionMismatchFallback();
				return;
			}
		}
	}
	catch (e)
	{
	}

	document.getElementById("downloadbutton").style.display = '';
	setTimeout("detectActiveX()", 1000);
}



function probeEPAResult()
{
	msg = epaActiveX.getEPAResult();
	if(msg == "wait") {
		timerID = window.setTimeout( "probeEPAResult()", 1000 );
	}
	else if(msg=="passed") {
		var errcookie = epaActiveX.getEPAErrcookie();
	    	ns_getredirpage(errcookie);
	    	window.location.replace( ns_location );
	}
	else if(msg=="choices") {
		var errcookie = epaActiveX.getEPAErrcookie();
		if (errcookie != null)
			document.cookie = "NSC_VPNERR=" + errcookie;
    		window.location.replace( "/vpns/choices.html" );
	}
	else {
		if( (msg.search(/<link>/i)!=-1) && (msg.search(/<\/link>/i)!=-1) ) {
			var redirecturl = "<link>";
			var redirectindex = msg.search(/<link>/i) + redirecturl.length;
			window.location.href = msg.slice(redirectindex,msg.search(/<\/link>/i));
 		}else{
			SetErrMsg(msg);
			document.cookie='NSC_AAAC=nothing;expires=Thursday, 1 Jan 1970 00:00:00 GMT; path=/';

			window.location.replace( "/epa/posterrorpage.html" );
		}
    }
}



function detectLinuxPlugin()
{

    if(timerID) window.clearTimeout(timerID);

    try

    {
        navigator.plugins.refresh(false);
        var npagee;
        npagee = navigator.mimeTypes["application/x-epa"];

        if(npagee) {

            var d = document.getElementById("nsepadiv");
            d.innerHTML = '<object id="npobj" type="application/x-epa" height="1" width="1"></OBJECT>' ;
            epaPlugin = document.getElementById("npobj");

            //getvesion, do upgrade/downgrade if version mismatch

            var url = document.location.host;

            if(epaPlugin.checkEPAUpgrade(url) == "upgrade") { //getvesion, do upgrade/downgrade if version mismatch

                document.getElementById("downloadbutton").style.display = '';

                document.cookie = "EPA_VERMISMATCH=1; path=/";

                setTimeout("detectLinuxPlugin()", 1000);

            } else {

                UnsetCookie("EPA_VERMISMATCH");

                UnsetCookie("EPA_ADMIN_USER");

                document.getElementById("downloadbutton").style.display = 'none';

                url = document.location.protocol + "//" + document.location.host;

                epaPlugin.StartEpa("NSC_AAAC=" + ns_getepacookie("NSC_AAAC"), url, document.location.pathname);

                timerID = window.setTimeout( "probeEPAResultPlugin()", 1000 );

            }

        } else {

            document.getElementById("downloadbutton").style.display = '';

            setTimeout("detectLinuxPlugin()", 1000);

        }

    }

    catch(e)

    {

        document.getElementById("downloadbutton").style.display = '';

        setTimeout("detectLinuxPlugin()", 1000);

    }

}


function detectPlugin()
{
	if(timerID) window.clearTimeout(timerID);
	try
	{
		if( ns_getepacookie("EPA_VERMISMATCH") == 1 ) {
			if( ns_getepacookie("EPA_ADMIN_USER") == 1 ) {
				bIsUserAdmin = 1;
			}
			document.getElementById("downloadbutton").style.display = '';
			UnsetCookie("EPA_VERMISMATCH");
			setTimeout("detectPlugin()", 12000);
			return;
		}

		navigator.plugins.refresh(false);
		var npagee;
		if ( require64bitPlugin )
			npagee = navigator.mimeTypes["application/citrix-npagee64"];
		else
			npagee = navigator.mimeTypes["application/citrix-npagee"];

		if(npagee) {
  			var d = document.getElementById("nsepadiv");
			if ( require64bitPlugin )
  				d.innerHTML = '<object id="epaobj" type="application/citrix-npagee64" height="1" width="1"></OBJECT>' ;
			else
				d.innerHTML = '<object id="epaobj" type="application/citrix-npagee" height="1" width="1"></OBJECT>' ;

			epaPlugin = document.getElementById("epaobj");

			var epaVersion = epaPlugin.getEPAVersion();
			if( ! isUpgradeRequired(epaVersion))
			{
				launchEPAPluginNonIE(epaVersion);
				return;
			}
			else
			{
				versionMismatchFallbackNonIE();
				return;
			}
		}
	}
	catch(e)
	{
	}

	document.getElementById("downloadbutton").style.display = '';
	setTimeout("detectPlugin()", 1000);
}


function versionMismatchFallbackChrome()
{
	document.getElementById("downloadbutton").style.display = '';

	function onFailure()
	{
		document.cookie = "EPA_VERMISMATCH=1; path=/";
		location.reload(false);
	}

	function onSuccess()
	{
		var userActionRequired = this.height;
		if(userActionRequired == 1)
		{
			if(timerID) window.clearTimeout(timerID);
				document.getElementById("downloadbutton").style.display = 'none';
			return;
		}
		else if(userActionRequired == 2)
		{
			document.cookie = "EPA_ADMIN_USER=1; path=/";
		}
		document.cookie = "EPA_VERMISMATCH=1; path=/";
		location.reload(false);
	}

	if (! bIsUserAdmin)
	{
		util.prob("isUserActionRequired&"+nsversion, onSuccess, onFailure);
	}
	else
	{
		onFailure();
	}
}

var probErrors = 0;
var maxProberrors = 5;

var EPAErrcookieMsg = "";

function probeEPAResultChrome()
{
	function ongetEPAErrcookie(errcookie)
	{
		if(errcookie == "")
		{
			probeEPAResultChrome();
			return;
		}

		if(EPAErrcookieMsg == "passed")
		{
			ns_getredirpage(errcookie);
			var sendExit = function () { return afterEPAExit(ns_location);};
			util.prob("exit", sendExit, sendExit);
		}
		else
		{
			document.cookie = "NSC_VPNERR=" + errcookie;
			var sendExit = function () { return afterEPAExit("/vpns/choices.html");};
			util.prob("exit", sendExit, sendExit);
		}
	}

	function onSuccess(msg)
	{
		if(msg =="")
		{
			if(probErrors <maxProberrors)
			{
				probErrors++;
				window.setTimeout( "probeEPAResultChrome()", 1000 );
			}
			else
			{
				location.reload(false);
			}
		}
		else if(msg == "wait")
		{
			timerID = window.setTimeout( "probeEPAResultChrome()", 1000 );
		}
		else if( (msg=="passed")  || (msg=="choices") )
		{
			EPAErrcookieMsg = msg;
			util.getStringFromLauncher("getEPAErrcookie", ongetEPAErrcookie);
		}
		else
		{
			showPostEpaError(msg);
		}
	}
	util.getStringFromLauncher("getEPAResult", onSuccess);
}


function launchEPAPluginChrome(pluginVersion)
{
	function onFailure()
	{
		location.reload(false);
	}

	function onSuccess()
	{
		if( this.height == 2 )
		{
			setTimeout("probeEPAResultChrome()", 3000);
		}
		else
		{
			onFailure();
		}
	}

	UnsetCookie("EPA_VERMISMATCH");
	UnsetCookie("EPA_ADMIN_USER");
	document.getElementById("downloadbutton").style.display = 'none';

	util.prob("StartEpa&" +
		encodeURIComponent(ns_getepacookie("NSC_AAAC") + '&' + document.location.href + "&" + nstrace +"&"+ nsvip +"&"+	pluginVersion  +"&"+ navigator.userAgent +  ", " + navigator.platform + "&" + document.title)  , onSuccess, onFailure);
}

function onChromeVersion(version)
{
	if(version == "")
	{
		//we didn't get correct version. try again.
		setTimeout("detectPluginChrome()", 2000);
		return;
	}

	if(! isUpgradeRequired(version))
	{
		launchEPAPluginChrome(version);
		return;
	}
	versionMismatchFallbackChrome();
}

var curTimerValue 		= util.winMaxTimerValue;
var showTimerHandler;

function showTimerDisplay(showTimer)
{
	if(showTimer)
	{
		document.getElementById("downloadbutton").style.display = "none";
		document.getElementById("AppINFO").style.display 		= "";
		document.getElementById("timer").style.display 			= "";
	}
	else
	{
		document.getElementById("downloadbutton").style.display = "";
		document.getElementById("AppINFO").style.display 		= "none";
		document.getElementById("timer").style.display 			= "none";
	}
}

function noLauncher()
{
	showTimerDisplay(false);
	curTimerValue = util.winMaxTimerValue;
	setTimeout("probEPAPlugin()", 10000);
}

function showTimer()
{
	if(curTimerValue == 0)
	{
		noLauncher();
		return;
	}

	showTimerDisplay(true);
	document.getElementById("timer").innerHTML = curTimerValue + " " + _("secs");
	curTimerValue -= 1;
	showTimerHandler = setTimeout(showTimer, 1000);
}

function stopTimer()
{
	if(typeof showTimerHandler != "undefined")
	{
		document.getElementById("AppINFO").style.display 	= "none";
		document.getElementById("timer").style.display 		= "none";
		clearTimeout(showTimerHandler);
	}
}

function launcherExist()
{
	stopTimer();
	util.getStringFromLauncher("getEPAVersion", onChromeVersion);
}

var probFailCount = 0
function onProbFailure()
{
	if(probFailCount < 25)
	{
		setTimeout("probEPAPlugin()", 2000);
		probFailCount++;
	}
	else
	{
		location.reload(false);
	}
}

function probEPAPlugin()
{
	util.prob("NOP", launcherExist, onProbFailure);
}

function detectPluginChrome()
{
	document.getElementById("AppINFO").style.display 	= "none";
	document.getElementById("timer").style.display 		= "none";

	if( ns_getepacookie("EPA_ADMIN_USER") == 1 )
	{
		bIsUserAdmin = 1;
	}

	if( ns_getepacookie("EPA_VERMISMATCH") == 1 )
	{
		function afterExit()
		{
			document.getElementById("downloadbutton").style.display = '';
			UnsetCookie("EPA_VERMISMATCH");
			setTimeout("probEPAPlugin()", 10000);
			return;
		}
		util.prob("exit", afterExit, afterExit);
		return;
	}

	util.checkIfLaunched = util._checkIfLaunched;
	util.launchPlugin(launcherExist, function () {} );
	showTimer();
}

function afterEPAExit(msg){
  window.location.replace(msg);
}

function certDetailsSubmited()
{

    var certPath = document.forms['certForm'].certPath.value;

    var passwd = document.forms['certForm'].passwd.value;

    if(certPath == "") {

        window.alert("You need to enter certificate Path");

        showCertForm();

    }

    else if(passwd == "") {

        window.alert("You need to enter passwd");

        showCertForm();

    }

    else

    {

        document.getElementById("certAuth").innerHTML='<DIV id=loginAgentCdaHeaderText class="CTX_ContentTitleHeader">Checking System Configuration on your Device</DIV><BR><p id="ctl08_scanInProgress" style="MARGIN: 0px auto; text-align: left"><span id="epa-msg">Before connecting to your organization\'s internal network, we need to check that your computer meets certain requirements.</span><br><br><span id="epa-check">Your device is checked automatically if the Citrix Endpoint Analysis Plug-in software is already installed.</span><br><br><br></p><br><div style="float: right" ><INPUT id="skipbutton" type="button" value="Skip Check" class="CTX_BlackButton" OnClick="javascript:ns_skipepa();" onmouseover="this.className=\'CTX_BlackButton_Hover\';" onmouseout="this.className=\'CTX_BlackButton\';"></div>';

        url = document.location.protocol + "//" + document.location.host;

        epaPlugin.StartEpa("NSC_AAAC=" + ns_getepacookie("NSC_AAAC"), url, document.location.pathname, certPath, passwd);

        if(timerID)

        window.clearTimeout(timerID);

        timerID = window.setTimeout( "probeEPAResultPlugin()", 1000 );

    }

}



function showCertForm()
{
    document.getElementById("certAuth").innerHTML='<DIV id=certAuthHeaderText class="CTX_ContentTitleHeader"><center>Client Certificate Request from EPA Lib</center></DIV><table width=95% id="ctl08_inputTable" class="CTXMSAM_LogonFont" cellspacing="0" cellpadding="4" border="0" style="border-width:0px;border-collapse:collapse;"><tr><td colspan=3></td></tr><tr><td align="right" style="padding-right:10px;white-space:nowrap;"><span id="User_name" class="CTXMSAM_LogonFont"></span></td><td colspan=2 style="padding-right:8px;">Certificate&nbsp;Path:&nbsp;&nbsp;<input id="Enter cert path" class="CTXMSAM_ContentFont" style="font-size: 8pt" type="text" title="" name="certPath" size="40" maxlength="127" placeholder="Please enter complete path of certificate" onFocus="loginFieldCheck()"style="width:100%;"/></td></tr><tr><td align="right" style="padding-right:10px;white-space:nowrap;"><span id="User_name" class="CTXMSAM_LogonFont"></span></td><td colspan=2 style="padding-right:8px;">Password:&emsp;&emsp;&emsp;<input id="cert_Password" class="CTXMSAM_ContentFont" style="font-size: 8pt" type="Password" title="" name="passwd" size="40" maxlength="127" sty style="width:100%;"/></td></tr><tr><td></td><td></td><td align="right"><span style="display:none"><img src="/vpn/images/LoginButtonRolloverGlow.gif"/></span><input type="submit" style="font-size: 10pt" id="Log_On" value="Submit" class="CTX_CaxtonButton" onclick="certDetailsSubmited()"  onmouseover="this.className=\'CTX_CaxtonButton_Hover\';" onmouseout="this.className=\'CTX_CaxtonButton\';" /></td></tr></table>';
}


function showPostEpaError(msg)
{
	if( (msg.search(/<link>/i)!=-1) && (msg.search(/<\/link>/i)!=-1) )
	{
		var redirecturl = "<link>";
		var redirectindex = msg.search(/<link>/i) + redirecturl.length;
		window.location.href = msg.slice(redirectindex,msg.search(/<\/link>/i));
	}
	else
	{
		SetErrMsg(msg);
		document.cookie='NSC_AAAC=nothing;expires=Thursday, 1 Jan 1970 00:00:00 GMT; path=/';
		var sendExit = function () { return afterEPAExit("/epa/posterrorpage.html");};
		util.prob("exit", sendExit, sendExit);
	}
}

function probeEPAResultPlugin()
{
    try {
        msg = epaPlugin.getEPAResult();
    } catch (err) {
        location.reload();
    }

    if(msg == "wait")
	{
        timerID = window.setTimeout( "probeEPAResultPlugin()", 1000 );
    }
    else if(msg=="passed")
	{
        var errcookie = epaPlugin.getEPAErrcookie();
        ns_getredirpage(errcookie);
        window.location.replace( ns_location );

    }
    else if(msg=="choices")
	{
        var errcookie = epaPlugin.getEPAErrcookie();
        if (errcookie != null)
        document.cookie = "NSC_VPNERR=" + errcookie;
        window.location.replace( "/vpns/choices.html" );
    }

    else if(msg=="certRequired")
	{
        showCertForm();
    }
    else
	{
        showPostEpaError(msg)
    }
}

//Mac variables
var agmac_cookie;
var agmac_nConnectAttempts = 15;
var agmac_count = 0;
var agmac_totalAttempts = 80;
var agmac_chromeFlag = 0;
var agmac_domainName_ws = "localhost";
var agmac_portNo = 6256;
var agmac_isVersionMatch = 1;
var agmac_isAppInstalled = 1;
var agmac_epa_iframe;
var agmac_didShowDwnld = 0;
var agmac_timeInterval = 1000;  //timer timeout in millis
var agmac_nSecs = 20;
var agmac_clearTimer;
var covpCookie="";
var covpCount = 0;
var agmac_EpaMsg="";

function agmac_showTimer()
{
	if( agmac_nSecs > 0 )
	{
		document.getElementById("timer").innerHTML = agmac_nSecs + " " + _("secs");
		agmac_clearTimer = setTimeout( agmac_showTimer, agmac_timeInterval );
		agmac_nSecs = agmac_nSecs-1;
	}
}

function agmac_launchEpaApp()
{
	document.getElementById("AppINFO").innerHTML = _("Checking if the plug-in is installed");
	agmac_showTimer();

	//Open AGMacEpa app using custom url scheme
	if( (navigator.userAgent.indexOf("Chrome") > -1) && (navigator.vendor == "Google Inc.") )
	{
	    window.location = "com.citrix.agmacepa://";
	}
	else
	{
		agmac_epa_iframe = document.createElement("iframe");
		document.body.appendChild(agmac_epa_iframe);
		agmac_epa_iframe.setAttribute("width", "1");
		agmac_epa_iframe.setAttribute("height", "1");
		agmac_epa_iframe.hidden = true;
		agmac_epa_iframe.src = "com.citrix.agmacepa://";
	}
	setTimeout("agmac_startChannel()", 2500);
}

function agmac_startChannel()
{
	if(agmac_count < agmac_nConnectAttempts)
	{
		agmac_cookie = "NSC_AAAC="+ns_getepacookie("NSC_AAAC");
		var image = new Image();
		image.onload = agmac_sepaHandler;
		image.onerror = agmac_sepaError;
		image.src = "http://localhost:"+agmac_portNo+"/sepa?"+agmac_cookie+"?"+window.location.host+"?POSTAUTH";
  	}
    else
    {
        if( (navigator.userAgent.indexOf("Chrome") > -1) && (navigator.vendor == "Google Inc.") )
        {
            document.getElementById("launchbutton").style.display = 'none';
            agmac_showDownload(_("Manual start of the Endpoint Analysis plug-in failed as it is not installed. Please click Download to install the plug-in."));
        }
        else
        {
            agmac_showDownload(_("Endpoint Analysis plug-in is either not launched/installed. Please launch or click on the download link provided."));
        }
    }
}

function agmac_sepaError()
{
    console.log("error : "+agmac_count);
    agmac_count++;
    agmac_portNo++;

    if( agmac_portNo > 6260 )
      agmac_portNo = 6256;

    if( (navigator.userAgent.indexOf("Chrome") > -1) && (navigator.vendor == "Google Inc.") )
    {
        if(agmac_count == 5 && agmac_chromeFlag == 0)
        {
            agmac_chromeFlag = 1;
            document.getElementById("launchbutton").style.display = '';
            document.getElementById("timer").style.display = 'none';
            document.getElementById("AppINFO").innerHTML = _("Automatic start of the Endpoint Analysis plug-in failed. Please click Launch to manually start the plug-in.");
            document.getElementById("AppINFO").style.display = '';
        }
    }
    window.setTimeout("agmac_startChannel()", 1000);
}

function agmac_sepaHandler(evt)
{
	document.getElementById("timer").style.display = "none";
	if( this.height == 2 )
	{
    //disable epaskip
    document.getElementById("skipbutton").style.display = 'none';
    document.getElementById("AppINFO").style.display = 'none';
		agmac_sendrepa();
	}
	else
	{
		SetErrMsg(_("End point analysis failed"));
		document.cookie='NSC_AAAC=nothing;expires=Thursday, 1 Jan 1970 00:00:00 GMT; path=/';
   	window.location = "/epa/posterrorpage.html";
	}
}

//firefox is caching image resopnses so need to make it unique hence adding counters
var ff_count = 0;
function agmac_sendrepa()
{
	var image = new Image();
	image.onload = agmac_repaHandler;
	image.onerror = agmac_repaError;
	image.src = "http://localhost:"+agmac_portNo+"/repa?"+agmac_cookie+"?"+ff_count;
}

function agmac_repaHandler()
{
  console.log(this.height);
	if( this.height == 1 )
	{
        //wait
        ff_count = ff_count+1;
        setTimeout("agmac_sendrepa()", 1000);
	}
	else if( this.height == 2 )
	{
      //version mismatch
      agmac_showDownload(_("You do not have the latest version of Endpoint Analysis plug-in installed. Please download the updated plug-in from the link provided"));
      window.setTimeout("agmac_startChannel()", 1000);
	}
	else if( this.height == 3 )
	{
      //failed epa
      // SetErrMsg(_("End point analysis failed"));
      // document.cookie='NSC_AAAC=nothing;expires=Thursday, 1 Jan 1970 00:00:00 GMT; path=/';
      // window.location = "/epa/posterrorpage.html";

      agmac_sendEpaMsg();
	}
	else if( this.height == 4 )
	{
		  //passed epa, fetch NSC_VPNERR cookie
      agmac_sendcovp();
	}
}

function agmac_repaError()
{
	agmac_epafailed();
}

function agmac_sendEpaMsg()
{
  console.log("agmac_sendEpaMsg");
  var image = new Image();
	image.onload = agmac_EpaMsgHandler;
	image.onerror = agmac_EpaMsgError;
	image.src = "http://localhost:"+agmac_portNo+"/epamsg?"+agmac_cookie+"?"+agmac_EpaMsg.length+"?"+ff_count;
}

function agmac_EpaMsgHandler()
{
  if (this.height != 2)
  {
    agmac_EpaMsg = agmac_EpaMsg+String.fromCharCode(this.height);
    ff_count = ff_count+1;
    var image = new Image();
    image.onload = agmac_EpaMsgHandler;
  	image.onerror = agmac_EpaMsgError;
  	image.src = "http://localhost:"+agmac_portNo+"/epamsg?"+agmac_cookie+"?"+agmac_EpaMsg.length+"?"+ff_count;
  }
  else {
    console.log("agmac_EpaMsg = ",agmac_EpaMsg);
    agmac_epafailed();
  }
}

function agmac_EpaMsgError()
{
  agmac_epafailed();
}

function agmac_epafailed()
{
  console.log("epa failed");
  if(agmac_EpaMsg == "")
  {
    SetErrMsg(_("End point analysis failed"));
  }
  else {
    SetErrMsg(agmac_EpaMsg);
  }
	document.cookie='NSC_AAAC=nothing;expires=Thursday, 1 Jan 1970 00:00:00 GMT; path=/';
  window.location = "/epa/posterrorpage.html";
}

function agmac_sendcovp()
{
    image = new Image();
    image.onerror = covpError;
    image.onload = covpSuccess;
    image.src = "http://localhost:"+agmac_portNo+"/covp?"+agmac_cookie+"?"+covpCookie;
}

function covpError()
{
  SetErrMsg(_("End point analysis failed"));
	document.cookie='NSC_AAAC=nothing;expires=Thursday, 1 Jan 1970 00:00:00 GMT; path=/';
  window.location = "/epa/posterrorpage.html";
}

function covpSuccess(evt)
{
    if(this.height == 1)
    {
        covpCookie = "NSC_VPNERR="+covpCount+covpCookie;
        console.log("We done ="+covpCookie);

        document.cookie = covpCookie;
        ns_location = "/vpns/choices.html";
        if(covpCookie.indexOf("1") !=-1)
        {
            ns_getredirpage(covpCookie);
        }
        window.location = ns_location;
        return;
    }
    if(this.height == 2)
    {
        covpCount = covpCount+1;
        covpCookie = covpCookie+",wicps";
    }
    if(this.height == 3)
    {
        covpCount = covpCount+1;
        covpCookie = covpCookie+",cvpn";
    }
    if(this.height == 4)
    {
        covpCount = covpCount+1;
        covpCookie = covpCookie+",java";
    }
    if(this.height == 5)
    {
        covpCount = covpCount+1;
        covpCookie = covpCookie+",mac";
    }
    if(this.height == 6)
    {
        covpCount = covpCount+1;
        covpCookie = covpCookie+",agent";
    }
    setTimeout("agmac_sendcovp()", 1000);
}

function agmac_showDownload(textinfo)
{
	if( !agmac_didShowDwnld )
  	{
  		agmac_didShowDwnld = 1;
			document.getElementById("timer").style.display = "none";
			document.getElementById("AppINFO").innerHTML = textinfo;
			document.getElementById("AppINFO").style.display = '';
			document.getElementById("downloadbutton").style.display = '';

			agmac_nConnectAttempts = agmac_totalAttempts;
			agmac_count = 0;
			agmac_startChannel();
			return;
		}
}

//chrome specific function. for some reason custom url doesn't open the app twice within short duration of time in chrome.
function agmac_onLaunch()
{
    clearTimeout(agmac_clearTimer);
    agmac_nSecs = 20;
    document.getElementById("timer").style.display = '';
    agmac_showTimer();
    window.location = "com.citrix.agmacepa://";
    setTimeout("agmac_startChannel()", 2500);
}

function detectEpaComponent()
{
    if(navigator.userAgent.indexOf("Linux") != -1)
    {
        //detectPluginVersion();
        setTimeout("linux_launchEpaApp()", 4000);//timeout to handle both preauth and postauth with two factor off
        return;
    }
    else
    {
        if (navigator.userAgent.indexOf("Windows NT") == -1)    //not a windows machine
        {
            if (navigator.userAgent.indexOf("Mac OS X") == -1)  //not a Mac machine
            {
                displayBrowserTypeError();
                return;
            }
            else
            {
                setTimeout("agmac_launchEpaApp()", 4000);//timeout to handle both preauth and postauth with two factor off
                return;
            }
        }

        detectPluginVersion();
		if(util.win.ACTIVEX_SUPPORTED)
		{
            detectActiveX();
        }
		else if(util.useLauncher)
		{
			detectPluginChrome();
		}
        else if( (navigator.userAgent.indexOf("Firefox") > -1) ||  (navigator.userAgent.indexOf("Gecko/2") > -1) ||   (navigator.userAgent.indexOf("AppleWebKit") > -1) )
		{
            detectPlugin();
		}
		else
		{
            displayBrowserTypeError();
		}
    }
}


//linux variables
var linux_cookie;


var linux_nConnectAttempts = 15;
var linux_count = 0;
var linux_totalAttempts = 80;
var linux_chromeFlag = 0;

var linux_domainName_ws = "localhost";
var linux_startportNo = 3118;
var linux_portNo = 3148;

var linux_isVersionMatch = 1;
var linux_isAppInstalled = 1;

var linux_epa_iframe;
var linux_didShowDwnld = 0;

var linux_timeInterval = 1000;  //timer timeout in millis
var linux_nSecs = 20;
var linux_clearTimer;

var covpCookie="";
var covpCount = 0;


function linux_showTimer()
{
	if( linux_nSecs > 0 )
	{
		document.getElementById("timer").innerHTML = linux_nSecs + " " + _("secs");
		linux_clearTimer = setTimeout( linux_showTimer, linux_timeInterval );
		linux_nSecs = linux_nSecs-1;
	}
}

function linux_launchEpaApp()
{
    document.getElementById("AppINFO").innerHTML = _("Checking if the plug-in is installed");

    linux_showTimer();
    if(navigator.userAgent.search("Firefox") != -1)
    {
	var launcherFrame = document.getElementById("launcherIframe");
	if(launcherFrame)
	{
	    launcherFrame.parentNode.removeChild(launcherFrame);
	}
	var iFrameChild = document.createElement("iframe");
	iFrameChild.setAttribute("src", "nsgcepa://nsgcepa");
	iFrameChild.id = "launcherIframe";
	iFrameChild.style.width = "1px";
	iFrameChild.style.height = "1px";
	iFrameChild.style.visibility = "hidden";
	document.body.appendChild(iFrameChild);
    }

    else {
	window.location = "nsgcepa://nsgcepa";
    }

	setTimeout("linux_startChannel()", 2500);
}

function linux_startChannel()
{
	if(linux_count < linux_nConnectAttempts)
	{
		linux_cookie = "NSC_AAAC="+ns_getepacookie("NSC_AAAC");
		var image = new Image();
		image.onload = linux_sepaHandler;
		image.onerror = linux_sepaError;
		image.src = "http://localhost:"+linux_portNo+"/sepa?"+linux_cookie+"?nsloc=https://"+window.location.host+"?POSTAUTH"+"?"+ff_count;
  	}
    else
    {
        if( (navigator.userAgent.indexOf("Chrome") > -1) && (navigator.vendor == "Google Inc.") )
        {
            document.getElementById("launchbutton").style.display = 'none';
            linux_showDownload(_("Manual start of the Endpoint Analysis plug-in failed as it is not installed. Please click Download to install the plug-in."));
        }
        else
        {
            linux_showDownload(_("Endpoint Analysis plug-in is either not launched/installed. Please launch or click on the download link provided."));
        }
    }
}

function linux_sepaError()
{
    console.log("error : "+linux_count);
    linux_count++;
    linux_portNo++;
    if( linux_portNo > (linux_startportNo + 5))
        linux_portNo = linux_startportNo;
//    if( (navigator.userAgent.indexOf("Chrome") > -1) && (navigator.vendor == "Google Inc.") )
//    {
//        if(linux_count == 5 && linux_chromeFlag == 0)
//        {
//            linux_chromeFlag = 1;
//            document.getElementById("launchbutton").style.display = '';
//            document.getElementById("timer").style.display = 'none';
//            document.getElementById("AppINFO").innerHTML = _("Automatic start of the Endpoint Analysis plug-in failed. Please click Launch to manually start the plug-in.");
//            document.getElementById("AppINFO").style.display = '';
//          return;
//        }
//    }
    window.setTimeout("linux_startChannel()", 1000);
}

function linux_sepaHandler(evt)
{
	document.getElementById("timer").style.display = "none";
	if( this.height == 2 )
	{
        //disable epaskip
        document.getElementById("skipbutton").style.display = 'none';
        document.getElementById("AppINFO").style.display = 'none';
		linux_sendrepa();
	}
	else
	{
		SetErrMsg(_("End point analysis failed"));
		document.cookie='NSC_AAAC=nothing;expires=Thursday, 1 Jan 1970 00:00:00 GMT; path=/';
   		window.location = "/epa/posterrorpage.html";
	}
}

//firefox is caching image resopnses so need to make it unique hence adding counters

var ff_count = 0;
function linux_sendrepa()
{
	var image = new Image();
	image.onload = linux_repaHandler;
	image.onerror = linux_repaError;
	image.src = "http://localhost:"+linux_portNo+"/repa?"+linux_cookie+"?"+ff_count;
}

function linux_repaHandler()
{
    console.log(this.height);
	if( this.height == 1 )
	{
        //wait
        ff_count = ff_count+1;
        setTimeout("linux_sendrepa()", 3000);
	}
	else if( this.height == 2 )
	{
        //version mismatch
        console.log("upgrade EPA");
        linux_showDownload(_("You do not have the latest version of Endpoint Analysis plug-in installed. Please download the updated plug-in from the link provided"));
	}
	else if( this.height == 3 )
	{
        //failed epa
        SetErrMsg(_("End point analysis failed"));
        document.cookie='NSC_AAAC=nothing;expires=Thursday, 1 Jan 1970 00:00:00 GMT; path=/';
        window.location = "/epa/posterrorpage.html";
	}
	else if( this.height == 4 )
	{
		//passed epa, fetch NSC_VPNERR cookie
        linux_sendcovp();
	}
}

function linux_repaError()
{
	SetErrMsg(_("End point analysis failed"));
	document.cookie='NSC_AAAC=nothing;expires=Thursday, 1 Jan 1970 00:00:00 GMT; path=/';
   	window.location = "/epa/posterrorpage.html";
}

function linux_sendcovp()
{
    image = new Image();
    image.onerror = linux_covpError;
    image.onload = linux_covpSuccess;
    image.src = "http://localhost:"+linux_portNo+"/covp?"+linux_cookie+"?covp="+covpCookie;
}

function linux_covpError()
{
    SetErrMsg(_("End point analysis failed"));
	document.cookie='NSC_AAAC=nothing;expires=Thursday, 1 Jan 1970 00:00:00 GMT; path=/';
   	window.location = "/epa/posterrorpage.html";
}

function linux_covpSuccess(evt)
{
    if(this.height == 1)
    {
        covpCookie = "NSC_VPNERR="+covpCount+covpCookie;
        console.log("We done ="+covpCookie);

        document.cookie = covpCookie;
        ns_location = "/vpns/choices.html";
        if(covpCookie.indexOf("1") !=-1)
        {
            ns_getredirpage(covpCookie);
        }
        window.location = ns_location;
    }
    if(this.height == 2)
    {
        covpCount = covpCount+1;
        covpCookie = covpCookie+",wicps";
    }
    if(this.height == 3)
    {
        covpCount = covpCount+1;
        covpCookie = covpCookie+",cvpn";
    }
    if(this.height == 4)
    {
        covpCount = covpCount+1;
        covpCookie = covpCookie+",java";
    }
    if(this.height == 5)
    {
        covpCount = covpCount+1;
        covpCookie = covpCookie+",mac";
    }
    if(this.height == 6)
    {
        covpCount = covpCount+1;
        covpCookie = covpCookie+",agent";
    }

    setTimeout("linux_sendcovp()", 1000);
}

function linux_showDownload(textinfo)
{
	linux_count = 0;
	linux_startChannel();
	if( !linux_didShowDwnld )
  		{
  			linux_didShowDwnld = 1;

			document.getElementById("timer").style.display = "none";
			document.getElementById("AppINFO").innerHTML = textinfo;
			document.getElementById("AppINFO").style.display = '';
			document.getElementById("downloadbutton").style.display = '';
			linux_nConnectAttempts = linux_totalAttempts;
			return;
		}
}

//chrome specific function. for some reason custom url doesn't open the app twice within short duration of time in chrome.
// copied from mac code. need to see if this causes start channel being called twice.
function linux_onLaunch()
{
    clearTimeout(linux_clearTimer);
    linux_nSecs = 20;
    document.getElementById("timer").style.display = '';
    linux_showTimer();
    window.location = "nsgcepa://nsgcepa";
    setTimeout("linux_startChannel()", 2500);
}

function downloadLinuxPlugin()
{
    if(navigator.platform.indexOf("i686") >= 0){
        window.location.assign('/epa/scripts/linux/nsepa32.deb');
    } else{
        window.location.assign('/epa/scripts/linux/nsepa.deb');
    }
}

function onDownload()
{
    if(navigator.userAgent.indexOf("Linux") >= 0)
    {
        downloadLinuxPlugin();
    }
    else if( navigator.userAgent.indexOf("Mac OS X") != -1)
	{
		window.location.assign('/epa/scripts/mac/Citrix_Endpoint_Analysis.dmg');
	}
	else
	{
		if(use64BitEPA())
		{
			util.redirectToPlugin("WIN", "EPA64");
		}
		else
		{
			util.redirectToPlugin("WIN", "EPA");
		}
	}
}

function detectPluginVersion()
{
	if( (navigator.userAgent.indexOf("Gecko/2") > -1 || //Firefox browsers
		navigator.userAgent.indexOf("AppleWebKit") > -1 )&& //Safari or Chrome browsers
		navigator.platform=="Win64" )			//64-bit browser on 64-bit OS
		require64bitPlugin = true;
}

function use64BitEPA()
{
	return (navigator.userAgent.indexOf("Win64") > -1 || 	//64-bit IE on 64-bit OS
			navigator.userAgent.indexOf("WOW64") > -1 ||	//32-bit IE on 64-bit OS
			require64bitPlugin);							//64-bit FF on 64-bit OS
}

function loadPage() {
	rdx.page.add_event_handler(rdx.events.PAGE_LOADED, new rdx.callback(login, login.do_action_on_load));
	rdx.page.add_event_handler(rdx.events.PAGE_LOADED, new rdx.callback(function()
	{
		resize();
	}));
	$(window).resize(function(){ resize();});

	Resources.Load();
}

rdx.FRAMEWORK_BASE = "/vpn/js" ;
$(document).ready(loadPage);
