#!/bin/sh

set -e

if [ $# -lt 1 ]; then
  echo >&2 "usage: $0 [-d] <cmd> [<arg> ...]"
  exit 1
fi

if [ "x$NFAST_HOME" = "x" ]; then
  echo >&2 "you must run $0 with NFAST_HOME set in the environment"
  exit 1
fi

if [ "$1" = "-d" ]; then
  shift
  echo >&2
  echo >&2 " ---- $0 $* ----"
  echo >&2
  subargs="$subargs -d"
  set -x
fi


cmd=$1
shift

case "$cmd" in

getdev)
	echo "/dev"
	;;

uid)
	if [ $# -gt 0 ]; then
		echo "usage: $0 uid" >&2
		exit 1
	fi
	id -u
	;;

getpsopts)
	if [ $# -gt 0 ]; then
		echo >&2 "usage: $0 getpsopts"
		exit 1
	fi
	echo "-wp"
	;;


mkdir)
	if [ $# -lt 1 ]; then
		echo >&2 "usage: $0 mkdir <dir> ..."
		exit 1
        fi
	for d in $*; do 
		test -d $d || mkdir $d
        done
	;;

mkdir__s_rwxrwxr_x)
	if [ $# -lt 3 ]; then
		echo "usage: $0 mkdir__s_rwxrwxr_x <user> <group> <dir> ..." >&2
		exit 1
	fi
	us=$1; shift
	gr=$1; shift
	for d in $*; do
		test -d $d || mkdir $d
		chown $us $d
		chgrp $gr $d
		chmod 2775 $d
	done
	;;

mkdir__s_rwxr_xr_x)
	if [ $# -lt 3 ]; then
		echo "usage: $0 mkdir__s_rwxr_xr_x <user> <group> <dir> ..." >&2
		exit 1
	fi
	us=$1; shift
	gr=$1; shift
	for d in $*; do
		test -d $d || mkdir $d
		chown $us $d
		chgrp $gr $d
		chmod 2755 $d
	done
	;;

mkdir__s_rwxr_x___)
	if [ $# -lt 3 ]; then
		echo "usage: $0 mkdir__s_rwxr_x___ <user> <group> <dir> ..." >&2
		exit 1
	fi
	us=$1; shift
	gr=$1; shift
	for d in $*; do
		test -d $d || mkdir $d
		chown $us $d
		chgrp $gr $d
		chmod 2750 $d
	done
	;;

mkdir___trwxrwxrwx)
	if [ $# -lt 3 ]; then
		echo "usage: $0 mkdir___trwxrwxrwx <user> <group> <dir> ..." >&2
		exit 1
	fi
	us="$1"; shift
	gr="$1"; shift
	for d in "$@"; do
		test -d $d || mkdir $d
		chown $us $d
		chgrp $gr $d
		chmod 1777 $d
	done
	;;

*)
	echo "$0: Unknown command '$cmd'" >&2
	exit 1
	;;
esac

exit 0
