#!/bin/sh

set -e

if [ $# -lt 1 ]; then
  echo "usage: $0 [-d] <cmd> [<arg> ...]" >&2
  exit 1
fi

if [ "$1" = "-d" ]; then
  shift
  echo >&2
  echo >&2 " ---- $0 $* ----"
  echo >&2
  subargs="$subargs -d"
  set -x
fi

cmd=$1
shift

case "$cmd" in

*)
	# pass all other commands to the default handler
	exec $NFAST_HOME/scripts/lib/utils-def.sh $subargs $cmd $*
        ;;
esac

exit 0
