#!/bin/sh
# NetScaler NextGen API Install script
#
# Copyright 2023-2025 Citrix Systems, Inc. All rights reserved.
# This software and documentation contain valuable trade
# secrets and proprietary property belonging to Citrix Systems, Inc.
# None of this software and documentation may be copied,
# duplicated or disclosed without the express
# written permission of Citrix Systems, Inc.
#
# Options:	NONE
#

NEXTGEN_INFRA_DIR="/var/nextgen/infra"
NEXTGEN_CONFIG_DIR="/var/nextgen/config"
NEXTGEN_PKGS_DIR="$NEXTGEN_INFRA_DIR/packages"
LOGFILE="/var/log/ngapi_install.log"

if [ -d $NEXTGEN_PKGS_DIR ]
then
    if [ -d $NEXTGEN_CONFIG_DIR ]
    then
        echo "Running pre-install script..." >> $LOGFILE
        /var/python/bin/python -m ngapi_lib.installation.main --pre_install >> $LOGFILE 2>&1
    fi

    echo `date` "Installing NextGen API..." >> $LOGFILE
    /var/python/bin/python -m easy_install $NEXTGEN_PKGS_DIR/MPSPython-1.0-py3.9.egg >> $LOGFILE 2>&1
    /var/python/bin/python -m easy_install --no-deps $NEXTGEN_PKGS_DIR/NetScalerStyleBooks-1.0-py3.9.egg >> $LOGFILE 2>&1
    /var/python/bin/python -m pip install $NEXTGEN_PKGS_DIR/NetScalerNitroStyleBooks14.1-43.44-py3-none-any.whl >> $LOGFILE 2>&1
    /var/python/bin/python -m pip install $NEXTGEN_PKGS_DIR/NetScalerNitroStyleBooks13.1-47.14-py3-none-any.whl >> $LOGFILE 2>&1
    /var/python/bin/python -m easy_install $NEXTGEN_PKGS_DIR/NetScalerNextGenAPI-1.0-py3.9.egg >> $LOGFILE 2>&1
    ln -sf $NEXTGEN_INFRA_DIR/openapispec/Nextgen-API-Spec.yaml /netscaler/ns_gui/admin_ui/gui_v2/nextgen_api/ >> $LOGFILE 2>&1
    echo `date` "Installing NextGen API... done" >> $LOGFILE

    if [ -d $NEXTGEN_CONFIG_DIR ]
    then
        echo "Running post-install script..." >> $LOGFILE
        /var/python/bin/python -m ngapi_lib.installation.main --post_install >> $LOGFILE 2>&1
        cp -f $NEXTGEN_INFRA_DIR/database/migration/migration.conf $NEXTGEN_CONFIG_DIR/migration/migration.conf >> $LOGFILE 2>&1
        cp  -f $NEXTGEN_INFRA_DIR/.ngapi.version $NEXTGEN_CONFIG_DIR/.ngapi.version >> $LOGFILE 2>&1
    fi
else
    echo `date` "NextGen API packages not present..." >> $LOGFILE
fi
