# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

import msrest.serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    import __init__ as _models


class ApiError(msrest.serialization.Model):
    """Api error.

    :ivar details: The Api error details.
    :vartype details: list[~azure.mgmt.compute.v2021_10_01.models.ApiErrorBase]
    :ivar innererror: The Api inner error.
    :vartype innererror: ~azure.mgmt.compute.v2021_10_01.models.InnerError
    :ivar code: The error code.
    :vartype code: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar message: The error message.
    :vartype message: str
    """

    _attribute_map = {
        'details': {'key': 'details', 'type': '[ApiErrorBase]'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        details: Optional[List["_models.ApiErrorBase"]] = None,
        innererror: Optional["_models.InnerError"] = None,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword details: The Api error details.
        :paramtype details: list[~azure.mgmt.compute.v2021_10_01.models.ApiErrorBase]
        :keyword innererror: The Api inner error.
        :paramtype innererror: ~azure.mgmt.compute.v2021_10_01.models.InnerError
        :keyword code: The error code.
        :paramtype code: str
        :keyword target: The target of the particular error.
        :paramtype target: str
        :keyword message: The error message.
        :paramtype message: str
        """
        super(ApiError, self).__init__(**kwargs)
        self.details = details
        self.innererror = innererror
        self.code = code
        self.target = target
        self.message = message


class ApiErrorBase(msrest.serialization.Model):
    """Api error base.

    :ivar code: The error code.
    :vartype code: str
    :ivar target: The target of the particular error.
    :vartype target: str
    :ivar message: The error message.
    :vartype message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: The error code.
        :paramtype code: str
        :keyword target: The target of the particular error.
        :paramtype target: str
        :keyword message: The error message.
        :paramtype message: str
        """
        super(ApiErrorBase, self).__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class CommunityGalleryInfo(msrest.serialization.Model):
    """Information of community gallery if current gallery is shared to community.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar publisher_uri: Community gallery publisher uri.
    :vartype publisher_uri: str
    :ivar publisher_contact: Community gallery publisher contact email.
    :vartype publisher_contact: str
    :ivar eula: Community gallery publisher eula.
    :vartype eula: str
    :ivar public_name_prefix: Community gallery public name prefix.
    :vartype public_name_prefix: str
    :ivar community_gallery_enabled: Contains info about whether community gallery sharing is
     enabled.
    :vartype community_gallery_enabled: bool
    :ivar public_names: Community gallery public name list.
    :vartype public_names: list[str]
    """

    _validation = {
        'community_gallery_enabled': {'readonly': True},
        'public_names': {'readonly': True},
    }

    _attribute_map = {
        'publisher_uri': {'key': 'publisherUri', 'type': 'str'},
        'publisher_contact': {'key': 'publisherContact', 'type': 'str'},
        'eula': {'key': 'eula', 'type': 'str'},
        'public_name_prefix': {'key': 'publicNamePrefix', 'type': 'str'},
        'community_gallery_enabled': {'key': 'communityGalleryEnabled', 'type': 'bool'},
        'public_names': {'key': 'publicNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        publisher_uri: Optional[str] = None,
        publisher_contact: Optional[str] = None,
        eula: Optional[str] = None,
        public_name_prefix: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword publisher_uri: Community gallery publisher uri.
        :paramtype publisher_uri: str
        :keyword publisher_contact: Community gallery publisher contact email.
        :paramtype publisher_contact: str
        :keyword eula: Community gallery publisher eula.
        :paramtype eula: str
        :keyword public_name_prefix: Community gallery public name prefix.
        :paramtype public_name_prefix: str
        """
        super(CommunityGalleryInfo, self).__init__(**kwargs)
        self.publisher_uri = publisher_uri
        self.publisher_contact = publisher_contact
        self.eula = eula
        self.public_name_prefix = public_name_prefix
        self.community_gallery_enabled = None
        self.public_names = None


class DiskImageEncryption(msrest.serialization.Model):
    """This is the disk image encryption base class.

    :ivar disk_encryption_set_id: A relative URI containing the resource ID of the disk encryption
     set.
    :vartype disk_encryption_set_id: str
    """

    _attribute_map = {
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_encryption_set_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword disk_encryption_set_id: A relative URI containing the resource ID of the disk
         encryption set.
        :paramtype disk_encryption_set_id: str
        """
        super(DiskImageEncryption, self).__init__(**kwargs)
        self.disk_encryption_set_id = disk_encryption_set_id


class DataDiskImageEncryption(DiskImageEncryption):
    """Contains encryption settings for a data disk image.

    All required parameters must be populated in order to send to Azure.

    :ivar disk_encryption_set_id: A relative URI containing the resource ID of the disk encryption
     set.
    :vartype disk_encryption_set_id: str
    :ivar lun: Required. This property specifies the logical unit number of the data disk. This
     value is used to identify data disks within the Virtual Machine and therefore must be unique
     for each data disk attached to the Virtual Machine.
    :vartype lun: int
    """

    _validation = {
        'lun': {'required': True},
    }

    _attribute_map = {
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
        'lun': {'key': 'lun', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        lun: int,
        disk_encryption_set_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword disk_encryption_set_id: A relative URI containing the resource ID of the disk
         encryption set.
        :paramtype disk_encryption_set_id: str
        :keyword lun: Required. This property specifies the logical unit number of the data disk. This
         value is used to identify data disks within the Virtual Machine and therefore must be unique
         for each data disk attached to the Virtual Machine.
        :paramtype lun: int
        """
        super(DataDiskImageEncryption, self).__init__(disk_encryption_set_id=disk_encryption_set_id, **kwargs)
        self.lun = lun


class Disallowed(msrest.serialization.Model):
    """Describes the disallowed disk types.

    :ivar disk_types: A list of disk types.
    :vartype disk_types: list[str]
    """

    _attribute_map = {
        'disk_types': {'key': 'diskTypes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        disk_types: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword disk_types: A list of disk types.
        :paramtype disk_types: list[str]
        """
        super(Disallowed, self).__init__(**kwargs)
        self.disk_types = disk_types


class EncryptionImages(msrest.serialization.Model):
    """Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.

    :ivar os_disk_image: Contains encryption settings for an OS disk image.
    :vartype os_disk_image: ~azure.mgmt.compute.v2021_10_01.models.OSDiskImageEncryption
    :ivar data_disk_images: A list of encryption specifications for data disk images.
    :vartype data_disk_images: list[~azure.mgmt.compute.v2021_10_01.models.DataDiskImageEncryption]
    """

    _attribute_map = {
        'os_disk_image': {'key': 'osDiskImage', 'type': 'OSDiskImageEncryption'},
        'data_disk_images': {'key': 'dataDiskImages', 'type': '[DataDiskImageEncryption]'},
    }

    def __init__(
        self,
        *,
        os_disk_image: Optional["_models.OSDiskImageEncryption"] = None,
        data_disk_images: Optional[List["_models.DataDiskImageEncryption"]] = None,
        **kwargs
    ):
        """
        :keyword os_disk_image: Contains encryption settings for an OS disk image.
        :paramtype os_disk_image: ~azure.mgmt.compute.v2021_10_01.models.OSDiskImageEncryption
        :keyword data_disk_images: A list of encryption specifications for data disk images.
        :paramtype data_disk_images:
         list[~azure.mgmt.compute.v2021_10_01.models.DataDiskImageEncryption]
        """
        super(EncryptionImages, self).__init__(**kwargs)
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images


class Resource(msrest.serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class Gallery(Resource):
    """Specifies information about the Shared Image Gallery that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: The description of this Shared Image Gallery resource. This property is
     updatable.
    :vartype description: str
    :ivar identifier: Describes the gallery unique name.
    :vartype identifier: ~azure.mgmt.compute.v2021_10_01.models.GalleryIdentifier
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2021_10_01.models.GalleryPropertiesProvisioningState
    :ivar sharing_profile: Profile for gallery sharing to subscription or tenant.
    :vartype sharing_profile: ~azure.mgmt.compute.v2021_10_01.models.SharingProfile
    :ivar soft_delete_policy: Contains information about the soft deletion policy of the gallery.
    :vartype soft_delete_policy: ~azure.mgmt.compute.v2021_10_01.models.SoftDeletePolicy
    :ivar sharing_status: Sharing status of current gallery.
    :vartype sharing_status: ~azure.mgmt.compute.v2021_10_01.models.SharingStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'sharing_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'identifier': {'key': 'properties.identifier', 'type': 'GalleryIdentifier'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'sharing_profile': {'key': 'properties.sharingProfile', 'type': 'SharingProfile'},
        'soft_delete_policy': {'key': 'properties.softDeletePolicy', 'type': 'SoftDeletePolicy'},
        'sharing_status': {'key': 'properties.sharingStatus', 'type': 'SharingStatus'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        identifier: Optional["_models.GalleryIdentifier"] = None,
        sharing_profile: Optional["_models.SharingProfile"] = None,
        soft_delete_policy: Optional["_models.SoftDeletePolicy"] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of this Shared Image Gallery resource. This property is
         updatable.
        :paramtype description: str
        :keyword identifier: Describes the gallery unique name.
        :paramtype identifier: ~azure.mgmt.compute.v2021_10_01.models.GalleryIdentifier
        :keyword sharing_profile: Profile for gallery sharing to subscription or tenant.
        :paramtype sharing_profile: ~azure.mgmt.compute.v2021_10_01.models.SharingProfile
        :keyword soft_delete_policy: Contains information about the soft deletion policy of the
         gallery.
        :paramtype soft_delete_policy: ~azure.mgmt.compute.v2021_10_01.models.SoftDeletePolicy
        """
        super(Gallery, self).__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.identifier = identifier
        self.provisioning_state = None
        self.sharing_profile = sharing_profile
        self.soft_delete_policy = soft_delete_policy
        self.sharing_status = None


class GalleryApplication(Resource):
    """Specifies information about the gallery Application Definition that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: The description of this gallery Application Definition resource. This
     property is updatable.
    :vartype description: str
    :ivar eula: The Eula agreement for the gallery Application Definition.
    :vartype eula: str
    :ivar privacy_statement_uri: The privacy statement uri.
    :vartype privacy_statement_uri: str
    :ivar release_note_uri: The release note uri.
    :vartype release_note_uri: str
    :ivar end_of_life_date: The end of life date of the gallery Application Definition. This
     property can be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar supported_os_type: This property allows you to specify the supported type of the OS that
     application is built for. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
     "Windows", "Linux".
    :vartype supported_os_type: str or ~azure.mgmt.compute.v2021_10_01.models.OperatingSystemTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'eula': {'key': 'properties.eula', 'type': 'str'},
        'privacy_statement_uri': {'key': 'properties.privacyStatementUri', 'type': 'str'},
        'release_note_uri': {'key': 'properties.releaseNoteUri', 'type': 'str'},
        'end_of_life_date': {'key': 'properties.endOfLifeDate', 'type': 'iso-8601'},
        'supported_os_type': {'key': 'properties.supportedOSType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        eula: Optional[str] = None,
        privacy_statement_uri: Optional[str] = None,
        release_note_uri: Optional[str] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        supported_os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of this gallery Application Definition resource. This
         property is updatable.
        :paramtype description: str
        :keyword eula: The Eula agreement for the gallery Application Definition.
        :paramtype eula: str
        :keyword privacy_statement_uri: The privacy statement uri.
        :paramtype privacy_statement_uri: str
        :keyword release_note_uri: The release note uri.
        :paramtype release_note_uri: str
        :keyword end_of_life_date: The end of life date of the gallery Application Definition. This
         property can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword supported_os_type: This property allows you to specify the supported type of the OS
         that application is built for. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
         "Windows", "Linux".
        :paramtype supported_os_type: str or
         ~azure.mgmt.compute.v2021_10_01.models.OperatingSystemTypes
        """
        super(GalleryApplication, self).__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.end_of_life_date = end_of_life_date
        self.supported_os_type = supported_os_type


class GalleryApplicationList(msrest.serialization.Model):
    """The List Gallery Applications operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. A list of Gallery Applications.
    :vartype value: list[~azure.mgmt.compute.v2021_10_01.models.GalleryApplication]
    :ivar next_link: The uri to fetch the next page of Application Definitions in the Application
     Gallery. Call ListNext() with this to fetch the next page of gallery Application Definitions.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GalleryApplication]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.GalleryApplication"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. A list of Gallery Applications.
        :paramtype value: list[~azure.mgmt.compute.v2021_10_01.models.GalleryApplication]
        :keyword next_link: The uri to fetch the next page of Application Definitions in the
         Application Gallery. Call ListNext() with this to fetch the next page of gallery Application
         Definitions.
        :paramtype next_link: str
        """
        super(GalleryApplicationList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UpdateResourceDefinition(msrest.serialization.Model):
    """The Update Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(UpdateResourceDefinition, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags


class GalleryApplicationUpdate(UpdateResourceDefinition):
    """Specifies information about the gallery Application Definition that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: The description of this gallery Application Definition resource. This
     property is updatable.
    :vartype description: str
    :ivar eula: The Eula agreement for the gallery Application Definition.
    :vartype eula: str
    :ivar privacy_statement_uri: The privacy statement uri.
    :vartype privacy_statement_uri: str
    :ivar release_note_uri: The release note uri.
    :vartype release_note_uri: str
    :ivar end_of_life_date: The end of life date of the gallery Application Definition. This
     property can be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar supported_os_type: This property allows you to specify the supported type of the OS that
     application is built for. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
     "Windows", "Linux".
    :vartype supported_os_type: str or ~azure.mgmt.compute.v2021_10_01.models.OperatingSystemTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'eula': {'key': 'properties.eula', 'type': 'str'},
        'privacy_statement_uri': {'key': 'properties.privacyStatementUri', 'type': 'str'},
        'release_note_uri': {'key': 'properties.releaseNoteUri', 'type': 'str'},
        'end_of_life_date': {'key': 'properties.endOfLifeDate', 'type': 'iso-8601'},
        'supported_os_type': {'key': 'properties.supportedOSType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        eula: Optional[str] = None,
        privacy_statement_uri: Optional[str] = None,
        release_note_uri: Optional[str] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        supported_os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of this gallery Application Definition resource. This
         property is updatable.
        :paramtype description: str
        :keyword eula: The Eula agreement for the gallery Application Definition.
        :paramtype eula: str
        :keyword privacy_statement_uri: The privacy statement uri.
        :paramtype privacy_statement_uri: str
        :keyword release_note_uri: The release note uri.
        :paramtype release_note_uri: str
        :keyword end_of_life_date: The end of life date of the gallery Application Definition. This
         property can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword supported_os_type: This property allows you to specify the supported type of the OS
         that application is built for. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
         "Windows", "Linux".
        :paramtype supported_os_type: str or
         ~azure.mgmt.compute.v2021_10_01.models.OperatingSystemTypes
        """
        super(GalleryApplicationUpdate, self).__init__(tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.end_of_life_date = end_of_life_date
        self.supported_os_type = supported_os_type


class GalleryApplicationVersion(Resource):
    """Specifies information about the gallery Application Version that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar publishing_profile: The publishing profile of a gallery image version.
    :vartype publishing_profile:
     ~azure.mgmt.compute.v2021_10_01.models.GalleryApplicationVersionPublishingProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2021_10_01.models.GalleryApplicationVersionPropertiesProvisioningState
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.v2021_10_01.models.ReplicationStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'replication_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'publishing_profile': {'key': 'properties.publishingProfile', 'type': 'GalleryApplicationVersionPublishingProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'replication_status': {'key': 'properties.replicationStatus', 'type': 'ReplicationStatus'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        publishing_profile: Optional["_models.GalleryApplicationVersionPublishingProfile"] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword publishing_profile: The publishing profile of a gallery image version.
        :paramtype publishing_profile:
         ~azure.mgmt.compute.v2021_10_01.models.GalleryApplicationVersionPublishingProfile
        """
        super(GalleryApplicationVersion, self).__init__(location=location, tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.provisioning_state = None
        self.replication_status = None


class GalleryApplicationVersionList(msrest.serialization.Model):
    """The List Gallery Application version operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. A list of gallery Application Versions.
    :vartype value: list[~azure.mgmt.compute.v2021_10_01.models.GalleryApplicationVersion]
    :ivar next_link: The uri to fetch the next page of gallery Application Versions. Call
     ListNext() with this to fetch the next page of gallery Application Versions.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GalleryApplicationVersion]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.GalleryApplicationVersion"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. A list of gallery Application Versions.
        :paramtype value: list[~azure.mgmt.compute.v2021_10_01.models.GalleryApplicationVersion]
        :keyword next_link: The uri to fetch the next page of gallery Application Versions. Call
         ListNext() with this to fetch the next page of gallery Application Versions.
        :paramtype next_link: str
        """
        super(GalleryApplicationVersionList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GalleryArtifactPublishingProfileBase(msrest.serialization.Model):
    """Describes the basic gallery artifact publishing profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_regions: The target regions where the Image Version is going to be replicated to.
     This property is updatable.
    :vartype target_regions: list[~azure.mgmt.compute.v2021_10_01.models.TargetRegion]
    :ivar replica_count: The number of replicas of the Image Version to be created per region. This
     property would take effect for a region when regionalReplicaCount is not specified. This
     property is updatable.
    :vartype replica_count: int
    :ivar exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of
     the Image Definition won't use this Image Version.
    :vartype exclude_from_latest: bool
    :ivar published_date: The timestamp for when the gallery image version is published.
    :vartype published_date: ~datetime.datetime
    :ivar end_of_life_date: The end of life date of the gallery image version. This property can be
     used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
     "Premium_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.v2021_10_01.models.StorageAccountType
    :ivar replication_mode: Optional parameter which specifies the mode to be used for replication.
     This property is not updatable. Known values are: "Full", "Shallow".
    :vartype replication_mode: str or ~azure.mgmt.compute.v2021_10_01.models.ReplicationMode
    :ivar target_extended_locations: The target extended locations where the Image Version is going
     to be replicated to. This property is updatable.
    :vartype target_extended_locations:
     list[~azure.mgmt.compute.v2021_10_01.models.GalleryTargetExtendedLocation]
    """

    _validation = {
        'published_date': {'readonly': True},
    }

    _attribute_map = {
        'target_regions': {'key': 'targetRegions', 'type': '[TargetRegion]'},
        'replica_count': {'key': 'replicaCount', 'type': 'int'},
        'exclude_from_latest': {'key': 'excludeFromLatest', 'type': 'bool'},
        'published_date': {'key': 'publishedDate', 'type': 'iso-8601'},
        'end_of_life_date': {'key': 'endOfLifeDate', 'type': 'iso-8601'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'replication_mode': {'key': 'replicationMode', 'type': 'str'},
        'target_extended_locations': {'key': 'targetExtendedLocations', 'type': '[GalleryTargetExtendedLocation]'},
    }

    def __init__(
        self,
        *,
        target_regions: Optional[List["_models.TargetRegion"]] = None,
        replica_count: Optional[int] = None,
        exclude_from_latest: Optional[bool] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = None,
        replication_mode: Optional[Union[str, "_models.ReplicationMode"]] = None,
        target_extended_locations: Optional[List["_models.GalleryTargetExtendedLocation"]] = None,
        **kwargs
    ):
        """
        :keyword target_regions: The target regions where the Image Version is going to be replicated
         to. This property is updatable.
        :paramtype target_regions: list[~azure.mgmt.compute.v2021_10_01.models.TargetRegion]
        :keyword replica_count: The number of replicas of the Image Version to be created per region.
         This property would take effect for a region when regionalReplicaCount is not specified. This
         property is updatable.
        :paramtype replica_count: int
        :keyword exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
         of the Image Definition won't use this Image Version.
        :paramtype exclude_from_latest: bool
        :keyword end_of_life_date: The end of life date of the gallery image version. This property can
         be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword storage_account_type: Specifies the storage account type to be used to store the
         image. This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
         "Premium_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.v2021_10_01.models.StorageAccountType
        :keyword replication_mode: Optional parameter which specifies the mode to be used for
         replication. This property is not updatable. Known values are: "Full", "Shallow".
        :paramtype replication_mode: str or ~azure.mgmt.compute.v2021_10_01.models.ReplicationMode
        :keyword target_extended_locations: The target extended locations where the Image Version is
         going to be replicated to. This property is updatable.
        :paramtype target_extended_locations:
         list[~azure.mgmt.compute.v2021_10_01.models.GalleryTargetExtendedLocation]
        """
        super(GalleryArtifactPublishingProfileBase, self).__init__(**kwargs)
        self.target_regions = target_regions
        self.replica_count = replica_count
        self.exclude_from_latest = exclude_from_latest
        self.published_date = None
        self.end_of_life_date = end_of_life_date
        self.storage_account_type = storage_account_type
        self.replication_mode = replication_mode
        self.target_extended_locations = target_extended_locations


class GalleryApplicationVersionPublishingProfile(GalleryArtifactPublishingProfileBase):
    """The publishing profile of a gallery image version.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar target_regions: The target regions where the Image Version is going to be replicated to.
     This property is updatable.
    :vartype target_regions: list[~azure.mgmt.compute.v2021_10_01.models.TargetRegion]
    :ivar replica_count: The number of replicas of the Image Version to be created per region. This
     property would take effect for a region when regionalReplicaCount is not specified. This
     property is updatable.
    :vartype replica_count: int
    :ivar exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of
     the Image Definition won't use this Image Version.
    :vartype exclude_from_latest: bool
    :ivar published_date: The timestamp for when the gallery image version is published.
    :vartype published_date: ~datetime.datetime
    :ivar end_of_life_date: The end of life date of the gallery image version. This property can be
     used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
     "Premium_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.v2021_10_01.models.StorageAccountType
    :ivar replication_mode: Optional parameter which specifies the mode to be used for replication.
     This property is not updatable. Known values are: "Full", "Shallow".
    :vartype replication_mode: str or ~azure.mgmt.compute.v2021_10_01.models.ReplicationMode
    :ivar target_extended_locations: The target extended locations where the Image Version is going
     to be replicated to. This property is updatable.
    :vartype target_extended_locations:
     list[~azure.mgmt.compute.v2021_10_01.models.GalleryTargetExtendedLocation]
    :ivar source: Required. The source image from which the Image Version is going to be created.
    :vartype source: ~azure.mgmt.compute.v2021_10_01.models.UserArtifactSource
    :ivar manage_actions:
    :vartype manage_actions: ~azure.mgmt.compute.v2021_10_01.models.UserArtifactManage
    :ivar enable_health_check: Optional. Whether or not this application reports health.
    :vartype enable_health_check: bool
    """

    _validation = {
        'published_date': {'readonly': True},
        'source': {'required': True},
    }

    _attribute_map = {
        'target_regions': {'key': 'targetRegions', 'type': '[TargetRegion]'},
        'replica_count': {'key': 'replicaCount', 'type': 'int'},
        'exclude_from_latest': {'key': 'excludeFromLatest', 'type': 'bool'},
        'published_date': {'key': 'publishedDate', 'type': 'iso-8601'},
        'end_of_life_date': {'key': 'endOfLifeDate', 'type': 'iso-8601'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'replication_mode': {'key': 'replicationMode', 'type': 'str'},
        'target_extended_locations': {'key': 'targetExtendedLocations', 'type': '[GalleryTargetExtendedLocation]'},
        'source': {'key': 'source', 'type': 'UserArtifactSource'},
        'manage_actions': {'key': 'manageActions', 'type': 'UserArtifactManage'},
        'enable_health_check': {'key': 'enableHealthCheck', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        source: "_models.UserArtifactSource",
        target_regions: Optional[List["_models.TargetRegion"]] = None,
        replica_count: Optional[int] = None,
        exclude_from_latest: Optional[bool] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = None,
        replication_mode: Optional[Union[str, "_models.ReplicationMode"]] = None,
        target_extended_locations: Optional[List["_models.GalleryTargetExtendedLocation"]] = None,
        manage_actions: Optional["_models.UserArtifactManage"] = None,
        enable_health_check: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword target_regions: The target regions where the Image Version is going to be replicated
         to. This property is updatable.
        :paramtype target_regions: list[~azure.mgmt.compute.v2021_10_01.models.TargetRegion]
        :keyword replica_count: The number of replicas of the Image Version to be created per region.
         This property would take effect for a region when regionalReplicaCount is not specified. This
         property is updatable.
        :paramtype replica_count: int
        :keyword exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
         of the Image Definition won't use this Image Version.
        :paramtype exclude_from_latest: bool
        :keyword end_of_life_date: The end of life date of the gallery image version. This property can
         be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword storage_account_type: Specifies the storage account type to be used to store the
         image. This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
         "Premium_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.v2021_10_01.models.StorageAccountType
        :keyword replication_mode: Optional parameter which specifies the mode to be used for
         replication. This property is not updatable. Known values are: "Full", "Shallow".
        :paramtype replication_mode: str or ~azure.mgmt.compute.v2021_10_01.models.ReplicationMode
        :keyword target_extended_locations: The target extended locations where the Image Version is
         going to be replicated to. This property is updatable.
        :paramtype target_extended_locations:
         list[~azure.mgmt.compute.v2021_10_01.models.GalleryTargetExtendedLocation]
        :keyword source: Required. The source image from which the Image Version is going to be
         created.
        :paramtype source: ~azure.mgmt.compute.v2021_10_01.models.UserArtifactSource
        :keyword manage_actions:
        :paramtype manage_actions: ~azure.mgmt.compute.v2021_10_01.models.UserArtifactManage
        :keyword enable_health_check: Optional. Whether or not this application reports health.
        :paramtype enable_health_check: bool
        """
        super(GalleryApplicationVersionPublishingProfile, self).__init__(target_regions=target_regions, replica_count=replica_count, exclude_from_latest=exclude_from_latest, end_of_life_date=end_of_life_date, storage_account_type=storage_account_type, replication_mode=replication_mode, target_extended_locations=target_extended_locations, **kwargs)
        self.source = source
        self.manage_actions = manage_actions
        self.enable_health_check = enable_health_check


class GalleryApplicationVersionUpdate(UpdateResourceDefinition):
    """Specifies information about the gallery Application Version that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar publishing_profile: The publishing profile of a gallery image version.
    :vartype publishing_profile:
     ~azure.mgmt.compute.v2021_10_01.models.GalleryApplicationVersionPublishingProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2021_10_01.models.GalleryApplicationVersionPropertiesProvisioningState
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.v2021_10_01.models.ReplicationStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'replication_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'publishing_profile': {'key': 'properties.publishingProfile', 'type': 'GalleryApplicationVersionPublishingProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'replication_status': {'key': 'properties.replicationStatus', 'type': 'ReplicationStatus'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        publishing_profile: Optional["_models.GalleryApplicationVersionPublishingProfile"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword publishing_profile: The publishing profile of a gallery image version.
        :paramtype publishing_profile:
         ~azure.mgmt.compute.v2021_10_01.models.GalleryApplicationVersionPublishingProfile
        """
        super(GalleryApplicationVersionUpdate, self).__init__(tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.provisioning_state = None
        self.replication_status = None


class GalleryArtifactSource(msrest.serialization.Model):
    """The source image from which the Image Version is going to be created.

    All required parameters must be populated in order to send to Azure.

    :ivar managed_image: Required. The managed artifact.
    :vartype managed_image: ~azure.mgmt.compute.v2021_10_01.models.ManagedArtifact
    """

    _validation = {
        'managed_image': {'required': True},
    }

    _attribute_map = {
        'managed_image': {'key': 'managedImage', 'type': 'ManagedArtifact'},
    }

    def __init__(
        self,
        *,
        managed_image: "_models.ManagedArtifact",
        **kwargs
    ):
        """
        :keyword managed_image: Required. The managed artifact.
        :paramtype managed_image: ~azure.mgmt.compute.v2021_10_01.models.ManagedArtifact
        """
        super(GalleryArtifactSource, self).__init__(**kwargs)
        self.managed_image = managed_image


class GalleryArtifactVersionSource(msrest.serialization.Model):
    """The gallery artifact version source.

    :ivar id: The id of the gallery artifact version source. Can specify a disk uri, snapshot uri,
     user image or storage account resource.
    :vartype id: str
    :ivar uri: The uri of the gallery artifact version source. Currently used to specify vhd/blob
     source.
    :vartype uri: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: The id of the gallery artifact version source. Can specify a disk uri, snapshot
         uri, user image or storage account resource.
        :paramtype id: str
        :keyword uri: The uri of the gallery artifact version source. Currently used to specify
         vhd/blob source.
        :paramtype uri: str
        """
        super(GalleryArtifactVersionSource, self).__init__(**kwargs)
        self.id = id
        self.uri = uri


class GalleryDiskImage(msrest.serialization.Model):
    """This is the disk image base class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar size_in_gb: This property indicates the size of the VHD to be created.
    :vartype size_in_gb: int
    :ivar host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     'ReadWrite'. Known values are: "None", "ReadOnly", "ReadWrite".
    :vartype host_caching: str or ~azure.mgmt.compute.v2021_10_01.models.HostCaching
    :ivar source: The gallery artifact version source.
    :vartype source: ~azure.mgmt.compute.v2021_10_01.models.GalleryArtifactVersionSource
    """

    _validation = {
        'size_in_gb': {'readonly': True},
    }

    _attribute_map = {
        'size_in_gb': {'key': 'sizeInGB', 'type': 'int'},
        'host_caching': {'key': 'hostCaching', 'type': 'str'},
        'source': {'key': 'source', 'type': 'GalleryArtifactVersionSource'},
    }

    def __init__(
        self,
        *,
        host_caching: Optional[Union[str, "_models.HostCaching"]] = None,
        source: Optional["_models.GalleryArtifactVersionSource"] = None,
        **kwargs
    ):
        """
        :keyword host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
         'ReadWrite'. Known values are: "None", "ReadOnly", "ReadWrite".
        :paramtype host_caching: str or ~azure.mgmt.compute.v2021_10_01.models.HostCaching
        :keyword source: The gallery artifact version source.
        :paramtype source: ~azure.mgmt.compute.v2021_10_01.models.GalleryArtifactVersionSource
        """
        super(GalleryDiskImage, self).__init__(**kwargs)
        self.size_in_gb = None
        self.host_caching = host_caching
        self.source = source


class GalleryDataDiskImage(GalleryDiskImage):
    """This is the data disk image.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar size_in_gb: This property indicates the size of the VHD to be created.
    :vartype size_in_gb: int
    :ivar host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     'ReadWrite'. Known values are: "None", "ReadOnly", "ReadWrite".
    :vartype host_caching: str or ~azure.mgmt.compute.v2021_10_01.models.HostCaching
    :ivar source: The gallery artifact version source.
    :vartype source: ~azure.mgmt.compute.v2021_10_01.models.GalleryArtifactVersionSource
    :ivar lun: Required. This property specifies the logical unit number of the data disk. This
     value is used to identify data disks within the Virtual Machine and therefore must be unique
     for each data disk attached to the Virtual Machine.
    :vartype lun: int
    """

    _validation = {
        'size_in_gb': {'readonly': True},
        'lun': {'required': True},
    }

    _attribute_map = {
        'size_in_gb': {'key': 'sizeInGB', 'type': 'int'},
        'host_caching': {'key': 'hostCaching', 'type': 'str'},
        'source': {'key': 'source', 'type': 'GalleryArtifactVersionSource'},
        'lun': {'key': 'lun', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        lun: int,
        host_caching: Optional[Union[str, "_models.HostCaching"]] = None,
        source: Optional["_models.GalleryArtifactVersionSource"] = None,
        **kwargs
    ):
        """
        :keyword host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
         'ReadWrite'. Known values are: "None", "ReadOnly", "ReadWrite".
        :paramtype host_caching: str or ~azure.mgmt.compute.v2021_10_01.models.HostCaching
        :keyword source: The gallery artifact version source.
        :paramtype source: ~azure.mgmt.compute.v2021_10_01.models.GalleryArtifactVersionSource
        :keyword lun: Required. This property specifies the logical unit number of the data disk. This
         value is used to identify data disks within the Virtual Machine and therefore must be unique
         for each data disk attached to the Virtual Machine.
        :paramtype lun: int
        """
        super(GalleryDataDiskImage, self).__init__(host_caching=host_caching, source=source, **kwargs)
        self.lun = lun


class GalleryExtendedLocation(msrest.serialization.Model):
    """The name of the extended location.

    :ivar name:
    :vartype name: str
    :ivar type: It is type of the extended location. Known values are: "EdgeZone", "Unknown".
    :vartype type: str or ~azure.mgmt.compute.v2021_10_01.models.GalleryExtendedLocationType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "_models.GalleryExtendedLocationType"]] = None,
        **kwargs
    ):
        """
        :keyword name:
        :paramtype name: str
        :keyword type: It is type of the extended location. Known values are: "EdgeZone", "Unknown".
        :paramtype type: str or ~azure.mgmt.compute.v2021_10_01.models.GalleryExtendedLocationType
        """
        super(GalleryExtendedLocation, self).__init__(**kwargs)
        self.name = name
        self.type = type


class GalleryIdentifier(msrest.serialization.Model):
    """Describes the gallery unique name.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar unique_name: The unique name of the Shared Image Gallery. This name is generated
     automatically by Azure.
    :vartype unique_name: str
    """

    _validation = {
        'unique_name': {'readonly': True},
    }

    _attribute_map = {
        'unique_name': {'key': 'uniqueName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(GalleryIdentifier, self).__init__(**kwargs)
        self.unique_name = None


class GalleryImage(Resource):
    """Specifies information about the gallery image definition that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: The description of this gallery image definition resource. This property is
     updatable.
    :vartype description: str
    :ivar eula: The Eula agreement for the gallery image definition.
    :vartype eula: str
    :ivar privacy_statement_uri: The privacy statement uri.
    :vartype privacy_statement_uri: str
    :ivar release_note_uri: The release note uri.
    :vartype release_note_uri: str
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk when creating a VM from a managed image. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
     "Windows", "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2021_10_01.models.OperatingSystemTypes
    :ivar os_state: This property allows the user to specify whether the virtual machines created
     under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized",
     "Specialized".
    :vartype os_state: str or ~azure.mgmt.compute.v2021_10_01.models.OperatingSystemStateTypes
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Known values are: "V1", "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.v2021_10_01.models.HyperVGeneration
    :ivar end_of_life_date: The end of life date of the gallery image definition. This property can
     be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar identifier: This is the gallery image definition identifier.
    :vartype identifier: ~azure.mgmt.compute.v2021_10_01.models.GalleryImageIdentifier
    :ivar recommended: The properties describe the recommended machine configuration for this Image
     Definition. These properties are updatable.
    :vartype recommended: ~azure.mgmt.compute.v2021_10_01.models.RecommendedMachineConfiguration
    :ivar disallowed: Describes the disallowed disk types.
    :vartype disallowed: ~azure.mgmt.compute.v2021_10_01.models.Disallowed
    :ivar purchase_plan: Describes the gallery image definition purchase plan. This is used by
     marketplace images.
    :vartype purchase_plan: ~azure.mgmt.compute.v2021_10_01.models.ImagePurchasePlan
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2021_10_01.models.GalleryImagePropertiesProvisioningState
    :ivar features: A list of gallery image features.
    :vartype features: list[~azure.mgmt.compute.v2021_10_01.models.GalleryImageFeature]
    :ivar architecture: The architecture of the image. Applicable to OS disks only. Known values
     are: "x64", "Arm64".
    :vartype architecture: str or ~azure.mgmt.compute.v2021_10_01.models.Architecture
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'eula': {'key': 'properties.eula', 'type': 'str'},
        'privacy_statement_uri': {'key': 'properties.privacyStatementUri', 'type': 'str'},
        'release_note_uri': {'key': 'properties.releaseNoteUri', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'os_state': {'key': 'properties.osState', 'type': 'str'},
        'hyper_v_generation': {'key': 'properties.hyperVGeneration', 'type': 'str'},
        'end_of_life_date': {'key': 'properties.endOfLifeDate', 'type': 'iso-8601'},
        'identifier': {'key': 'properties.identifier', 'type': 'GalleryImageIdentifier'},
        'recommended': {'key': 'properties.recommended', 'type': 'RecommendedMachineConfiguration'},
        'disallowed': {'key': 'properties.disallowed', 'type': 'Disallowed'},
        'purchase_plan': {'key': 'properties.purchasePlan', 'type': 'ImagePurchasePlan'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'features': {'key': 'properties.features', 'type': '[GalleryImageFeature]'},
        'architecture': {'key': 'properties.architecture', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        eula: Optional[str] = None,
        privacy_statement_uri: Optional[str] = None,
        release_note_uri: Optional[str] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        os_state: Optional[Union[str, "_models.OperatingSystemStateTypes"]] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        identifier: Optional["_models.GalleryImageIdentifier"] = None,
        recommended: Optional["_models.RecommendedMachineConfiguration"] = None,
        disallowed: Optional["_models.Disallowed"] = None,
        purchase_plan: Optional["_models.ImagePurchasePlan"] = None,
        features: Optional[List["_models.GalleryImageFeature"]] = None,
        architecture: Optional[Union[str, "_models.Architecture"]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of this gallery image definition resource. This property
         is updatable.
        :paramtype description: str
        :keyword eula: The Eula agreement for the gallery image definition.
        :paramtype eula: str
        :keyword privacy_statement_uri: The privacy statement uri.
        :paramtype privacy_statement_uri: str
        :keyword release_note_uri: The release note uri.
        :paramtype release_note_uri: str
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk when creating a VM from a managed image. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
         "Windows", "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2021_10_01.models.OperatingSystemTypes
        :keyword os_state: This property allows the user to specify whether the virtual machines
         created under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized",
         "Specialized".
        :paramtype os_state: str or ~azure.mgmt.compute.v2021_10_01.models.OperatingSystemStateTypes
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
         disks only. Known values are: "V1", "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.v2021_10_01.models.HyperVGeneration
        :keyword end_of_life_date: The end of life date of the gallery image definition. This property
         can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword identifier: This is the gallery image definition identifier.
        :paramtype identifier: ~azure.mgmt.compute.v2021_10_01.models.GalleryImageIdentifier
        :keyword recommended: The properties describe the recommended machine configuration for this
         Image Definition. These properties are updatable.
        :paramtype recommended: ~azure.mgmt.compute.v2021_10_01.models.RecommendedMachineConfiguration
        :keyword disallowed: Describes the disallowed disk types.
        :paramtype disallowed: ~azure.mgmt.compute.v2021_10_01.models.Disallowed
        :keyword purchase_plan: Describes the gallery image definition purchase plan. This is used by
         marketplace images.
        :paramtype purchase_plan: ~azure.mgmt.compute.v2021_10_01.models.ImagePurchasePlan
        :keyword features: A list of gallery image features.
        :paramtype features: list[~azure.mgmt.compute.v2021_10_01.models.GalleryImageFeature]
        :keyword architecture: The architecture of the image. Applicable to OS disks only. Known values
         are: "x64", "Arm64".
        :paramtype architecture: str or ~azure.mgmt.compute.v2021_10_01.models.Architecture
        """
        super(GalleryImage, self).__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.os_type = os_type
        self.os_state = os_state
        self.hyper_v_generation = hyper_v_generation
        self.end_of_life_date = end_of_life_date
        self.identifier = identifier
        self.recommended = recommended
        self.disallowed = disallowed
        self.purchase_plan = purchase_plan
        self.provisioning_state = None
        self.features = features
        self.architecture = architecture


class GalleryImageFeature(msrest.serialization.Model):
    """A feature for gallery image.

    :ivar name: The name of the gallery image feature.
    :vartype name: str
    :ivar value: The value of the gallery image feature.
    :vartype value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the gallery image feature.
        :paramtype name: str
        :keyword value: The value of the gallery image feature.
        :paramtype value: str
        """
        super(GalleryImageFeature, self).__init__(**kwargs)
        self.name = name
        self.value = value


class GalleryImageIdentifier(msrest.serialization.Model):
    """This is the gallery image definition identifier.

    All required parameters must be populated in order to send to Azure.

    :ivar publisher: Required. The name of the gallery image definition publisher.
    :vartype publisher: str
    :ivar offer: Required. The name of the gallery image definition offer.
    :vartype offer: str
    :ivar sku: Required. The name of the gallery image definition SKU.
    :vartype sku: str
    """

    _validation = {
        'publisher': {'required': True},
        'offer': {'required': True},
        'sku': {'required': True},
    }

    _attribute_map = {
        'publisher': {'key': 'publisher', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        publisher: str,
        offer: str,
        sku: str,
        **kwargs
    ):
        """
        :keyword publisher: Required. The name of the gallery image definition publisher.
        :paramtype publisher: str
        :keyword offer: Required. The name of the gallery image definition offer.
        :paramtype offer: str
        :keyword sku: Required. The name of the gallery image definition SKU.
        :paramtype sku: str
        """
        super(GalleryImageIdentifier, self).__init__(**kwargs)
        self.publisher = publisher
        self.offer = offer
        self.sku = sku


class GalleryImageList(msrest.serialization.Model):
    """The List Gallery Images operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. A list of Shared Image Gallery images.
    :vartype value: list[~azure.mgmt.compute.v2021_10_01.models.GalleryImage]
    :ivar next_link: The uri to fetch the next page of Image Definitions in the Shared Image
     Gallery. Call ListNext() with this to fetch the next page of gallery image definitions.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GalleryImage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.GalleryImage"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. A list of Shared Image Gallery images.
        :paramtype value: list[~azure.mgmt.compute.v2021_10_01.models.GalleryImage]
        :keyword next_link: The uri to fetch the next page of Image Definitions in the Shared Image
         Gallery. Call ListNext() with this to fetch the next page of gallery image definitions.
        :paramtype next_link: str
        """
        super(GalleryImageList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GalleryImageUpdate(UpdateResourceDefinition):
    """Specifies information about the gallery image definition that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: The description of this gallery image definition resource. This property is
     updatable.
    :vartype description: str
    :ivar eula: The Eula agreement for the gallery image definition.
    :vartype eula: str
    :ivar privacy_statement_uri: The privacy statement uri.
    :vartype privacy_statement_uri: str
    :ivar release_note_uri: The release note uri.
    :vartype release_note_uri: str
    :ivar os_type: This property allows you to specify the type of the OS that is included in the
     disk when creating a VM from a managed image. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
     "Windows", "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2021_10_01.models.OperatingSystemTypes
    :ivar os_state: This property allows the user to specify whether the virtual machines created
     under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized",
     "Specialized".
    :vartype os_state: str or ~azure.mgmt.compute.v2021_10_01.models.OperatingSystemStateTypes
    :ivar hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Known values are: "V1", "V2".
    :vartype hyper_v_generation: str or ~azure.mgmt.compute.v2021_10_01.models.HyperVGeneration
    :ivar end_of_life_date: The end of life date of the gallery image definition. This property can
     be used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar identifier: This is the gallery image definition identifier.
    :vartype identifier: ~azure.mgmt.compute.v2021_10_01.models.GalleryImageIdentifier
    :ivar recommended: The properties describe the recommended machine configuration for this Image
     Definition. These properties are updatable.
    :vartype recommended: ~azure.mgmt.compute.v2021_10_01.models.RecommendedMachineConfiguration
    :ivar disallowed: Describes the disallowed disk types.
    :vartype disallowed: ~azure.mgmt.compute.v2021_10_01.models.Disallowed
    :ivar purchase_plan: Describes the gallery image definition purchase plan. This is used by
     marketplace images.
    :vartype purchase_plan: ~azure.mgmt.compute.v2021_10_01.models.ImagePurchasePlan
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2021_10_01.models.GalleryImagePropertiesProvisioningState
    :ivar features: A list of gallery image features.
    :vartype features: list[~azure.mgmt.compute.v2021_10_01.models.GalleryImageFeature]
    :ivar architecture: The architecture of the image. Applicable to OS disks only. Known values
     are: "x64", "Arm64".
    :vartype architecture: str or ~azure.mgmt.compute.v2021_10_01.models.Architecture
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'eula': {'key': 'properties.eula', 'type': 'str'},
        'privacy_statement_uri': {'key': 'properties.privacyStatementUri', 'type': 'str'},
        'release_note_uri': {'key': 'properties.releaseNoteUri', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'os_state': {'key': 'properties.osState', 'type': 'str'},
        'hyper_v_generation': {'key': 'properties.hyperVGeneration', 'type': 'str'},
        'end_of_life_date': {'key': 'properties.endOfLifeDate', 'type': 'iso-8601'},
        'identifier': {'key': 'properties.identifier', 'type': 'GalleryImageIdentifier'},
        'recommended': {'key': 'properties.recommended', 'type': 'RecommendedMachineConfiguration'},
        'disallowed': {'key': 'properties.disallowed', 'type': 'Disallowed'},
        'purchase_plan': {'key': 'properties.purchasePlan', 'type': 'ImagePurchasePlan'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'features': {'key': 'properties.features', 'type': '[GalleryImageFeature]'},
        'architecture': {'key': 'properties.architecture', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        eula: Optional[str] = None,
        privacy_statement_uri: Optional[str] = None,
        release_note_uri: Optional[str] = None,
        os_type: Optional[Union[str, "_models.OperatingSystemTypes"]] = None,
        os_state: Optional[Union[str, "_models.OperatingSystemStateTypes"]] = None,
        hyper_v_generation: Optional[Union[str, "_models.HyperVGeneration"]] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        identifier: Optional["_models.GalleryImageIdentifier"] = None,
        recommended: Optional["_models.RecommendedMachineConfiguration"] = None,
        disallowed: Optional["_models.Disallowed"] = None,
        purchase_plan: Optional["_models.ImagePurchasePlan"] = None,
        features: Optional[List["_models.GalleryImageFeature"]] = None,
        architecture: Optional[Union[str, "_models.Architecture"]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of this gallery image definition resource. This property
         is updatable.
        :paramtype description: str
        :keyword eula: The Eula agreement for the gallery image definition.
        :paramtype eula: str
        :keyword privacy_statement_uri: The privacy statement uri.
        :paramtype privacy_statement_uri: str
        :keyword release_note_uri: The release note uri.
        :paramtype release_note_uri: str
        :keyword os_type: This property allows you to specify the type of the OS that is included in
         the disk when creating a VM from a managed image. :code:`<br>`:code:`<br>` Possible values are:
         :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Known values are:
         "Windows", "Linux".
        :paramtype os_type: str or ~azure.mgmt.compute.v2021_10_01.models.OperatingSystemTypes
        :keyword os_state: This property allows the user to specify whether the virtual machines
         created under this image are 'Generalized' or 'Specialized'. Known values are: "Generalized",
         "Specialized".
        :paramtype os_state: str or ~azure.mgmt.compute.v2021_10_01.models.OperatingSystemStateTypes
        :keyword hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
         disks only. Known values are: "V1", "V2".
        :paramtype hyper_v_generation: str or ~azure.mgmt.compute.v2021_10_01.models.HyperVGeneration
        :keyword end_of_life_date: The end of life date of the gallery image definition. This property
         can be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword identifier: This is the gallery image definition identifier.
        :paramtype identifier: ~azure.mgmt.compute.v2021_10_01.models.GalleryImageIdentifier
        :keyword recommended: The properties describe the recommended machine configuration for this
         Image Definition. These properties are updatable.
        :paramtype recommended: ~azure.mgmt.compute.v2021_10_01.models.RecommendedMachineConfiguration
        :keyword disallowed: Describes the disallowed disk types.
        :paramtype disallowed: ~azure.mgmt.compute.v2021_10_01.models.Disallowed
        :keyword purchase_plan: Describes the gallery image definition purchase plan. This is used by
         marketplace images.
        :paramtype purchase_plan: ~azure.mgmt.compute.v2021_10_01.models.ImagePurchasePlan
        :keyword features: A list of gallery image features.
        :paramtype features: list[~azure.mgmt.compute.v2021_10_01.models.GalleryImageFeature]
        :keyword architecture: The architecture of the image. Applicable to OS disks only. Known values
         are: "x64", "Arm64".
        :paramtype architecture: str or ~azure.mgmt.compute.v2021_10_01.models.Architecture
        """
        super(GalleryImageUpdate, self).__init__(tags=tags, **kwargs)
        self.description = description
        self.eula = eula
        self.privacy_statement_uri = privacy_statement_uri
        self.release_note_uri = release_note_uri
        self.os_type = os_type
        self.os_state = os_state
        self.hyper_v_generation = hyper_v_generation
        self.end_of_life_date = end_of_life_date
        self.identifier = identifier
        self.recommended = recommended
        self.disallowed = disallowed
        self.purchase_plan = purchase_plan
        self.provisioning_state = None
        self.features = features
        self.architecture = architecture


class GalleryImageVersion(Resource):
    """Specifies information about the gallery image version that you want to create or update.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar publishing_profile: The publishing profile of a gallery image Version.
    :vartype publishing_profile:
     ~azure.mgmt.compute.v2021_10_01.models.GalleryImageVersionPublishingProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2021_10_01.models.GalleryImageVersionPropertiesProvisioningState
    :ivar storage_profile: This is the storage profile of a Gallery Image Version.
    :vartype storage_profile:
     ~azure.mgmt.compute.v2021_10_01.models.GalleryImageVersionStorageProfile
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.v2021_10_01.models.ReplicationStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'replication_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'publishing_profile': {'key': 'properties.publishingProfile', 'type': 'GalleryImageVersionPublishingProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'GalleryImageVersionStorageProfile'},
        'replication_status': {'key': 'properties.replicationStatus', 'type': 'ReplicationStatus'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        publishing_profile: Optional["_models.GalleryImageVersionPublishingProfile"] = None,
        storage_profile: Optional["_models.GalleryImageVersionStorageProfile"] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword publishing_profile: The publishing profile of a gallery image Version.
        :paramtype publishing_profile:
         ~azure.mgmt.compute.v2021_10_01.models.GalleryImageVersionPublishingProfile
        :keyword storage_profile: This is the storage profile of a Gallery Image Version.
        :paramtype storage_profile:
         ~azure.mgmt.compute.v2021_10_01.models.GalleryImageVersionStorageProfile
        """
        super(GalleryImageVersion, self).__init__(location=location, tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.provisioning_state = None
        self.storage_profile = storage_profile
        self.replication_status = None


class GalleryImageVersionList(msrest.serialization.Model):
    """The List Gallery Image version operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. A list of gallery image versions.
    :vartype value: list[~azure.mgmt.compute.v2021_10_01.models.GalleryImageVersion]
    :ivar next_link: The uri to fetch the next page of gallery image versions. Call ListNext() with
     this to fetch the next page of gallery image versions.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GalleryImageVersion]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.GalleryImageVersion"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. A list of gallery image versions.
        :paramtype value: list[~azure.mgmt.compute.v2021_10_01.models.GalleryImageVersion]
        :keyword next_link: The uri to fetch the next page of gallery image versions. Call ListNext()
         with this to fetch the next page of gallery image versions.
        :paramtype next_link: str
        """
        super(GalleryImageVersionList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GalleryImageVersionPublishingProfile(GalleryArtifactPublishingProfileBase):
    """The publishing profile of a gallery image Version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_regions: The target regions where the Image Version is going to be replicated to.
     This property is updatable.
    :vartype target_regions: list[~azure.mgmt.compute.v2021_10_01.models.TargetRegion]
    :ivar replica_count: The number of replicas of the Image Version to be created per region. This
     property would take effect for a region when regionalReplicaCount is not specified. This
     property is updatable.
    :vartype replica_count: int
    :ivar exclude_from_latest: If set to true, Virtual Machines deployed from the latest version of
     the Image Definition won't use this Image Version.
    :vartype exclude_from_latest: bool
    :ivar published_date: The timestamp for when the gallery image version is published.
    :vartype published_date: ~datetime.datetime
    :ivar end_of_life_date: The end of life date of the gallery image version. This property can be
     used for decommissioning purposes. This property is updatable.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
     "Premium_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.v2021_10_01.models.StorageAccountType
    :ivar replication_mode: Optional parameter which specifies the mode to be used for replication.
     This property is not updatable. Known values are: "Full", "Shallow".
    :vartype replication_mode: str or ~azure.mgmt.compute.v2021_10_01.models.ReplicationMode
    :ivar target_extended_locations: The target extended locations where the Image Version is going
     to be replicated to. This property is updatable.
    :vartype target_extended_locations:
     list[~azure.mgmt.compute.v2021_10_01.models.GalleryTargetExtendedLocation]
    """

    _validation = {
        'published_date': {'readonly': True},
    }

    _attribute_map = {
        'target_regions': {'key': 'targetRegions', 'type': '[TargetRegion]'},
        'replica_count': {'key': 'replicaCount', 'type': 'int'},
        'exclude_from_latest': {'key': 'excludeFromLatest', 'type': 'bool'},
        'published_date': {'key': 'publishedDate', 'type': 'iso-8601'},
        'end_of_life_date': {'key': 'endOfLifeDate', 'type': 'iso-8601'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'replication_mode': {'key': 'replicationMode', 'type': 'str'},
        'target_extended_locations': {'key': 'targetExtendedLocations', 'type': '[GalleryTargetExtendedLocation]'},
    }

    def __init__(
        self,
        *,
        target_regions: Optional[List["_models.TargetRegion"]] = None,
        replica_count: Optional[int] = None,
        exclude_from_latest: Optional[bool] = None,
        end_of_life_date: Optional[datetime.datetime] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = None,
        replication_mode: Optional[Union[str, "_models.ReplicationMode"]] = None,
        target_extended_locations: Optional[List["_models.GalleryTargetExtendedLocation"]] = None,
        **kwargs
    ):
        """
        :keyword target_regions: The target regions where the Image Version is going to be replicated
         to. This property is updatable.
        :paramtype target_regions: list[~azure.mgmt.compute.v2021_10_01.models.TargetRegion]
        :keyword replica_count: The number of replicas of the Image Version to be created per region.
         This property would take effect for a region when regionalReplicaCount is not specified. This
         property is updatable.
        :paramtype replica_count: int
        :keyword exclude_from_latest: If set to true, Virtual Machines deployed from the latest version
         of the Image Definition won't use this Image Version.
        :paramtype exclude_from_latest: bool
        :keyword end_of_life_date: The end of life date of the gallery image version. This property can
         be used for decommissioning purposes. This property is updatable.
        :paramtype end_of_life_date: ~datetime.datetime
        :keyword storage_account_type: Specifies the storage account type to be used to store the
         image. This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
         "Premium_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.v2021_10_01.models.StorageAccountType
        :keyword replication_mode: Optional parameter which specifies the mode to be used for
         replication. This property is not updatable. Known values are: "Full", "Shallow".
        :paramtype replication_mode: str or ~azure.mgmt.compute.v2021_10_01.models.ReplicationMode
        :keyword target_extended_locations: The target extended locations where the Image Version is
         going to be replicated to. This property is updatable.
        :paramtype target_extended_locations:
         list[~azure.mgmt.compute.v2021_10_01.models.GalleryTargetExtendedLocation]
        """
        super(GalleryImageVersionPublishingProfile, self).__init__(target_regions=target_regions, replica_count=replica_count, exclude_from_latest=exclude_from_latest, end_of_life_date=end_of_life_date, storage_account_type=storage_account_type, replication_mode=replication_mode, target_extended_locations=target_extended_locations, **kwargs)


class GalleryImageVersionStorageProfile(msrest.serialization.Model):
    """This is the storage profile of a Gallery Image Version.

    :ivar source: The gallery artifact version source.
    :vartype source: ~azure.mgmt.compute.v2021_10_01.models.GalleryArtifactVersionSource
    :ivar os_disk_image: This is the OS disk image.
    :vartype os_disk_image: ~azure.mgmt.compute.v2021_10_01.models.GalleryOSDiskImage
    :ivar data_disk_images: A list of data disk images.
    :vartype data_disk_images: list[~azure.mgmt.compute.v2021_10_01.models.GalleryDataDiskImage]
    """

    _attribute_map = {
        'source': {'key': 'source', 'type': 'GalleryArtifactVersionSource'},
        'os_disk_image': {'key': 'osDiskImage', 'type': 'GalleryOSDiskImage'},
        'data_disk_images': {'key': 'dataDiskImages', 'type': '[GalleryDataDiskImage]'},
    }

    def __init__(
        self,
        *,
        source: Optional["_models.GalleryArtifactVersionSource"] = None,
        os_disk_image: Optional["_models.GalleryOSDiskImage"] = None,
        data_disk_images: Optional[List["_models.GalleryDataDiskImage"]] = None,
        **kwargs
    ):
        """
        :keyword source: The gallery artifact version source.
        :paramtype source: ~azure.mgmt.compute.v2021_10_01.models.GalleryArtifactVersionSource
        :keyword os_disk_image: This is the OS disk image.
        :paramtype os_disk_image: ~azure.mgmt.compute.v2021_10_01.models.GalleryOSDiskImage
        :keyword data_disk_images: A list of data disk images.
        :paramtype data_disk_images: list[~azure.mgmt.compute.v2021_10_01.models.GalleryDataDiskImage]
        """
        super(GalleryImageVersionStorageProfile, self).__init__(**kwargs)
        self.source = source
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images


class GalleryImageVersionUpdate(UpdateResourceDefinition):
    """Specifies information about the gallery image version that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar publishing_profile: The publishing profile of a gallery image Version.
    :vartype publishing_profile:
     ~azure.mgmt.compute.v2021_10_01.models.GalleryImageVersionPublishingProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2021_10_01.models.GalleryImageVersionPropertiesProvisioningState
    :ivar storage_profile: This is the storage profile of a Gallery Image Version.
    :vartype storage_profile:
     ~azure.mgmt.compute.v2021_10_01.models.GalleryImageVersionStorageProfile
    :ivar replication_status: This is the replication status of the gallery image version.
    :vartype replication_status: ~azure.mgmt.compute.v2021_10_01.models.ReplicationStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'replication_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'publishing_profile': {'key': 'properties.publishingProfile', 'type': 'GalleryImageVersionPublishingProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'GalleryImageVersionStorageProfile'},
        'replication_status': {'key': 'properties.replicationStatus', 'type': 'ReplicationStatus'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        publishing_profile: Optional["_models.GalleryImageVersionPublishingProfile"] = None,
        storage_profile: Optional["_models.GalleryImageVersionStorageProfile"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword publishing_profile: The publishing profile of a gallery image Version.
        :paramtype publishing_profile:
         ~azure.mgmt.compute.v2021_10_01.models.GalleryImageVersionPublishingProfile
        :keyword storage_profile: This is the storage profile of a Gallery Image Version.
        :paramtype storage_profile:
         ~azure.mgmt.compute.v2021_10_01.models.GalleryImageVersionStorageProfile
        """
        super(GalleryImageVersionUpdate, self).__init__(tags=tags, **kwargs)
        self.publishing_profile = publishing_profile
        self.provisioning_state = None
        self.storage_profile = storage_profile
        self.replication_status = None


class GalleryList(msrest.serialization.Model):
    """The List Galleries operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. A list of galleries.
    :vartype value: list[~azure.mgmt.compute.v2021_10_01.models.Gallery]
    :ivar next_link: The uri to fetch the next page of galleries. Call ListNext() with this to
     fetch the next page of galleries.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Gallery]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["_models.Gallery"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. A list of galleries.
        :paramtype value: list[~azure.mgmt.compute.v2021_10_01.models.Gallery]
        :keyword next_link: The uri to fetch the next page of galleries. Call ListNext() with this to
         fetch the next page of galleries.
        :paramtype next_link: str
        """
        super(GalleryList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GalleryOSDiskImage(GalleryDiskImage):
    """This is the OS disk image.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar size_in_gb: This property indicates the size of the VHD to be created.
    :vartype size_in_gb: int
    :ivar host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
     'ReadWrite'. Known values are: "None", "ReadOnly", "ReadWrite".
    :vartype host_caching: str or ~azure.mgmt.compute.v2021_10_01.models.HostCaching
    :ivar source: The gallery artifact version source.
    :vartype source: ~azure.mgmt.compute.v2021_10_01.models.GalleryArtifactVersionSource
    """

    _validation = {
        'size_in_gb': {'readonly': True},
    }

    _attribute_map = {
        'size_in_gb': {'key': 'sizeInGB', 'type': 'int'},
        'host_caching': {'key': 'hostCaching', 'type': 'str'},
        'source': {'key': 'source', 'type': 'GalleryArtifactVersionSource'},
    }

    def __init__(
        self,
        *,
        host_caching: Optional[Union[str, "_models.HostCaching"]] = None,
        source: Optional["_models.GalleryArtifactVersionSource"] = None,
        **kwargs
    ):
        """
        :keyword host_caching: The host caching of the disk. Valid values are 'None', 'ReadOnly', and
         'ReadWrite'. Known values are: "None", "ReadOnly", "ReadWrite".
        :paramtype host_caching: str or ~azure.mgmt.compute.v2021_10_01.models.HostCaching
        :keyword source: The gallery artifact version source.
        :paramtype source: ~azure.mgmt.compute.v2021_10_01.models.GalleryArtifactVersionSource
        """
        super(GalleryOSDiskImage, self).__init__(host_caching=host_caching, source=source, **kwargs)


class GalleryTargetExtendedLocation(msrest.serialization.Model):
    """GalleryTargetExtendedLocation.

    :ivar name: The name of the region.
    :vartype name: str
    :ivar extended_location: The name of the extended location.
    :vartype extended_location: ~azure.mgmt.compute.v2021_10_01.models.GalleryExtendedLocation
    :ivar extended_location_replica_count: The number of replicas of the Image Version to be
     created per extended location. This property is updatable.
    :vartype extended_location_replica_count: int
    :ivar storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
     "Premium_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.v2021_10_01.models.StorageAccountType
    :ivar encryption: Optional. Allows users to provide customer managed keys for encrypting the OS
     and data disks in the gallery artifact.
    :vartype encryption: ~azure.mgmt.compute.v2021_10_01.models.EncryptionImages
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'extended_location': {'key': 'extendedLocation', 'type': 'GalleryExtendedLocation'},
        'extended_location_replica_count': {'key': 'extendedLocationReplicaCount', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'encryption': {'key': 'encryption', 'type': 'EncryptionImages'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        extended_location: Optional["_models.GalleryExtendedLocation"] = None,
        extended_location_replica_count: Optional[int] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = None,
        encryption: Optional["_models.EncryptionImages"] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the region.
        :paramtype name: str
        :keyword extended_location: The name of the extended location.
        :paramtype extended_location: ~azure.mgmt.compute.v2021_10_01.models.GalleryExtendedLocation
        :keyword extended_location_replica_count: The number of replicas of the Image Version to be
         created per extended location. This property is updatable.
        :paramtype extended_location_replica_count: int
        :keyword storage_account_type: Specifies the storage account type to be used to store the
         image. This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
         "Premium_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.v2021_10_01.models.StorageAccountType
        :keyword encryption: Optional. Allows users to provide customer managed keys for encrypting the
         OS and data disks in the gallery artifact.
        :paramtype encryption: ~azure.mgmt.compute.v2021_10_01.models.EncryptionImages
        """
        super(GalleryTargetExtendedLocation, self).__init__(**kwargs)
        self.name = name
        self.extended_location = extended_location
        self.extended_location_replica_count = extended_location_replica_count
        self.storage_account_type = storage_account_type
        self.encryption = encryption


class GalleryUpdate(UpdateResourceDefinition):
    """Specifies information about the Shared Image Gallery that you want to update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: The description of this Shared Image Gallery resource. This property is
     updatable.
    :vartype description: str
    :ivar identifier: Describes the gallery unique name.
    :vartype identifier: ~azure.mgmt.compute.v2021_10_01.models.GalleryIdentifier
    :ivar provisioning_state: The provisioning state, which only appears in the response. Known
     values are: "Creating", "Updating", "Failed", "Succeeded", "Deleting", "Migrating".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2021_10_01.models.GalleryPropertiesProvisioningState
    :ivar sharing_profile: Profile for gallery sharing to subscription or tenant.
    :vartype sharing_profile: ~azure.mgmt.compute.v2021_10_01.models.SharingProfile
    :ivar soft_delete_policy: Contains information about the soft deletion policy of the gallery.
    :vartype soft_delete_policy: ~azure.mgmt.compute.v2021_10_01.models.SoftDeletePolicy
    :ivar sharing_status: Sharing status of current gallery.
    :vartype sharing_status: ~azure.mgmt.compute.v2021_10_01.models.SharingStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'sharing_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'identifier': {'key': 'properties.identifier', 'type': 'GalleryIdentifier'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'sharing_profile': {'key': 'properties.sharingProfile', 'type': 'SharingProfile'},
        'soft_delete_policy': {'key': 'properties.softDeletePolicy', 'type': 'SoftDeletePolicy'},
        'sharing_status': {'key': 'properties.sharingStatus', 'type': 'SharingStatus'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        identifier: Optional["_models.GalleryIdentifier"] = None,
        sharing_profile: Optional["_models.SharingProfile"] = None,
        soft_delete_policy: Optional["_models.SoftDeletePolicy"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: The description of this Shared Image Gallery resource. This property is
         updatable.
        :paramtype description: str
        :keyword identifier: Describes the gallery unique name.
        :paramtype identifier: ~azure.mgmt.compute.v2021_10_01.models.GalleryIdentifier
        :keyword sharing_profile: Profile for gallery sharing to subscription or tenant.
        :paramtype sharing_profile: ~azure.mgmt.compute.v2021_10_01.models.SharingProfile
        :keyword soft_delete_policy: Contains information about the soft deletion policy of the
         gallery.
        :paramtype soft_delete_policy: ~azure.mgmt.compute.v2021_10_01.models.SoftDeletePolicy
        """
        super(GalleryUpdate, self).__init__(tags=tags, **kwargs)
        self.description = description
        self.identifier = identifier
        self.provisioning_state = None
        self.sharing_profile = sharing_profile
        self.soft_delete_policy = soft_delete_policy
        self.sharing_status = None


class ImagePurchasePlan(msrest.serialization.Model):
    """Describes the gallery image definition purchase plan. This is used by marketplace images.

    :ivar name: The plan ID.
    :vartype name: str
    :ivar publisher: The publisher ID.
    :vartype publisher: str
    :ivar product: The product ID.
    :vartype product: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The plan ID.
        :paramtype name: str
        :keyword publisher: The publisher ID.
        :paramtype publisher: str
        :keyword product: The product ID.
        :paramtype product: str
        """
        super(ImagePurchasePlan, self).__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product


class InnerError(msrest.serialization.Model):
    """Inner error details.

    :ivar exceptiontype: The exception type.
    :vartype exceptiontype: str
    :ivar errordetail: The internal error message or exception dump.
    :vartype errordetail: str
    """

    _attribute_map = {
        'exceptiontype': {'key': 'exceptiontype', 'type': 'str'},
        'errordetail': {'key': 'errordetail', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        exceptiontype: Optional[str] = None,
        errordetail: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword exceptiontype: The exception type.
        :paramtype exceptiontype: str
        :keyword errordetail: The internal error message or exception dump.
        :paramtype errordetail: str
        """
        super(InnerError, self).__init__(**kwargs)
        self.exceptiontype = exceptiontype
        self.errordetail = errordetail


class ManagedArtifact(msrest.serialization.Model):
    """The managed artifact.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. The managed artifact id.
    :vartype id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        """
        :keyword id: Required. The managed artifact id.
        :paramtype id: str
        """
        super(ManagedArtifact, self).__init__(**kwargs)
        self.id = id


class OSDiskImageEncryption(DiskImageEncryption):
    """Contains encryption settings for an OS disk image.

    :ivar disk_encryption_set_id: A relative URI containing the resource ID of the disk encryption
     set.
    :vartype disk_encryption_set_id: str
    :ivar security_profile: This property specifies the security profile of an OS disk image.
    :vartype security_profile: ~azure.mgmt.compute.v2021_10_01.models.OSDiskImageSecurityProfile
    """

    _attribute_map = {
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
        'security_profile': {'key': 'securityProfile', 'type': 'OSDiskImageSecurityProfile'},
    }

    def __init__(
        self,
        *,
        disk_encryption_set_id: Optional[str] = None,
        security_profile: Optional["_models.OSDiskImageSecurityProfile"] = None,
        **kwargs
    ):
        """
        :keyword disk_encryption_set_id: A relative URI containing the resource ID of the disk
         encryption set.
        :paramtype disk_encryption_set_id: str
        :keyword security_profile: This property specifies the security profile of an OS disk image.
        :paramtype security_profile: ~azure.mgmt.compute.v2021_10_01.models.OSDiskImageSecurityProfile
        """
        super(OSDiskImageEncryption, self).__init__(disk_encryption_set_id=disk_encryption_set_id, **kwargs)
        self.security_profile = security_profile


class OSDiskImageSecurityProfile(msrest.serialization.Model):
    """Contains security profile for an OS disk image.

    :ivar confidential_vm_encryption_type: confidential VM encryption types. Known values are:
     "EncryptedVMGuestStateOnlyWithPmk", "EncryptedWithPmk", "EncryptedWithCmk".
    :vartype confidential_vm_encryption_type: str or
     ~azure.mgmt.compute.v2021_10_01.models.ConfidentialVMEncryptionType
    :ivar secure_vm_disk_encryption_set_id: secure VM disk encryption set id.
    :vartype secure_vm_disk_encryption_set_id: str
    """

    _attribute_map = {
        'confidential_vm_encryption_type': {'key': 'confidentialVMEncryptionType', 'type': 'str'},
        'secure_vm_disk_encryption_set_id': {'key': 'secureVMDiskEncryptionSetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        confidential_vm_encryption_type: Optional[Union[str, "_models.ConfidentialVMEncryptionType"]] = None,
        secure_vm_disk_encryption_set_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword confidential_vm_encryption_type: confidential VM encryption types. Known values are:
         "EncryptedVMGuestStateOnlyWithPmk", "EncryptedWithPmk", "EncryptedWithCmk".
        :paramtype confidential_vm_encryption_type: str or
         ~azure.mgmt.compute.v2021_10_01.models.ConfidentialVMEncryptionType
        :keyword secure_vm_disk_encryption_set_id: secure VM disk encryption set id.
        :paramtype secure_vm_disk_encryption_set_id: str
        """
        super(OSDiskImageSecurityProfile, self).__init__(**kwargs)
        self.confidential_vm_encryption_type = confidential_vm_encryption_type
        self.secure_vm_disk_encryption_set_id = secure_vm_disk_encryption_set_id


class RecommendedMachineConfiguration(msrest.serialization.Model):
    """The properties describe the recommended machine configuration for this Image Definition. These properties are updatable.

    :ivar v_cp_us: Describes the resource range.
    :vartype v_cp_us: ~azure.mgmt.compute.v2021_10_01.models.ResourceRange
    :ivar memory: Describes the resource range.
    :vartype memory: ~azure.mgmt.compute.v2021_10_01.models.ResourceRange
    """

    _attribute_map = {
        'v_cp_us': {'key': 'vCPUs', 'type': 'ResourceRange'},
        'memory': {'key': 'memory', 'type': 'ResourceRange'},
    }

    def __init__(
        self,
        *,
        v_cp_us: Optional["_models.ResourceRange"] = None,
        memory: Optional["_models.ResourceRange"] = None,
        **kwargs
    ):
        """
        :keyword v_cp_us: Describes the resource range.
        :paramtype v_cp_us: ~azure.mgmt.compute.v2021_10_01.models.ResourceRange
        :keyword memory: Describes the resource range.
        :paramtype memory: ~azure.mgmt.compute.v2021_10_01.models.ResourceRange
        """
        super(RecommendedMachineConfiguration, self).__init__(**kwargs)
        self.v_cp_us = v_cp_us
        self.memory = memory


class RegionalReplicationStatus(msrest.serialization.Model):
    """This is the regional replication status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar region: The region to which the gallery image version is being replicated to.
    :vartype region: str
    :ivar state: This is the regional replication state. Known values are: "Unknown",
     "Replicating", "Completed", "Failed".
    :vartype state: str or ~azure.mgmt.compute.v2021_10_01.models.ReplicationState
    :ivar details: The details of the replication status.
    :vartype details: str
    :ivar progress: It indicates progress of the replication job.
    :vartype progress: int
    """

    _validation = {
        'region': {'readonly': True},
        'state': {'readonly': True},
        'details': {'readonly': True},
        'progress': {'readonly': True},
    }

    _attribute_map = {
        'region': {'key': 'region', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
        'progress': {'key': 'progress', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(RegionalReplicationStatus, self).__init__(**kwargs)
        self.region = None
        self.state = None
        self.details = None
        self.progress = None


class RegionalSharingStatus(msrest.serialization.Model):
    """Gallery regional sharing status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar region: Region name.
    :vartype region: str
    :ivar state: Gallery sharing state in current region. Known values are: "Succeeded",
     "InProgress", "Failed", "Unknown".
    :vartype state: str or ~azure.mgmt.compute.v2021_10_01.models.SharingState
    :ivar details: Details of gallery regional sharing failure.
    :vartype details: str
    """

    _validation = {
        'state': {'readonly': True},
    }

    _attribute_map = {
        'region': {'key': 'region', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        region: Optional[str] = None,
        details: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword region: Region name.
        :paramtype region: str
        :keyword details: Details of gallery regional sharing failure.
        :paramtype details: str
        """
        super(RegionalSharingStatus, self).__init__(**kwargs)
        self.region = region
        self.state = None
        self.details = details


class ReplicationStatus(msrest.serialization.Model):
    """This is the replication status of the gallery image version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar aggregated_state: This is the aggregated replication status based on all the regional
     replication status flags. Known values are: "Unknown", "InProgress", "Completed", "Failed".
    :vartype aggregated_state: str or
     ~azure.mgmt.compute.v2021_10_01.models.AggregatedReplicationState
    :ivar summary: This is a summary of replication status for each region.
    :vartype summary: list[~azure.mgmt.compute.v2021_10_01.models.RegionalReplicationStatus]
    """

    _validation = {
        'aggregated_state': {'readonly': True},
        'summary': {'readonly': True},
    }

    _attribute_map = {
        'aggregated_state': {'key': 'aggregatedState', 'type': 'str'},
        'summary': {'key': 'summary', 'type': '[RegionalReplicationStatus]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ReplicationStatus, self).__init__(**kwargs)
        self.aggregated_state = None
        self.summary = None


class ResourceRange(msrest.serialization.Model):
    """Describes the resource range.

    :ivar min: The minimum number of the resource.
    :vartype min: int
    :ivar max: The maximum number of the resource.
    :vartype max: int
    """

    _attribute_map = {
        'min': {'key': 'min', 'type': 'int'},
        'max': {'key': 'max', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        min: Optional[int] = None,
        max: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword min: The minimum number of the resource.
        :paramtype min: int
        :keyword max: The maximum number of the resource.
        :paramtype max: int
        """
        super(ResourceRange, self).__init__(**kwargs)
        self.min = min
        self.max = max


class SharingProfile(msrest.serialization.Model):
    """Profile for gallery sharing to subscription or tenant.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar permissions: This property allows you to specify the permission of sharing gallery.
     :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Private**
     :code:`<br>`:code:`<br>` **Groups**. Known values are: "Private", "Groups".
    :vartype permissions: str or
     ~azure.mgmt.compute.v2021_10_01.models.GallerySharingPermissionTypes
    :ivar groups: A list of sharing profile groups.
    :vartype groups: list[~azure.mgmt.compute.v2021_10_01.models.SharingProfileGroup]
    :ivar community_gallery_info: Information of community gallery if current gallery is shared to
     community.
    :vartype community_gallery_info: any
    """

    _validation = {
        'groups': {'readonly': True},
    }

    _attribute_map = {
        'permissions': {'key': 'permissions', 'type': 'str'},
        'groups': {'key': 'groups', 'type': '[SharingProfileGroup]'},
        'community_gallery_info': {'key': 'communityGalleryInfo', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        permissions: Optional[Union[str, "_models.GallerySharingPermissionTypes"]] = None,
        community_gallery_info: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword permissions: This property allows you to specify the permission of sharing gallery.
         :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Private**
         :code:`<br>`:code:`<br>` **Groups**. Known values are: "Private", "Groups".
        :paramtype permissions: str or
         ~azure.mgmt.compute.v2021_10_01.models.GallerySharingPermissionTypes
        :keyword community_gallery_info: Information of community gallery if current gallery is shared
         to community.
        :paramtype community_gallery_info: any
        """
        super(SharingProfile, self).__init__(**kwargs)
        self.permissions = permissions
        self.groups = None
        self.community_gallery_info = community_gallery_info


class SharingProfileGroup(msrest.serialization.Model):
    """Group of the gallery sharing profile.

    :ivar type: This property allows you to specify the type of sharing group.
     :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Subscriptions**
     :code:`<br>`:code:`<br>` **AADTenants** :code:`<br>`:code:`<br>` **Community**. Known values
     are: "Subscriptions", "AADTenants", "Community".
    :vartype type: str or ~azure.mgmt.compute.v2021_10_01.models.SharingProfileGroupTypes
    :ivar ids: A list of subscription/tenant ids the gallery is aimed to be shared to.
    :vartype ids: list[str]
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'ids': {'key': 'ids', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.SharingProfileGroupTypes"]] = None,
        ids: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword type: This property allows you to specify the type of sharing group.
         :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Subscriptions**
         :code:`<br>`:code:`<br>` **AADTenants** :code:`<br>`:code:`<br>` **Community**. Known values
         are: "Subscriptions", "AADTenants", "Community".
        :paramtype type: str or ~azure.mgmt.compute.v2021_10_01.models.SharingProfileGroupTypes
        :keyword ids: A list of subscription/tenant ids the gallery is aimed to be shared to.
        :paramtype ids: list[str]
        """
        super(SharingProfileGroup, self).__init__(**kwargs)
        self.type = type
        self.ids = ids


class SharingStatus(msrest.serialization.Model):
    """Sharing status of current gallery.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar aggregated_state: Aggregated sharing state of current gallery. Known values are:
     "Succeeded", "InProgress", "Failed", "Unknown".
    :vartype aggregated_state: str or ~azure.mgmt.compute.v2021_10_01.models.SharingState
    :ivar summary: Summary of all regional sharing status.
    :vartype summary: list[~azure.mgmt.compute.v2021_10_01.models.RegionalSharingStatus]
    """

    _validation = {
        'aggregated_state': {'readonly': True},
    }

    _attribute_map = {
        'aggregated_state': {'key': 'aggregatedState', 'type': 'str'},
        'summary': {'key': 'summary', 'type': '[RegionalSharingStatus]'},
    }

    def __init__(
        self,
        *,
        summary: Optional[List["_models.RegionalSharingStatus"]] = None,
        **kwargs
    ):
        """
        :keyword summary: Summary of all regional sharing status.
        :paramtype summary: list[~azure.mgmt.compute.v2021_10_01.models.RegionalSharingStatus]
        """
        super(SharingStatus, self).__init__(**kwargs)
        self.aggregated_state = None
        self.summary = summary


class SharingUpdate(msrest.serialization.Model):
    """Specifies information about the gallery sharing profile update.

    All required parameters must be populated in order to send to Azure.

    :ivar operation_type: Required. This property allows you to specify the operation type of
     gallery sharing update. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>`
     **Add** :code:`<br>`:code:`<br>` **Remove** :code:`<br>`:code:`<br>` **Reset**. Known values
     are: "Add", "Remove", "Reset", "EnableCommunity".
    :vartype operation_type: str or
     ~azure.mgmt.compute.v2021_10_01.models.SharingUpdateOperationTypes
    :ivar groups: A list of sharing profile groups.
    :vartype groups: list[~azure.mgmt.compute.v2021_10_01.models.SharingProfileGroup]
    """

    _validation = {
        'operation_type': {'required': True},
    }

    _attribute_map = {
        'operation_type': {'key': 'operationType', 'type': 'str'},
        'groups': {'key': 'groups', 'type': '[SharingProfileGroup]'},
    }

    def __init__(
        self,
        *,
        operation_type: Union[str, "_models.SharingUpdateOperationTypes"],
        groups: Optional[List["_models.SharingProfileGroup"]] = None,
        **kwargs
    ):
        """
        :keyword operation_type: Required. This property allows you to specify the operation type of
         gallery sharing update. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>`
         **Add** :code:`<br>`:code:`<br>` **Remove** :code:`<br>`:code:`<br>` **Reset**. Known values
         are: "Add", "Remove", "Reset", "EnableCommunity".
        :paramtype operation_type: str or
         ~azure.mgmt.compute.v2021_10_01.models.SharingUpdateOperationTypes
        :keyword groups: A list of sharing profile groups.
        :paramtype groups: list[~azure.mgmt.compute.v2021_10_01.models.SharingProfileGroup]
        """
        super(SharingUpdate, self).__init__(**kwargs)
        self.operation_type = operation_type
        self.groups = groups


class SoftDeletePolicy(msrest.serialization.Model):
    """Contains information about the soft deletion policy of the gallery.

    :ivar is_soft_delete_enabled: Enables soft-deletion for resources in this gallery, allowing
     them to be recovered within retention time.
    :vartype is_soft_delete_enabled: bool
    """

    _attribute_map = {
        'is_soft_delete_enabled': {'key': 'isSoftDeleteEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        is_soft_delete_enabled: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword is_soft_delete_enabled: Enables soft-deletion for resources in this gallery, allowing
         them to be recovered within retention time.
        :paramtype is_soft_delete_enabled: bool
        """
        super(SoftDeletePolicy, self).__init__(**kwargs)
        self.is_soft_delete_enabled = is_soft_delete_enabled


class TargetRegion(msrest.serialization.Model):
    """Describes the target region information.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the region.
    :vartype name: str
    :ivar regional_replica_count: The number of replicas of the Image Version to be created per
     region. This property is updatable.
    :vartype regional_replica_count: int
    :ivar storage_account_type: Specifies the storage account type to be used to store the image.
     This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
     "Premium_LRS".
    :vartype storage_account_type: str or ~azure.mgmt.compute.v2021_10_01.models.StorageAccountType
    :ivar encryption: Optional. Allows users to provide customer managed keys for encrypting the OS
     and data disks in the gallery artifact.
    :vartype encryption: ~azure.mgmt.compute.v2021_10_01.models.EncryptionImages
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'regional_replica_count': {'key': 'regionalReplicaCount', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'encryption': {'key': 'encryption', 'type': 'EncryptionImages'},
    }

    def __init__(
        self,
        *,
        name: str,
        regional_replica_count: Optional[int] = None,
        storage_account_type: Optional[Union[str, "_models.StorageAccountType"]] = None,
        encryption: Optional["_models.EncryptionImages"] = None,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the region.
        :paramtype name: str
        :keyword regional_replica_count: The number of replicas of the Image Version to be created per
         region. This property is updatable.
        :paramtype regional_replica_count: int
        :keyword storage_account_type: Specifies the storage account type to be used to store the
         image. This property is not updatable. Known values are: "Standard_LRS", "Standard_ZRS",
         "Premium_LRS".
        :paramtype storage_account_type: str or
         ~azure.mgmt.compute.v2021_10_01.models.StorageAccountType
        :keyword encryption: Optional. Allows users to provide customer managed keys for encrypting the
         OS and data disks in the gallery artifact.
        :paramtype encryption: ~azure.mgmt.compute.v2021_10_01.models.EncryptionImages
        """
        super(TargetRegion, self).__init__(**kwargs)
        self.name = name
        self.regional_replica_count = regional_replica_count
        self.storage_account_type = storage_account_type
        self.encryption = encryption


class UserArtifactManage(msrest.serialization.Model):
    """UserArtifactManage.

    All required parameters must be populated in order to send to Azure.

    :ivar install: Required. Required. The path and arguments to install the gallery application.
     This is limited to 4096 characters.
    :vartype install: str
    :ivar remove: Required. Required. The path and arguments to remove the gallery application.
     This is limited to 4096 characters.
    :vartype remove: str
    :ivar update: Optional. The path and arguments to update the gallery application. If not
     present, then update operation will invoke remove command on the previous version and install
     command on the current version of the gallery application. This is limited to 4096 characters.
    :vartype update: str
    """

    _validation = {
        'install': {'required': True},
        'remove': {'required': True},
    }

    _attribute_map = {
        'install': {'key': 'install', 'type': 'str'},
        'remove': {'key': 'remove', 'type': 'str'},
        'update': {'key': 'update', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        install: str,
        remove: str,
        update: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword install: Required. Required. The path and arguments to install the gallery
         application. This is limited to 4096 characters.
        :paramtype install: str
        :keyword remove: Required. Required. The path and arguments to remove the gallery application.
         This is limited to 4096 characters.
        :paramtype remove: str
        :keyword update: Optional. The path and arguments to update the gallery application. If not
         present, then update operation will invoke remove command on the previous version and install
         command on the current version of the gallery application. This is limited to 4096 characters.
        :paramtype update: str
        """
        super(UserArtifactManage, self).__init__(**kwargs)
        self.install = install
        self.remove = remove
        self.update = update


class UserArtifactSource(msrest.serialization.Model):
    """The source image from which the Image Version is going to be created.

    All required parameters must be populated in order to send to Azure.

    :ivar media_link: Required. Required. The mediaLink of the artifact, must be a readable storage
     page blob.
    :vartype media_link: str
    :ivar default_configuration_link: Optional. The defaultConfigurationLink of the artifact, must
     be a readable storage page blob.
    :vartype default_configuration_link: str
    """

    _validation = {
        'media_link': {'required': True},
    }

    _attribute_map = {
        'media_link': {'key': 'mediaLink', 'type': 'str'},
        'default_configuration_link': {'key': 'defaultConfigurationLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        media_link: str,
        default_configuration_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword media_link: Required. Required. The mediaLink of the artifact, must be a readable
         storage page blob.
        :paramtype media_link: str
        :keyword default_configuration_link: Optional. The defaultConfigurationLink of the artifact,
         must be a readable storage page blob.
        :paramtype default_configuration_link: str
        """
        super(UserArtifactSource, self).__init__(**kwargs)
        self.media_link = media_link
        self.default_configuration_link = default_configuration_link
