# Copyright (C) 2018-2023. Cloud Software Group, Inc. All Rights Reserved. Confidential & Proprietary.

"""Configuration options as defined in libccauth"""
from ccauth.util import AttributedObject
from .request import CircuitBreakerRequirement
from .security import BearerTokenRequirement, ServiceKeyRequirement
from types import FunctionType
import rsa


class ConfigurationOptions(AttributedObject):
    """Configuration options."""
    _attrs_ = [
        ('route_template', str),
        ('service_name', str),
        ('service_instance', str),
        ('private_key', [str, rsa.PrivateKey]),
        ('signing_algorithm', int),
        ('capabilities_cache_ttl', int),
        ('publickey_cache_ttl', int),
        ('refresh_publickeys_onfail', bool),
        ('access_cache_ttl', int),
        ('token_blacklist_cache_ttl', int),
        ('allow_custom_admins', bool),
        ('token_requirement', BearerTokenRequirement),
        ('servicekey_requirement', ServiceKeyRequirement),
        ('logging_level', int),
        ('logging_func', FunctionType),
        ('request_handler_func', FunctionType),
        ('cache_grace_period', int),
        ('circuitbreaker_requirement', CircuitBreakerRequirement),
        ('max_content_length', int)
    ]

    def __init__(self, **kwargs):
        self.route_template = None
        self.service_name = None
        self.service_instance = None
        self.private_key = None
        self.signing_algorithm = None
        self.capabilities_cache_ttl = None
        self.publickey_cache_ttl = None
        self.refresh_publickeys_onfail = None
        self.access_cache_ttl = None
        self.token_blacklist_cache_ttl = None
        self.allow_custom_admins = None
        self.token_requirement = None
        self.servicekey_requirement = None
        self.logging_level = None
        self.logging_func = None
        self.request_handler_func = None
        self.cache_grace_period = None
        self.circuitbreaker_requirement = None
        self.max_content_length = None

        AttributedObject.__init__(self, **kwargs)
