# Copyright (C) 2018-2023. Cloud Software Group, Inc. All Rights Reserved. Confidential & Proprietary.

"""Random number generator."""
import random


def randbytes(count):
    """Returns a hex-encoded string contaning bitsize/8 random bytes.

    :param count:   the number of random bytes to generate
    :returns:       a bytes object of length `count`
    """
    rng = random.SystemRandom()
    return bytes([rng.randint(0, 255) for _ in range(count)])
