# Copyright (C) 2018-2023. Cloud Software Group, Inc. All Rights Reserved. Confidential & Proprietary.

"""Callbacks as defined in libccauth."""
from ctypes import *
from .types import request

# ccauth_request_callback
request_callback_functype = CFUNCTYPE(
    c_void_p,
    POINTER(c_int),
    POINTER(request.CCAuthRequest),
    POINTER(request.CCAuthResponse))

# ccauth_header_callback
header_callback_functype = CFUNCTYPE(
    c_size_t,
    c_char_p,
    POINTER(c_ubyte),
    c_size_t,
    c_void_p)

# ccauth_content_callback
content_callback_functype = CFUNCTYPE(
    c_size_t,
    POINTER(c_ubyte),
    c_size_t,
    c_void_p)

# ccauth_sign_callback
sign_callback_functype = CFUNCTYPE(
    c_size_t,
    c_void_p,
    POINTER(c_ubyte),
    c_size_t,
    POINTER(c_ubyte),
    c_size_t)

# ccauth_verify_callback
verify_callback_functype = CFUNCTYPE(
    c_int,
    c_void_p,
    POINTER(c_ubyte),
    c_size_t,
    POINTER(c_ubyte),
    c_size_t,
    c_char_p)

# ccauth_log_callback
log_callback_functype = CFUNCTYPE(
    None,
    c_void_p,
    c_int,
    c_char_p,
    c_size_t,
    c_void_p)

# ccauth_rand_callback
rand_callback_functype = CFUNCTYPE(
    c_size_t,
    c_void_p,
    POINTER(c_ubyte),
    c_size_t)
