# Copyright (C) 2018-2023. Cloud Software Group, Inc. All Rights Reserved. Confidential & Proprietary.

"""Public API as defined in libccauth."""
from .binding import _load_library
from .types import CCAuthRequestInfo, CCAuthValidationContext, CCAuthRsaParameters, CCAuthAccessPolicy, CCAuthAccessContext
from ctypes import *

_libccauth = _load_library()

# ccauth_global_init
_ccauth_global_init_impl = _libccauth.ccauth_global_init
_ccauth_global_init_impl.argtypes = []
_ccauth_global_init_impl.restype = c_int


def ccauth_global_init():
    return _ccauth_global_init_impl()


# ccauth_init
_ccauth_init_impl = _libccauth.ccauth_init
_ccauth_init_impl.argtypes = [POINTER(c_void_p)]
_ccauth_init_impl.restype = c_int


def ccauth_init(handle_ptr):
    return _ccauth_init_impl(handle_ptr)


# ccauth_deinit
_ccauth_deinit_impl = _libccauth.ccauth_deinit
_ccauth_deinit_impl.argtypes = [c_void_p]
_ccauth_deinit_impl.restype = None


def ccauth_deinit(handle):
    return _ccauth_deinit_impl(handle)


# ccauth_config
_ccauth_config_impl = _libccauth.ccauth_config
# _ccauth_config_impl.argtypes = [POINTER(c_void_p), c_int, ...]
_ccauth_config_impl.restype = c_int


def ccauth_config(handle, option, *args):
    return _ccauth_config_impl(handle, option, *args)


# ccauth_create_servicekey
_ccauth_create_servicekey_impl = _libccauth.ccauth_create_servicekey
_ccauth_create_servicekey_impl.argtypes = [c_void_p, c_int, POINTER(CCAuthRequestInfo), POINTER(c_char_p)]
_ccauth_create_servicekey_impl.restype = c_int


def ccauth_create_servicekey(handle, algorithm, request_info, servicekey_ptr):
    return _ccauth_create_servicekey_impl(handle, algorithm, request_info, servicekey_ptr)


# ccauth_decode_servicekey
_ccauth_decode_servicekey_impl = _libccauth.ccauth_decode_servicekey
_ccauth_decode_servicekey_impl.argtypes = [c_char_p, POINTER(c_void_p)]
_ccauth_decode_servicekey_impl.restype = c_int


def ccauth_decode_servicekey(servicekey, servicekey_ptr):
    return _ccauth_decode_servicekey_impl(servicekey, servicekey_ptr)


# ccauth_free_servicekey
_ccauth_free_servicekey_impl = _libccauth.ccauth_free_servicekey
_ccauth_free_servicekey_impl.argtypes = [c_void_p]
_ccauth_free_servicekey_impl.restype = None


def ccauth_free_servicekey(servicekey):
    return _ccauth_free_servicekey_impl(servicekey)


# ccauth_validate_identity
_ccauth_validate_identity_impl = _libccauth.ccauth_validate_identity
_ccauth_validate_identity_impl.argtypes = [c_void_p, c_char_p, POINTER(CCAuthRequestInfo), POINTER(CCAuthValidationContext), POINTER(c_void_p)]
_ccauth_validate_identity_impl.restype = c_int


def ccauth_validate_identity(handle, header, request_info, validation_context, identity_ptr):
    return _ccauth_validate_identity_impl(handle, header, request_info, validation_context, identity_ptr)


# ccauth_free_identity
_ccauth_free_identity_impl = _libccauth.ccauth_free_identity
_ccauth_free_identity_impl.argtypes = [c_void_p]
_ccauth_free_identity_impl.restype = None


def ccauth_free_identity(identity):
    return _ccauth_free_identity_impl(identity)


# ccauth_required_policy
_ccauth_required_policy_impl = _libccauth.ccauth_required_policy
_ccauth_required_policy_impl.argtypes = [POINTER(CCAuthAccessPolicy), c_char_p, c_char_p, c_char_p, POINTER(c_void_p)]
_ccauth_required_policy_impl.restype = c_int


def ccauth_required_policy(template, customer_id, service_name, service_profile, policy_ptr):
    return _ccauth_required_policy_impl(template, customer_id, service_name, service_profile, policy_ptr)


# ccauth_check_access
_ccauth_check_access_impl = _libccauth.ccauth_check_access
_ccauth_check_access_impl.argtypes = [c_void_p, POINTER(CCAuthAccessPolicy), c_size_t, POINTER(CCAuthAccessContext), POINTER(c_int)]
_ccauth_check_access_impl.restype = c_int


def ccauth_check_access(handle, required, count, query_context, access_ptr):
    return _ccauth_check_access_impl(handle, required, count, query_context, access_ptr)


# ccauth_free_policy
_ccauth_free_policy_impl = _libccauth.ccauth_free_policy
_ccauth_free_policy_impl.argtypes = [c_void_p]
_ccauth_free_policy_impl.restype = None


def ccauth_free_policy(policy):
    return _ccauth_free_policy_impl(policy)


# ccauth_create_autheader
_ccauth_create_autheader_impl = _libccauth.ccauth_create_autheader
_ccauth_create_autheader_impl.argtypes = [c_char_p, c_char_p, c_bool, POINTER(c_char_p)]
_ccauth_create_autheader_impl.restype = c_int


def ccauth_create_autheader(bearertoken, servicekey, quoted, header_ptr):
    return _ccauth_create_autheader_impl(bearertoken, servicekey, quoted, header_ptr)


# ccauth_encode_rsakey
_ccauth_encode_rsakey_impl = _libccauth.ccauth_encode_rsakey
_ccauth_encode_rsakey_impl.argtypes = [POINTER(CCAuthRsaParameters), POINTER(c_char_p)]
_ccauth_encode_rsakey_impl.restype = c_int


def ccauth_encode_rsakey(rsaparams, servicekey_ptr):
    return _ccauth_encode_rsakey_impl(rsaparams, servicekey_ptr)


# ccauth_decode_rsakey
_ccauth_decode_rsakey_impl = _libccauth.ccauth_decode_rsakey
_ccauth_decode_rsakey_impl.argtypes = [c_char_p, POINTER(c_void_p)]
_ccauth_decode_rsakey_impl.restype = c_int


def ccauth_decode_rsakey(servicekey, rsaparams_ptr):
    return _ccauth_decode_rsakey_impl(servicekey, rsaparams_ptr)


# ccauth_free
_ccauth_free_impl = _libccauth.ccauth_free
_ccauth_free_impl.argtypes = [c_void_p]
_ccauth_free_impl.restype = None


def ccauth_free(ptr):
    return _ccauth_free_impl(ptr)
