# Copyright (C) 2019-2023. Cloud Software Group, Inc. All Rights Reserved. Confidential & Proprietary.

import ccauth.interop as interop
from ccauth.util import asbytes
from .array import CCAuthArray
from ctypes import *

class CCAuthAccessPolicy(Structure):
    """Creates a struct mirroring ccauth_policy"""
    _fields_ = [
        ('permissions', POINTER(CCAuthArray)),
        ('scopes', POINTER(CCAuthArray))
    ]

    @staticmethod
    def _marshal(policy):
        native = CCAuthAccessPolicy()

        native.permissions = pointer(CCAuthArray._marshal(policy.permissions)) if policy.permissions is not None else None
        native.scopes = pointer(CCAuthArray._marshal(policy.scopes)) if policy.scopes is not None else None
        return native

class CCAuthAccessContext(Structure):
    """Creates a struct mirroring ccauth_access_context"""
    _fields_ = [
        ('customer', c_char_p),
        ('user_id', c_char_p),
        ('service_name', c_char_p),
        ('service_instance', c_char_p),
        ('rbac_version', c_int),
        ('admin_claims', c_void_p),
        ('bearer_token', c_char_p)
    ]

    @staticmethod
    def _marshal(context):
        native = CCAuthAccessContext()

        native.customer = asbytes(context.customer_id)
        native.user_id = asbytes(context.user_id) if context.user_id is not None else None
        native.service_name = asbytes(context.service_name) if context.service_name is not None else None
        native.service_instance = asbytes(context.service_instance) if context.service_instance is not None else None
        native.rbac_version = context.rbac_version if context.rbac_version is not None and context.rbac_version else 0
        native.admin_claims = interop.CCAuthAdminClaims._marshal(context.admin_claims)\
            if context.admin_claims is not None else None
        native.bearer_token = asbytes(context.bearer_token) if context.bearer_token is not None else None
        return native
