# Copyright (C) 2019-2023. Cloud Software Group, Inc. All Rights Reserved. Confidential & Proprietary.

from ccauth.util import asstring, asbytes
from ctypes import *


class CCAuthArray(Structure):
    """Creates a struct mirroring ccauth_array"""
    _fields_ = [
        ('values', POINTER(c_char_p)),
        ('count', c_size_t)
    ]

    @staticmethod
    def _marshal(lst):
        native = CCAuthArray()

        n = len(lst)
        strs = [asbytes(x) for x in lst]
        native.values = (c_char_p * n)(*strs)
        native.count = c_size_t(n)
        return native

    @staticmethod
    def _unmarshal(ptr):
        native = cast(ptr, POINTER(CCAuthArray))[0]
        return [asstring(string_at(native.values[i])) for i in range(native.count)] if native.count > 0 else None
