# Copyright (C) 2018-2023. Cloud Software Group, Inc. All Rights Reserved. Confidential & Proprietary.

from ccauth.util import asbytes
from ctypes import *


class CCAuthCircuitBreakerRequirement(Structure):
    """Creates a struct mirroring ccauth_circuitbreaker_requirement"""
    _fields_ = [
        ('failure_threshold', c_int),
        ('success_threshold', c_int),
        ('reset_timeout', c_int)
    ]

    @staticmethod
    def _marshal(req):
        native = CCAuthCircuitBreakerRequirement()

        native.failure_threshold = req.failure_threshold if req.failure_threshold is not None else -1
        native.success_threshold = req.success_threshold if req.success_threshold is not None else -1
        native.reset_timeout = req.reset_timeout if req.reset_timeout is not None else -1
        return native


class CCAuthHeader(Structure):
    """Creates a struct mirroring ccauth_header"""
    _fields_ = [
        ('name', c_char_p),
        ('value', c_char_p),
    ]


class CCAuthRequestInfo(Structure):
    """Creates a struct mirroring ccauth_request_info"""
    _fields_ = [
        ('method', c_int),
        ('url', c_char_p)
    ]

    @staticmethod
    def _marshal(request_info):
        native = CCAuthRequestInfo()

        native.method = request_info.method
        native.url = asbytes(request_info.uri)
        return native


class CCAuthRequest(Structure):
    """Creates a struct mirroring ccauth_request"""
    _fields_ = [
        ('method', c_int),
        ('url', c_char_p),
        ('content', POINTER(c_ubyte)),
        ('content_size', c_size_t),
        ('headers', POINTER(CCAuthHeader)),
        ('header_count', c_size_t)
    ]


class CCAuthResponse(Structure):
    """Creates a struct mirroring ccauth_response"""
    _fields_ = [
        ('status', c_int),
        ('callback', CFUNCTYPE(c_size_t, POINTER(c_ubyte), c_size_t, c_void_p)),
        ('userdata', c_void_p)
    ]
